/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.background;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;

public class WaitDialog
extends JDialog {
    private static final int PADDING = 8;
    private static final Log logger = LogFactory.getLog(WaitDialog.class);
    private List<CancelListener> cancelListeners = new ArrayList<CancelListener>();
    private JLabel message;

    public WaitDialog(boolean allowCancel) {
        this.init(allowCancel);
    }

    public WaitDialog(Dialog parent, boolean allowCancel) {
        super(parent);
        this.init(allowCancel);
    }

    public WaitDialog(Frame parent, boolean allowCancel) {
        super(parent);
        this.init(allowCancel);
    }

    public void addCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }

    public void removeCancelListener(CancelListener listener) {
        this.cancelListeners.remove(listener);
    }

    private void init(boolean allowCancel) {
        logger.debug((Object)"Initializing the Wait Dialog");
        this.setModal(true);
        this.setTitle(Messages.getInstance().getString("WaitDialog.TITLE"));
        this.setLayout(new BorderLayout(8, 8));
        JPanel contentPanel = new JPanel(new FlowLayout(1));
        this.message = new JLabel(Messages.getInstance().getString("WaitDialog.MESSAGE"));
        contentPanel.add(this.message);
        this.add((Component)contentPanel, "Center");
        if (allowCancel) {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 8, 8));
            JButton cancelButton = new JButton(new CancelActionListener());
            buttonPanel.add(cancelButton);
            this.add((Component)buttonPanel, "South");
        }
        this.setResizable(false);
        this.pack();
        LibSwingUtil.centerFrameOnScreen(this);
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public void exit() {
        this.setVisible(false);
        this.dispose();
    }

    private class CancelActionListener
    extends AbstractAction {
        private CancelActionListener() {
            this.putValue("Name", Messages.getInstance().getString("WaitDialog.CANCEL"));
        }

        public void actionPerformed(ActionEvent e) {
            CancelEvent event = new CancelEvent(this);
            for (CancelListener cancelListener : WaitDialog.this.cancelListeners) {
                try {
                    if (cancelListener == null) continue;
                    logger.debug((Object)("Passing cancel action along to cancel listener [" + cancelListener + "]"));
                    cancelListener.cancelProcessing(event);
                }
                catch (Throwable ignored) {
                    logger.warn((Object)Messages.getInstance().formatMessage("WaitDialog.CANCEL_EXCEPTION", ignored.getLocalizedMessage()));
                }
            }
        }
    }
}

