/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.date.DateChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.date.DateChooserPopupMenu;
import org.pentaho.reporting.libraries.designtime.swing.date.DateConverter;

public class DateCellEditor
extends JPanel
implements TableCellEditor {
    private static final Log logger = LogFactory.getLog(DateCellEditor.class);
    private DateChooserPanel dateChooserPanel;
    private JTextField dateField;
    private DateFormat sdf;
    private DateChooserPopupMenu dateWindow;
    private JButton pickDateButton;
    private Class dateType;
    private EventListenerList listeners = new EventListenerList();
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    public DateCellEditor(Class dateType) {
        this.dateType = dateType;
        if (this.dateType.isArray()) {
            this.dateType = this.dateType.getComponentType();
        }
        this.setLayout(new BorderLayout());
        this.dateField = new JTextField();
        this.dateField.setColumns(20);
        this.dateField.setEditable(true);
        this.pickDateButton = new EllipsisButton(new PickDateListener());
        this.add((Component)this.dateField, "Center");
        this.add((Component)this.pickDateButton, "East");
    }

    private void init() {
        if (this.dateChooserPanel == null) {
            this.dateChooserPanel = new DateChooserPanel(Calendar.getInstance(), true);
            this.dateChooserPanel.addPropertyChangeListener("date", new InternalDateUpdateHandler());
            TextComponentEditHandler listener = new TextComponentEditHandler(this.dateField, this.dateChooserPanel);
            this.dateField.getDocument().addDocumentListener(listener);
            this.dateField.addActionListener(listener);
            if (this.sdf == null) {
                this.setDateFormat(DateCellEditor.createDateFormat(DEFAULT_FORMAT, Locale.getDefault(), TimeZone.getDefault()));
            }
        }
    }

    private static DateFormat createDateFormat(String parameterFormatString, Locale locale, TimeZone timeZone) {
        if (parameterFormatString != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(parameterFormatString, new DateFormatSymbols(locale));
                dateFormat.setTimeZone(timeZone);
                dateFormat.setLenient(true);
                return dateFormat;
            }
            catch (Exception e) {
                logger.warn((Object)"Parameter format-string for date-parameter was not a valid date-format-string", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT, new DateFormatSymbols(locale));
        dateFormat.setTimeZone(timeZone);
        dateFormat.setLenient(true);
        return dateFormat;
    }

    private void setDate(Object value) {
        block9: {
            this.init();
            if (this.dateWindow != null && this.dateWindow.isVisible()) {
                this.dateWindow.setVisible(false);
            }
            if (value == null) {
                this.dateChooserPanel.setDate(null);
                return;
            }
            if (value instanceof String) {
                try {
                    String text = (String)value;
                    if (StringUtils.isEmpty((String)text)) {
                        this.dateChooserPanel.setDate(null);
                        this.dateField.setText(null);
                        break block9;
                    }
                    Date date = this.convertValue(text);
                    this.dateChooserPanel.setDate(date);
                    this.dateField.setText(this.sdf.format(date));
                }
                catch (Exception e) {
                    logger.debug((Object)"Unparsable date-string", (Throwable)e);
                }
            } else if (value instanceof Date) {
                Date date = (Date)value;
                this.dateChooserPanel.setDate(date);
                this.dateField.setText(this.sdf.format(date));
            } else {
                logger.debug((Object)("Date-parameter must be set either as normalized date-string or as date-object: " + value + " [" + value.getClass() + "]"));
            }
        }
    }

    protected Date convertValue(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        try {
            Date o = (Date)this.sdf.parseObject(text);
            return DateConverter.convertToDateType(o, this.dateType);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to format object");
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.init();
        this.setDate(value);
        return this;
    }

    public Object getCellEditorValue() {
        this.init();
        return this.dateChooserPanel.getDate();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.dateWindow != null) {
            this.dateWindow.setVisible(false);
        }
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        if (this.dateWindow != null) {
            this.dateWindow.setVisible(false);
        }
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listeners.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.listeners.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(CellEditorListener.class, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(CellEditorListener.class, l);
    }

    public void setDateFormat(DateFormat timeFormat) {
        if (timeFormat == null) {
            throw new NullPointerException();
        }
        this.sdf = timeFormat;
        if (timeFormat instanceof SimpleDateFormat) {
            SimpleDateFormat dateFormat = (SimpleDateFormat)timeFormat;
            this.setToolTipText(dateFormat.toLocalizedPattern());
        } else {
            this.setToolTipText(null);
        }
        if (this.dateChooserPanel != null) {
            this.setDate(this.getCellEditorValue());
        }
    }

    public DateFormat getDateFormat() {
        return this.sdf;
    }

    private class InternalDateUpdateHandler
    implements PropertyChangeListener {
        private InternalDateUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent changeEvent) {
            if (!"date".equals(changeEvent.getPropertyName())) {
                return;
            }
            Date date = (Date)changeEvent.getNewValue();
            if (date == null) {
                DateCellEditor.this.dateField.setText(null);
            } else {
                DateCellEditor.this.dateField.setText(DateCellEditor.this.sdf.format(date));
            }
            if (DateCellEditor.this.dateChooserPanel.isDateSelected()) {
                DebugLog.log((Object)"PropertyChange on DATE - about to close");
                DateCellEditor.this.dateWindow.setVisible(false);
            }
        }
    }

    private class PickDateListener
    extends AbstractAction {
        private PickDateListener() {
            this.putValue("Name", "..");
        }

        public void actionPerformed(ActionEvent e) {
            if (DateCellEditor.this.dateWindow != null && DateCellEditor.this.dateWindow.isVisible()) {
                return;
            }
            if (DateCellEditor.this.dateWindow == null) {
                DateCellEditor.this.dateChooserPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                DateCellEditor.this.dateWindow = new DateChooserPopupMenu(DateCellEditor.this.dateChooserPanel);
                DateCellEditor.this.dateWindow.setLayout(new BorderLayout());
                DateCellEditor.this.dateWindow.add((Component)DateCellEditor.this.dateChooserPanel, "Center");
                DateCellEditor.this.dateWindow.pack();
            }
            DateCellEditor.this.dateChooserPanel.setDateSelected(false);
            DateCellEditor.this.dateWindow.show(DateCellEditor.this, 0, DateCellEditor.this.pickDateButton.getHeight());
        }
    }

    private class TextComponentEditHandler
    implements Runnable,
    DocumentListener,
    ActionListener {
        private JTextComponent textComponent;
        private DateChooserPanel dateChooserPanel;
        private Color color;
        private boolean inProgress;

        public TextComponentEditHandler(JTextComponent textComponent, DateChooserPanel dateChooserPanel) {
            this.textComponent = textComponent;
            this.dateChooserPanel = dateChooserPanel;
            this.color = this.textComponent.getBackground();
        }

        public void insertUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        public void removeUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        public void changedUpdate(DocumentEvent e) {
            this.convertParameterValue();
        }

        private void convertParameterValue() {
            if (this.inProgress) {
                return;
            }
            this.inProgress = true;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.convert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void convert() {
            try {
                String text = this.textComponent.getText();
                this.textComponent.setBackground(this.color);
                Date date = DateCellEditor.this.convertValue(text);
                this.dateChooserPanel.setDate(date);
            }
            catch (Exception e) {
                this.textComponent.setBackground(Color.RED);
            }
            finally {
                this.inProgress = false;
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.convert();
        }
    }
}

