/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.filechooser;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;

public class SwingFileChooserService
implements CommonFileChooser {
    protected static final File[] EMPTY_FILES = new File[0];
    protected static final FileFilter[] EMPTY_FILEFILTER = new FileFilter[0];
    protected static final Object lock = new Object();
    private static JFileChooser fileChooser;
    private String fileType;
    private File[] selectedFiles;
    private boolean allowMultiSelection;
    private FileFilter[] filters;

    public SwingFileChooserService(String fileType) {
        this.fileType = fileType;
        this.selectedFiles = EMPTY_FILES;
        this.filters = EMPTY_FILEFILTER;
    }

    public String getFileType() {
        return this.fileType;
    }

    public File[] getSelectedFiles() {
        return (File[])this.selectedFiles.clone();
    }

    public File getSelectedFile() {
        if (this.selectedFiles.length == 0) {
            return null;
        }
        return this.selectedFiles[0];
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFiles = selectedFile == null ? EMPTY_FILES : new File[]{selectedFile};
    }

    public void setSelectedFiles(File[] selectedFiles) {
        this.selectedFiles = (File[])selectedFiles.clone();
    }

    public boolean isAllowMultiSelection() {
        return this.allowMultiSelection;
    }

    public void setAllowMultiSelection(boolean allowMultiSelection) {
        this.allowMultiSelection = allowMultiSelection;
    }

    public FileFilter[] getFilters() {
        return (FileFilter[])this.filters.clone();
    }

    public void setFilters(FileFilter[] filters) {
        this.filters = (FileFilter[])filters.clone();
    }

    public boolean showDialog(Component parent, int mode) {
        File currentDirectory = null;
        if (this.selectedFiles.length == 0) {
            if (FileChooserService.getInstance().isStoreLocations(this.getFileType())) {
                File lastLocation = FileChooserService.getInstance().getLastLocation(this.getFileType());
                if (lastLocation != null) {
                    if (lastLocation.isDirectory()) {
                        currentDirectory = lastLocation;
                        this.setSelectedFile(null);
                    } else {
                        currentDirectory = lastLocation.getParentFile();
                        this.setSelectedFile(lastLocation);
                    }
                }
            } else {
                File staticLocation = FileChooserService.getInstance().getStaticLocation(this.getFileType());
                if (staticLocation != null) {
                    if (staticLocation.isDirectory()) {
                        currentDirectory = staticLocation;
                        this.setSelectedFile(null);
                    } else {
                        currentDirectory = staticLocation.getParentFile();
                        this.setSelectedFile(staticLocation);
                    }
                }
            }
        }
        FileSelectionTask task = new FileSelectionTask(parent, mode, this.getFilters(), this.getSelectedFiles(), currentDirectory, this.isAllowMultiSelection());
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (task.getRetval() == 0) {
            this.selectedFiles = task.getSelectedFiles();
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null && FileChooserService.getInstance().isStoreLocations(this.getFileType())) {
                FileChooserService.getInstance().setLastLocation(this.getFileType(), selectedFile);
            }
            return true;
        }
        return false;
    }

    private static class FileSelectionTask
    implements Runnable {
        private FileFilter[] filters;
        private Component parent;
        private int mode;
        private int retval;
        private File[] selectedFiles;
        private boolean allowMultiSelection;
        private File currentDirectory;

        private FileSelectionTask(Component parent, int mode, FileFilter[] filters, File[] selectedFiles, File currentDirectory, boolean allowMultiSelection) {
            this.parent = parent;
            this.mode = mode;
            this.filters = filters;
            this.selectedFiles = selectedFiles;
            this.currentDirectory = currentDirectory;
            this.allowMultiSelection = allowMultiSelection;
        }

        public int getRetval() {
            return this.retval;
        }

        public File[] getSelectedFiles() {
            return this.selectedFiles;
        }

        public void run() {
            if (fileChooser == null) {
                fileChooser = new JFileChooser();
            }
            fileChooser.setMultiSelectionEnabled(this.allowMultiSelection);
            fileChooser.setCurrentDirectory(this.currentDirectory);
            fileChooser.setSelectedFiles(this.selectedFiles);
            fileChooser.updateUI();
            fileChooser.resetChoosableFileFilters();
            for (int i = 0; i < this.filters.length; ++i) {
                fileChooser.addChoosableFileFilter(this.filters[i]);
            }
            this.retval = this.mode == 0 ? fileChooser.showOpenDialog(this.parent) : fileChooser.showSaveDialog(this.parent);
            this.selectedFiles = this.retval == 0 ? (fileChooser.isMultiSelectionEnabled() ? fileChooser.getSelectedFiles() : new File[]{fileChooser.getSelectedFile()}) : EMPTY_FILES;
        }
    }
}

