/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.BasicFontPropertiesPane;

public class FontPropertyEditor
implements PropertyEditor {
    private BasicFontPropertiesPane basicFontPropertiesPane;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Font font;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setValue(Object value) {
        Font oldValue = this.font;
        this.font = value instanceof Font ? (Font)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.font);
    }

    public Object getValue() {
        return this.font;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        if (this.font == null) {
            return null;
        }
        String style = this.font.isBold() && this.font.isItalic() ? "BOLDITALIC" : (this.font.isBold() ? "BOLD" : (this.font.isItalic() ? "ITALIC" : "PLAIN"));
        return this.font.getFamily() + '-' + style + '-' + this.font.getSize();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(Font.decode(text));
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.basicFontPropertiesPane == null) {
            this.basicFontPropertiesPane = new BasicFontPropertiesPane();
            this.basicFontPropertiesPane.setExtendedFontPropertiesShowing(false);
            this.basicFontPropertiesPane.init();
            this.basicFontPropertiesPane.addChangeListener(new FontPropertiesHandler());
        }
        if (this.font != null) {
            this.basicFontPropertiesPane.setFontFamily(this.font.getFamily());
            this.basicFontPropertiesPane.setFontStyle(this.font.getStyle());
            this.basicFontPropertiesPane.setFontSize(this.font.getSize());
        }
        return this.basicFontPropertiesPane;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private class FontPropertiesHandler
    implements ChangeListener {
        private FontPropertiesHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            String fontName = FontPropertyEditor.this.basicFontPropertiesPane.getFontFamily();
            int fontSize = FontPropertyEditor.this.basicFontPropertiesPane.getFontSize();
            int fontStyle = FontPropertyEditor.this.basicFontPropertiesPane.getFontStyle();
            FontPropertyEditor.this.setValue(new Font(fontName, fontStyle, fontSize));
        }
    }
}

