/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;

public class PropertyEditorCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private PropertyEditor propertyEditor;
    private JTextField defaultCellEditor;
    private boolean usingCustomEditor;
    private boolean usingTags;
    private JComboBox tagsCellEditor = new JComboBox();

    public PropertyEditorCellEditor() {
        this.tagsCellEditor.addActionListener(new SelectionAction());
        this.tagsCellEditor.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.tagsCellEditor.getInputMap().put(KeyStroke.getKeyStroke(27, 0), new CancelAction());
        this.tagsCellEditor.setRenderer(new TagListComboBoxRenderer());
        this.defaultCellEditor = new JTextField();
        this.defaultCellEditor.addActionListener(new SelectionAction());
        this.defaultCellEditor.setBorder(BorderFactory.createEmptyBorder());
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.propertyEditor.setValue(value);
        if (this.propertyEditor.supportsCustomEditor()) {
            this.usingCustomEditor = true;
            return this.propertyEditor.getCustomEditor();
        }
        String[] tags = this.propertyEditor.getTags();
        if (tags != null) {
            this.usingCustomEditor = false;
            this.usingTags = true;
            this.tagsCellEditor.setModel(new DefaultComboBoxModel<String>(tags));
            this.tagsCellEditor.setSelectedItem(this.propertyEditor.getAsText());
            return this.tagsCellEditor;
        }
        this.usingCustomEditor = false;
        this.usingTags = false;
        this.defaultCellEditor.setText(this.propertyEditor.getAsText());
        return this.defaultCellEditor;
    }

    public Object getCellEditorValue() {
        if (this.propertyEditor == null) {
            return null;
        }
        if (this.usingCustomEditor) {
            return this.propertyEditor.getValue();
        }
        try {
            if (this.usingTags) {
                String text = (String)this.tagsCellEditor.getSelectedItem();
                this.propertyEditor.setAsText(text);
                return this.propertyEditor.getValue();
            }
            String text = this.defaultCellEditor.getText();
            this.propertyEditor.setAsText(text);
            return this.propertyEditor.getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean stopCellEditing() {
        if (this.usingCustomEditor) {
            this.fireEditingStopped();
            return true;
        }
        if (this.usingTags) {
            String s = (String)this.tagsCellEditor.getSelectedItem();
            this.propertyEditor.setAsText(s);
            boolean retval = this.propertyEditor.getValue() != null;
            this.fireEditingStopped();
            return retval;
        }
        try {
            this.propertyEditor.setAsText(this.defaultCellEditor.getText());
            boolean retval = this.propertyEditor.getValue() != null;
            this.fireEditingStopped();
            return retval;
        }
        catch (Exception e) {
            this.fireEditingCanceled();
            return true;
        }
    }

    private static class TagListComboBoxRenderer
    extends DefaultListCellRenderer {
        private TagListComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, "<undefined>", index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    protected class CancelAction
    extends AbstractAction {
        protected CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PropertyEditorCellEditor.this.cancelCellEditing();
        }
    }

    private class SelectionAction
    implements ActionListener {
        private SelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!PropertyEditorCellEditor.this.usingCustomEditor) {
                PropertyEditorCellEditor.this.stopCellEditing();
            }
        }
    }
}

