/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class PropertyEditorCellRenderer
implements TableCellRenderer,
ListCellRenderer {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private PropertyEditor propertyEditor;
    private DefaultTableCellRenderer fallbackRenderer = new DefaultTableCellRenderer();
    private PropertyPainter propertyPainter;

    public PropertyEditorCellRenderer() {
        this.fallbackRenderer.putClientProperty("html.disable", Boolean.TRUE);
        this.propertyPainter = new PropertyPainter();
    }

    public Component getListCellRendererComponent(JList table, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (this.propertyEditor == null) {
            throw new IllegalStateException();
        }
        try {
            this.propertyEditor.setValue(value);
            if (value != null) {
                if (this.propertyEditor.isPaintable()) {
                    return this.propertyPainter;
                }
                this.fallbackRenderer.setText(this.propertyEditor.getAsText());
            } else {
                this.fallbackRenderer.setText("");
            }
        }
        catch (Exception e) {
            this.fallbackRenderer.setText(this.propertyEditor.getAsText());
        }
        if (isSelected) {
            this.fallbackRenderer.setForeground(table.getSelectionForeground());
            this.fallbackRenderer.setBackground(table.getSelectionBackground());
        } else {
            this.fallbackRenderer.setForeground(table.getForeground());
            this.fallbackRenderer.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.fallbackRenderer.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.fallbackRenderer.setBorder(NO_FOCUS_BORDER);
        }
        return this.fallbackRenderer;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.propertyEditor == null) {
            throw new IllegalStateException();
        }
        try {
            this.propertyEditor.setValue(value);
            if (value != null && this.propertyEditor.isPaintable()) {
                return this.propertyPainter;
            }
            this.fallbackRenderer.setText(this.propertyEditor.getAsText());
        }
        catch (Exception e) {
            this.fallbackRenderer.setText(this.propertyEditor.getAsText());
        }
        if (isSelected) {
            this.fallbackRenderer.setForeground(table.getSelectionForeground());
            this.fallbackRenderer.setBackground(table.getSelectionBackground());
        } else {
            this.fallbackRenderer.setForeground(table.getForeground());
            this.fallbackRenderer.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.fallbackRenderer.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.fallbackRenderer.setBorder(NO_FOCUS_BORDER);
        }
        return this.fallbackRenderer;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    private class PropertyPainter
    extends JComponent {
        private PropertyPainter() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            PropertyEditor propertyEditor = PropertyEditorCellRenderer.this.getPropertyEditor();
            if (propertyEditor == null) {
                return;
            }
            if (!propertyEditor.isPaintable()) {
                return;
            }
            propertyEditor.paintValue(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }
}

