/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.settings;

import java.util.Locale;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class DefaultLocaleSettings
implements LocaleSettings {
    private static final String DATE_FORMAT_PATTERN = "DateFormatPattern";
    private static final String TIME_FORMAT_PATTERN = "TimeFormatPattern";
    private static final String DATETIME_FORMAT_PATTERN = "DatetimeFormatPattern";
    private Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/libraries/designtime/swing/locale-settings");

    private void put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (StringUtils.isEmpty((String)value)) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    private String getString(String key) {
        return this.properties.get(key, null);
    }

    public String getDateFormatPattern() {
        String s = this.getString(DATE_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return "yyyy-MM-dd";
        }
        return s;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.put(DATE_FORMAT_PATTERN, dateFormatPattern);
    }

    public String getTimeFormatPattern() {
        String s = this.getString(DATE_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return "HH:mm:ss.SSSS";
        }
        return s;
    }

    public void setTimeFormatPattern(String timeFormatPattern) {
        this.put(TIME_FORMAT_PATTERN, timeFormatPattern);
    }

    public String getDatetimeFormatPattern() {
        String s = this.getString(DATE_FORMAT_PATTERN);
        if (StringUtils.isEmpty((String)s)) {
            return "yyyy-MM-dd HH:mm:ss.SSSS";
        }
        return s;
    }

    public void setDatetimeFormatPattern(String datetimeFormatPattern) {
        this.put(DATETIME_FORMAT_PATTERN, datetimeFormatPattern);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }
}

