/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.mapreduce.server.tasktracker.Localizer;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.Shell;

public class DefaultTaskController
extends TaskController {
    private static final Log LOG = LogFactory.getLog(DefaultTaskController.class);
    private FileSystem fs;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        try {
            this.fs = FileSystem.getLocal((Configuration)conf).getRaw();
        }
        catch (IOException ie) {
            throw new RuntimeException("Failed getting LocalFileSystem", ie);
        }
    }

    @Override
    public void createLogDir(TaskAttemptID taskID, boolean isCleanup) throws IOException {
        TaskLog.createTaskAttemptLogDir(taskID, isCleanup, this.localStorage.getDirs());
    }

    @Override
    public int launchTask(String user, String jobId, String attemptId, List<String> setup, List<String> jvmArguments, File currentWorkDirectory, String stdout, String stderr) throws IOException {
        Shell.ShellCommandExecutor shExec = null;
        try {
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.getConf());
            new Localizer((FileSystem)localFs, this.getConf().getTrimmedStrings("mapred.local.dir")).initializeAttemptDirs(user, jobId, attemptId);
            if (!currentWorkDirectory.mkdir()) {
                throw new IOException("Mkdirs failed to create " + currentWorkDirectory.toString());
            }
            String logLocation = TaskLog.getAttemptDir(jobId, attemptId).toString();
            if (!localFs.mkdirs(new Path(logLocation))) {
                throw new IOException("Mkdirs failed to create " + logLocation);
            }
            FileSystem rawFs = FileSystem.getLocal((Configuration)this.getConf()).getRaw();
            long logSize = 0L;
            String cmdLine = TaskLog.buildCommandLine(setup, jvmArguments, new File(stdout), new File(stderr), logSize, true);
            Path p = new Path(this.allocator.getLocalPathForWrite(TaskTracker.getPrivateDirTaskScriptLocation(user, jobId, attemptId), this.getConf()), "taskjvm.sh");
            String commandFile = DefaultTaskController.writeCommand(cmdLine, rawFs, p);
            try {
                rawFs.setPermission(p, TaskController.TASK_LAUNCH_SCRIPT_PERMISSION);
            }
            catch (Shell.ExitCodeException ece) {
                throw new IOException("Could not set permissions on " + p, ece);
            }
            shExec = new Shell.ShellCommandExecutor(new String[]{"bash", "-c", commandFile}, currentWorkDirectory);
            shExec.execute();
        }
        catch (Shell.ExitCodeException ece) {
            if (shExec != null) {
                this.logShExecStatus(shExec);
            }
            if (ece.getMessage() != null && !ece.getMessage().isEmpty()) {
                LOG.warn((Object)("Task wrapper stderr: " + ece.getMessage()));
            }
            return shExec != null ? shExec.getExitCode() : -1;
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected error launching task JVM", (Throwable)e);
            if (shExec != null) {
                this.logShExecStatus(shExec);
            }
            return -1;
        }
        return 0;
    }

    private void logShExecStatus(Shell.ShellCommandExecutor shExec) {
        LOG.warn((Object)("Exit code from task is : " + shExec.getExitCode()));
        String stdout = shExec.getOutput().trim();
        if (!stdout.isEmpty()) {
            LOG.info((Object)"Output from DefaultTaskController's launchTask follows:");
            this.logOutput(shExec.getOutput());
        }
    }

    @Override
    public void initializeJob(String user, String jobid, Path credentials, Path jobConf, TaskUmbilicalProtocol taskTracker, InetSocketAddress ttAddr) throws IOException, InterruptedException {
        LocalDirAllocator lDirAlloc = this.allocator;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.getConf());
        JobLocalizer localizer = new JobLocalizer((JobConf)this.getConf(), user, jobid);
        localizer.createLocalDirs();
        localizer.createUserDirs();
        localizer.createJobDirs();
        JobConf jConf = new JobConf(jobConf);
        localizer.createWorkDir(jConf);
        Path localJobTokenFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getLocalJobTokenFile(user, jobid), this.getConf());
        FileUtil.copy((FileSystem)localFs, (Path)credentials, (FileSystem)localFs, (Path)localJobTokenFile, (boolean)false, (Configuration)this.getConf());
        localizer.initializeJobLogDir();
        localizer.localizeJobFiles(JobID.forName(jobid), jConf, localJobTokenFile, taskTracker);
    }

    @Override
    public void signalTask(String user, int taskPid, ProcessTree.Signal signal) {
        if (ProcessTree.isSetsidAvailable) {
            ProcessTree.killProcessGroup(Integer.toString(taskPid), signal);
        } else {
            ProcessTree.killProcess(Integer.toString(taskPid), signal);
        }
    }

    @Override
    public void deleteAsUser(String user, String subDir) throws IOException {
        String dir = TaskTracker.getUserDir(user) + "/" + subDir;
        for (Path fullDir : this.allocator.getAllLocalPathsToRead(dir, this.getConf())) {
            this.fs.delete(fullDir, true);
        }
    }

    @Override
    public void deleteLogAsUser(String user, String subDir) throws IOException {
        Path dir = new Path(TaskLog.getUserLogDir().getAbsolutePath(), subDir);
        File subDirPath = new File(dir.toString());
        FileUtil.fullyDelete((File)subDirPath);
        for (String localdir : this.localStorage.getDirs()) {
            String dirPath = localdir + File.separatorChar + "userlogs" + File.separatorChar + subDir;
            try {
                FileUtil.fullyDelete((File)new File(dirPath));
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not delete dir: " + dirPath + " , Reason : " + e.getMessage()));
            }
        }
    }

    @Override
    public void truncateLogsAsUser(String user, List<Task> allAttempts) throws IOException {
        Task firstTask = allAttempts.get(0);
        TaskLogsTruncater trunc = new TaskLogsTruncater(this.getConf());
        trunc.truncateLogs(new JVMInfo(TaskLog.getAttemptDir(firstTask.getTaskID(), firstTask.isTaskCleanupTask()), allAttempts));
    }

    @Override
    public void setup(LocalDirAllocator allocator, TaskTracker.LocalStorage localStorage) {
        this.allocator = allocator;
        this.localStorage = localStorage;
    }
}

