/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.IFileOutputStream;
import org.apache.hadoop.mapred.RamManager;
import org.apache.hadoop.mapred.TaskAttemptID;

class IFile {
    private static final Log LOG = LogFactory.getLog(IFile.class);
    private static final int EOF_MARKER = -1;

    IFile() {
    }

    public static class InMemoryReader<K, V>
    extends Reader<K, V> {
        RamManager ramManager;
        TaskAttemptID taskAttemptId;

        public InMemoryReader(RamManager ramManager, TaskAttemptID taskAttemptId, byte[] data, int start, int length) throws IOException {
            super(null, null, length - start, null, null);
            this.ramManager = ramManager;
            this.taskAttemptId = taskAttemptId;
            this.buffer = data;
            this.bufferSize = (int)this.fileLength;
            this.dataIn.reset(this.buffer, start, length);
        }

        @Override
        public long getPosition() throws IOException {
            return this.bytesRead;
        }

        @Override
        public long getLength() {
            return this.fileLength;
        }

        private void dumpOnError() {
            File dumpFile = new File("../output/" + this.taskAttemptId + ".dump");
            System.err.println("Dumping corrupt map-output of " + this.taskAttemptId + " to " + dumpFile.getAbsolutePath());
            try {
                FileOutputStream fos = new FileOutputStream(dumpFile);
                fos.write(this.buffer, 0, this.bufferSize);
                fos.close();
            }
            catch (IOException ioe) {
                System.err.println("Failed to dump map-output of " + this.taskAttemptId);
            }
        }

        @Override
        public boolean next(DataInputBuffer key, DataInputBuffer value) throws IOException {
            try {
                if (this.eof) {
                    throw new EOFException("Completed reading " + this.bytesRead);
                }
                int oldPos = this.dataIn.getPosition();
                int keyLength = WritableUtils.readVInt((DataInput)this.dataIn);
                int valueLength = WritableUtils.readVInt((DataInput)this.dataIn);
                int pos = this.dataIn.getPosition();
                this.bytesRead += (long)(pos - oldPos);
                if (keyLength == -1 && valueLength == -1) {
                    this.eof = true;
                    return false;
                }
                if (keyLength < 0) {
                    throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + keyLength);
                }
                if (valueLength < 0) {
                    throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + valueLength);
                }
                int recordLength = keyLength + valueLength;
                pos = this.dataIn.getPosition();
                byte[] data = this.dataIn.getData();
                key.reset(data, pos, keyLength);
                value.reset(data, pos + keyLength, valueLength);
                long skipped = this.dataIn.skip((long)recordLength);
                if (skipped != (long)recordLength) {
                    throw new IOException("Rec# " + this.recNo + ": Failed to skip past record of length: " + recordLength);
                }
                this.bytesRead += (long)recordLength;
                ++this.recNo;
                return true;
            }
            catch (IOException ioe) {
                this.dumpOnError();
                throw ioe;
            }
        }

        @Override
        public void close() {
            this.dataIn = null;
            this.buffer = null;
            this.ramManager.unreserve(this.bufferSize);
        }
    }

    public static class Reader<K, V> {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private static final int MAX_VINT_SIZE = 9;
        private long numRecordsRead = 0L;
        private final Counters.Counter readRecordsCounter;
        final InputStream in;
        Decompressor decompressor;
        long bytesRead = 0L;
        final long fileLength;
        boolean eof = false;
        final IFileInputStream checksumIn;
        byte[] buffer = null;
        int bufferSize = 131072;
        DataInputBuffer dataIn = new DataInputBuffer();
        int recNo = 1;

        public Reader(Configuration conf, FileSystem fs, Path file, CompressionCodec codec, Counters.Counter readsCounter) throws IOException {
            this(conf, fs.open(file), fs.getFileStatus(file).getLen(), codec, readsCounter);
        }

        public Reader(Configuration conf, FSDataInputStream in, long length, CompressionCodec codec, Counters.Counter readsCounter) throws IOException {
            this.readRecordsCounter = readsCounter;
            this.checksumIn = new IFileInputStream((InputStream)in, length);
            if (codec != null) {
                this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (this.decompressor != null) {
                    this.in = codec.createInputStream((InputStream)this.checksumIn, this.decompressor);
                } else {
                    LOG.warn((Object)"Could not obtain decompressor from CodecPool");
                    this.in = this.checksumIn;
                }
            } else {
                this.in = this.checksumIn;
            }
            this.fileLength = length;
            if (conf != null) {
                this.bufferSize = conf.getInt("io.file.buffer.size", 131072);
            }
        }

        public long getLength() {
            return this.fileLength - this.checksumIn.getSize();
        }

        public long getPosition() throws IOException {
            return this.checksumIn.getPosition();
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = this.in.read(buf, off + bytesRead, len - bytesRead);
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        void readNextBlock(int minSize) throws IOException {
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
                this.dataIn.reset(this.buffer, 0, 0);
            }
            this.buffer = this.rejigData(this.buffer, this.bufferSize < minSize ? new byte[minSize << 1] : this.buffer);
            this.bufferSize = this.buffer.length;
        }

        private byte[] rejigData(byte[] source, byte[] destination) throws IOException {
            int bytesRemaining = this.dataIn.getLength() - this.dataIn.getPosition();
            if (bytesRemaining > 0) {
                System.arraycopy(source, this.dataIn.getPosition(), destination, 0, bytesRemaining);
            }
            int n = this.readData(destination, bytesRemaining, destination.length - bytesRemaining);
            this.dataIn.reset(destination, 0, bytesRemaining + n);
            return destination;
        }

        public boolean next(DataInputBuffer key, DataInputBuffer value) throws IOException {
            if (this.eof) {
                throw new EOFException("Completed reading " + this.bytesRead);
            }
            if (this.dataIn.getLength() - this.dataIn.getPosition() < 18) {
                this.readNextBlock(18);
            }
            int oldPos = this.dataIn.getPosition();
            int keyLength = WritableUtils.readVInt((DataInput)this.dataIn);
            int valueLength = WritableUtils.readVInt((DataInput)this.dataIn);
            int pos = this.dataIn.getPosition();
            this.bytesRead += (long)(pos - oldPos);
            if (keyLength == -1 && valueLength == -1) {
                this.eof = true;
                return false;
            }
            if (keyLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative key-length: " + keyLength);
            }
            if (valueLength < 0) {
                throw new IOException("Rec# " + this.recNo + ": Negative value-length: " + valueLength);
            }
            int recordLength = keyLength + valueLength;
            if (this.dataIn.getLength() - pos < recordLength) {
                this.readNextBlock(recordLength);
                if (this.dataIn.getLength() - this.dataIn.getPosition() < recordLength) {
                    throw new EOFException("Rec# " + this.recNo + ": Could read the next " + " record");
                }
            }
            pos = this.dataIn.getPosition();
            byte[] data = this.dataIn.getData();
            key.reset(data, pos, keyLength);
            value.reset(data, pos + keyLength, valueLength);
            long skipped = this.dataIn.skip((long)recordLength);
            if (skipped != (long)recordLength) {
                throw new IOException("Rec# " + this.recNo + ": Failed to skip past record " + "of length: " + recordLength);
            }
            this.bytesRead += (long)recordLength;
            ++this.recNo;
            ++this.numRecordsRead;
            return true;
        }

        public void close() throws IOException {
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
            this.in.close();
            this.dataIn = null;
            this.buffer = null;
            if (this.readRecordsCounter != null) {
                this.readRecordsCounter.increment(this.numRecordsRead);
            }
        }
    }

    public static class Writer<K, V> {
        FSDataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        FSDataOutputStream rawOut;
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        private long numRecordsWritten = 0L;
        private final Counters.Counter writtenRecordsCounter;
        IFileOutputStream checksumOut;
        Class<K> keyClass;
        Class<V> valueClass;
        Serializer<K> keySerializer;
        Serializer<V> valueSerializer;
        DataOutputBuffer buffer = new DataOutputBuffer();

        public Writer(Configuration conf, FileSystem fs, Path file, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Counters.Counter writesCounter) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec, writesCounter);
            this.ownOutputStream = true;
        }

        public Writer(Configuration conf, FSDataOutputStream out, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec, Counters.Counter writesCounter) throws IOException {
            this.writtenRecordsCounter = writesCounter;
            this.checksumOut = new IFileOutputStream((OutputStream)out);
            this.rawOut = out;
            this.start = this.rawOut.getPos();
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                if (this.compressor != null) {
                    this.compressor.reset();
                    this.compressedOut = codec.createOutputStream((OutputStream)this.checksumOut, this.compressor);
                    this.out = new FSDataOutputStream((OutputStream)this.compressedOut, null);
                    this.compressOutput = true;
                } else {
                    LOG.warn((Object)"Could not obtain compressor from CodecPool");
                    this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
                }
            } else {
                this.out = new FSDataOutputStream((OutputStream)this.checksumOut, null);
            }
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keySerializer = serializationFactory.getSerializer(keyClass);
            this.keySerializer.open((OutputStream)this.buffer);
            this.valueSerializer = serializationFactory.getSerializer(valueClass);
            this.valueSerializer.open((OutputStream)this.buffer);
        }

        public void close() throws IOException {
            this.keySerializer.close();
            this.valueSerializer.close();
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize((long)-1L));
            this.out.flush();
            if (this.compressOutput) {
                this.compressedOut.finish();
                this.compressedOut.resetState();
            }
            if (this.ownOutputStream) {
                this.out.close();
            } else {
                this.checksumOut.finish();
            }
            this.compressedBytesWritten = this.rawOut.getPos() - this.start;
            if (this.compressOutput) {
                CodecPool.returnCompressor((Compressor)this.compressor);
                this.compressor = null;
            }
            this.out = null;
            if (this.writtenRecordsCounter != null) {
                this.writtenRecordsCounter.increment(this.numRecordsWritten);
            }
        }

        public void append(K key, V value) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass() + " is not " + this.keyClass);
            }
            if (value.getClass() != this.valueClass) {
                throw new IOException("wrong value class: " + value.getClass() + " is not " + this.valueClass);
            }
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
            this.buffer.reset();
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
            ++this.numRecordsWritten;
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            if (keyLength < 0) {
                throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
            }
            int valueLength = value.getLength() - value.getPosition();
            if (valueLength < 0) {
                throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
            }
            WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(key.getData(), key.getPosition(), keyLength);
            this.out.write(value.getData(), value.getPosition(), valueLength);
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength));
            ++this.numRecordsWritten;
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }
    }
}

