/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapred.lib.KeyFieldBasedComparator;
import org.apache.hadoop.mapred.lib.KeyFieldBasedPartitioner;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.ReflectionUtils;

public class JobConf
extends Configuration {
    private static final Log LOG = LogFactory.getLog(JobConf.class);
    @Deprecated
    public static final String MAPRED_TASK_MAXVMEM_PROPERTY = "mapred.task.maxvmem";
    @Deprecated
    public static final String UPPER_LIMIT_ON_TASK_VMEM_PROPERTY = "mapred.task.limit.maxvmem";
    @Deprecated
    public static final String MAPRED_TASK_DEFAULT_MAXVMEM_PROPERTY = "mapred.task.default.maxvmem";
    @Deprecated
    public static final String MAPRED_TASK_MAXPMEM_PROPERTY = "mapred.task.maxpmem";
    public static final long DISABLED_MEMORY_LIMIT = -1L;
    public static final String MAPRED_LOCAL_DIR_PROPERTY = "mapred.local.dir";
    public static final String DEFAULT_QUEUE_NAME = "default";
    static final String MAPRED_JOB_MAP_MEMORY_MB_PROPERTY = "mapred.job.map.memory.mb";
    static final String MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY = "mapred.job.reduce.memory.mb";
    public static final Pattern UNPACK_JAR_PATTERN_DEFAULT;
    public static final String JOB_LEVEL_AUTHORIZATION_ENABLING_FLAG = "mapreduce.cluster.job-authorization-enabled";
    static final String MR_ACLS_ENABLED = "mapred.acls.enabled";
    static final String MR_ADMINS = "mapreduce.cluster.administrators";
    @Deprecated
    public static final String MAPRED_TASK_JAVA_OPTS = "mapred.child.java.opts";
    public static final String MAPRED_MAP_TASK_JAVA_OPTS = "mapred.map.child.java.opts";
    public static final String MAPRED_REDUCE_TASK_JAVA_OPTS = "mapred.reduce.child.java.opts";
    public static final String DEFAULT_MAPRED_TASK_JAVA_OPTS = "-Xmx200m";
    @Deprecated
    public static final String MAPRED_TASK_ULIMIT = "mapred.child.ulimit";
    public static final String MAPRED_MAP_TASK_ULIMIT = "mapred.map.child.ulimit";
    public static final String MAPRED_REDUCE_TASK_ULIMIT = "mapred.reduce.child.ulimit";
    @Deprecated
    public static final String MAPRED_TASK_ENV = "mapred.child.env";
    public static final String MAPRED_MAP_TASK_ENV = "mapred.map.child.env";
    public static final String MAPRED_REDUCE_TASK_ENV = "mapred.reduce.child.env";
    private Credentials credentials = new Credentials();

    public JobConf() {
        this.checkAndWarnDeprecation();
    }

    public JobConf(Class exampleClass) {
        this.setJarByClass(exampleClass);
        this.checkAndWarnDeprecation();
    }

    public JobConf(Configuration conf) {
        super(conf);
        if (conf instanceof JobConf) {
            JobConf that = (JobConf)conf;
            this.credentials = that.credentials;
        }
        this.checkAndWarnDeprecation();
    }

    public JobConf(Configuration conf, Class exampleClass) {
        this(conf);
        this.setJarByClass(exampleClass);
    }

    public JobConf(String config) {
        this(new Path(config));
    }

    public JobConf(Path config) {
        this.addResource(config);
        this.checkAndWarnDeprecation();
    }

    public JobConf(boolean loadDefaults) {
        super(loadDefaults);
        this.checkAndWarnDeprecation();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getJar() {
        return this.get("mapred.jar");
    }

    public void setJar(String jar) {
        this.set("mapred.jar", jar);
    }

    public Pattern getJarUnpackPattern() {
        return this.getPattern("mapreduce.job.jar.unpack.pattern", UNPACK_JAR_PATTERN_DEFAULT);
    }

    public void setJarByClass(Class cls) {
        String jar = JobConf.findContainingJar(cls);
        if (jar != null) {
            this.setJar(jar);
        }
    }

    public String[] getLocalDirs() throws IOException {
        return this.getTrimmedStrings(MAPRED_LOCAL_DIR_PROPERTY);
    }

    @Deprecated
    public void deleteLocalFiles() throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal((Configuration)this).delete(new Path(localDirs[i]));
        }
    }

    public void deleteLocalFiles(String subdir) throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal((Configuration)this).delete(new Path(localDirs[i], subdir));
        }
    }

    public Path getLocalPath(String pathString) throws IOException {
        return this.getLocalPath(MAPRED_LOCAL_DIR_PROPERTY, pathString);
    }

    public String getUser() {
        return this.get("user.name");
    }

    public void setUser(String user) {
        this.set("user.name", user);
    }

    public void setKeepFailedTaskFiles(boolean keep) {
        this.setBoolean("keep.failed.task.files", keep);
    }

    public boolean getKeepFailedTaskFiles() {
        return this.getBoolean("keep.failed.task.files", false);
    }

    public void setKeepTaskFilesPattern(String pattern) {
        this.set("keep.task.files.pattern", pattern);
    }

    public String getKeepTaskFilesPattern() {
        return this.get("keep.task.files.pattern");
    }

    public void setWorkingDirectory(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.working.dir", dir.toString());
    }

    public Path getWorkingDirectory() {
        String name = this.get("mapred.working.dir");
        if (name != null) {
            return new Path(name);
        }
        try {
            Path dir = FileSystem.get((Configuration)this).getWorkingDirectory();
            this.set("mapred.working.dir", dir.toString());
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNumTasksToExecutePerJvm(int numTasks) {
        this.setInt("mapred.job.reuse.jvm.num.tasks", numTasks);
    }

    public int getNumTasksToExecutePerJvm() {
        return this.getInt("mapred.job.reuse.jvm.num.tasks", 1);
    }

    public InputFormat getInputFormat() {
        return (InputFormat)ReflectionUtils.newInstance((Class)this.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), (Configuration)this);
    }

    public void setInputFormat(Class<? extends InputFormat> theClass) {
        this.setClass("mapred.input.format.class", theClass, InputFormat.class);
    }

    public OutputFormat getOutputFormat() {
        return (OutputFormat)ReflectionUtils.newInstance((Class)this.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), (Configuration)this);
    }

    public OutputCommitter getOutputCommitter() {
        return (OutputCommitter)ReflectionUtils.newInstance((Class)this.getClass("mapred.output.committer.class", FileOutputCommitter.class, OutputCommitter.class), (Configuration)this);
    }

    public void setOutputCommitter(Class<? extends OutputCommitter> theClass) {
        this.setClass("mapred.output.committer.class", theClass, OutputCommitter.class);
    }

    public void setOutputFormat(Class<? extends OutputFormat> theClass) {
        this.setClass("mapred.output.format.class", theClass, OutputFormat.class);
    }

    public void setCompressMapOutput(boolean compress) {
        this.setBoolean("mapred.compress.map.output", compress);
    }

    public boolean getCompressMapOutput() {
        return this.getBoolean("mapred.compress.map.output", false);
    }

    public void setMapOutputCompressorClass(Class<? extends CompressionCodec> codecClass) {
        this.setCompressMapOutput(true);
        this.setClass("mapred.map.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public Class<? extends CompressionCodec> getMapOutputCompressorClass(Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = this.get("mapred.map.output.compression.codec");
        if (name != null) {
            try {
                codecClass = this.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public Class<?> getMapOutputKeyClass() {
        Class<?> retv = this.getClass("mapred.mapoutput.key.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputKeyClass();
        }
        return retv;
    }

    public void setMapOutputKeyClass(Class<?> theClass) {
        this.setClass("mapred.mapoutput.key.class", theClass, Object.class);
    }

    public Class<?> getMapOutputValueClass() {
        Class<?> retv = this.getClass("mapred.mapoutput.value.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputValueClass();
        }
        return retv;
    }

    public void setMapOutputValueClass(Class<?> theClass) {
        this.setClass("mapred.mapoutput.value.class", theClass, Object.class);
    }

    public Class<?> getOutputKeyClass() {
        return this.getClass("mapred.output.key.class", LongWritable.class, Object.class);
    }

    public void setOutputKeyClass(Class<?> theClass) {
        this.setClass("mapred.output.key.class", theClass, Object.class);
    }

    public RawComparator getOutputKeyComparator() {
        Class theClass = this.getClass("mapred.output.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)this);
        }
        return WritableComparator.get(this.getMapOutputKeyClass().asSubclass(WritableComparable.class));
    }

    public void setOutputKeyComparatorClass(Class<? extends RawComparator> theClass) {
        this.setClass("mapred.output.key.comparator.class", theClass, RawComparator.class);
    }

    public void setKeyFieldComparatorOptions(String keySpec) {
        this.setOutputKeyComparatorClass(KeyFieldBasedComparator.class);
        this.set("mapred.text.key.comparator.options", keySpec);
    }

    public String getKeyFieldComparatorOption() {
        return this.get("mapred.text.key.comparator.options");
    }

    public void setKeyFieldPartitionerOptions(String keySpec) {
        this.setPartitionerClass(KeyFieldBasedPartitioner.class);
        this.set("mapred.text.key.partitioner.options", keySpec);
    }

    public String getKeyFieldPartitionerOption() {
        return this.get("mapred.text.key.partitioner.options");
    }

    public RawComparator getOutputValueGroupingComparator() {
        Class theClass = this.getClass("mapred.output.value.groupfn.class", null, RawComparator.class);
        if (theClass == null) {
            return this.getOutputKeyComparator();
        }
        return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)this);
    }

    public void setOutputValueGroupingComparator(Class<? extends RawComparator> theClass) {
        this.setClass("mapred.output.value.groupfn.class", theClass, RawComparator.class);
    }

    public boolean getUseNewMapper() {
        return this.getBoolean("mapred.mapper.new-api", false);
    }

    public void setUseNewMapper(boolean flag) {
        this.setBoolean("mapred.mapper.new-api", flag);
    }

    public boolean getUseNewReducer() {
        return this.getBoolean("mapred.reducer.new-api", false);
    }

    public void setUseNewReducer(boolean flag) {
        this.setBoolean("mapred.reducer.new-api", flag);
    }

    public Class<?> getOutputValueClass() {
        return this.getClass("mapred.output.value.class", Text.class, Object.class);
    }

    public void setOutputValueClass(Class<?> theClass) {
        this.setClass("mapred.output.value.class", theClass, Object.class);
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.getClass("mapred.mapper.class", IdentityMapper.class, Mapper.class);
    }

    public void setMapperClass(Class<? extends Mapper> theClass) {
        this.setClass("mapred.mapper.class", theClass, Mapper.class);
    }

    public Class<? extends MapRunnable> getMapRunnerClass() {
        return this.getClass("mapred.map.runner.class", MapRunner.class, MapRunnable.class);
    }

    public void setMapRunnerClass(Class<? extends MapRunnable> theClass) {
        this.setClass("mapred.map.runner.class", theClass, MapRunnable.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("mapred.partitioner.class", HashPartitioner.class, Partitioner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> theClass) {
        this.setClass("mapred.partitioner.class", theClass, Partitioner.class);
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.getClass("mapred.reducer.class", IdentityReducer.class, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.reducer.class", theClass, Reducer.class);
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.getClass("mapred.combiner.class", null, Reducer.class);
    }

    public void setCombinerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.combiner.class", theClass, Reducer.class);
    }

    public boolean getSpeculativeExecution() {
        return this.getMapSpeculativeExecution() || this.getReduceSpeculativeExecution();
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.setMapSpeculativeExecution(speculativeExecution);
        this.setReduceSpeculativeExecution(speculativeExecution);
    }

    public boolean getMapSpeculativeExecution() {
        return this.getBoolean("mapred.map.tasks.speculative.execution", true);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapred.map.tasks.speculative.execution", speculativeExecution);
    }

    public boolean getReduceSpeculativeExecution() {
        return this.getBoolean("mapred.reduce.tasks.speculative.execution", true);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapred.reduce.tasks.speculative.execution", speculativeExecution);
    }

    public int getNumMapTasks() {
        return this.getInt("mapred.map.tasks", 1);
    }

    public void setNumMapTasks(int n) {
        this.setInt("mapred.map.tasks", n);
    }

    public int getNumReduceTasks() {
        return this.getInt("mapred.reduce.tasks", 1);
    }

    public void setNumReduceTasks(int n) {
        this.setInt("mapred.reduce.tasks", n);
    }

    public int getMaxMapAttempts() {
        return this.getInt("mapred.map.max.attempts", 4);
    }

    public void setMaxMapAttempts(int n) {
        this.setInt("mapred.map.max.attempts", n);
    }

    public int getMaxReduceAttempts() {
        return this.getInt("mapred.reduce.max.attempts", 4);
    }

    public void setMaxReduceAttempts(int n) {
        this.setInt("mapred.reduce.max.attempts", n);
    }

    public String getJobName() {
        return this.get("mapred.job.name", "");
    }

    public void setJobName(String name) {
        this.set("mapred.job.name", name);
    }

    public String getSessionId() {
        return this.get("session.id", "");
    }

    public void setSessionId(String sessionId) {
        this.set("session.id", sessionId);
    }

    public void setMaxTaskFailuresPerTracker(int noFailures) {
        this.setInt("mapred.max.tracker.failures", noFailures);
    }

    public int getMaxTaskFailuresPerTracker() {
        return this.getInt("mapred.max.tracker.failures", 4);
    }

    public int getMaxMapTaskFailuresPercent() {
        return this.getInt("mapred.max.map.failures.percent", 0);
    }

    public void setMaxMapTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.map.failures.percent", percent);
    }

    public int getMaxReduceTaskFailuresPercent() {
        return this.getInt("mapred.max.reduce.failures.percent", 0);
    }

    public void setMaxReduceTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.reduce.failures.percent", percent);
    }

    public void setJobPriority(JobPriority prio) {
        this.set("mapred.job.priority", prio.toString());
    }

    public JobPriority getJobPriority() {
        String prio = this.get("mapred.job.priority");
        if (prio == null) {
            return JobPriority.NORMAL;
        }
        return JobPriority.valueOf(prio);
    }

    void setJobSubmitHostName(String hostname) {
        this.set("mapreduce.job.submithost", hostname);
    }

    String getJobSubmitHostName() {
        String hostname = this.get("mapreduce.job.submithost");
        return hostname;
    }

    void setJobSubmitHostAddress(String hostadd) {
        this.set("mapreduce.job.submithostaddress", hostadd);
    }

    String getJobSubmitHostAddress() {
        String hostadd = this.get("mapreduce.job.submithostaddress");
        return hostadd;
    }

    public boolean getProfileEnabled() {
        return this.getBoolean("mapred.task.profile", false);
    }

    public void setProfileEnabled(boolean newValue) {
        this.setBoolean("mapred.task.profile", newValue);
    }

    public void setUserClassesTakesPrecedence(boolean value) {
        this.setBoolean("mapreduce.task.classpath.user.precedence", value);
    }

    public boolean userClassesTakesPrecedence() {
        return this.getBoolean("mapreduce.task.classpath.user.precedence", false);
    }

    public String getProfileParams() {
        return this.get("mapred.task.profile.params", "-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s");
    }

    public void setProfileParams(String value) {
        this.set("mapred.task.profile.params", value);
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.getRange(isMap ? "mapred.task.profile.maps" : "mapred.task.profile.reduces", "0-2");
    }

    public void setProfileTaskRange(boolean isMap, String newValue) {
        new Configuration.IntegerRanges(newValue);
        this.set(isMap ? "mapred.task.profile.maps" : "mapred.task.profile.reduces", newValue);
    }

    public void setMapDebugScript(String mDbgScript) {
        this.set("mapred.map.task.debug.script", mDbgScript);
    }

    public String getMapDebugScript() {
        return this.get("mapred.map.task.debug.script");
    }

    public void setReduceDebugScript(String rDbgScript) {
        this.set("mapred.reduce.task.debug.script", rDbgScript);
    }

    public String getReduceDebugScript() {
        return this.get("mapred.reduce.task.debug.script");
    }

    public String getJobEndNotificationURI() {
        return this.get("job.end.notification.url");
    }

    public void setJobEndNotificationURI(String uri) {
        this.set("job.end.notification.url", uri);
    }

    public String getJobLocalDir() {
        return this.get("job.local.dir");
    }

    public long getMemoryForMapTask() {
        long value = this.getDeprecatedMemoryValue();
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPRED_JOB_MAP_MEMORY_MB_PROPERTY, -1L));
        }
        return value;
    }

    public void setMemoryForMapTask(long mem) {
        this.setLong(MAPRED_JOB_MAP_MEMORY_MB_PROPERTY, mem);
    }

    public long getMemoryForReduceTask() {
        long value = this.getDeprecatedMemoryValue();
        if (value == -1L) {
            value = JobConf.normalizeMemoryConfigValue(this.getLong(MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY, -1L));
        }
        return value;
    }

    private long getDeprecatedMemoryValue() {
        long oldValue = this.getLong(MAPRED_TASK_MAXVMEM_PROPERTY, -1L);
        if ((oldValue = JobConf.normalizeMemoryConfigValue(oldValue)) != -1L) {
            oldValue /= 0x100000L;
        }
        return oldValue;
    }

    public void setMemoryForReduceTask(long mem) {
        this.setLong(MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY, mem);
    }

    public String getQueueName() {
        return this.get("mapred.job.queue.name", DEFAULT_QUEUE_NAME);
    }

    public void setQueueName(String queueName) {
        this.set("mapred.job.queue.name", queueName);
    }

    public static long normalizeMemoryConfigValue(long val) {
        if (val < 0L) {
            val = -1L;
        }
        return val;
    }

    int computeNumSlotsPerMap(long slotSizePerMap) {
        if (slotSizePerMap == -1L || this.getMemoryForMapTask() == -1L) {
            return 1;
        }
        return (int)Math.ceil((float)this.getMemoryForMapTask() / (float)slotSizePerMap);
    }

    int computeNumSlotsPerReduce(long slotSizePerReduce) {
        if (slotSizePerReduce == -1L || this.getMemoryForReduceTask() == -1L) {
            return 1;
        }
        return (int)Math.ceil((float)this.getMemoryForReduceTask() / (float)slotSizePerReduce);
    }

    private static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Deprecated
    public long getMaxVirtualMemoryForTask() {
        LOG.warn((Object)"getMaxVirtualMemoryForTask() is deprecated. Instead use getMemoryForMapTask() and getMemoryForReduceTask()");
        long value = this.getLong(MAPRED_TASK_MAXVMEM_PROPERTY, -1L);
        value = JobConf.normalizeMemoryConfigValue(value);
        if (value == -1L) {
            value = Math.max(this.getMemoryForMapTask(), this.getMemoryForReduceTask());
            if ((value = JobConf.normalizeMemoryConfigValue(value)) != -1L) {
                value *= 0x100000L;
            }
        }
        return value;
    }

    @Deprecated
    public void setMaxVirtualMemoryForTask(long vmem) {
        LOG.warn((Object)"setMaxVirtualMemoryForTask() is deprecated.Instead use setMemoryForMapTask() and setMemoryForReduceTask()");
        if (vmem != -1L && vmem < 0L) {
            this.setMemoryForMapTask(-1L);
            this.setMemoryForReduceTask(-1L);
        }
        if (this.get(MAPRED_TASK_MAXVMEM_PROPERTY) == null) {
            this.setMemoryForMapTask(vmem / 0x100000L);
            this.setMemoryForReduceTask(vmem / 0x100000L);
        } else {
            this.setLong(MAPRED_TASK_MAXVMEM_PROPERTY, vmem);
        }
    }

    @Deprecated
    public long getMaxPhysicalMemoryForTask() {
        LOG.warn((Object)"The API getMaxPhysicalMemoryForTask() is deprecated. Refer to the APIs getMemoryForMapTask() and getMemoryForReduceTask() for details.");
        return -1L;
    }

    @Deprecated
    public void setMaxPhysicalMemoryForTask(long mem) {
        LOG.warn((Object)"The API setMaxPhysicalMemoryForTask() is deprecated. The value set is ignored. Refer to  setMemoryForMapTask() and setMemoryForReduceTask() for details.");
    }

    static String deprecatedString(String key) {
        return "The variable " + key + " is no longer used.";
    }

    private void checkAndWarnDeprecation() {
        if (this.get(MAPRED_TASK_MAXVMEM_PROPERTY) != null) {
            LOG.warn((Object)(JobConf.deprecatedString(MAPRED_TASK_MAXVMEM_PROPERTY) + " Instead use " + MAPRED_JOB_MAP_MEMORY_MB_PROPERTY + " and " + MAPRED_JOB_REDUCE_MEMORY_MB_PROPERTY));
        }
    }

    static {
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
        UNPACK_JAR_PATTERN_DEFAULT = Pattern.compile("(?:classes/|lib/).*");
    }
}

