/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.InfoMap;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JettyBugMonitor;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.NetUtils2;
import org.apache.hadoop.mapred.NodeHealthCheckerService;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskMemoryManagerThread;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerInstrumentation;
import org.apache.hadoop.mapred.TaskTrackerMXBean;
import org.apache.hadoop.mapred.TaskTrackerMetricsInst;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.UserLogCleaner;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.mapreduce.server.tasktracker.Localizer;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobCompletedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JobStartedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JvmFinishedEvent;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.UserLogManager;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.MRAsyncDiskService;
import org.apache.hadoop.util.MemoryCalculatorPlugin;
import org.apache.hadoop.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ResourceCalculatorPlugin;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;

public class TaskTracker
implements MRConstants,
TaskUmbilicalProtocol,
Runnable,
TaskTrackerMXBean {
    @Deprecated
    static final String MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY = "mapred.tasktracker.vmem.reserved";
    @Deprecated
    static final String MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY = "mapred.tasktracker.pmem.reserved";
    static final String TT_RESERVED_PHYSICALMEMORY_MB = "mapreduce.tasktracker.reserved.physicalmemory.mb";
    static final String TT_MEMORY_MANAGER_MONITORING_INTERVAL = "mapreduce.tasktracker.taskmemorymanager.monitoringinterval";
    static final String CONF_VERSION_KEY = "mapreduce.tasktracker.conf.version";
    static final String CONF_VERSION_DEFAULT = "default";
    static final long WAIT_FOR_DONE = 3000L;
    private int httpPort;
    static final FsPermission LOCAL_DIR_PERMISSION = FsPermission.createImmutable((short)493);
    public static final Log LOG;
    public static final String MR_CLIENTTRACE_FORMAT = "src: %s, dest: %s, bytes: %s, op: %s, cliID: %s, duration: %s";
    public static final Log ClientTraceLog;
    static String jobACLsFile;
    volatile boolean running = true;
    private LocalStorage localStorage;
    private long lastCheckDirsTime;
    private int lastNumFailures;
    private LocalDirAllocator localDirAllocator;
    String taskTrackerName;
    String localHostname;
    InetSocketAddress jobTrackAddr;
    InetSocketAddress taskReportAddress;
    Server taskReportServer = null;
    InterTrackerProtocol jobClient;
    private TrackerDistributedCacheManager distributedCacheManager;
    static int FILE_CACHE_SIZE;
    short heartbeatResponseId = (short)-1;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    TaskTrackerStatus status = null;
    Path systemDirectory = null;
    FileSystem systemFS = null;
    private LocalFileSystem localFs = null;
    private final HttpServer server;
    volatile boolean shuttingDown = false;
    Map<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> tasks = new HashMap<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress>();
    Map<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> runningTasks = null;
    Map<JobID, RunningJob> runningJobs = new TreeMap<JobID, RunningJob>();
    private final JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    volatile int mapTotal = 0;
    volatile int reduceTotal = 0;
    boolean justStarted = true;
    boolean justInited = true;
    Set<org.apache.hadoop.mapred.TaskAttemptID> shouldReset = new HashSet<org.apache.hadoop.mapred.TaskAttemptID>();
    Map<String, DF> localDirsDf = new HashMap<String, DF>();
    long minSpaceStart = 0L;
    boolean acceptNewTasks = true;
    long minSpaceKill = 0L;
    static Random r;
    public static final String SUBDIR = "taskTracker";
    static final String DISTCACHEDIR = "distcache";
    static final String JOBCACHE = "jobcache";
    static final String OUTPUT = "output";
    static final String JARSDIR = "jars";
    static final String LOCAL_SPLIT_FILE = "split.info";
    static final String JOBFILE = "job.xml";
    static final String TT_PRIVATE_DIR = "ttprivate";
    public static final String TT_LOG_TMP_DIR = "tt_log_tmp";
    static final String JVM_EXTRA_ENV_FILE = "jvm.extra.env";
    static final String JOB_LOCAL_DIR = "job.local.dir";
    static final String JOB_TOKEN_FILE = "jobToken";
    private JobConf fConf;
    private JobConf originalConf;
    private Localizer localizer;
    private int maxMapSlots;
    private int maxReduceSlots;
    private int taskFailures;
    final long mapRetainSize;
    final long reduceRetainSize;
    private ACLsManager aclsManager;
    static final String TT_OUTOFBAND_HEARBEAT = "mapreduce.tasktracker.outofband.heartbeat";
    private volatile boolean oobHeartbeatOnTaskCompletion;
    private boolean manageOsCacheInShuffle = false;
    private int readaheadLength;
    private ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    private IntWritable finishedCount = new IntWritable(0);
    private MapEventsFetcherThread mapEventsFetcher;
    final int workerThreads;
    CleanupQueue directoryCleanupThread;
    private volatile JvmManager jvmManager;
    private TaskMemoryManagerThread taskMemoryManager;
    private boolean taskMemoryManagerEnabled = true;
    private long totalVirtualMemoryOnTT = -1L;
    private long totalPhysicalMemoryOnTT = -1L;
    private long mapSlotMemorySizeOnTT = -1L;
    private long reduceSlotSizeMemoryOnTT = -1L;
    private long totalMemoryAllottedForTasks = -1L;
    private long reservedPhysicalMemoryOnTT = -1L;
    private ResourceCalculatorPlugin resourceCalculatorPlugin = null;
    private UserLogManager userLogManager;
    static final String MAPRED_TASKTRACKER_MEMORY_CALCULATOR_PLUGIN_PROPERTY = "mapred.tasktracker.memory_calculator_plugin";
    public static final String TT_RESOURCE_CALCULATOR_PLUGIN = "mapreduce.tasktracker.resourcecalculatorplugin";
    private MRAsyncDiskService asyncDiskService;
    private volatile int heartbeatInterval = 300;
    private int probe_sample_size = 500;
    private IndexCache indexCache;
    private TaskController taskController;
    private NodeHealthCheckerService healthChecker;
    private JettyBugMonitor jettyBugMonitor;
    static final String DISK_HEALTH_CHECK_INTERVAL_PROPERTY = "mapred.disk.healthChecker.interval";
    private long diskHealthCheckInterval;
    private boolean relaxedVersionCheck;
    private List<org.apache.hadoop.mapred.TaskAttemptID> commitResponses = Collections.synchronizedList(new ArrayList());
    private ShuffleServerMetrics shuffleServerMetrics;
    private TaskTrackerInstrumentation myInstrumentation = null;
    private BlockingQueue<TaskTrackerAction> tasksToCleanup = new LinkedBlockingQueue<TaskTrackerAction>();
    private Thread taskCleanupThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskTrackerAction action = (TaskTrackerAction)TaskTracker.this.tasksToCleanup.take();
                        TaskTracker.this.checkJobStatusAndWait(action);
                        if (action instanceof KillJobAction) {
                            TaskTracker.this.purgeJob((KillJobAction)action);
                            continue;
                        }
                        if (action instanceof KillTaskAction) {
                            TaskTracker.this.processKillTaskAction((KillTaskAction)action);
                            continue;
                        }
                        LOG.error((Object)("Non-delete action given to cleanup thread: " + action));
                    }
                }
                catch (Throwable except) {
                    LOG.warn((Object)StringUtils.stringifyException((Throwable)except));
                    continue;
                }
                break;
            }
        }
    }, "taskCleanup");
    public static final String TT_USER_NAME = "mapreduce.tasktracker.kerberos.principal";
    public static final String TT_KEYTAB_FILE = "mapreduce.tasktracker.keytab.file";
    private Object waitingOn = new Object();
    private static LocalDirAllocator lDirAlloc;
    private long previousUpdate = 0L;
    private TaskLauncher mapLauncher;
    private TaskLauncher reduceLauncher;

    JobTokenSecretManager getJobTokenSecretManager() {
        return this.jobTokenSecretManager;
    }

    RunningJob getRunningJob(JobID jobId) {
        return this.runningJobs.get(jobId);
    }

    public TaskTrackerInstrumentation getTaskTrackerInstrumentation() {
        return this.myInstrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processKillTaskAction(KillTaskAction killAction) throws IOException {
        TaskInProgress tip;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            tip = this.tasks.get(killAction.getTaskID());
        }
        LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskID()));
        this.purgeTask(tip, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJobStatusAndWait(TaskTrackerAction action) throws InterruptedException {
        JobID jobId = null;
        if (action instanceof KillJobAction) {
            jobId = ((KillJobAction)action).getJobID();
        } else if (action instanceof KillTaskAction) {
            jobId = ((KillTaskAction)action).getTaskID().getJobID();
        } else {
            return;
        }
        RunningJob rjob = null;
        Object object = this.runningJobs;
        synchronized (object) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob != null) {
            object = rjob;
            synchronized (object) {
                while (rjob.localizing) {
                    rjob.wait();
                }
            }
        }
    }

    public TaskController getTaskController() {
        return this.taskController;
    }

    void setTaskController(TaskController t) {
        this.taskController = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningJob addTaskToJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rJob = null;
            if (!this.runningJobs.containsKey(jobId)) {
                rJob = new RunningJob(jobId);
                rJob.tasks = new HashSet<TaskInProgress>();
                this.runningJobs.put(jobId, rJob);
            } else {
                rJob = this.runningJobs.get(jobId);
            }
            RunningJob runningJob = rJob;
            synchronized (runningJob) {
                rJob.tasks.add(tip);
            }
            return rJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskFromJob(JobID jobId, TaskInProgress tip) {
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob == null) {
                LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
            } else {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.tasks.remove(tip);
                }
            }
        }
    }

    UserLogManager getUserLogManager() {
        return this.userLogManager;
    }

    void setUserLogManager(UserLogManager u) {
        this.userLogManager = u;
    }

    public static String getUserDir(String user) {
        return "taskTracker/" + user;
    }

    Localizer getLocalizer() {
        return this.localizer;
    }

    void setLocalizer(Localizer l) {
        this.localizer = l;
    }

    public static String getPrivateDistributedCacheDir(String user) {
        return TaskTracker.getUserDir(user) + "/" + DISTCACHEDIR;
    }

    public static String getPublicDistributedCacheDir() {
        return "taskTracker/distcache";
    }

    public static String getJobCacheSubdir(String user) {
        return TaskTracker.getUserDir(user) + "/" + JOBCACHE;
    }

    public static String getLocalJobDir(String user, String jobid) {
        return TaskTracker.getJobCacheSubdir(user) + "/" + jobid;
    }

    static String getLocalJobConfFile(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JOBFILE;
    }

    static String getPrivateDirJobConfFile(String user, String jobid) {
        return "ttprivate/" + TaskTracker.getLocalJobConfFile(user, jobid);
    }

    static String getTaskConfFile(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid, isCleanupAttempt) + "/" + JOBFILE;
    }

    static String getPrivateDirTaskScriptLocation(String user, String jobid, String taskid) {
        return "ttprivate/" + TaskTracker.getLocalTaskDir(user, jobid, taskid);
    }

    static String getJobJarsDir(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JARSDIR;
    }

    public static String getJobJarFile(String user, String jobid) {
        return TaskTracker.getJobJarsDir(user, jobid) + "/" + "job.jar";
    }

    static String getJobWorkDir(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + "work";
    }

    static String getLocalSplitFile(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid) + "/" + LOCAL_SPLIT_FILE;
    }

    static String getIntermediateOutputDir(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid) + "/" + OUTPUT;
    }

    public static String getLocalTaskDir(String user, String jobid, String taskid) {
        return TaskTracker.getLocalTaskDir(user, jobid, taskid, false);
    }

    public static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = TaskTracker.getLocalJobDir(user, jobid) + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + TASK_CLEANUP_SUFFIX;
        }
        return taskDir;
    }

    static String getTaskWorkDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String dir = TaskTracker.getLocalTaskDir(user, jobid, taskid, isCleanupAttempt);
        return dir + "/" + "work";
    }

    static String getLocalJobTokenFile(String user, String jobid) {
        return TaskTracker.getLocalJobDir(user, jobid) + "/" + JOB_TOKEN_FILE;
    }

    static String getPrivateDirJobTokenFile(String user, String jobid) {
        return "ttprivate/" + TaskTracker.getLocalJobTokenFile(user, jobid);
    }

    static String getPrivateDirForJob(String user, String jobid) {
        return "ttprivate/" + TaskTracker.getLocalJobDir(user, jobid);
    }

    private FileSystem getFS(final Path filePath, JobID jobId, final Configuration conf) throws IOException, InterruptedException {
        RunningJob rJob = this.runningJobs.get(jobId);
        FileSystem userFs = (FileSystem)rJob.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return filePath.getFileSystem(conf);
            }
        });
        return userFs;
    }

    String getPid(org.apache.hadoop.mapred.TaskAttemptID tid) {
        TaskInProgress tip = this.tasks.get(tid);
        if (tip != null) {
            return this.jvmManager.getPid(tip.getTaskRunner());
        }
        return null;
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(TaskUmbilicalProtocol.class.getName())) {
            return 18L;
        }
        throw new IOException("Unknown protocol for task tracker: " + protocol);
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    private void deleteUserDirectories(Configuration conf) throws IOException {
        for (String root : this.localStorage.getDirs()) {
            try {
                for (FileStatus status : this.localFs.listStatus(new Path(root, SUBDIR))) {
                    String owner = status.getOwner();
                    String path = status.getPath().getName();
                    if (!path.equals(owner)) continue;
                    this.taskController.deleteAsUser(owner, "");
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    void initializeDirectories() throws IOException {
        String dirs = this.localStorage.getDirsString();
        this.fConf.setStrings("mapred.local.dir", new String[]{dirs});
        LOG.info((Object)("Good mapred local directories are: " + dirs));
        this.taskController.setConf(this.fConf);
        if (this.server != null) {
            this.server.setAttribute("conf", (Object)this.fConf);
        }
        this.deleteUserDirectories(this.fConf);
        this.asyncDiskService = new MRAsyncDiskService(this.fConf);
        this.asyncDiskService.cleanupAllVolumes();
        FsPermission ttdir = FsPermission.createImmutable((short)493);
        for (String s : this.localStorage.getDirs()) {
            this.localFs.mkdirs(new Path(s, SUBDIR), ttdir);
        }
        this.fConf.deleteLocalFiles(TT_PRIVATE_DIR);
        FsPermission priv = FsPermission.createImmutable((short)448);
        for (String s : this.localStorage.getDirs()) {
            this.localFs.mkdirs(new Path(s, TT_PRIVATE_DIR), priv);
        }
        this.fConf.deleteLocalFiles(TT_LOG_TMP_DIR);
        FsPermission pub = FsPermission.createImmutable((short)493);
        for (String s : this.localStorage.getDirs()) {
            this.localFs.mkdirs(new Path(s, TT_LOG_TMP_DIR), pub);
        }
        for (String s : this.localStorage.getDirs()) {
            Path userLogsDir = new Path(s, "userlogs");
            if (!this.localFs.exists(userLogsDir)) {
                if (this.localFs.mkdirs(userLogsDir, pub)) continue;
                LOG.warn((Object)("Unable to create task log directory: " + userLogsDir));
                continue;
            }
            try {
                this.localFs.setPermission(userLogsDir, new FsPermission(493));
            }
            catch (IOException ioe) {
                throw new IOException("Unable to set permissions on task log directory. " + userLogsDir + " should be owned by " + "and accessible by user '" + System.getProperty("user.name") + "'.", ioe);
            }
        }
    }

    private void checkSecurityRequirements() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        if (!NativeIO.isAvailable()) {
            throw new IOException("Secure IO is necessary to run a secure task tracker.");
        }
    }

    synchronized void initialize() throws IOException, InterruptedException {
        this.fConf = new JobConf(this.originalConf);
        LOG.info((Object)("Starting tasktracker with owner as " + this.getMROwner().getShortUserName()));
        if (this.fConf.get("slave.host.name") != null) {
            this.localHostname = this.fConf.get("slave.host.name");
        }
        if (this.localHostname == null) {
            this.localHostname = DNS.getDefaultHost((String)this.fConf.get("mapred.tasktracker.dns.interface", CONF_VERSION_DEFAULT), (String)this.fConf.get("mapred.tasktracker.dns.nameserver", CONF_VERSION_DEFAULT));
        }
        this.initializeDirectories();
        this.checkSecurityRequirements();
        this.tasks.clear();
        this.runningTasks = new LinkedHashMap<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress>();
        this.runningJobs = new TreeMap<JobID, RunningJob>();
        this.mapTotal = 0;
        this.reduceTotal = 0;
        this.acceptNewTasks = true;
        this.status = null;
        this.minSpaceStart = this.fConf.getLong("mapred.local.dir.minspacestart", 0L);
        this.minSpaceKill = this.fConf.getLong("mapred.local.dir.minspacekill", 0L);
        this.probe_sample_size = this.fConf.getInt("mapred.tasktracker.events.batchsize", 500);
        try {
            Class<? extends TaskTrackerInstrumentation> metricsInst = TaskTracker.getInstrumentationClass(this.fConf);
            Constructor<? extends TaskTrackerInstrumentation> c = metricsInst.getConstructor(TaskTracker.class);
            this.myInstrumentation = c.newInstance(this);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to initialize taskTracker metrics. Falling back to default.", (Throwable)e);
            this.myInstrumentation = new TaskTrackerMetricsInst(this);
        }
        String address = NetUtils2.getServerAddress(this.fConf, "mapred.task.tracker.report.bindAddress", "mapred.task.tracker.report.port", "mapred.task.tracker.report.address");
        InetSocketAddress socAddr = NetUtils.createSocketAddr((String)address);
        String bindAddress = socAddr.getHostName();
        int tmpPort = socAddr.getPort();
        this.jvmManager = new JvmManager(this);
        int max = this.maxMapSlots > this.maxReduceSlots ? this.maxMapSlots : this.maxReduceSlots;
        this.taskReportServer = RPC.getServer(TaskUmbilicalProtocol.class, (Object)this, (String)bindAddress, (int)tmpPort, (int)(2 * max), (boolean)false, (Configuration)this.fConf, (SecretManager)this.jobTokenSecretManager);
        if (this.fConf.getBoolean("hadoop.security.authorization", false)) {
            PolicyProvider policyProvider = (PolicyProvider)ReflectionUtils.newInstance((Class)this.fConf.getClass("hadoop.security.authorization.policyprovider", MapReducePolicyProvider.class, PolicyProvider.class), (Configuration)this.fConf);
            this.taskReportServer.refreshServiceAcl((Configuration)this.fConf, policyProvider);
        }
        this.taskReportServer.start();
        this.taskReportAddress = this.taskReportServer.getListenerAddress();
        this.fConf.set("mapred.task.tracker.report.address", this.taskReportAddress.getHostName() + ":" + this.taskReportAddress.getPort());
        LOG.info((Object)("TaskTracker up at: " + this.taskReportAddress));
        this.taskTrackerName = "tracker_" + this.localHostname + ":" + this.taskReportAddress;
        LOG.info((Object)("Starting tracker " + this.taskTrackerName));
        this.distributedCacheManager = new TrackerDistributedCacheManager(this.fConf, this.taskController, this.asyncDiskService);
        this.distributedCacheManager.purgeCache();
        this.jobClient = (InterTrackerProtocol)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                return RPC.waitForProxy(InterTrackerProtocol.class, (long)32L, (InetSocketAddress)TaskTracker.this.jobTrackAddr, (Configuration)TaskTracker.this.fConf);
            }
        });
        this.justInited = true;
        this.running = true;
        this.mapEventsFetcher = new MapEventsFetcherThread();
        this.mapEventsFetcher.setDaemon(true);
        this.mapEventsFetcher.setName("Map-events fetcher for all reduce tasks on " + this.taskTrackerName);
        this.mapEventsFetcher.start();
        Class clazz = this.fConf.getClass(TT_RESOURCE_CALCULATOR_PLUGIN, null, ResourceCalculatorPlugin.class);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(clazz, this.fConf);
        LOG.info((Object)(" Using ResourceCalculatorPlugin : " + (Object)((Object)this.resourceCalculatorPlugin)));
        this.initializeMemoryManagement();
        this.getUserLogManager().clearOldUserLogs(this.fConf);
        this.setIndexCache(new IndexCache(this.fConf));
        this.mapLauncher = new TaskLauncher(TaskType.MAP, this.maxMapSlots);
        this.reduceLauncher = new TaskLauncher(TaskType.REDUCE, this.maxReduceSlots);
        this.mapLauncher.start();
        this.reduceLauncher.start();
        this.setLocalizer(new Localizer((FileSystem)this.localFs, this.localStorage.getDirs()));
        if (this.shouldStartHealthMonitor(this.fConf)) {
            this.startHealthMonitor(this.fConf);
        }
        this.startJettyBugMonitor();
        this.oobHeartbeatOnTaskCompletion = this.fConf.getBoolean(TT_OUTOFBAND_HEARBEAT, false);
        this.manageOsCacheInShuffle = this.fConf.getBoolean("mapred.tasktracker.shuffle.fadvise", true);
        this.readaheadLength = this.fConf.getInt("mapred.tasktracker.shuffle.readahead.bytes", 0x400000);
    }

    private void startJettyBugMonitor() {
        this.jettyBugMonitor = JettyBugMonitor.create(this.fConf);
        if (this.jettyBugMonitor != null) {
            this.jettyBugMonitor.start();
        }
    }

    UserGroupInformation getMROwner() {
        return this.aclsManager.getMROwner();
    }

    boolean areACLsEnabled() {
        return this.fConf.getBoolean("mapred.acls.enabled", false);
    }

    public static Class<? extends TaskTrackerInstrumentation> getInstrumentationClass(Configuration conf) {
        return conf.getClass("mapred.tasktracker.instrumentation", TaskTrackerMetricsInst.class, TaskTrackerInstrumentation.class);
    }

    public static void setInstrumentationClass(Configuration conf, Class<? extends TaskTrackerInstrumentation> t) {
        conf.setClass("mapred.tasktracker.instrumentation", t, TaskTrackerInstrumentation.class);
    }

    @Deprecated
    public void cleanupStorage() throws IOException {
        this.fConf.deleteLocalFiles(SUBDIR);
        this.fConf.deleteLocalFiles(TT_PRIVATE_DIR);
        this.fConf.deleteLocalFiles(TT_LOG_TMP_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RunningJob localizeJob(TaskInProgress tip) throws IOException, InterruptedException {
        Object object;
        RunningJob rjob;
        block22: {
            Task t = tip.getTask();
            JobID jobId = t.getJobID();
            rjob = this.addTaskToJob(jobId, tip);
            InetSocketAddress ttAddr = this.getTaskTrackerReportAddress();
            try {
                object = rjob;
                synchronized (object) {
                    if (!rjob.localized) {
                        while (rjob.localizing) {
                            rjob.wait();
                        }
                        if (!rjob.localized) {
                            rjob.localizing = true;
                        }
                    }
                }
                if (rjob.localized) break block22;
                Path localJobConfPath = this.initializeJob(t, rjob, ttAddr);
                JobConf localJobConf = new JobConf(localJobConfPath);
                localJobConf.setUser(t.getUser());
                TaskTracker.resetNumTasksPerJvm(localJobConf);
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.localizedJobConf = localJobConfPath;
                    rjob.jobConf = localJobConf;
                    rjob.keepJobFiles = localJobConf.getKeepTaskFilesPattern() != null || localJobConf.getKeepFailedTaskFiles();
                    rjob.localized = true;
                }
            }
            finally {
                object = rjob;
                synchronized (object) {
                    if (rjob.localizing) {
                        rjob.localizing = false;
                        rjob.notifyAll();
                    }
                }
            }
        }
        object = this.runningJobs;
        synchronized (object) {
            this.runningJobs.notify();
        }
        return rjob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path initializeJob(final Task t, final RunningJob rjob, final InetSocketAddress ttAddr) throws IOException, InterruptedException {
        final JobID jobId = t.getJobID();
        Path jobFile = new Path(t.getJobFile());
        final String userName = t.getUser();
        final JobConf conf = this.getJobConf();
        final String localJobTokenFile = this.localizeJobTokenFile(t.getUser(), jobId);
        RunningJob runningJob = rjob;
        synchronized (runningJob) {
            rjob.ugi = UserGroupInformation.createRemoteUser((String)t.getUser());
            Credentials ts = TokenCache.loadTokens(localJobTokenFile, conf);
            Token<JobTokenIdentifier> jt = TokenCache.getJobToken(ts);
            if (jt != null) {
                this.getJobTokenSecretManager().addTokenForJob(jobId.toString(), jt);
            }
            for (Token token : ts.getAllTokens()) {
                rjob.ugi.addToken(token);
            }
        }
        FileSystem userFs = this.getFS(jobFile, jobId, conf);
        final Path localJobFile = this.localizeJobConfFile(new Path(t.getJobFile()), userName, userFs, jobId);
        rjob.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, InterruptedException {
                try {
                    TaskDistributedCacheManager taskDistributedCacheManager;
                    JobConf localJobConf = new JobConf(localJobFile);
                    rjob.distCacheMgr = taskDistributedCacheManager = TaskTracker.this.getTrackerDistributedCacheManager().newTaskDistributedCacheManager(jobId, localJobConf);
                    taskDistributedCacheManager.setupCache(localJobConf, TaskTracker.getPublicDistributedCacheDir(), TaskTracker.getPrivateDistributedCacheDir(userName));
                    localJobConf.set("mapred.local.dir", TaskTracker.this.getJobConf().get("mapred.local.dir"));
                    if (conf.get("slave.host.name") != null) {
                        localJobConf.set("slave.host.name", conf.get("slave.host.name"));
                    }
                    TaskTracker.resetNumTasksPerJvm(localJobConf);
                    localJobConf.setUser(t.getUser());
                    JobLocalizer.writeLocalJobFile(localJobFile, localJobConf);
                    TaskTracker.this.taskController.initializeJob(t.getUser(), jobId.toString(), new Path(localJobTokenFile), localJobFile, TaskTracker.this, ttAddr);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Exception while localization " + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Exception while localization " + StringUtils.stringifyException((Throwable)ie)));
                    throw ie;
                }
                return null;
            }
        });
        Path initializedConf = lDirAlloc.getLocalPathToRead(TaskTracker.getLocalJobConfFile(userName, jobId.toString()), (Configuration)this.getJobConf());
        return initializedConf;
    }

    static void resetNumTasksPerJvm(JobConf localJobConf) {
        boolean debugEnabled = false;
        if (localJobConf.getNumTasksToExecutePerJvm() == 1) {
            return;
        }
        if (localJobConf.getMapDebugScript() != null || localJobConf.getReduceDebugScript() != null) {
            debugEnabled = true;
        }
        String keepPattern = localJobConf.getKeepTaskFilesPattern();
        if (debugEnabled || localJobConf.getProfileEnabled() || keepPattern != null || localJobConf.getKeepFailedTaskFiles()) {
            localJobConf.setNumTasksToExecutePerJvm(1);
        }
    }

    void saveLogDir(JobID jobId, JobConf localJobConf) throws IOException {
        JobStartedEvent jse = new JobStartedEvent(jobId);
        this.getUserLogManager().addLogEvent(jse);
    }

    private Path localizeJobConfFile(Path jobFile, String user, FileSystem userFs, JobID jobId) throws IOException {
        FileStatus status = null;
        long jobFileSize = -1L;
        try {
            status = userFs.getFileStatus(jobFile);
            jobFileSize = status.getLen();
        }
        catch (FileNotFoundException fe) {
            jobFileSize = -1L;
        }
        Path localJobFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getPrivateDirJobConfFile(user, jobId.toString()), jobFileSize, (Configuration)this.fConf);
        userFs.copyToLocalFile(jobFile, localJobFile);
        return localJobFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTaskForJob(TaskInProgress tip, JobConf jobConf, RunningJob rjob) throws IOException {
        TaskInProgress taskInProgress = tip;
        synchronized (taskInProgress) {
            jobConf.set("mapred.local.dir", this.localStorage.getDirsString());
            tip.setJobConf(jobConf);
            tip.setUGI(rjob.ugi);
            tip.launchTask(rjob);
        }
    }

    public synchronized void shutdown() throws IOException, InterruptedException {
        this.shuttingDown = true;
        this.close();
        if (this.server != null) {
            try {
                LOG.info((Object)"Shutting down StatusHttpServer");
                this.server.stop();
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception shutting down TaskTracker", (Throwable)e);
            }
        }
    }

    public synchronized void close() throws IOException, InterruptedException {
        TreeMap<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> tasksToClose = new TreeMap<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress>();
        tasksToClose.putAll(this.tasks);
        for (TaskInProgress tip : tasksToClose.values()) {
            tip.jobHasFinished(false);
        }
        this.running = false;
        if (this.asyncDiskService != null) {
            try {
                this.asyncDiskService.cleanupAllVolumes();
            }
            catch (Exception ioe) {
                LOG.warn((Object)"IOException shutting down TaskTracker", (Throwable)ioe);
            }
            this.asyncDiskService.shutdown();
            try {
                if (!this.asyncDiskService.awaitTermination(10000L)) {
                    this.asyncDiskService.shutdownNow();
                    this.asyncDiskService = null;
                }
            }
            catch (InterruptedException e) {
                this.asyncDiskService.shutdownNow();
                this.asyncDiskService = null;
            }
        }
        this.mapEventsFetcher.interrupt();
        this.mapLauncher.interrupt();
        this.reduceLauncher.interrupt();
        this.jvmManager.stop();
        RPC.stopProxy((Object)this.jobClient);
        boolean done = false;
        while (!done) {
            try {
                this.mapEventsFetcher.join();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.taskReportServer != null) {
            this.taskReportServer.stop();
            this.taskReportServer = null;
        }
        if (this.healthChecker != null) {
            this.healthChecker.stop();
            this.healthChecker = null;
        }
        if (this.jettyBugMonitor != null) {
            this.jettyBugMonitor.shutdown();
            this.jettyBugMonitor = null;
        }
    }

    TaskTracker() {
        this.server = null;
        this.workerThreads = 0;
        this.mapRetainSize = -1L;
        this.reduceRetainSize = -1L;
    }

    void setConf(JobConf conf) {
        this.fConf = conf;
    }

    void setLocalStorage(LocalStorage in) {
        this.localStorage = in;
    }

    void setLocalDirAllocator(LocalDirAllocator in) {
        this.localDirAllocator = in;
    }

    public TaskTracker(JobConf conf) throws IOException, InterruptedException {
        this.originalConf = conf;
        this.relaxedVersionCheck = conf.getBoolean("hadoop.relaxed.worker.version.check", true);
        FILE_CACHE_SIZE = conf.getInt("mapred.tasktracker.file.cache.size", 2000);
        this.maxMapSlots = conf.getInt("mapred.tasktracker.map.tasks.maximum", 2);
        this.maxReduceSlots = conf.getInt("mapred.tasktracker.reduce.tasks.maximum", 2);
        this.diskHealthCheckInterval = conf.getLong(DISK_HEALTH_CHECK_INTERVAL_PROPERTY, 60000L);
        this.aclsManager = new ACLsManager(conf, new JobACLsManager(conf), null);
        this.jobTrackAddr = JobTracker.getAddress(conf);
        String infoAddr = NetUtils2.getServerAddress(conf, "tasktracker.http.bindAddress", "tasktracker.http.port", "mapred.task.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)infoAddr);
        String httpBindAddress = infoSocAddr.getHostName();
        int httpPort = infoSocAddr.getPort();
        this.server = new HttpServer("task", httpBindAddress, httpPort, httpPort == 0, (Configuration)conf, this.aclsManager.getAdminsAcl());
        this.shuffleServerMetrics = new ShuffleServerMetrics(conf);
        this.workerThreads = conf.getInt("tasktracker.http.threads", 40);
        this.server.setThreads(1, this.workerThreads);
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        this.localDirAllocator = new LocalDirAllocator("mapred.local.dir");
        Class taskControllerClass = conf.getClass("mapred.task.tracker.task-controller", DefaultTaskController.class, TaskController.class);
        this.fConf = new JobConf(conf);
        this.localFs = FileSystem.getLocal((Configuration)this.fConf);
        this.localStorage = new LocalStorage(this.fConf.getLocalDirs());
        this.localStorage.checkDirs(this.localFs, true);
        this.taskController = (TaskController)ReflectionUtils.newInstance((Class)taskControllerClass, (Configuration)this.fConf);
        this.taskController.setup(this.localDirAllocator, this.localStorage);
        this.lastNumFailures = this.localStorage.numFailures();
        this.setUserLogManager(new UserLogManager(conf, this.taskController));
        SecurityUtil.login((Configuration)this.originalConf, (String)TT_KEYTAB_FILE, (String)TT_USER_NAME);
        this.initialize();
        this.server.setAttribute("task.tracker", (Object)this);
        this.server.setAttribute("local.file.system", (Object)local);
        this.server.setAttribute("log", (Object)LOG);
        this.server.setAttribute("localDirAllocator", (Object)this.localDirAllocator);
        this.server.setAttribute("shuffleServerMetrics", (Object)this.shuffleServerMetrics);
        String exceptionStackRegex = conf.get("mapreduce.reduce.shuffle.catch.exception.stack.regex");
        String exceptionMsgRegex = conf.get("mapreduce.reduce.shuffle.catch.exception.message.regex");
        this.server.setAttribute("exceptionStackRegex", (Object)exceptionStackRegex);
        this.server.setAttribute("exceptionMsgRegex", (Object)exceptionMsgRegex);
        this.server.addInternalServlet("mapOutput", "/mapOutput", MapOutputServlet.class);
        this.server.addServlet("taskLog", "/tasklog", TaskLogServlet.class);
        this.server.start();
        this.httpPort = this.server.getPort();
        this.checkJettyPort(httpPort);
        LOG.info((Object)("FILE_CACHE_SIZE for mapOutputServlet set to : " + FILE_CACHE_SIZE));
        this.mapRetainSize = conf.getLong("mapreduce.cluster.map.userlog.retain-size", -1L);
        this.reduceRetainSize = conf.getLong("mapreduce.cluster.reduce.userlog.retain-size", -1L);
    }

    private void checkJettyPort(int port) throws IOException {
        if (port < 0) {
            this.shuttingDown = true;
            throw new IOException("Jetty problem. Jetty didn't bind to a valid port");
        }
    }

    private void startCleanupThreads() throws IOException {
        this.taskCleanupThread.setDaemon(true);
        this.taskCleanupThread.start();
        this.directoryCleanupThread = CleanupQueue.getInstance();
    }

    void setCleanupThread(CleanupQueue c) {
        this.directoryCleanupThread = c;
    }

    CleanupQueue getCleanupThread() {
        return this.directoryCleanupThread;
    }

    public InterTrackerProtocol getJobClient() {
        return this.jobClient;
    }

    public synchronized InetSocketAddress getTaskTrackerReportAddress() {
        return this.taskReportAddress;
    }

    private List<TaskCompletionEvent> queryJobTracker(IntWritable fromEventId, JobID jobId, InterTrackerProtocol jobClient) throws IOException {
        TaskCompletionEvent[] t = jobClient.getTaskCompletionEvents(jobId, fromEventId.get(), this.probe_sample_size);
        ArrayList<TaskCompletionEvent> recentMapEvents = new ArrayList<TaskCompletionEvent>();
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].isMap) continue;
            recentMapEvents.add(t[i]);
        }
        fromEventId.set(fromEventId.get() + t.length);
        return recentMapEvents;
    }

    boolean isPermittedVersion(String jtBuildVersion, String jtVersion) {
        boolean buildVersionMatch = jtBuildVersion.equals(VersionInfo.getBuildVersion());
        boolean versionMatch = jtVersion.equals(VersionInfo.getVersion());
        if (buildVersionMatch && !versionMatch) {
            throw new AssertionError((Object)("Invalid build. The build versions match but the JT version is " + jtVersion + " and the TT version is " + VersionInfo.getVersion()));
        }
        if (this.relaxedVersionCheck) {
            if (!buildVersionMatch && versionMatch) {
                LOG.info((Object)("Permitting tasktracker revision " + VersionInfo.getRevision() + " to connect to jobtracker " + jtBuildVersion + " because " + " hadoop.relaxed.worker.version.check is enabled"));
            }
            return versionMatch;
        }
        return buildVersionMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State offerService() throws Exception {
        long lastHeartbeat = 0L;
        while (this.running && !this.shuttingDown) {
            String msg;
            try {
                Object dir;
                long now = System.currentTimeMillis();
                long waitTime = (long)this.heartbeatInterval - (now - lastHeartbeat);
                if (waitTime > 0L) {
                    IntWritable intWritable = this.finishedCount;
                    synchronized (intWritable) {
                        if (this.finishedCount.get() == 0) {
                            this.finishedCount.wait(waitTime);
                        }
                        this.finishedCount.set(0);
                    }
                }
                if (this.justInited) {
                    String jtVersion;
                    String jtBuildVersion = this.jobClient.getBuildVersion();
                    if (!this.isPermittedVersion(jtBuildVersion, jtVersion = this.jobClient.getVIVersion())) {
                        String msg2 = "Shutting down. Incompatible buildVersion.\nJobTracker's: " + jtBuildVersion + "\nTaskTracker's: " + VersionInfo.getBuildVersion() + " and hadoop.relaxed.worker.version.check is " + (this.relaxedVersionCheck ? "enabled" : "not enabled");
                        LOG.fatal((Object)msg2);
                        try {
                            this.jobClient.reportTaskTrackerError(this.taskTrackerName, null, msg2);
                        }
                        catch (Exception e) {
                            LOG.info((Object)("Problem reporting to jobtracker: " + e));
                        }
                        return State.DENIED;
                    }
                    dir = this.jobClient.getSystemDir();
                    if (dir == null) {
                        throw new IOException("Failed to get system directory");
                    }
                    this.systemDirectory = new Path((String)dir);
                    this.systemFS = this.systemDirectory.getFileSystem((Configuration)this.fConf);
                }
                if ((now = System.currentTimeMillis()) > this.lastCheckDirsTime + this.diskHealthCheckInterval) {
                    this.localStorage.checkDirs(this.localFs, false);
                    this.lastCheckDirsTime = now;
                    int numFailures = this.localStorage.numFailures();
                    if (numFailures > this.lastNumFailures) {
                        this.lastNumFailures = numFailures;
                        return State.STALE;
                    }
                }
                HeartbeatResponse heartbeatResponse = this.transmitHeartBeat(now);
                lastHeartbeat = System.currentTimeMillis();
                Set<JobID> jobs = heartbeatResponse.getRecoveredJobs();
                if (jobs.size() > 0) {
                    dir = this;
                    synchronized (dir) {
                        for (JobID job : jobs) {
                            Map<JobID, RunningJob> map = this.runningJobs;
                            synchronized (map) {
                                RunningJob rjob = this.runningJobs.get(job);
                                if (rjob != null) {
                                    RunningJob runningJob = rjob;
                                    synchronized (runningJob) {
                                        FetchStatus f = rjob.getFetchStatus();
                                        if (f != null) {
                                            f.reset();
                                        }
                                    }
                                }
                            }
                        }
                        Set<org.apache.hadoop.mapred.TaskAttemptID> i$ = this.shouldReset;
                        synchronized (i$) {
                            for (Map.Entry<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> entry : this.runningTasks.entrySet()) {
                                if (entry.getValue().getStatus().getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                                this.shouldReset.add(entry.getKey());
                            }
                        }
                    }
                }
                TaskTrackerAction[] actions = heartbeatResponse.getActions();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got heartbeatResponse from JobTracker with responseId: " + heartbeatResponse.getResponseId() + " and " + (actions != null ? actions.length : 0) + " actions"));
                }
                if (this.reinitTaskTracker(actions)) {
                    return State.STALE;
                }
                this.heartbeatInterval = heartbeatResponse.getHeartbeatInterval();
                this.justStarted = false;
                this.justInited = false;
                if (actions != null) {
                    for (TaskTrackerAction action : actions) {
                        if (action instanceof LaunchTaskAction) {
                            this.addToTaskQueue((LaunchTaskAction)action);
                            continue;
                        }
                        if (action instanceof CommitTaskAction) {
                            CommitTaskAction commitAction = (CommitTaskAction)action;
                            if (this.commitResponses.contains(commitAction.getTaskID())) continue;
                            LOG.info((Object)("Received commit task action for " + commitAction.getTaskID()));
                            this.commitResponses.add(commitAction.getTaskID());
                            continue;
                        }
                        this.tasksToCleanup.put(action);
                    }
                }
                this.markUnresponsiveTasks();
                this.killOverflowingTasks();
                if (!this.acceptNewTasks && this.isIdle()) {
                    this.acceptNewTasks = true;
                }
                this.checkJettyPort(this.server.getPort());
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted. Closing down.");
                return State.INTERRUPTED;
            }
            catch (DiskChecker.DiskErrorException de) {
                msg = "Exiting task tracker for disk error:\n" + StringUtils.stringifyException((Throwable)de);
                LOG.error((Object)msg);
                TaskTracker taskTracker = this;
                synchronized (taskTracker) {
                    this.jobClient.reportTaskTrackerError(this.taskTrackerName, "DiskErrorException", msg);
                }
                return State.DENIED;
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (!DisallowedTaskTrackerException.class.getName().equals(reClass)) continue;
                LOG.info((Object)"Tasktracker disallowed by JobTracker.");
                return State.DENIED;
            }
            catch (Exception except) {
                msg = "Caught exception: " + StringUtils.stringifyException((Throwable)except);
                LOG.error((Object)msg);
            }
        }
        return State.NORMAL;
    }

    void setIndexCache(IndexCache cache) {
        this.indexCache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeartbeatResponse transmitHeartBeat(long now) throws IOException {
        long localMinSpaceStart;
        boolean askForNewTask;
        boolean sendAllCounters;
        if (now > this.previousUpdate + 60000L) {
            sendAllCounters = true;
            this.previousUpdate = now;
        } else {
            sendAllCounters = false;
        }
        if (this.status == null) {
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.status = new TaskTrackerStatus(this.taskTrackerName, this.localHostname, this.httpPort, this.cloneAndResetRunningTaskStatuses(sendAllCounters), this.taskFailures, this.localStorage.numFailures(), this.maxMapSlots, this.maxReduceSlots);
            }
        } else {
            LOG.info((Object)("Resending 'status' to '" + this.jobTrackAddr.getHostName() + "' with reponseId '" + this.heartbeatResponseId));
        }
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            askForNewTask = (this.status.countOccupiedMapSlots() < this.maxMapSlots || this.status.countOccupiedReduceSlots() < this.maxReduceSlots) && this.acceptNewTasks;
            localMinSpaceStart = this.minSpaceStart;
        }
        if (askForNewTask) {
            askForNewTask = this.enoughFreeSpace(localMinSpaceStart);
            long freeDiskSpace = this.getFreeSpace();
            long totVmem = this.getTotalVirtualMemoryOnTT();
            long totPmem = this.getTotalPhysicalMemoryOnTT();
            long availableVmem = this.getAvailableVirtualMemoryOnTT();
            long availablePmem = this.getAvailablePhysicalMemoryOnTT();
            long cumuCpuTime = this.getCumulativeCpuTimeOnTT();
            long cpuFreq = this.getCpuFrequencyOnTT();
            int numCpu = this.getNumProcessorsOnTT();
            float cpuUsage = this.getCpuUsageOnTT();
            this.status.getResourceStatus().setAvailableSpace(freeDiskSpace);
            this.status.getResourceStatus().setTotalVirtualMemory(totVmem);
            this.status.getResourceStatus().setTotalPhysicalMemory(totPmem);
            this.status.getResourceStatus().setMapSlotMemorySizeOnTT(this.mapSlotMemorySizeOnTT);
            this.status.getResourceStatus().setReduceSlotMemorySizeOnTT(this.reduceSlotSizeMemoryOnTT);
            this.status.getResourceStatus().setAvailableVirtualMemory(availableVmem);
            this.status.getResourceStatus().setAvailablePhysicalMemory(availablePmem);
            this.status.getResourceStatus().setCumulativeCpuTime(cumuCpuTime);
            this.status.getResourceStatus().setCpuFrequency(cpuFreq);
            this.status.getResourceStatus().setNumProcessors(numCpu);
            this.status.getResourceStatus().setCpuUsage(cpuUsage);
        }
        TaskTrackerStatus.TaskTrackerHealthStatus healthStatus = this.status.getHealthStatus();
        TaskTracker taskTracker2 = this;
        synchronized (taskTracker2) {
            if (this.healthChecker != null) {
                this.healthChecker.setHealthStatus(healthStatus);
            } else {
                healthStatus.setNodeHealthy(true);
                healthStatus.setLastReported(0L);
                healthStatus.setHealthReport("");
            }
        }
        HeartbeatResponse heartbeatResponse = this.jobClient.heartbeat(this.status, this.justStarted, this.justInited, askForNewTask, this.heartbeatResponseId);
        this.heartbeatResponseId = heartbeatResponse.getResponseId();
        TaskTracker taskTracker3 = this;
        synchronized (taskTracker3) {
            for (TaskStatus taskStatus : this.status.getTaskReports()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || taskStatus.inTaskCleanupPhase()) continue;
                if (taskStatus.getIsMap()) {
                    --this.mapTotal;
                } else {
                    --this.reduceTotal;
                }
                try {
                    this.myInstrumentation.completeTask(taskStatus.getTaskID());
                }
                catch (MetricsException me) {
                    LOG.warn((Object)("Caught: " + StringUtils.stringifyException((Throwable)me)));
                }
                this.runningTasks.remove(taskStatus.getTaskID());
            }
            for (TaskInProgress tip : this.runningTasks.values()) {
                tip.getStatus().clearStatus();
            }
        }
        this.status = null;
        return heartbeatResponse;
    }

    long getTotalVirtualMemoryOnTT() {
        return this.totalVirtualMemoryOnTT;
    }

    long getTotalPhysicalMemoryOnTT() {
        return this.totalPhysicalMemoryOnTT;
    }

    long getAvailableVirtualMemoryOnTT() {
        long availableVirtualMemoryOnTT = -1L;
        if (this.resourceCalculatorPlugin != null) {
            availableVirtualMemoryOnTT = this.resourceCalculatorPlugin.getAvailableVirtualMemorySize();
        }
        return availableVirtualMemoryOnTT;
    }

    long getAvailablePhysicalMemoryOnTT() {
        long availablePhysicalMemoryOnTT = -1L;
        if (this.resourceCalculatorPlugin != null) {
            availablePhysicalMemoryOnTT = this.resourceCalculatorPlugin.getAvailablePhysicalMemorySize();
        }
        return availablePhysicalMemoryOnTT;
    }

    long getCumulativeCpuTimeOnTT() {
        long cumulativeCpuTime = -1L;
        if (this.resourceCalculatorPlugin != null) {
            cumulativeCpuTime = this.resourceCalculatorPlugin.getCumulativeCpuTime();
        }
        return cumulativeCpuTime;
    }

    int getNumProcessorsOnTT() {
        int numProcessors = -1;
        if (this.resourceCalculatorPlugin != null) {
            numProcessors = this.resourceCalculatorPlugin.getNumProcessors();
        }
        return numProcessors;
    }

    long getCpuFrequencyOnTT() {
        long cpuFrequency = -1L;
        if (this.resourceCalculatorPlugin != null) {
            cpuFrequency = this.resourceCalculatorPlugin.getCpuFrequency();
        }
        return cpuFrequency;
    }

    float getCpuUsageOnTT() {
        float cpuUsage = -1.0f;
        if (this.resourceCalculatorPlugin != null) {
            cpuUsage = this.resourceCalculatorPlugin.getCpuUsage();
        }
        return cpuUsage;
    }

    long getTotalMemoryAllottedForTasksOnTT() {
        return this.totalMemoryAllottedForTasks;
    }

    long getRetainSize(TaskAttemptID tid) {
        return tid.isMap() ? this.mapRetainSize : this.reduceRetainSize;
    }

    long getReservedPhysicalMemoryOnTT() {
        return this.reservedPhysicalMemoryOnTT;
    }

    private boolean reinitTaskTracker(TaskTrackerAction[] actions) {
        if (actions != null) {
            for (TaskTrackerAction action : actions) {
                if (action.getActionId() != TaskTrackerAction.ActionType.REINIT_TRACKER) continue;
                LOG.info((Object)"Recieved RenitTrackerAction from JobTracker");
                return true;
            }
        }
        return false;
    }

    private synchronized void markUnresponsiveTasks() throws IOException {
        long now = System.currentTimeMillis();
        for (TaskInProgress tip : this.runningTasks.values()) {
            long timeSinceLastReport;
            long jobTaskTimeout;
            if (tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING && !tip.isCleaningup() || (jobTaskTimeout = tip.getTaskTimeout()) == 0L || (timeSinceLastReport = now - tip.getLastProgressReport()) <= jobTaskTimeout || tip.wasKilled) continue;
            String msg = "Task " + tip.getTask().getTaskID() + " failed to report status for " + timeSinceLastReport / 1000L + " seconds. Killing!";
            LOG.info((Object)(tip.getTask().getTaskID() + ": " + msg));
            ReflectionUtils.logThreadInfo((Log)LOG, (String)"lost task", (long)30L);
            tip.reportDiagnosticInfo(msg);
            this.myInstrumentation.timedoutTask(tip.getTask().getTaskID());
            this.purgeTask(tip, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void purgeJob(KillJobAction action) throws IOException {
        JobID jobId = action.getJobID();
        LOG.info((Object)("Received 'KillJobAction' for job: " + jobId));
        RunningJob rjob = null;
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob == null) {
            LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
        } else {
            map = rjob;
            synchronized (map) {
                rjob.distCacheMgr.release();
                for (TaskInProgress tip : rjob.tasks) {
                    tip.jobHasFinished(false);
                    Task t = tip.getTask();
                    if (!t.isMapTask()) continue;
                    this.indexCache.removeMap(tip.getTask().getTaskID().toString());
                }
                if (!rjob.keepJobFiles) {
                    this.removeJobFiles(rjob.ugi.getShortUserName(), rjob.getJobID());
                }
                long now = System.currentTimeMillis();
                JobCompletedEvent jca = new JobCompletedEvent(rjob.getJobID(), now, UserLogCleaner.getUserlogRetainHours(rjob.getJobConf()));
                this.getUserLogManager().addLogEvent(jca);
                rjob.tasks.clear();
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)rjob.getUGI());
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Ignoring exception " + StringUtils.stringifyException((Throwable)ie) + " while closing FileSystem for " + rjob.getUGI()));
                }
            }
        }
        map = this.runningJobs;
        synchronized (map) {
            this.runningJobs.remove(jobId);
        }
        this.getJobTokenSecretManager().removeTokenForJob(jobId.toString());
        this.distributedCacheManager.removeTaskDistributedCacheManager(jobId);
    }

    void removeJobFiles(String user, JobID jobId) throws IOException {
        String userDir = TaskTracker.getUserDir(user);
        String jobDir = TaskTracker.getLocalJobDir(user, jobId.toString());
        TaskController.DeletionContext jobCleanup = new TaskController.DeletionContext(this.getTaskController(), false, user, jobDir.substring(userDir.length()));
        this.directoryCleanupThread.addToQueue(jobCleanup);
        for (String str : this.localStorage.getDirs()) {
            Path ttPrivateJobDir = FileSystem.getLocal((Configuration)this.fConf).makeQualified(new Path(str, TaskTracker.getPrivateDirForJob(user, jobId.toString())));
            CleanupQueue.PathDeletionContext ttPrivateJobCleanup = new CleanupQueue.PathDeletionContext(ttPrivateJobDir, this.fConf);
            this.directoryCleanupThread.addToQueue(ttPrivateJobCleanup);
        }
    }

    private void purgeTask(TaskInProgress tip, boolean wasFailure) throws IOException {
        if (tip != null) {
            LOG.info((Object)("About to purge task: " + tip.getTask().getTaskID()));
            this.removeTaskFromJob(tip.getTask().getJobID(), tip);
            tip.jobHasFinished(wasFailure);
            if (tip.getTask().isMapTask()) {
                this.indexCache.removeMap(tip.getTask().getTaskID().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOverflowingTasks() throws IOException {
        long localMinSpaceKill;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            localMinSpaceKill = this.minSpaceKill;
        }
        if (!this.enoughFreeSpace(localMinSpaceKill)) {
            this.acceptNewTasks = false;
            taskTracker = this;
            synchronized (taskTracker) {
                TaskInProgress killMe = this.findTaskToKill(null);
                if (killMe != null) {
                    String msg = "Tasktracker running out of space. Killing task.";
                    LOG.info((Object)(killMe.getTask().getTaskID() + ": " + msg));
                    killMe.reportDiagnosticInfo(msg);
                    this.purgeTask(killMe, false);
                }
            }
        }
    }

    synchronized TaskInProgress findTaskToKill(List<org.apache.hadoop.mapred.TaskAttemptID> tasksToExclude) {
        TaskInProgress killMe = null;
        for (TaskInProgress tip : this.runningTasks.values()) {
            if (tasksToExclude != null && tasksToExclude.contains(tip.getTask().getTaskID()) || tip.getRunState() != TaskStatus.State.RUNNING && tip.getRunState() != TaskStatus.State.COMMIT_PENDING || tip.wasKilled) continue;
            if (killMe == null) {
                killMe = tip;
                continue;
            }
            if (!tip.getTask().isMapTask()) {
                if (!killMe.getTask().isMapTask() && !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
                killMe = tip;
                continue;
            }
            if (!killMe.getTask().isMapTask() || !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
            killMe = tip;
        }
        return killMe;
    }

    private boolean enoughFreeSpace(long minSpace) throws IOException {
        if (minSpace == 0L) {
            return true;
        }
        return minSpace < this.getFreeSpace();
    }

    private long getFreeSpace() throws IOException {
        long biggestSeenSoFar = 0L;
        String[] localDirs = this.localStorage.getDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            DF df = null;
            if (this.localDirsDf.containsKey(localDirs[i])) {
                df = this.localDirsDf.get(localDirs[i]);
            } else {
                df = new DF(new File(localDirs[i]), (Configuration)this.fConf);
                this.localDirsDf.put(localDirs[i], df);
            }
            long availOnThisVol = df.getAvailable();
            if (availOnThisVol <= biggestSeenSoFar) continue;
            biggestSeenSoFar = availOnThisVol;
        }
        return biggestSeenSoFar;
    }

    public JvmManager getJvmManagerInstance() {
        return this.jvmManager;
    }

    void setJvmManagerInstance(JvmManager jvmManager) {
        this.jvmManager = jvmManager;
    }

    private void addToTaskQueue(LaunchTaskAction action) {
        if (action.getTask().isMapTask()) {
            this.mapLauncher.addToTaskQueue(action);
        } else {
            this.reduceLauncher.addToTaskQueue(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskInProgress registerTask(LaunchTaskAction action, TaskLauncher launcher) {
        Task t = action.getTask();
        LOG.info((Object)("LaunchTaskAction (registerTask): " + t.getTaskID() + " task's state:" + (Object)((Object)t.getState())));
        TaskInProgress tip = new TaskInProgress(t, this.fConf, launcher);
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            this.tasks.put(t.getTaskID(), tip);
            this.runningTasks.put(t.getTaskID(), tip);
            boolean isMap = t.isMapTask();
            if (isMap) {
                ++this.mapTotal;
            } else {
                ++this.reduceTotal;
            }
        }
        return tip;
    }

    void startNewTask(TaskInProgress tip) throws InterruptedException {
        block6: {
            try {
                RunningJob rjob = this.localizeJob(tip);
                tip.getTask().setJobFile(rjob.localizedJobConf.toString());
                this.launchTaskForJob(tip, new JobConf(rjob.jobConf), rjob);
            }
            catch (Throwable e) {
                String msg = "Error initializing " + tip.getTask().getTaskID() + ":\n" + StringUtils.stringifyException((Throwable)e);
                LOG.warn((Object)msg);
                tip.reportDiagnosticInfo(msg);
                try {
                    tip.kill(true);
                    tip.cleanup(true);
                }
                catch (IOException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskID()), (Throwable)ie2);
                }
                catch (InterruptedException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskID()), (Throwable)ie2);
                }
                if (!(e instanceof Error)) break block6;
                throw (Error)e;
            }
        }
    }

    void addToMemoryManager(org.apache.hadoop.mapred.TaskAttemptID attemptId, boolean isMap, JobConf conf) {
        if (!this.isTaskMemoryManagerEnabled()) {
            return;
        }
        long physicalMemoryLimit = conf.getLong(isMap ? "mapreduce.map.memory.physical.mb" : "mapreduce.reduce.memory.physical.mb", -1L);
        if (physicalMemoryLimit > 0L) {
            physicalMemoryLimit *= 0x100000L;
        }
        long virtualMemoryLimit = isMap ? conf.getMemoryForMapTask() * 1024L * 1024L : conf.getMemoryForReduceTask() * 1024L * 1024L;
        this.taskMemoryManager.addTask(attemptId, virtualMemoryLimit, physicalMemoryLimit);
    }

    void removeFromMemoryManager(org.apache.hadoop.mapred.TaskAttemptID attemptId) {
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager.removeTask(attemptId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTTAboutTaskCompletion() {
        if (this.oobHeartbeatOnTaskCompletion) {
            IntWritable intWritable = this.finishedCount;
            synchronized (intWritable) {
                int value = this.finishedCount.get();
                this.finishedCount.set(value + 1);
                this.finishedCount.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.getUserLogManager().start();
            this.startCleanupThreads();
            boolean denied = false;
            while (this.running && !this.shuttingDown) {
                boolean staleState = false;
                try {
                    while (this.running && !staleState && !this.shuttingDown && !denied) {
                        try {
                            State osState = this.offerService();
                            if (osState == State.STALE) {
                                staleState = true;
                                continue;
                            }
                            if (osState != State.DENIED) continue;
                            denied = true;
                        }
                        catch (Exception ex) {
                            if (this.shuttingDown) continue;
                            LOG.info((Object)("Lost connection to JobTracker [" + this.jobTrackAddr + "].  Retrying..."), (Throwable)ex);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
                finally {
                    if (!denied) {
                        this.close();
                    }
                }
                if (this.shuttingDown) {
                    return;
                }
                if (denied) break;
                LOG.warn((Object)"Reinitializing local state");
                this.initialize();
            }
            if (!denied) return;
            this.shutdown();
            return;
        }
        catch (IOException iex) {
            LOG.error((Object)("Got fatal exception while reinitializing TaskTracker: " + StringUtils.stringifyException((Throwable)iex)));
            return;
        }
        catch (InterruptedException i) {
            LOG.error((Object)("Got interrupted while reinitializing TaskTracker: " + i.getMessage()));
            return;
        }
    }

    private void validateJVM(TaskInProgress tip, JvmContext jvmContext, org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
        if (jvmContext == null) {
            LOG.warn((Object)"Null jvmContext. Cannot verify Jvm. validateJvm throwing exception");
            throw new IOException("JvmValidate Failed. JvmContext is null - cannot validate JVM");
        }
        if (!this.jvmManager.validateTipToJvm(tip, jvmContext.jvmId)) {
            throw new IOException("JvmValidate Failed. Ignoring request from task: " + taskid + ", with JvmId: " + jvmContext.jvmId);
        }
    }

    private void ensureAuthorizedJVM(org.apache.hadoop.mapreduce.JobID jobId) throws IOException {
        String currentJobId = UserGroupInformation.getCurrentUser().getUserName();
        if (!currentJobId.equals(jobId.toString())) {
            throw new IOException("JVM with " + currentJobId + " is not authorized for " + jobId);
        }
    }

    @Override
    public synchronized JvmTask getTask(JvmContext context) throws IOException {
        this.ensureAuthorizedJVM(context.jvmId.getJobId());
        JVMId jvmId = context.jvmId;
        LOG.debug((Object)("JVM with ID : " + jvmId + " asked for a task"));
        this.jvmManager.setPidToJvm(jvmId, context.pid);
        if (!this.jvmManager.isJvmKnown(jvmId)) {
            LOG.info((Object)("Killing unknown JVM " + jvmId));
            return new JvmTask(null, true);
        }
        RunningJob rjob = this.runningJobs.get(jvmId.getJobId());
        if (rjob == null) {
            LOG.info((Object)("Killing JVM " + jvmId + " since job " + jvmId.getJobId() + " is dead"));
            try {
                this.jvmManager.killJvm(jvmId);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Failed to kill " + jvmId), (Throwable)e);
            }
            return new JvmTask(null, true);
        }
        TaskInProgress tip = this.jvmManager.getTaskForJvm(jvmId);
        if (tip == null) {
            return new JvmTask(null, false);
        }
        if (this.tasks.get(tip.getTask().getTaskID()) != null) {
            LOG.info((Object)("JVM with ID: " + jvmId + " given task: " + tip.getTask().getTaskID()));
            return new JvmTask(tip.getTask(), false);
        }
        LOG.info((Object)("Killing JVM with ID: " + jvmId + " since scheduled task: " + tip.getTask().getTaskID() + " is " + (Object)((Object)tip.taskStatus.getRunState())));
        return new JvmTask(null, true);
    }

    @Override
    public synchronized boolean statusUpdate(org.apache.hadoop.mapred.TaskAttemptID taskid, TaskStatus taskStatus, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            try {
                this.validateJVM(tip, jvmContext, taskid);
            }
            catch (IOException ie) {
                LOG.warn((Object)"Failed validating JVM", (Throwable)ie);
                return false;
            }
            tip.reportProgress(taskStatus);
            return true;
        }
        LOG.warn((Object)("Progress from unknown child task: " + taskid));
        return false;
    }

    @Override
    public synchronized void reportDiagnosticInfo(org.apache.hadoop.mapred.TaskAttemptID taskid, String info, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskid);
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    synchronized void internalReportDiagnosticInfo(org.apache.hadoop.mapred.TaskAttemptID taskid, String info) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void reportNextRecordRange(org.apache.hadoop.mapred.TaskAttemptID taskid, SortedRanges.Range range, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskid);
            tip.reportNextRecordRange(range);
        } else {
            LOG.warn((Object)("reportNextRecordRange from unknown child task: " + taskid + ". " + "Ignored."));
        }
    }

    @Override
    public synchronized boolean ping(org.apache.hadoop.mapred.TaskAttemptID taskid, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskid);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void commitPending(org.apache.hadoop.mapred.TaskAttemptID taskid, TaskStatus taskStatus, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        LOG.info((Object)("Task " + taskid + " is in commit-pending," + "" + " task state:" + (Object)((Object)taskStatus.getRunState())));
        if (!this.statusUpdate(taskid, taskStatus, jvmContext)) {
            throw new IOException("Task not found for taskid: " + taskid);
        }
        this.reportTaskFinished(taskid, true);
    }

    @Override
    public synchronized boolean canCommit(org.apache.hadoop.mapred.TaskAttemptID taskid, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        this.validateJVM(tip, jvmContext, taskid);
        return this.commitResponses.contains(taskid);
    }

    @Override
    public synchronized void done(org.apache.hadoop.mapred.TaskAttemptID taskid, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskid.getJobID());
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskid);
            this.commitResponses.remove(taskid);
            tip.reportDone();
        } else {
            LOG.warn((Object)("Unknown child task done: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void shuffleError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskId.getJobID());
        TaskInProgress tip = this.runningTasks.get(taskId);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskId);
            LOG.fatal((Object)("Task: " + taskId + " - Killed due to Shuffle Failure: " + message));
            tip.reportDiagnosticInfo("Shuffle Error: " + message);
            this.purgeTask(tip, true);
        } else {
            LOG.warn((Object)("Unknown child task shuffleError: " + taskId + ". Ignored."));
        }
    }

    @Override
    public synchronized void fsError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskId.getJobID());
        TaskInProgress tip = this.runningTasks.get(taskId);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskId);
            LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
            tip.reportDiagnosticInfo("FSError: " + message);
            this.purgeTask(tip, true);
        } else {
            LOG.warn((Object)("Unknown child task fsError: " + taskId + ". Ignored."));
        }
    }

    synchronized void internalFsError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("FSError: " + message);
        this.purgeTask(tip, true);
    }

    @Override
    public synchronized void fatalError(org.apache.hadoop.mapred.TaskAttemptID taskId, String msg, JvmContext jvmContext) throws IOException {
        this.ensureAuthorizedJVM(taskId.getJobID());
        TaskInProgress tip = this.runningTasks.get(taskId);
        if (tip != null) {
            this.validateJVM(tip, jvmContext, taskId);
            LOG.fatal((Object)("Task: " + taskId + " - Killed : " + msg));
            tip.reportDiagnosticInfo("Error: " + msg);
            this.purgeTask(tip, true);
        } else {
            LOG.warn((Object)("Unknown child task fatalError: " + taskId + ". Ignored."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, org.apache.hadoop.mapred.TaskAttemptID id, JvmContext jvmContext) throws IOException {
        TaskInProgress tip = this.runningTasks.get(id);
        if (tip == null) {
            throw new IOException("Unknown task; " + id + ". Ignoring getMapCompletionEvents Request");
        }
        this.validateJVM(tip, jvmContext, id);
        this.ensureAuthorizedJVM(jobId);
        TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
        Set<org.apache.hadoop.mapred.TaskAttemptID> set = this.shouldReset;
        synchronized (set) {
            if (this.shouldReset.remove(id)) {
                return new MapTaskCompletionEventsUpdate(mapEvents, true);
            }
        }
        Map<JobID, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob != null) {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    if (f != null) {
                        mapEvents = f.getMapEvents(fromEventId, maxLocs);
                    }
                }
            }
        }
        return new MapTaskCompletionEventsUpdate(mapEvents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTaskFinished(org.apache.hadoop.mapred.TaskAttemptID taskid, boolean commitPending) {
        TaskInProgress tip;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            tip = this.tasks.get(taskid);
        }
        if (tip != null) {
            tip.reportTaskFinished(commitPending);
        } else {
            LOG.warn((Object)("Unknown child task finished: " + taskid + ". Ignored."));
        }
    }

    public synchronized void mapOutputLost(org.apache.hadoop.mapred.TaskAttemptID taskid, String errorMsg) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.mapOutputLost(errorMsg);
        } else {
            LOG.warn((Object)("Unknown child with bad map output: " + taskid + ". Ignored."));
        }
    }

    String getName() {
        return this.taskTrackerName;
    }

    private synchronized List<TaskStatus> cloneAndResetRunningTaskStatuses(boolean sendCounters) {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            TaskStatus status = tip.getStatus();
            status.setIncludeAllCounters(sendCounters);
            if (status.getRunState() != TaskStatus.State.RUNNING) {
                status.setIncludeAllCounters(true);
            }
            result.add((TaskStatus)status.clone());
            status.clearStatus();
        }
        return result;
    }

    synchronized List<TaskStatus> getRunningTaskStatuses() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            result.add(tip.getStatus());
        }
        return result;
    }

    synchronized List<TaskStatus> getNonRunningTasks() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<org.apache.hadoop.mapred.TaskAttemptID, TaskInProgress> task : this.tasks.entrySet()) {
            if (this.runningTasks.containsKey(task.getKey())) continue;
            result.add(task.getValue().getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<TaskStatus> getTasksFromRunningJobs() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<JobID, RunningJob> item : this.runningJobs.entrySet()) {
            RunningJob rjob;
            RunningJob runningJob = rjob = item.getValue();
            synchronized (runningJob) {
                for (TaskInProgress tip : rjob.tasks) {
                    result.add(tip.getStatus());
                }
            }
        }
        return result;
    }

    JobConf getJobConf() {
        return this.fConf;
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty() && this.tasksToCleanup.isEmpty();
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(TaskTracker.class, (String[])argv, (Log)LOG);
        if (argv.length != 0) {
            System.out.println("usage: TaskTracker");
            System.exit(-1);
        }
        try {
            JobConf conf = new JobConf();
            ReflectionUtils.setContentionTracing((boolean)conf.getBoolean("tasktracker.contention.tracking", false));
            TaskTracker tt = new TaskTracker(conf);
            MBeanUtil.registerMBean((String)"TaskTracker", (String)"TaskTrackerInfo", (Object)tt);
            tt.run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can not start task tracker because " + StringUtils.stringifyException((Throwable)e)));
            System.exit(-1);
        }
    }

    Path[] getLocalFiles(JobConf conf, String subdir) throws IOException {
        String[] localDirs = conf.getLocalDirs();
        Path[] paths = new Path[localDirs.length];
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        boolean subdirNeeded = subdir != null && subdir.length() > 0;
        for (int i = 0; i < localDirs.length; ++i) {
            paths[i] = subdirNeeded ? new Path(localDirs[i], subdir) : new Path(localDirs[i]);
            paths[i] = paths[i].makeQualified((FileSystem)localFs);
        }
        return paths;
    }

    FileSystem getLocalFileSystem() {
        return this.localFs;
    }

    void setLocalFileSystem(FileSystem fs) {
        this.localFs = (LocalFileSystem)fs;
    }

    int getMaxCurrentMapTasks() {
        return this.maxMapSlots;
    }

    int getMaxCurrentReduceTasks() {
        return this.maxReduceSlots;
    }

    int getNumDirFailures() {
        return this.localStorage.numFailures();
    }

    synchronized void setMaxMapSlots(int mapSlots) {
        this.maxMapSlots = mapSlots;
    }

    synchronized void setMaxReduceSlots(int reduceSlots) {
        this.maxReduceSlots = reduceSlots;
    }

    public boolean isTaskMemoryManagerEnabled() {
        return this.taskMemoryManagerEnabled;
    }

    public TaskMemoryManagerThread getTaskMemoryManager() {
        return this.taskMemoryManager;
    }

    synchronized TaskInProgress getRunningTask(org.apache.hadoop.mapred.TaskAttemptID tid) {
        return this.runningTasks.get(tid);
    }

    private long normalizeMemoryConfigValue(long val) {
        if (val < 0L) {
            val = -1L;
        }
        return val;
    }

    private void initializeMemoryManagement() {
        Class clazz;
        MemoryCalculatorPlugin memoryCalculatorPlugin;
        if (this.fConf.get(MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY) != null) {
            LOG.warn((Object)JobConf.deprecatedString(MAPRED_TASKTRACKER_VMEM_RESERVED_PROPERTY));
        }
        if (this.fConf.get(MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY) != null) {
            LOG.warn((Object)JobConf.deprecatedString(MAPRED_TASKTRACKER_PMEM_RESERVED_PROPERTY));
        }
        if (this.fConf.get("mapred.task.default.maxvmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString("mapred.task.default.maxvmem"));
        }
        if (this.fConf.get("mapred.task.limit.maxvmem") != null) {
            LOG.warn((Object)JobConf.deprecatedString("mapred.task.limit.maxvmem"));
        }
        MemoryCalculatorPlugin memoryCalculatorPlugin2 = memoryCalculatorPlugin = (clazz = this.fConf.getClass(MAPRED_TASKTRACKER_MEMORY_CALCULATOR_PLUGIN_PROPERTY, null, MemoryCalculatorPlugin.class)) == null ? null : MemoryCalculatorPlugin.getMemoryCalculatorPlugin(clazz, this.fConf);
        if (memoryCalculatorPlugin != null || this.resourceCalculatorPlugin != null) {
            long l = this.totalVirtualMemoryOnTT = memoryCalculatorPlugin == null ? this.resourceCalculatorPlugin.getVirtualMemorySize() : memoryCalculatorPlugin.getVirtualMemorySize();
            if (this.totalVirtualMemoryOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalVmem could not be calculated. Setting it to -1");
                this.totalVirtualMemoryOnTT = -1L;
            }
            long l2 = this.totalPhysicalMemoryOnTT = memoryCalculatorPlugin == null ? this.resourceCalculatorPlugin.getPhysicalMemorySize() : memoryCalculatorPlugin.getPhysicalMemorySize();
            if (this.totalPhysicalMemoryOnTT <= 0L) {
                LOG.warn((Object)"TaskTracker's totalPmem could not be calculated. Setting it to -1");
                this.totalPhysicalMemoryOnTT = -1L;
            }
        }
        this.mapSlotMemorySizeOnTT = this.fConf.getLong("mapred.cluster.map.memory.mb", -1L);
        this.reduceSlotSizeMemoryOnTT = this.fConf.getLong("mapred.cluster.reduce.memory.mb", -1L);
        this.totalMemoryAllottedForTasks = (long)this.maxMapSlots * this.mapSlotMemorySizeOnTT + (long)this.maxReduceSlots * this.reduceSlotSizeMemoryOnTT;
        if (this.totalMemoryAllottedForTasks < 0L) {
            long memoryAllotedForSlot = JobConf.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.default.maxvmem", -1L));
            long limitVmPerTask = JobConf.normalizeMemoryConfigValue(this.fConf.getLong("mapred.task.limit.maxvmem", -1L));
            if (memoryAllotedForSlot == -1L) {
                this.totalMemoryAllottedForTasks = -1L;
            } else if (memoryAllotedForSlot > limitVmPerTask) {
                LOG.info((Object)"DefaultMaxVmPerTask is mis-configured. It shouldn't be greater than task limits");
                this.totalMemoryAllottedForTasks = -1L;
            } else {
                this.totalMemoryAllottedForTasks = (long)(this.maxMapSlots + this.maxReduceSlots) * (memoryAllotedForSlot / 0x100000L);
            }
        }
        if (this.totalMemoryAllottedForTasks > this.totalPhysicalMemoryOnTT) {
            LOG.info((Object)"totalMemoryAllottedForTasks > totalPhysicalMemoryOnTT. Thrashing might happen.");
        } else if (this.totalMemoryAllottedForTasks > this.totalVirtualMemoryOnTT) {
            LOG.info((Object)"totalMemoryAllottedForTasks > totalVirtualMemoryOnTT. Thrashing might happen.");
        }
        this.reservedPhysicalMemoryOnTT = this.fConf.getLong(TT_RESERVED_PHYSICALMEMORY_MB, -1L);
        this.reservedPhysicalMemoryOnTT = this.reservedPhysicalMemoryOnTT == -1L ? -1L : this.reservedPhysicalMemoryOnTT * 1024L * 1024L;
        this.setTaskMemoryManagerEnabledFlag();
        if (this.isTaskMemoryManagerEnabled()) {
            this.taskMemoryManager = new TaskMemoryManagerThread(this);
            this.taskMemoryManager.setDaemon(true);
            this.taskMemoryManager.start();
        }
    }

    void setTaskMemoryManagerEnabledFlag() {
        if (!ProcfsBasedProcessTree.isAvailable()) {
            LOG.info((Object)"ProcessTree implementation is missing on this system. TaskMemoryManager is disabled.");
            this.taskMemoryManagerEnabled = false;
            return;
        }
        if (this.reservedPhysicalMemoryOnTT == -1L && this.totalMemoryAllottedForTasks == -1L) {
            this.taskMemoryManagerEnabled = false;
            LOG.warn((Object)"TaskTracker's totalMemoryAllottedForTasks is -1 and reserved physical memory is not configured. TaskMemoryManager is disabled.");
            return;
        }
        this.taskMemoryManagerEnabled = true;
    }

    synchronized void cleanUpOverMemoryTask(org.apache.hadoop.mapred.TaskAttemptID tid, boolean wasFailure, String diagnosticMsg) {
        TaskInProgress tip = this.runningTasks.get(tid);
        if (tip != null) {
            tip.reportDiagnosticInfo(diagnosticMsg);
            try {
                this.purgeTask(tip, wasFailure);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Couldn't purge the task of " + tid + ". Error : " + ioe));
            }
        }
    }

    private boolean shouldStartHealthMonitor(Configuration conf) {
        return NodeHealthCheckerService.shouldRun(conf);
    }

    private void startHealthMonitor(Configuration conf) {
        this.healthChecker = new NodeHealthCheckerService(conf);
        this.healthChecker.start();
    }

    TrackerDistributedCacheManager getTrackerDistributedCacheManager() {
        return this.distributedCacheManager;
    }

    private String localizeJobTokenFile(String user, JobID jobId) throws IOException {
        Path skPath = new Path(this.systemDirectory, jobId.toString() + "/" + JOB_TOKEN_FILE);
        FileStatus status = null;
        long jobTokenSize = -1L;
        status = this.systemFS.getFileStatus(skPath);
        jobTokenSize = status.getLen();
        Path localJobTokenFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getPrivateDirJobTokenFile(user, jobId.toString()), jobTokenSize, (Configuration)this.fConf);
        String localJobTokenFileStr = localJobTokenFile.toUri().getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("localizingJobTokenFile from sd=" + skPath.toUri().getPath() + " to " + localJobTokenFileStr));
        }
        this.systemFS.copyToLocalFile(skPath, localJobTokenFile);
        return localJobTokenFileStr;
    }

    JobACLsManager getJobACLsManager() {
        return this.aclsManager.getJobACLsManager();
    }

    ACLsManager getACLsManager() {
        return this.aclsManager;
    }

    @Override
    public String getHostname() {
        return this.localHostname;
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getConfigVersion() {
        return this.originalConf.get(CONF_VERSION_KEY, CONF_VERSION_DEFAULT);
    }

    @Override
    public String getJobTrackerUrl() {
        return this.originalConf.get("mapred.job.tracker");
    }

    @Override
    public int getRpcPort() {
        return this.taskReportAddress.getPort();
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public boolean isHealthy() {
        boolean healthy = true;
        TaskTrackerStatus.TaskTrackerHealthStatus hs = new TaskTrackerStatus.TaskTrackerHealthStatus();
        if (this.healthChecker != null) {
            this.healthChecker.setHealthStatus(hs);
            healthy = hs.isNodeHealthy();
        }
        return healthy;
    }

    @Override
    public String getTasksInfoJson() {
        return this.getTasksInfo().toJson();
    }

    InfoMap getTasksInfo() {
        InfoMap map = new InfoMap();
        int failed = 0;
        int commitPending = 0;
        for (TaskStatus st : this.getNonRunningTasks()) {
            if (st.getRunState() == TaskStatus.State.FAILED || st.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                ++failed;
                continue;
            }
            if (st.getRunState() != TaskStatus.State.COMMIT_PENDING) continue;
            ++commitPending;
        }
        map.put("running", this.runningTasks.size());
        map.put("failed", failed);
        map.put("commit_pending", commitPending);
        return map;
    }

    @Override
    public void updatePrivateDistributedCacheSizes(org.apache.hadoop.mapreduce.JobID jobId, long[] sizes) throws IOException {
        this.ensureAuthorizedJVM(jobId);
        this.distributedCacheManager.setArchiveSizes(jobId, sizes);
    }

    static {
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
        LOG = LogFactory.getLog(TaskTracker.class);
        ClientTraceLog = LogFactory.getLog((String)(TaskTracker.class.getName() + ".clienttrace"));
        jobACLsFile = "job-acls.xml";
        FILE_CACHE_SIZE = 2000;
        r = new Random();
        lDirAlloc = new LocalDirAllocator("mapred.local.dir");
    }

    public static class MapOutputServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final int MAX_BYTES_TO_READ = 65536;
        private static LRUCache<String, Path> fileCache = new LRUCache(FILE_CACHE_SIZE);
        private static LRUCache<String, Path> fileIndexCache = new LRUCache(FILE_CACHE_SIZE);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            long startTime;
            ShuffleServerMetrics shuffleMetrics;
            long totalRead;
            ServletOutputStream outStream;
            String mapId;
            block24: {
                mapId = request.getParameter("map");
                String reduceId = request.getParameter("reduce");
                String jobId = request.getParameter("job");
                if (jobId == null) {
                    throw new IOException("job parameter is required");
                }
                if (mapId == null || reduceId == null) {
                    throw new IOException("map and reduce parameters are required");
                }
                ServletContext context = this.getServletContext();
                int reduce = Integer.parseInt(reduceId);
                byte[] buffer = new byte[65536];
                boolean isInputException = true;
                outStream = null;
                FileInputStream mapOutputIn = null;
                totalRead = 0L;
                shuffleMetrics = (ShuffleServerMetrics)context.getAttribute("shuffleServerMetrics");
                TaskTracker tracker = (TaskTracker)context.getAttribute("task.tracker");
                String exceptionStackRegex = (String)context.getAttribute("exceptionStackRegex");
                String exceptionMsgRegex = (String)context.getAttribute("exceptionMsgRegex");
                this.verifyRequest(request, response, tracker, jobId);
                startTime = 0L;
                try {
                    String fileKey;
                    Path mapOutputFileName;
                    shuffleMetrics.serverHandlerBusy();
                    if (ClientTraceLog.isInfoEnabled()) {
                        startTime = System.nanoTime();
                    }
                    response.setContentType("application/octet-stream");
                    outStream = response.getOutputStream();
                    JobConf conf = (JobConf)((Object)context.getAttribute("conf"));
                    LocalDirAllocator lDirAlloc = (LocalDirAllocator)context.getAttribute("localDirAllocator");
                    FileSystem rfs = ((LocalFileSystem)context.getAttribute("local.file.system")).getRaw();
                    String userName = null;
                    String runAsUserName = null;
                    Map<JobID, RunningJob> map = tracker.runningJobs;
                    synchronized (map) {
                        RunningJob rjob = tracker.runningJobs.get(JobID.forName(jobId));
                        if (rjob == null) {
                            throw new IOException("Unknown job " + jobId + "!!");
                        }
                        userName = rjob.jobConf.getUser();
                        runAsUserName = tracker.getTaskController().getRunAsUser(rjob.jobConf);
                    }
                    String intermediateOutputDir = TaskTracker.getIntermediateOutputDir(userName, jobId, mapId);
                    String indexKey = intermediateOutputDir + "/file.out.index";
                    Path indexFileName = fileIndexCache.get(indexKey);
                    if (indexFileName == null) {
                        indexFileName = lDirAlloc.getLocalPathToRead(indexKey, (Configuration)conf);
                        fileIndexCache.put(indexKey, indexFileName);
                    }
                    if ((mapOutputFileName = fileCache.get(fileKey = intermediateOutputDir + "/file.out")) == null) {
                        mapOutputFileName = lDirAlloc.getLocalPathToRead(fileKey, (Configuration)conf);
                        fileCache.put(fileKey, mapOutputFileName);
                    }
                    IndexRecord info = tracker.indexCache.getIndexInformation(mapId, reduce, indexFileName, runAsUserName);
                    response.setHeader("from-map-task", mapId);
                    response.setHeader("Raw-Map-Output-Length", Long.toString(info.rawLength));
                    response.setHeader("Map-Output-Length", Long.toString(info.partLength));
                    response.setHeader("for-reduce-task", Integer.toString(reduce));
                    response.setBufferSize(65536);
                    String filePath = mapOutputFileName.toUri().getPath();
                    mapOutputIn = SecureIOUtils.openForRead((File)new File(filePath), (String)runAsUserName, null);
                    ReadaheadPool.ReadaheadRequest curReadahead = null;
                    mapOutputIn.skip(info.startOffset);
                    long rem = info.partLength;
                    long offset = info.startOffset;
                    while (rem > 0L) {
                        int len;
                        if (tracker.manageOsCacheInShuffle && tracker.readaheadPool != null) {
                            curReadahead = tracker.readaheadPool.readaheadStream(filePath, mapOutputIn.getFD(), offset, (long)tracker.readaheadLength, info.startOffset + info.partLength, curReadahead);
                        }
                        if ((len = mapOutputIn.read(buffer, 0, (int)Math.min(rem, 65536L))) < 0) break;
                        rem -= (long)len;
                        offset += (long)len;
                        try {
                            shuffleMetrics.outputBytes(len);
                            outStream.write(buffer, 0, len);
                            outStream.flush();
                        }
                        catch (IOException ie) {
                            isInputException = false;
                            throw ie;
                        }
                        totalRead += (long)len;
                    }
                    if (curReadahead != null) {
                        curReadahead.cancel();
                    }
                    if (tracker.manageOsCacheInShuffle && info.partLength > 0L) {
                        NativeIO.posixFadviseIfPossible((FileDescriptor)mapOutputIn.getFD(), (long)info.startOffset, (long)info.partLength, (int)4);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.info((Object)("Sent out " + totalRead + " bytes for reduce: " + reduce + " from map: " + mapId + " given " + info.partLength + "/" + info.rawLength));
                    }
                    if (null == mapOutputIn) break block24;
                }
                catch (IOException ie) {
                    try {
                        Log log = (Log)context.getAttribute("log");
                        String errorMsg = "getMapOutput(" + mapId + "," + reduceId + ") failed :\n" + StringUtils.stringifyException((Throwable)ie);
                        log.warn((Object)errorMsg);
                        this.checkException(ie, exceptionMsgRegex, exceptionStackRegex, shuffleMetrics);
                        if (isInputException) {
                            tracker.mapOutputLost(org.apache.hadoop.mapred.TaskAttemptID.forName(mapId), errorMsg);
                        }
                        response.sendError(410, errorMsg);
                        shuffleMetrics.failedOutput();
                        throw ie;
                    }
                    catch (Throwable throwable) {
                        if (null != mapOutputIn) {
                            mapOutputIn.close();
                        }
                        long endTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
                        shuffleMetrics.serverHandlerFree();
                        if (ClientTraceLog.isInfoEnabled()) {
                            ClientTraceLog.info((Object)String.format(TaskTracker.MR_CLIENTTRACE_FORMAT, request.getLocalAddr() + ":" + request.getLocalPort(), request.getRemoteAddr() + ":" + request.getRemotePort(), totalRead, "MAPRED_SHUFFLE", mapId, endTime - startTime));
                        }
                        throw throwable;
                    }
                }
                mapOutputIn.close();
            }
            long endTime = ClientTraceLog.isInfoEnabled() ? System.nanoTime() : 0L;
            shuffleMetrics.serverHandlerFree();
            if (ClientTraceLog.isInfoEnabled()) {
                ClientTraceLog.info((Object)String.format(TaskTracker.MR_CLIENTTRACE_FORMAT, request.getLocalAddr() + ":" + request.getLocalPort(), request.getRemoteAddr() + ":" + request.getRemotePort(), totalRead, "MAPRED_SHUFFLE", mapId, endTime - startTime));
            }
            outStream.close();
            shuffleMetrics.successOutput();
        }

        protected void checkException(IOException ie, String exceptionMsgRegex, String exceptionStackRegex, ShuffleServerMetrics shuffleMetrics) {
            String msg;
            if (!(exceptionMsgRegex == null || (msg = ie.getMessage()) != null && msg.matches(exceptionMsgRegex))) {
                return;
            }
            if (exceptionStackRegex != null && !this.checkStackException(ie, exceptionStackRegex)) {
                return;
            }
            shuffleMetrics.exceptionsCaught();
        }

        private boolean checkStackException(IOException ie, String exceptionStackRegex) {
            StackTraceElement[] stack;
            for (StackTraceElement elem : stack = ie.getStackTrace()) {
                String stacktrace = elem.toString();
                if (!stacktrace.matches(exceptionStackRegex)) continue;
                return true;
            }
            return false;
        }

        private void verifyRequest(HttpServletRequest request, HttpServletResponse response, TaskTracker tracker, String jobId) throws IOException {
            SecretKey tokenSecret = tracker.getJobTokenSecretManager().retrieveTokenSecret(jobId);
            String enc_str = SecureShuffleUtils.buildMsgFrom(request);
            String urlHashStr = request.getHeader("UrlHash");
            if (urlHashStr == null) {
                response.sendError(401);
                throw new IOException("fetcher cannot be authenticated " + request.getRemoteHost());
            }
            int len = urlHashStr.length();
            LOG.debug((Object)("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1)));
            try {
                SecureShuffleUtils.verifyReply(urlHashStr, enc_str, tokenSecret);
            }
            catch (IOException ioe) {
                response.sendError(401);
                throw ioe;
            }
            String reply = SecureShuffleUtils.generateHash(urlHashStr.getBytes(), tokenSecret);
            response.addHeader("ReplyHash", reply);
            len = reply.length();
            LOG.debug((Object)("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1)));
        }
    }

    static class LRUCache<K, V> {
        private int cacheSize;
        private LinkedHashMap<K, V> map;

        public LRUCache(int cacheSize) {
            this.cacheSize = cacheSize;
            this.map = new LinkedHashMap<K, V>(cacheSize, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > LRUCache.this.cacheSize;
                }
            };
        }

        public synchronized V get(K key) {
            return this.map.get(key);
        }

        public synchronized void put(K key, V value) {
            this.map.put(key, value);
        }

        public synchronized int size() {
            return this.map.size();
        }

        public Iterator<Map.Entry<K, V>> getIterator() {
            return new LinkedList<Map.Entry<K, V>>(this.map.entrySet()).iterator();
        }

        public synchronized void clear() {
            this.map.clear();
        }
    }

    static class RunningJob {
        private JobID jobid;
        private JobConf jobConf;
        private Path localizedJobConf;
        volatile Set<TaskInProgress> tasks;
        volatile boolean localized;
        boolean localizing;
        boolean keepJobFiles;
        UserGroupInformation ugi;
        FetchStatus f;
        TaskDistributedCacheManager distCacheMgr;

        RunningJob(JobID jobid) {
            this.jobid = jobid;
            this.localized = false;
            this.localizing = false;
            this.tasks = new HashSet<TaskInProgress>();
            this.keepJobFiles = false;
        }

        JobID getJobID() {
            return this.jobid;
        }

        UserGroupInformation getUGI() {
            return this.ugi;
        }

        void setFetchStatus(FetchStatus f) {
            this.f = f;
        }

        FetchStatus getFetchStatus() {
            return this.f;
        }

        JobConf getJobConf() {
            return this.jobConf;
        }
    }

    class TaskInProgress {
        Task task;
        long lastProgressReport;
        StringBuffer diagnosticInfo = new StringBuffer();
        private TaskRunner runner;
        volatile boolean done = false;
        volatile boolean wasKilled = false;
        private JobConf ttConf;
        private JobConf localJobConf;
        private boolean keepFailedTaskFiles;
        private boolean alwaysKeepTaskFiles;
        private TaskStatus taskStatus;
        private long taskTimeout;
        private String debugCommand;
        private volatile boolean slotTaken = false;
        private TaskLauncher launcher;
        private UserGroupInformation ugi;

        UserGroupInformation getUGI() {
            return this.ugi;
        }

        void setUGI(UserGroupInformation userUGI) {
            this.ugi = userUGI;
        }

        public TaskInProgress(Task task, JobConf conf) {
            this(task, conf, null);
        }

        public TaskInProgress(Task task, JobConf conf, TaskLauncher launcher) {
            this.task = task;
            this.launcher = launcher;
            this.lastProgressReport = System.currentTimeMillis();
            this.ttConf = conf;
            this.localJobConf = null;
            this.taskStatus = TaskStatus.createTaskStatus(task.isMapTask(), task.getTaskID(), 0.0f, task.getNumSlotsRequired(), task.getState(), this.diagnosticInfo.toString(), "initializing", TaskTracker.this.getName(), task.isTaskCleanupTask() ? TaskStatus.Phase.CLEANUP : (task.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE), task.getCounters());
            this.taskTimeout = 600000L;
        }

        void localizeTask(Task task) throws IOException {
            task.localizeConfiguration(this.localJobConf);
            task.setConf(this.localJobConf);
        }

        public Task getTask() {
            return this.task;
        }

        TaskRunner getTaskRunner() {
            return this.runner;
        }

        void setTaskRunner(TaskRunner rnr) {
            this.runner = rnr;
        }

        public synchronized void setJobConf(JobConf lconf) {
            this.localJobConf = lconf;
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            this.taskTimeout = this.localJobConf.getLong("mapred.task.timeout", 600000L);
            this.debugCommand = this.task.isMapTask() ? this.localJobConf.getMapDebugScript() : this.localJobConf.getReduceDebugScript();
            String keepPattern = this.localJobConf.getKeepTaskFilesPattern();
            this.alwaysKeepTaskFiles = keepPattern != null ? Pattern.matches(keepPattern, this.task.getTaskID().toString()) : false;
        }

        public synchronized JobConf getJobConf() {
            return this.localJobConf;
        }

        public synchronized TaskStatus getStatus() {
            this.taskStatus.setDiagnosticInfo(this.diagnosticInfo.toString());
            if (this.diagnosticInfo.length() > 0) {
                this.diagnosticInfo = new StringBuffer();
            }
            return this.taskStatus;
        }

        public synchronized void launchTask(RunningJob rjob) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.localizeTask(this.task);
                if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                    this.taskStatus.setRunState(TaskStatus.State.RUNNING);
                }
                this.setTaskRunner(this.task.createRunner(TaskTracker.this, this, rjob));
                this.runner.start();
                long now = System.currentTimeMillis();
                this.taskStatus.setStartTime(now);
                this.lastProgressReport = now;
            } else {
                LOG.info((Object)("Not launching task: " + this.task.getTaskID() + " since it's state is " + (Object)((Object)this.taskStatus.getRunState())));
            }
        }

        boolean isCleaningup() {
            return this.taskStatus.inTaskCleanupPhase();
        }

        boolean canBeLaunched() {
            return this.getRunState() == TaskStatus.State.UNASSIGNED || this.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.getRunState() == TaskStatus.State.KILLED_UNCLEAN;
        }

        public synchronized void reportProgress(TaskStatus taskStatus) {
            LOG.info((Object)(this.task.getTaskID() + " " + taskStatus.getProgress() + "% " + taskStatus.getStateString()));
            if (this.done || this.taskStatus.getRunState() != TaskStatus.State.RUNNING && this.taskStatus.getRunState() != TaskStatus.State.COMMIT_PENDING && !this.isCleaningup() || (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) && (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.UNASSIGNED)) {
                LOG.info((Object)(this.task.getTaskID() + " Ignoring status-update since " + (this.done ? "task is 'done'" : "runState: " + (Object)((Object)this.taskStatus.getRunState()))));
                return;
            }
            this.taskStatus.statusUpdate(taskStatus);
            this.lastProgressReport = System.currentTimeMillis();
        }

        public long getLastProgressReport() {
            return this.lastProgressReport;
        }

        public TaskStatus.State getRunState() {
            return this.taskStatus.getRunState();
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public synchronized void reportDiagnosticInfo(String info) {
            this.diagnosticInfo.append(info);
        }

        public synchronized void reportNextRecordRange(SortedRanges.Range range) {
            this.taskStatus.setNextRecordRange(range);
        }

        public synchronized void reportDone() {
            if (this.isCleaningup()) {
                if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            } else {
                this.taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
            }
            this.taskStatus.setProgress(1.0f);
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            this.done = true;
            TaskTracker.this.jvmManager.taskFinished(this.runner);
            this.runner.signalDone();
            LOG.info((Object)("Task " + this.task.getTaskID() + " is done."));
            LOG.info((Object)("reported output size for " + this.task.getTaskID() + "  was " + this.taskStatus.getOutputSize()));
        }

        public boolean wasKilled() {
            return this.wasKilled;
        }

        void reportTaskFinished(boolean commitPending) {
            if (!commitPending) {
                this.taskFinished();
                this.releaseSlot();
            }
            TaskTracker.this.notifyTTAboutTaskCompletion();
        }

        private void setTaskFailState(boolean wasFailure) {
            if (this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN) {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            } else if (this.task.isMapOrReduce() && this.taskStatus.getPhase() != TaskStatus.Phase.CLEANUP) {
                if (wasFailure) {
                    this.taskStatus.setRunState(TaskStatus.State.FAILED_UNCLEAN);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED_UNCLEAN);
                }
            } else if (wasFailure) {
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
            } else {
                this.taskStatus.setRunState(TaskStatus.State.KILLED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished() {
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            boolean needCleanup = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.done || !this.wasKilled) {
                    TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
                }
                if (!this.done) {
                    if (!this.wasKilled) {
                        TaskTracker.this.taskFailures++;
                        this.setTaskFailState(true);
                        if (this.debugCommand != null) {
                            String taskStdout = "";
                            String taskStderr = "";
                            String taskSyslog = "";
                            String jobConf = this.task.getJobFile();
                            try {
                                Map<TaskLog.LogName, TaskLog.LogFileDetail> allFilesDetails = TaskLog.getAllLogsFileDetails(this.task.getTaskID(), this.task.isTaskCleanupTask());
                                taskStdout = TaskLog.getRealTaskLogFilePath(allFilesDetails.get((Object)((Object)TaskLog.LogName.STDOUT)).location, TaskLog.LogName.STDOUT);
                                taskStderr = TaskLog.getRealTaskLogFilePath(allFilesDetails.get((Object)((Object)TaskLog.LogName.STDERR)).location, TaskLog.LogName.STDERR);
                                taskSyslog = TaskLog.getRealTaskLogFilePath(allFilesDetails.get((Object)((Object)TaskLog.LogName.SYSLOG)).location, TaskLog.LogName.SYSLOG);
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Exception finding task's stdout/err/syslog files");
                            }
                            File workDir = null;
                            try {
                                workDir = new File(lDirAlloc.getLocalPathToRead(TaskTracker.getLocalTaskDir(this.task.getUser(), this.task.getJobID().toString(), this.task.getTaskID().toString(), this.task.isTaskCleanupTask()) + "/" + "work", (Configuration)this.localJobConf).toString());
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Working Directory of the task " + this.task.getTaskID() + " doesnt exist. Caught exception " + StringUtils.stringifyException((Throwable)e)));
                            }
                            File stdout = TaskLog.getTaskLogFile(this.task.getTaskID(), this.task.isTaskCleanupTask(), TaskLog.LogName.DEBUGOUT);
                            String program = "";
                            String executable = Submitter.getExecutable(this.localJobConf);
                            if (executable != null) {
                                try {
                                    program = new URI(executable).getFragment();
                                }
                                catch (URISyntaxException ur) {
                                    LOG.warn((Object)"Problem in the URI fragment for pipes executable");
                                }
                            }
                            String[] debug = this.debugCommand.split(" ");
                            Vector<String> vargs = new Vector<String>();
                            for (String component : debug) {
                                vargs.add(component);
                            }
                            vargs.add(taskStdout);
                            vargs.add(taskStderr);
                            vargs.add(taskSyslog);
                            vargs.add(jobConf);
                            vargs.add(program);
                            try {
                                List<String> wrappedCommand = TaskLog.captureDebugOut(vargs, stdout);
                                try {
                                    this.runScript(wrappedCommand, workDir);
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("runScript failed with: " + StringUtils.stringifyException((Throwable)ioe)));
                                }
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Error in preparing wrapped debug command");
                            }
                            try {
                                int num = this.localJobConf.getInt("mapred.debug.out.lines", -1);
                                this.addDiagnostics(FileUtil.makeShellPath((File)stdout), num, "DEBUG OUT");
                            }
                            catch (IOException ioe) {
                                LOG.warn((Object)"Exception in add diagnostics!");
                            }
                            JvmFinishedEvent jvmFinished = new JvmFinishedEvent(new JVMInfo(TaskLog.getAttemptDir(this.task.getTaskID(), this.task.isTaskCleanupTask()), Arrays.asList(this.task)));
                            TaskTracker.this.getUserLogManager().addLogEvent(jvmFinished);
                        }
                    }
                    this.taskStatus.setProgress(0.0f);
                }
                this.taskStatus.setFinishTime(System.currentTimeMillis());
                needCleanup = this.taskStatus.getRunState() == TaskStatus.State.FAILED || this.taskStatus.getRunState() == TaskStatus.State.FAILED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED_UNCLEAN || this.taskStatus.getRunState() == TaskStatus.State.KILLED;
            }
            if (needCleanup) {
                TaskTracker.this.removeTaskFromJob(this.task.getJobID(), this);
            }
            try {
                this.cleanup(needCleanup);
            }
            catch (IOException ie) {
                // empty catch block
            }
        }

        public void runScript(List<String> args, File dir) throws IOException {
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]), dir);
            shexec.execute();
            int exitCode = shexec.getExitCode();
            if (exitCode != 0) {
                throw new IOException("Task debug script exit with nonzero status of " + exitCode + ".");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDiagnostics(String file, int num, String tag) {
            RandomAccessFile rafile = null;
            try {
                int n;
                rafile = new RandomAccessFile(file, "r");
                int no_lines = 0;
                String line = null;
                StringBuffer tail = new StringBuffer();
                tail.append("\n-------------------- " + tag + "---------------------\n");
                String[] lines = null;
                if (num > 0) {
                    lines = new String[num];
                }
                while ((line = rafile.readLine()) != null) {
                    ++no_lines;
                    if (num > 0) {
                        if (no_lines <= num) {
                            lines[no_lines - 1] = line;
                            continue;
                        }
                        for (int i = 0; i < num - 1; ++i) {
                            lines[i] = lines[i + 1];
                        }
                        lines[num - 1] = line;
                        continue;
                    }
                    if (num != -1) continue;
                    tail.append(line);
                    tail.append("\n");
                }
                int n2 = n = no_lines > num ? num : no_lines;
                if (num > 0) {
                    for (int i = 0; i < n; ++i) {
                        tail.append(lines[i]);
                        tail.append("\n");
                    }
                }
                if (n != 0) {
                    this.reportDiagnosticInfo(tail.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                LOG.warn((Object)("File " + file + " not found"));
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error reading file " + file));
            }
            finally {
                try {
                    if (rafile != null) {
                        rafile.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + file));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobHasFinished(boolean wasFailure) throws IOException {
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.getRunState() == TaskStatus.State.RUNNING || this.getRunState() == TaskStatus.State.UNASSIGNED || this.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                    try {
                        this.kill(wasFailure);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while killing " + this.getTask().getTaskID(), e);
                    }
                }
            }
            this.cleanup(true);
        }

        public synchronized void kill(boolean wasFailure) throws IOException, InterruptedException {
            if (this.taskStatus.getRunState() == TaskStatus.State.RUNNING || this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.isCleaningup()) {
                this.wasKilled = true;
                if (wasFailure) {
                    TaskTracker.this.taskFailures++;
                }
                if (this.runner != null) {
                    this.runner.kill();
                }
                this.setTaskFailState(wasFailure);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                if (wasFailure) {
                    TaskTracker.this.taskFailures++;
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            }
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            TaskTracker.this.removeFromMemoryManager(this.task.getTaskID());
            this.releaseSlot();
            TaskTracker.this.notifyTTAboutTaskCompletion();
        }

        private synchronized void releaseSlot() {
            if (this.slotTaken) {
                if (this.launcher != null) {
                    this.launcher.addFreeSlots(this.task.getNumSlotsRequired());
                }
                this.slotTaken = false;
            } else if (this.launcher != null) {
                this.launcher.notifySlots();
            }
        }

        private synchronized void mapOutputLost(String failure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.SUCCEEDED) {
                LOG.info((Object)("Reporting output lost:" + this.task.getTaskID()));
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
                this.taskStatus.setProgress(0.0f);
                this.reportDiagnosticInfo("Map output lost, rescheduling: " + failure);
                TaskTracker.this.runningTasks.put(this.task.getTaskID(), this);
                ++TaskTracker.this.mapTotal;
            } else {
                LOG.warn((Object)("Output already reported lost:" + this.task.getTaskID()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup(boolean needCleanup) throws IOException {
            org.apache.hadoop.mapred.TaskAttemptID taskId = this.task.getTaskID();
            LOG.debug((Object)("Cleaning up " + taskId));
            Object object = TaskTracker.this;
            synchronized (object) {
                if (needCleanup && TaskTracker.this.tasks.get(taskId) == this) {
                    TaskTracker.this.tasks.remove(taskId);
                }
                TaskInProgress taskInProgress = this;
                synchronized (taskInProgress) {
                    if (this.alwaysKeepTaskFiles || this.taskStatus.getRunState() == TaskStatus.State.FAILED && this.keepFailedTaskFiles) {
                        return;
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (this.localJobConf == null) {
                    return;
                }
                try {
                    this.removeTaskFiles(needCleanup);
                }
                catch (Throwable ie) {
                    LOG.info((Object)("Error cleaning up task runner: " + StringUtils.stringifyException((Throwable)ie)));
                }
            }
        }

        void removeTaskFiles(boolean removeOutputs) throws IOException {
            if (this.localJobConf.getNumTasksToExecutePerJvm() == 1) {
                String user = this.ugi.getShortUserName();
                int userDirLen = TaskTracker.getUserDir(user).length();
                String jobId = this.task.getJobID().toString();
                String taskId = this.task.getTaskID().toString();
                boolean cleanup = this.task.isTaskCleanupTask();
                String taskDir = !removeOutputs ? TaskTracker.getTaskWorkDir(user, jobId, taskId, cleanup) : TaskTracker.getLocalTaskDir(user, jobId, taskId, cleanup);
                TaskController.DeletionContext item = new TaskController.DeletionContext(TaskTracker.this.taskController, false, user, taskDir.substring(userDirLen));
                TaskTracker.this.directoryCleanupThread.addToQueue(item);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof TaskInProgress && this.task.getTaskID().equals(((TaskInProgress)obj).getTask().getTaskID());
        }

        public int hashCode() {
            return this.task.getTaskID().hashCode();
        }
    }

    class TaskLauncher
    extends Thread {
        private IntWritable numFreeSlots;
        private final int maxSlots;
        private List<TaskInProgress> tasksToLaunch;

        public TaskLauncher(TaskType taskType, int numSlots) {
            this.maxSlots = numSlots;
            this.numFreeSlots = new IntWritable(numSlots);
            this.tasksToLaunch = new LinkedList<TaskInProgress>();
            this.setDaemon(true);
            this.setName("TaskLauncher for " + (Object)((Object)taskType) + " tasks");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToTaskQueue(LaunchTaskAction action) {
            List<TaskInProgress> list = this.tasksToLaunch;
            synchronized (list) {
                TaskInProgress tip = TaskTracker.this.registerTask(action, this);
                this.tasksToLaunch.add(tip);
                this.tasksToLaunch.notifyAll();
            }
        }

        public void cleanTaskQueue() {
            this.tasksToLaunch.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFreeSlots(int numSlots) {
            IntWritable intWritable = this.numFreeSlots;
            synchronized (intWritable) {
                this.numFreeSlots.set(this.numFreeSlots.get() + numSlots);
                assert (this.numFreeSlots.get() <= this.maxSlots);
                LOG.info((Object)("addFreeSlot : current free slots : " + this.numFreeSlots.get()));
                this.numFreeSlots.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifySlots() {
            IntWritable intWritable = this.numFreeSlots;
            synchronized (intWritable) {
                this.numFreeSlots.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getNumWaitingTasksToLaunch() {
            List<TaskInProgress> list = this.tasksToLaunch;
            synchronized (list) {
                return this.tasksToLaunch.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Task task;
                    TaskInProgress tip;
                    Object object = this.tasksToLaunch;
                    synchronized (object) {
                        while (this.tasksToLaunch.isEmpty()) {
                            this.tasksToLaunch.wait();
                        }
                        tip = this.tasksToLaunch.remove(0);
                        task = tip.getTask();
                        LOG.info((Object)("Trying to launch : " + tip.getTask().getTaskID() + " which needs " + task.getNumSlotsRequired() + " slots"));
                    }
                    object = this.numFreeSlots;
                    synchronized (object) {
                        boolean canLaunch = true;
                        while (this.numFreeSlots.get() < task.getNumSlotsRequired()) {
                            if (!tip.canBeLaunched()) {
                                LOG.info((Object)("Not blocking slots for " + task.getTaskID() + " as it got killed externally. Task's state is " + (Object)((Object)tip.getRunState())));
                                canLaunch = false;
                                break;
                            }
                            LOG.info((Object)("TaskLauncher : Waiting for " + task.getNumSlotsRequired() + " to launch " + task.getTaskID() + ", currently we have " + this.numFreeSlots.get() + " free slots"));
                            this.numFreeSlots.wait();
                        }
                        if (!canLaunch) {
                            continue;
                        }
                        LOG.info((Object)("In TaskLauncher, current free slots : " + this.numFreeSlots.get() + " and trying to launch " + tip.getTask().getTaskID() + " which needs " + task.getNumSlotsRequired() + " slots"));
                        this.numFreeSlots.set(this.numFreeSlots.get() - task.getNumSlotsRequired());
                        assert (this.numFreeSlots.get() >= 0);
                    }
                    object = tip;
                    synchronized (object) {
                        if (!tip.canBeLaunched()) {
                            LOG.info((Object)("Not launching task " + task.getTaskID() + " as it got" + " killed externally. Task's state is " + (Object)((Object)tip.getRunState())));
                            this.addFreeSlots(task.getNumSlotsRequired());
                            continue;
                        }
                        tip.slotTaken = true;
                    }
                    TaskTracker.this.startNewTask(tip);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable th) {
                    LOG.error((Object)("TaskLauncher error " + StringUtils.stringifyException((Throwable)th)));
                }
            }
        }
    }

    private class FetchStatus {
        private IntWritable fromEventId = new IntWritable(0);
        private List<TaskCompletionEvent> allMapEvents;
        private JobID jobId;
        private long lastFetchTime;
        private boolean fetchAgain;

        public FetchStatus(JobID jobId, int numMaps) {
            this.jobId = jobId;
            this.allMapEvents = new ArrayList<TaskCompletionEvent>(numMaps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.fromEventId.set(0);
                    this.allMapEvents.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskCompletionEvent[] getMapEvents(int fromId, int max) {
            TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
            boolean notifyFetcher = false;
            Object object = this.allMapEvents;
            synchronized (object) {
                if (this.allMapEvents.size() > fromId) {
                    int actualMax = Math.min(max, this.allMapEvents.size() - fromId);
                    List<TaskCompletionEvent> eventSublist = this.allMapEvents.subList(fromId, actualMax + fromId);
                    mapEvents = eventSublist.toArray(mapEvents);
                } else {
                    notifyFetcher = true;
                }
            }
            if (notifyFetcher) {
                object = TaskTracker.this.waitingOn;
                synchronized (object) {
                    TaskTracker.this.waitingOn.notify();
                }
            }
            return mapEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchMapCompletionEvents(long currTime) throws IOException {
            if (!this.fetchAgain && currTime - this.lastFetchTime < (long)TaskTracker.this.heartbeatInterval) {
                return false;
            }
            int currFromEventId = 0;
            IntWritable intWritable = this.fromEventId;
            synchronized (intWritable) {
                currFromEventId = this.fromEventId.get();
                List recentMapEvents = TaskTracker.this.queryJobTracker(this.fromEventId, this.jobId, TaskTracker.this.jobClient);
                List<TaskCompletionEvent> list = this.allMapEvents;
                synchronized (list) {
                    this.allMapEvents.addAll(recentMapEvents);
                }
                this.lastFetchTime = currTime;
                if (this.fromEventId.get() - currFromEventId >= TaskTracker.this.probe_sample_size) {
                    this.fetchAgain = true;
                    return true;
                }
            }
            this.fetchAgain = false;
            return false;
        }
    }

    private class MapEventsFetcherThread
    extends Thread {
        private MapEventsFetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FetchStatus> reducesInShuffle() {
            ArrayList<FetchStatus> fList = new ArrayList<FetchStatus>();
            for (Map.Entry<JobID, RunningJob> item : TaskTracker.this.runningJobs.entrySet()) {
                RunningJob rjob = item.getValue();
                if (!rjob.localized) continue;
                JobID jobId = item.getKey();
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    for (TaskInProgress tip : rjob.tasks) {
                        Task task = tip.getTask();
                        if (task.isMapTask() || ((ReduceTask)task).getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                        if (rjob.getFetchStatus() == null) {
                            f = new FetchStatus(jobId, ((ReduceTask)task).getNumMaps());
                            rjob.setFetchStatus(f);
                        }
                        f = rjob.getFetchStatus();
                        fList.add(f);
                        break;
                    }
                }
            }
            return fList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)("Starting thread: " + this.getName()));
            while (TaskTracker.this.running) {
                try {
                    List<FetchStatus> fList = null;
                    Map<JobID, RunningJob> map = TaskTracker.this.runningJobs;
                    synchronized (map) {
                        while ((fList = this.reducesInShuffle()).size() == 0) {
                            try {
                                TaskTracker.this.runningJobs.wait();
                            }
                            catch (InterruptedException e) {
                                LOG.info((Object)("Shutting down: " + this.getName()));
                                return;
                            }
                        }
                    }
                    boolean fetchAgain = false;
                    for (FetchStatus f : fList) {
                        long currentTime = System.currentTimeMillis();
                        try {
                            if (f.fetchMapCompletionEvents(currentTime)) {
                                fetchAgain = true;
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Ignoring exception that fetch for map completion events threw for " + f.jobId + " threw: " + StringUtils.stringifyException((Throwable)e)));
                        }
                        if (TaskTracker.this.running) continue;
                        break;
                    }
                    Object object = TaskTracker.this.waitingOn;
                    synchronized (object) {
                        try {
                            if (!fetchAgain) {
                                TaskTracker.this.waitingOn.wait(TaskTracker.this.heartbeatInterval);
                            }
                        }
                        catch (InterruptedException ie) {
                            LOG.info((Object)("Shutting down: " + this.getName()));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Ignoring exception " + e.getMessage()));
                }
            }
        }
    }

    class ShuffleServerMetrics
    implements Updater {
        private MetricsRecord shuffleMetricsRecord = null;
        private int serverHandlerBusy = 0;
        private long outputBytes = 0L;
        private int failedOutputs = 0;
        private int successOutputs = 0;
        private int exceptionsCaught = 0;

        ShuffleServerMetrics(JobConf conf) {
            MetricsContext context = MetricsUtil.getContext((String)"mapred");
            this.shuffleMetricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"shuffleOutput");
            this.shuffleMetricsRecord.setTag("sessionId", conf.getSessionId());
            context.registerUpdater((Updater)this);
        }

        synchronized void serverHandlerBusy() {
            ++this.serverHandlerBusy;
        }

        synchronized void serverHandlerFree() {
            --this.serverHandlerBusy;
        }

        synchronized void outputBytes(long bytes) {
            this.outputBytes += bytes;
        }

        synchronized void failedOutput() {
            ++this.failedOutputs;
        }

        synchronized void successOutput() {
            ++this.successOutputs;
        }

        synchronized void exceptionsCaught() {
            ++this.exceptionsCaught;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            ShuffleServerMetrics shuffleServerMetrics = this;
            synchronized (shuffleServerMetrics) {
                if (TaskTracker.this.workerThreads != 0) {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 100.0f * ((float)this.serverHandlerBusy / (float)TaskTracker.this.workerThreads));
                } else {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 0);
                }
                this.shuffleMetricsRecord.incrMetric("shuffle_output_bytes", this.outputBytes);
                this.shuffleMetricsRecord.incrMetric("shuffle_failed_outputs", this.failedOutputs);
                this.shuffleMetricsRecord.incrMetric("shuffle_success_outputs", this.successOutputs);
                this.shuffleMetricsRecord.incrMetric("shuffle_exceptions_caught", this.exceptionsCaught);
                this.outputBytes = 0L;
                this.failedOutputs = 0;
                this.successOutputs = 0;
                this.exceptionsCaught = 0;
            }
            this.shuffleMetricsRecord.update();
        }
    }

    static class LocalStorage {
        private List<String> localDirs = new ArrayList<String>();
        private int numFailures;

        public LocalStorage(String[] dirs) {
            this.localDirs.addAll(Arrays.asList(dirs));
        }

        synchronized int numDirs() {
            return this.localDirs.size();
        }

        synchronized String[] getDirs() {
            return this.localDirs.toArray(new String[this.localDirs.size()]);
        }

        synchronized String getDirsString() {
            return StringUtils.join((CharSequence)",", this.localDirs);
        }

        synchronized int numFailures() {
            return this.numFailures;
        }

        synchronized void checkDirs(LocalFileSystem fs, boolean checkAndFixPermissions) throws DiskChecker.DiskErrorException {
            ListIterator<String> it = this.localDirs.listIterator();
            while (it.hasNext()) {
                String path = it.next();
                try {
                    File dir = new File(path);
                    if (checkAndFixPermissions) {
                        DiskChecker.checkDir((LocalFileSystem)fs, (Path)new Path(path), (FsPermission)LOCAL_DIR_PERMISSION);
                        if (!dir.canRead()) {
                            throw new DiskChecker.DiskErrorException("Dir is not readable: " + path);
                        }
                        if (dir.canWrite()) continue;
                        throw new DiskChecker.DiskErrorException("Dir is not writable: " + path);
                    }
                    DiskChecker.checkDir((File)dir);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("TaskTracker local dir " + path + " error " + ioe.getMessage() + ", removing from local dirs"));
                    it.remove();
                    ++this.numFailures;
                }
            }
            if (this.localDirs.isEmpty()) {
                throw new DiskChecker.DiskErrorException("No mapred local directories are writable");
            }
        }
    }

    static enum State {
        NORMAL,
        STALE,
        INTERRUPTED,
        DENIED;

    }
}

