/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.CommitTaskAction;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.ReinitTrackerAction;

abstract class TaskTrackerAction
implements Writable {
    private ActionType actionType;

    public static TaskTrackerAction createAction(ActionType actionType) {
        TaskTrackerAction action = null;
        switch (actionType) {
            case LAUNCH_TASK: {
                action = new LaunchTaskAction();
                break;
            }
            case KILL_TASK: {
                action = new KillTaskAction();
                break;
            }
            case KILL_JOB: {
                action = new KillJobAction();
                break;
            }
            case REINIT_TRACKER: {
                action = new ReinitTrackerAction();
                break;
            }
            case COMMIT_TASK: {
                action = new CommitTaskAction();
            }
        }
        return action;
    }

    protected TaskTrackerAction(ActionType actionType) {
        this.actionType = actionType;
    }

    ActionType getActionId() {
        return this.actionType;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.actionType);
    }

    public void readFields(DataInput in) throws IOException {
        this.actionType = (ActionType)WritableUtils.readEnum((DataInput)in, ActionType.class);
    }

    public static enum ActionType {
        LAUNCH_TASK,
        KILL_TASK,
        KILL_JOB,
        REINIT_TRACKER,
        COMMIT_TASK;

    }
}

