/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.LineReader;

public class NLineInputFormat
extends FileInputFormat<LongWritable, Text>
implements JobConfigurable {
    private int N = 1;

    @Override
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit genericSplit, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(genericSplit.toString());
        return new LineRecordReader(job, (FileSplit)genericSplit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (FileStatus status : this.listStatus(job)) {
            Path fileName = status.getPath();
            if (status.isDir()) {
                throw new IOException("Not a file: " + fileName);
            }
            FileSystem fs = fileName.getFileSystem((Configuration)job);
            LineReader lr = null;
            try {
                FSDataInputStream in = fs.open(fileName);
                lr = new LineReader((InputStream)in, (Configuration)job);
                Text line = new Text();
                int numLines = 0;
                long begin = 0L;
                long length = 0L;
                int num = -1;
                while ((num = lr.readLine(line)) > 0) {
                    length += (long)num;
                    if (++numLines != this.N) continue;
                    splits.add(new FileSplit(fileName, begin, length, new String[0]));
                    begin += length;
                    length = 0L;
                    numLines = 0;
                }
                if (numLines == 0) continue;
                splits.add(new FileSplit(fileName, begin, length, new String[0]));
            }
            finally {
                if (lr != null) {
                    lr.close();
                }
            }
        }
        return splits.toArray(new FileSplit[splits.size()]);
    }

    @Override
    public void configure(JobConf conf) {
        this.N = conf.getInt("mapred.line.input.format.linespermap", 1);
    }
}

