/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.StringUtils;

public class ControlledJob {
    private State state;
    private String controlID;
    private Job job;
    private String message;
    private ArrayList<ControlledJob> dependingJobs;

    public ControlledJob(Job job, ArrayList<ControlledJob> dependingJobs) throws IOException {
        this.job = job;
        this.dependingJobs = dependingJobs;
        this.state = State.WAITING;
        this.controlID = "unassigned";
        this.message = "just initialized";
    }

    public ControlledJob(Configuration conf) throws IOException {
        this(new Job(conf), null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("job name:\t").append(this.job.getJobName()).append("\n");
        sb.append("job id:\t").append(this.controlID).append("\n");
        sb.append("job state:\t").append((Object)this.state).append("\n");
        sb.append("job mapred id:\t").append(this.job.getJobID()).append("\n");
        sb.append("job message:\t").append(this.message).append("\n");
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            sb.append("job has no depending job:\t").append("\n");
        } else {
            sb.append("job has ").append(this.dependingJobs.size()).append(" dependeng jobs:\n");
            for (int i = 0; i < this.dependingJobs.size(); ++i) {
                sb.append("\t depending job ").append(i).append(":\t");
                sb.append(this.dependingJobs.get(i).getJobName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String getJobName() {
        return this.job.getJobName();
    }

    public void setJobName(String jobName) {
        this.job.setJobName(jobName);
    }

    public String getJobID() {
        return this.controlID;
    }

    public void setJobID(String id) {
        this.controlID = id;
    }

    public JobID getMapredJobID() {
        return this.job.getJobID();
    }

    public synchronized Job getJob() {
        return this.job;
    }

    public synchronized void setJob(Job job) {
        this.job = job;
    }

    public synchronized State getJobState() {
        return this.state;
    }

    protected synchronized void setJobState(State state) {
        this.state = state;
    }

    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized void setMessage(String message) {
        this.message = message;
    }

    public ArrayList<ControlledJob> getDependentJobs() {
        return this.dependingJobs;
    }

    public synchronized boolean addDependingJob(ControlledJob dependingJob) {
        if (this.state == State.WAITING) {
            if (this.dependingJobs == null) {
                this.dependingJobs = new ArrayList();
            }
            return this.dependingJobs.add(dependingJob);
        }
        return false;
    }

    public synchronized boolean isCompleted() {
        return this.state == State.FAILED || this.state == State.DEPENDENT_FAILED || this.state == State.SUCCESS;
    }

    public synchronized boolean isReady() {
        return this.state == State.READY;
    }

    public void killJob() throws IOException {
        this.job.killJob();
    }

    private void checkRunningState() {
        try {
            if (this.job.isComplete()) {
                if (this.job.isSuccessful()) {
                    this.state = State.SUCCESS;
                } else {
                    this.state = State.FAILED;
                    this.message = "Job failed!";
                }
            }
        }
        catch (IOException ioe) {
            this.state = State.FAILED;
            this.message = StringUtils.stringifyException((Throwable)ioe);
            try {
                if (this.job != null) {
                    this.job.killJob();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    synchronized State checkState() {
        State s;
        if (this.state == State.RUNNING) {
            this.checkRunningState();
        }
        if (this.state != State.WAITING) {
            return this.state;
        }
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            this.state = State.READY;
            return this.state;
        }
        ControlledJob pred = null;
        int n = this.dependingJobs.size();
        for (int i = 0; i < n && (s = (pred = this.dependingJobs.get(i)).checkState()) != State.WAITING && s != State.READY && s != State.RUNNING; ++i) {
            if (s == State.FAILED || s == State.DEPENDENT_FAILED) {
                this.state = State.DEPENDENT_FAILED;
                this.message = "depending job " + i + " with jobID " + pred.getJobID() + " failed. " + pred.getMessage();
                break;
            }
            if (i != n - 1) continue;
            this.state = State.READY;
        }
        return this.state;
    }

    protected synchronized void submit() {
        try {
            Configuration conf = this.job.getConfiguration();
            if (conf.getBoolean("create.empty.dir.if.nonexist", false)) {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path[] inputPaths = FileInputFormat.getInputPaths(this.job);
                for (int i = 0; i < inputPaths.length; ++i) {
                    if (fs.exists(inputPaths[i])) continue;
                    try {
                        fs.mkdirs(inputPaths[i]);
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            this.job.submit();
            this.state = State.RUNNING;
        }
        catch (Exception ioe) {
            this.state = State.FAILED;
            this.message = StringUtils.stringifyException((Throwable)ioe);
        }
    }

    public static enum State {
        SUCCESS,
        WAITING,
        RUNNING,
        READY,
        FAILED,
        DEPENDENT_FAILED;

    }
}

