/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    static final String MAPREDUCE_JOB_CREDENTIALS_BINARY = "mapreduce.job.credentials.binary";
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN = new Text("ShuffleAndJobToken");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(credentials, ps, conf);
    }

    public static void cleanUpTokenReferral(Configuration conf) {
        conf.unset(MAPREDUCE_JOB_CREDENTIALS_BINARY);
    }

    static void obtainTokensForNamenodesInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        HadoopKerberosName jtKrbName = new HadoopKerberosName(conf.get("mapreduce.jobtracker.kerberos.principal", ""));
        String delegTokenRenewer = jtKrbName.getShortName();
        boolean readFile = true;
        for (Path p : ps) {
            Token token;
            List tokens;
            FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)conf);
            String fsName = fs.getCanonicalServiceName();
            if (TokenCache.getDelegationToken(credentials, fsName) != null) continue;
            if (readFile) {
                readFile = false;
                String binaryTokenFilename = conf.get(MAPREDUCE_JOB_CREDENTIALS_BINARY);
                if (binaryTokenFilename != null) {
                    Credentials binary;
                    try {
                        binary = Credentials.readTokenStorageFile((Path)new Path("file:///" + binaryTokenFilename), (Configuration)conf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    credentials.addAll(binary);
                }
                if (TokenCache.getDelegationToken(credentials, fsName) != null) {
                    LOG.debug((Object)("DT for " + fsName + " is already present"));
                    continue;
                }
            }
            if ((tokens = fs.getDelegationTokens(delegTokenRenewer, credentials)) != null) {
                for (Token token2 : tokens) {
                    credentials.addToken(token2.getService(), token2);
                    LOG.info((Object)("Got dt for " + fs.getUri() + ";uri=" + fsName + ";t.service=" + token2.getService()));
                }
            }
            if ((token = fs.getDelegationToken(delegTokenRenewer)) == null) continue;
            credentials.addToken(token.getService(), token);
            LOG.info((Object)("Got dt for " + p + ";uri=" + fsName + ";t.service=" + token.getService()));
        }
    }

    public static Token<DelegationTokenIdentifier> getDelegationToken(Credentials credentials, String namenode) {
        if (namenode == null) {
            return null;
        }
        return credentials.getToken(new Text(namenode));
    }

    public static Credentials loadTokens(String jobTokenFile, Configuration conf) throws IOException {
        Path localJobTokenFile = new Path("file:///" + jobTokenFile);
        Credentials ts = Credentials.readTokenStorageFile((Path)localJobTokenFile, (Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys() + " Number of tokens " + ts.numberOfTokens()));
        }
        return ts;
    }

    public static void setJobToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(JOB_TOKEN, t);
    }

    public static Token<JobTokenIdentifier> getJobToken(Credentials credentials) {
        return credentials.getToken(JOB_TOKEN);
    }
}

