/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.launcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.pentaho.commons.launcher.PropertyLookupParser;

public class Launcher {
    private static final String JAR_SUFFIX = ".jar";
    private static final String ZIP_SUFFIX = ".zip";
    private static boolean debug = false;
    private static JarFilter jarFilter;
    private static String mainClass;
    private static ArrayList libraries;
    private static ArrayList classpath;

    private Launcher() {
    }

    public static void main(String[] args) throws Exception {
        int i;
        jarFilter = new JarFilter();
        libraries = new ArrayList();
        classpath = new ArrayList();
        int parsedArgs = Launcher.parseParameters(args);
        URL location = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        File appDir = Launcher.computeApplicationDir(location, new File("."));
        File configurationFile = new File(appDir, "launcher.properties");
        Launcher.parseConfiguration(configurationFile, appDir);
        ArrayList<URL> jars = new ArrayList<URL>();
        for (i = 0; i < classpath.size(); ++i) {
            String path = (String)classpath.get(i);
            File file = new File(appDir, path);
            if (file.exists() && file.canRead()) {
                try {
                    jars.add(file.toURI().toURL());
                }
                catch (Exception e) {
                    System.err.println("Invalid classpath entry, ignoring '" + path + "'");
                }
                continue;
            }
            System.err.println("Invalid classpath entry, ignoring '" + path + "'");
        }
        for (i = 0; i < libraries.size(); ++i) {
            String library = (String)libraries.get(i);
            Launcher.addLibrary(appDir, library, jars);
        }
        URL[] classpathEntries = jars.toArray(new URL[jars.size()]);
        URLClassLoader cl = new URLClassLoader(classpathEntries);
        Thread.currentThread().setContextClassLoader(cl);
        if (mainClass == null) {
            System.err.println("Invalid main-class entry, cannot proceed.");
            System.err.println("Application Directory: " + appDir);
            System.exit(1);
        }
        if (debug) {
            System.out.println("Application Directory: " + appDir);
            for (int i2 = 0; i2 < classpathEntries.length; ++i2) {
                URL url = classpathEntries[i2];
                System.out.println("ClassPath[" + i2 + "] = " + url);
            }
        }
        Class<?> mainClass = cl.loadClass(Launcher.mainClass);
        String[] newArgs = new String[args.length - parsedArgs];
        System.arraycopy(args, parsedArgs, newArgs, 0, newArgs.length);
        Method method = mainClass.getMethod("main", String[].class);
        method.invoke(null, new Object[]{newArgs});
    }

    private static void addLibrary(File directory, String path, ArrayList list) {
        File realPath = new File(directory, path);
        File[] files = realPath.listFiles(jarFilter);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.exists() && file.canRead()) {
                try {
                    list.add(file.toURI().toURL());
                }
                catch (Exception e) {
                    System.err.println("Invalid classpath entry, ignoring '" + path + "'");
                }
                continue;
            }
            System.err.println("Invalid classpath entry, ignoring '" + path + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseConfiguration(File configuration, File applicationDirectory) {
        try {
            Properties p = new Properties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(configuration));
            try {
                p.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            if (mainClass == null) {
                mainClass = p.getProperty("main");
            }
            debug = "true".equals(p.getProperty("debug"));
            Launcher.parsePath(p.getProperty("libraries"), libraries, ":");
            Launcher.parsePath(p.getProperty("classpath"), classpath, ":");
            LookupParser parser = new LookupParser(applicationDirectory);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("system-property.")) continue;
                String propertyName = key.substring("system-property.".length());
                String propertyValue = p.getProperty(key);
                String translatedValue = parser.translateAndLookup(propertyValue);
                if (translatedValue == null || "".equals(translatedValue)) continue;
                System.setProperty(propertyName, translatedValue);
            }
            if ("true".equals(p.getProperty("uninstall-security-manager", "false"))) {
                System.setSecurityManager(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int parseParameters(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-main".equals(arg)) {
                if (++i == args.length) {
                    System.err.println("Argument parse error: '-main' needs an parameter");
                    System.exit(1);
                }
                mainClass = args[i];
                continue;
            }
            if ("-lib".equals(arg)) {
                if (++i == args.length) {
                    System.err.println("Argument parse error: '-lib' needs an parameter");
                    System.exit(1);
                }
                Launcher.parsePath(args[i], libraries, File.pathSeparator);
                continue;
            }
            if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                if (++i == args.length) {
                    System.err.println("Argument parse error: '-cp' needs an parameter");
                    System.exit(1);
                }
                Launcher.parsePath(args[i], classpath, File.pathSeparator);
                continue;
            }
            if ("--".equals(arg)) {
                return i + 1;
            }
            return i;
        }
        return args.length;
    }

    private static void parsePath(String path, ArrayList list, String separator) {
        if (path == null) {
            return;
        }
        StringTokenizer strtok = new StringTokenizer(path, separator);
        while (strtok.hasMoreTokens()) {
            list.add(strtok.nextToken());
        }
    }

    private static File computeApplicationDir(URL location, File defaultDir) {
        if (location == null) {
            System.err.println("Warning: Cannot locate the program directory. Assuming default.");
            return defaultDir;
        }
        if (!"file".equalsIgnoreCase(location.getProtocol())) {
            System.err.println("Warning: Unrecognized location type. Assuming default.");
            return new File(".");
        }
        String file = location.toExternalForm();
        if (Launcher.endsWithIgnoreCase(file, JAR_SUFFIX) || Launcher.endsWithIgnoreCase(file, ZIP_SUFFIX)) {
            try {
                return new File(location.toURI()).getParentFile();
            }
            catch (URISyntaxException e) {
                return new File(location.getFile());
            }
        }
        try {
            return new File(location.toURI()).getParentFile();
        }
        catch (URISyntaxException e) {
            return new File(location.getFile());
        }
    }

    public static boolean endsWithIgnoreCase(String base, String end) {
        if (base.length() < end.length()) {
            return false;
        }
        return base.regionMatches(true, base.length() - end.length(), end, 0, end.length());
    }

    private static class LookupParser
    extends PropertyLookupParser {
        private File applicationDirectory;

        private LookupParser(File applicationDirectory) {
            this.applicationDirectory = applicationDirectory;
        }

        protected String lookupVariable(String property) {
            if (property.equals("SYS:APP_DIR")) {
                return this.applicationDirectory.getAbsolutePath();
            }
            return System.getenv(property);
        }
    }

    private static class JarFilter
    implements FileFilter {
        private JarFilter() {
        }

        public boolean accept(File pathname) {
            String base = pathname.getName();
            return Launcher.endsWithIgnoreCase(base, Launcher.JAR_SUFFIX) || Launcher.endsWithIgnoreCase(base, Launcher.ZIP_SUFFIX);
        }
    }
}

