/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BugCheckException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public final class Array
implements java.sql.Array {
    Object data_ = null;
    long id_ = 0L;
    ArrayDescriptor descriptor_ = null;
    Connection connection_ = null;
    private static final BigDecimal bdMaxShortValue = new BigDecimal(32767.0);
    private static final BigDecimal bdMinShortValue = new BigDecimal(-32768.0);
    private static final BigDecimal bdMaxIntValue = new BigDecimal(2.147483647E9);
    private static final BigDecimal bdMinIntValue = new BigDecimal(-2.147483648E9);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(1.4E-45f);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(Double.MIN_VALUE);
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    Array(Object object) throws SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 131);
        }
        this.data_ = object;
    }

    Array(Object object, ArrayDescriptor arrayDescriptor) throws SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 132);
        }
        this.setDescriptor(arrayDescriptor);
        this.data_ = object;
    }

    Array(long l, ArrayDescriptor arrayDescriptor, Connection connection) throws SQLException {
        this.setDescriptor(arrayDescriptor);
        this.id_ = l;
        this.connection_ = connection;
    }

    void setDescriptor(ArrayDescriptor arrayDescriptor) throws SQLException {
        if (arrayDescriptor == null) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 133);
        }
        if (this.data_ != null) {
            this.checkDimensions(this.data_, arrayDescriptor, 0);
        }
        this.descriptor_ = arrayDescriptor;
    }

    private void checkDimensions(Object object, ArrayDescriptor arrayDescriptor, int n) throws SQLException {
        if (object == null) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        int n2 = java.lang.reflect.Array.getLength(object);
        if (arrayDescriptor.dimensionBounds_[n][1] - arrayDescriptor.dimensionBounds_[n][0] + 1 != n2) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        if (object.getClass().getComponentType().isArray()) {
            if (++n >= arrayDescriptor.dimensions_) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
            }
            int n3 = 0;
            while (n3 < n2) {
                this.checkDimensions(java.lang.reflect.Array.get(object, n3), arrayDescriptor, n);
                ++n3;
            }
        } else if (n != arrayDescriptor.dimensions_ - 1) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
    }

    void putArraySlice() throws SQLException {
        long l = this.descriptor_.dimensionBounds_[0][1] - this.descriptor_.dimensionBounds_[0][0] + 1;
        int n = 1;
        while (n < this.descriptor_.dimensions_) {
            l *= (long)(this.descriptor_.dimensionBounds_[n][1] - this.descriptor_.dimensionBounds_[n][0] + 1);
            ++n;
        }
        l *= (long)this.descriptor_.elementLength_;
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    private Object remote_GET_ARRAY_SLICE(int[][] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    private Object createJavaArray(int[][] nArray) throws SQLException {
        Class clazz = null;
        int[] nArray2 = new int[this.descriptor_.dimensions_];
        int n = 0;
        while (n < this.descriptor_.dimensions_) {
            nArray2[n] = nArray[n][1] - nArray[n][0] + 1;
            ++n;
        }
        switch (this.descriptor_.elementDataType_) {
            case 1: {
                clazz = Short.TYPE;
                break;
            }
            case 2: {
                clazz = Integer.TYPE;
                break;
            }
            case 3: {
                clazz = Float.TYPE;
                break;
            }
            case 4: {
                clazz = Double.TYPE;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                clazz = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Array.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                break;
            }
            case 8: 
            case 9: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = Array.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 11: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Array.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            default: {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 135);
            }
        }
        return java.lang.reflect.Array.newInstance(clazz, nArray2);
    }

    public synchronized String getBaseTypeName() throws SQLException {
        return IBTypes.getIBTypeName(this.descriptor_.elementDataType_);
    }

    public synchronized int getBaseType() throws SQLException {
        return IBTypes.getSQLType(this.descriptor_.elementDataType_);
    }

    public synchronized Object getArray() throws SQLException {
        if (this.data_ != null) {
            return this.data_;
        }
        this.data_ = this.remote_GET_ARRAY_SLICE(this.descriptor_.dimensionBounds_);
        this.connection_.transactionStartedOnServer_ = true;
        return this.data_;
    }

    public synchronized Object getArray(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(long l, int n) throws SQLException {
        int[][] nArray = this.descriptor_.getDimensions();
        nArray[0][0] = (int)l;
        nArray[0][1] = (int)(l + (long)n - 1L);
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(int[][] nArray) throws SQLException {
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized ResultSet getResultSet(int[][] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

