/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BlobIOException;
import interbase.interclient.BugCheckException;
import interbase.interclient.ByteToUnicodeConverterStream;
import interbase.interclient.CharacterEncodingException;
import interbase.interclient.CommunicationException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.IBException;
import interbase.interclient.IscBlobHandle;
import interbase.interclient.Statement;
import interbase.interclient.Utils;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import sun.io.ByteToCharConverter;

class BlobOutput {
    InputStreamReader reader_ = null;
    private long blobId_;
    private Statement statement_;
    int actualSegmentSize_;
    boolean lastSegment_ = false;
    int blobRef_;
    ByteToCharConverter btc_;
    String encoding_;
    IscBlobHandle blobHandle_;
    IBBlobInputStream ibBlobInputStream_ = null;
    int bufferlength = 16384;
    private IBException sqlWarnings_;

    BlobOutput(Statement statement, long l, ByteToCharConverter byteToCharConverter) throws SQLException {
        this.statement_ = statement;
        this.blobId_ = l;
        this.btc_ = byteToCharConverter;
        this.encoding_ = this.btc_.getCharacterEncoding();
        this.remote_OPEN_BLOB();
        try {
            this.reader_ = new InputStreamReader((InputStream)this.ibBlobInputStream_, this.encoding_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 129);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    void close() throws SQLException {
        try {
            this.ibBlobInputStream_.close();
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_blob_close_01__, "server", Utils.getMessage(iOException));
        }
    }

    void remote_OPEN_BLOB() throws SQLException {
        try {
            try {
                this.blobHandle_ = this.statement_.connection_.ibase_.getNewIscBlobHandle();
                this.blobHandle_.setBlobId(this.blobId_);
                this.statement_.connection_.ibase_.iscOpenBlob2(this.statement_.connection_.db_, this.statement_.connection_.tra_, this.blobHandle_, null, this.sqlWarnings_);
                this.ibBlobInputStream_ = new IBBlobInputStream();
            }
            catch (IBException iBException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_blob_read_01__, "server", Utils.getMessage(iBException));
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            throw throwable;
        }
    }

    InputStream getInputStream() {
        return this.ibBlobInputStream_;
    }

    InputStream getUnicodeInputStream() {
        return new ByteToUnicodeConverterStream(this.ibBlobInputStream_, this.reader_);
    }

    byte[] getBytes() throws SQLException, IOException {
        int n = this.ibBlobInputStream_.available();
        byte[] byArray = new byte[n];
        this.getBytes(byArray, 0, n);
        return byArray;
    }

    private void getBytes(byte[] byArray, int n, int n2) throws SQLException {
        try {
            int n3 = 0;
            while (n3 < n2) {
                n3 += this.ibBlobInputStream_.read(byArray, n + n3, n2 - n3);
            }
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_blob_read_01__, "server", Utils.getMessage(iOException));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 130);
        }
    }

    String getString() throws SQLException, IOException {
        int n = this.ibBlobInputStream_.available();
        if (n > 0) {
            String string;
            char[] cArray = Globals.cache__.takeCharBuffer(n);
            byte[] byArray = Globals.cache__.takeBuffer(n);
            this.getBytes(byArray, 0, n);
            try {
                int n2 = this.statement_.connection_.btc_.convert(byArray, 0, n, cArray, 0, n);
                int n3 = this.statement_.maxFieldSize_ == 0 ? n2 : Math.min(n2, this.statement_.maxFieldSize_);
                string = new String(cArray, 0, n3);
            }
            catch (CharConversionException charConversionException) {
                try {
                    throw new CharacterEncodingException(ErrorKey.characterEncoding__read_0__, Utils.getMessage(charConversionException));
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    Globals.cache__.returnCharBuffer(cArray);
                    Globals.cache__.returnBuffer(byArray);
                    throw throwable;
                }
            }
            Object var8_8 = null;
            Globals.cache__.returnCharBuffer(cArray);
            Globals.cache__.returnBuffer(byArray);
            return string;
        }
        return null;
    }

    public class IBBlobInputStream
    extends InputStream {
        private byte[] buffer = null;
        private int pos = 0;

        private IBBlobInputStream() {
        }

        public int available() throws IOException {
            if (this.buffer == null) {
                if (BlobOutput.this.blobHandle_.isEof()) {
                    return -1;
                }
                try {
                    this.buffer = ((BlobOutput)BlobOutput.this).statement_.connection_.ibase_.iscGetSegment(BlobOutput.this.blobHandle_, BlobOutput.this.bufferlength, BlobOutput.this.sqlWarnings_);
                }
                catch (SQLException sQLException) {
                    throw new BlobIOException("62", Utils.getMessage(sQLException));
                }
                this.pos = 0;
                if (this.buffer.length == 0) {
                    return -1;
                }
            }
            return this.buffer.length - this.pos;
        }

        public int read() throws IOException {
            if (this.available() <= 0) {
                return -1;
            }
            int n = this.buffer[this.pos++] & 0xFF;
            if (this.pos == this.buffer.length) {
                this.buffer = null;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.available();
            if (n3 <= 0) {
                return -1;
            }
            if (n3 > n2) {
                System.arraycopy(this.buffer, this.pos, byArray, n, n2);
                this.pos += n2;
                return n2;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n, n3);
            this.buffer = null;
            this.pos = 0;
            return n3;
        }

        public void close() throws IOException {
            if (BlobOutput.this.blobHandle_ != null) {
                try {
                    ((BlobOutput)BlobOutput.this).statement_.connection_.ibase_.iscCloseBlob(BlobOutput.this.blobHandle_, BlobOutput.this.sqlWarnings_);
                }
                catch (SQLException sQLException) {
                    throw new BlobIOException("63", Utils.getMessage(sQLException));
                }
                BlobOutput.this.blobHandle_ = null;
            }
        }
    }
}

