/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ConnectionPoolObject;
import interbase.interclient.DelegateXAConnection;
import interbase.interclient.SQLException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class ConnectionPoolModule
implements DataSource,
XADataSource,
ConnectionEventListener,
Referenceable,
Serializable {
    private ConnectionPoolDataSource cpds = null;
    private String user_ = null;
    private String password_ = null;
    private String factoryName_;
    private transient PoolItem usedList_;
    private transient PoolItem pooledList_;
    private int maxPoolCount_;
    private int minPoolCount_;
    private int maxCount_;
    private transient int poolCount;
    private transient int totalCount;
    transient PrintWriter logWriter_;
    private int timeout_;
    private int waitCount_;

    public Connection getConnection() throws java.sql.SQLException {
        return this.getPooledConnection().getConnection();
    }

    public Connection getConnection(String string, String string2) throws java.sql.SQLException {
        return this.getPooledConnection(string, string2).getConnection();
    }

    private final PooledConnection getPooledConnection() throws java.sql.SQLException {
        return this.getPooledConnection(this.user_, this.password_);
    }

    public synchronized PrintWriter getLogWriter() throws java.sql.SQLException {
        return this.logWriter_;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws java.sql.SQLException {
        this.logWriter_ = printWriter;
    }

    public synchronized void setLoginTimeout(int n) throws java.sql.SQLException {
        this.timeout_ = n;
    }

    public synchronized int getLoginTimeout() throws java.sql.SQLException {
        return this.timeout_;
    }

    public Reference getReference() throws NamingException {
        return new ConnectionPoolObject().getReference(this);
    }

    public XAConnection getXAConnection() throws java.sql.SQLException {
        XAConnection xAConnection = (XAConnection)this.getPooledConnection();
        return new DelegateXAConnection(xAConnection);
    }

    public XAConnection getXAConnection(String string, String string2) throws java.sql.SQLException {
        XAConnection xAConnection = (XAConnection)this.getPooledConnection(string, string2);
        return new DelegateXAConnection(xAConnection);
    }

    private final synchronized PooledConnection getPooledConnection(String string, String string2) throws java.sql.SQLException {
        Object object;
        Object var4_3 = null;
        PoolItem poolItem = this.removeFromPooled(string);
        if (poolItem != null) {
            if (this.logWriter_ != null || DriverManager.getLogWriter() != null) {
                this.println(poolItem.con, "getPooledConnection(" + string + ",***) <from pool>");
            }
            this.addToUsed(poolItem);
            return poolItem.con;
        }
        if (this.maxCount_ != 0 && this.totalCount >= this.maxCount_) {
            ++this.waitCount_;
            try {
                if (this.timeout_ == 0) {
                    this.wait();
                } else {
                    this.wait(this.timeout_);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.waitCount_;
            if (this.totalCount >= this.maxCount_) {
                throw new java.sql.SQLException("Too many connections");
            }
        }
        ++this.totalCount;
        if (this.cpds == null) {
            if (this.factoryName_ != null) {
                try {
                    object = new InitialContext();
                    this.cpds = (ConnectionPoolDataSource)object.lookup(this.factoryName_);
                }
                catch (NamingException namingException) {
                    throw new java.sql.SQLException(namingException.getMessage());
                }
            } else {
                throw new java.sql.SQLException("Factory not set");
            }
        }
        if ((object = this.cpds.getPooledConnection(string, string2)) != null) {
            object.addConnectionEventListener(this);
            poolItem = new PoolItem((PooledConnection)object, string);
            if (this.logWriter_ != null || DriverManager.getLogWriter() != null) {
                this.println(poolItem.con, "getPooledConnection(" + string + ",***) <created>");
            }
            this.addToUsed(poolItem);
            return object;
        }
        throw new java.sql.SQLException("pooled connection error, this should be exception");
    }

    final void println(Object object, String string) {
        if (this.logWriter_ != null) {
            this.logWriter_.println(string);
        }
        DriverManager.println(string);
    }

    public final void setUser(String string) {
        this.user_ = string;
    }

    public final String getUser() {
        return this.user_;
    }

    public final void setPassword(String string) {
        this.password_ = string;
    }

    public final String getPassword() {
        return this.password_;
    }

    public final void setMinPool(int n) {
        this.minPoolCount_ = n;
    }

    public int getMinPool() {
        return this.minPoolCount_;
    }

    public final void setMaxPool(int n) {
        this.maxPoolCount_ = n;
    }

    public int getMaxPool() {
        return this.maxPoolCount_;
    }

    public final void setMaxConnections(int n) {
        this.maxCount_ = n;
    }

    public int getMaxConnections() {
        return this.maxCount_;
    }

    public final void setConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource) throws SQLException {
        this.cpds = connectionPoolDataSource;
    }

    public final ConnectionPoolDataSource getConnectionFactory() {
        return this.cpds;
    }

    public void setDataSourceName(String string) {
        this.factoryName_ = string;
    }

    public String getDataSourceName() {
        return this.factoryName_;
    }

    public final synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        PoolItem poolItem = this.removeFromUsed(connectionEvent.getSource());
        if (poolItem != null) {
            try {
                this.addToPooled(poolItem);
            }
            catch (java.sql.SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage());
            }
            if (this.waitCount_ > 0) {
                this.notify();
            }
        }
    }

    public final void connectionErrorOccurred(ConnectionEvent connectionEvent) {
    }

    public final synchronized void shutdown() throws java.sql.SQLException {
        this.shutdown(this.usedList_);
        this.usedList_ = null;
        this.shutdown(this.pooledList_);
        this.pooledList_ = null;
        this.poolCount = 0;
    }

    private final void shutdown(PoolItem poolItem) throws java.sql.SQLException {
        while (poolItem != null) {
            poolItem.con.close();
            poolItem = poolItem.next;
            --this.totalCount;
        }
    }

    private final void shrink() throws java.sql.SQLException {
        if (this.minPoolCount_ > 0 && this.minPoolCount_ < this.maxPoolCount_) {
            while (this.poolCount > this.minPoolCount_) {
                if (this.pooledList_ == null) break;
                this.pooledList_.con.close();
                this.pooledList_ = this.pooledList_.next;
                --this.totalCount;
                --this.poolCount;
            }
        }
    }

    private final void addToPooled(PoolItem poolItem) throws java.sql.SQLException {
        if (this.poolCount < this.maxPoolCount_ || this.maxPoolCount_ == 0) {
            this.pooledList_ = this.add(this.pooledList_, poolItem);
            ++this.poolCount;
        } else {
            poolItem.con.close();
            --this.totalCount;
            this.shrink();
        }
    }

    private final void addToUsed(PoolItem poolItem) {
        this.usedList_ = this.add(this.usedList_, poolItem);
    }

    private final PoolItem add(PoolItem poolItem, PoolItem poolItem2) {
        poolItem2.next = poolItem;
        return poolItem2;
    }

    private final PoolItem removeFromPooled(String string) {
        PoolItem poolItem = this.removeFromPooled(string, true);
        if (poolItem == null) {
            poolItem = this.removeFromPooled(string, false);
        }
        if (poolItem != null) {
            --this.poolCount;
        }
        return poolItem;
    }

    private final PoolItem removeFromPooled(String string, boolean bl) {
        PoolItem poolItem = this.pooledList_;
        PoolItem poolItem2 = this.pooledList_;
        while (poolItem != null) {
            if (bl && poolItem.name == string || !bl && poolItem.name.equals(string)) {
                if (poolItem == this.pooledList_) {
                    this.pooledList_ = poolItem.next;
                } else {
                    poolItem2.next = poolItem.next;
                }
                poolItem.next = null;
                return poolItem;
            }
            poolItem2 = poolItem;
            poolItem = poolItem.next;
        }
        return null;
    }

    private final PoolItem removeFromUsed(Object object) {
        PoolItem poolItem = this.usedList_;
        PoolItem poolItem2 = this.usedList_;
        poolItem = this.usedList_;
        while (poolItem != null) {
            if (poolItem.con == object) {
                if (poolItem == this.usedList_) {
                    this.usedList_ = poolItem.next;
                } else {
                    poolItem2.next = poolItem.next;
                }
                poolItem.next = null;
                return poolItem;
            }
            poolItem2 = poolItem;
            poolItem = poolItem.next;
        }
        return null;
    }

    class PoolItem {
        PooledConnection con;
        String name;
        PoolItem next;

        PoolItem(PooledConnection pooledConnection, String string) {
            this.con = pooledConnection;
            this.name = string;
        }
    }
}

