/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class DelegateXAConnection
implements XAConnection,
ConnectionEventListener {
    private XAConnection con;

    DelegateXAConnection(XAConnection xAConnection) {
        this.con = xAConnection;
        xAConnection.addConnectionEventListener(this);
    }

    private final void checkCon() throws SQLException {
        if (this.con == null) {
            throw new SQLException("connection is already closed");
        }
    }

    private final void checkConRuntime() {
        try {
            this.checkCon();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.forgetCon();
    }

    private final void forgetCon() {
        this.con.removeConnectionEventListener(this);
        this.con = null;
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
    }

    public XAResource getXAResource() throws SQLException {
        this.checkCon();
        return this.con.getXAResource();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.checkConRuntime();
        this.con.addConnectionEventListener(connectionEventListener);
    }

    public void close() throws SQLException {
        if (this.con != null) {
            this.con.close();
            this.forgetCon();
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkCon();
        return this.con.getConnection();
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.checkConRuntime();
        this.con.removeConnectionEventListener(connectionEventListener);
    }
}

