/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeClauseParser;
import interbase.interclient.EscapeLexer;
import interbase.interclient.EscapeSyntaxException;
import java.sql.SQLException;
import java.util.NoSuchElementException;

final class EscapeFunctionParser
implements EscapeClauseParser {
    static String[] userTokens = new String[]{"FN", "USER", "(", ")"};
    static String[] nowTokens = new String[]{"FN", "NOW", "(", ")"};
    static String[] curdateTokens = new String[]{"FN", "CURDATE", "(", ")"};
    static String[] ucaseTokens = new String[]{"FN", "UCASE", "("};
    static String[] lengthTokens = new String[]{"FN", "LENGTH", "("};
    static String[] subStringTokens = new String[]{"FN", "SUBSTRING", "("};
    static String[] lowerTokens = new String[]{"FN", "LCASE", "("};
    static String[] asciiValTokens = new String[]{"FN", "CHAR", "("};
    static String[] asciiCharTokens = new String[]{"FN", "ASCII", "("};
    static String escapeString = "escape ";

    EscapeFunctionParser() {
    }

    private synchronized boolean matchStringToTokens(String string, String[] stringArray, boolean bl) throws SQLException {
        EscapeLexer escapeLexer = new EscapeLexer(string);
        if (!escapeLexer.hasMoreTokens()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 123);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            try {
                string2 = escapeLexer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
            if (string2.toUpperCase().compareTo(stringArray[n]) != 0) {
                return false;
            }
            ++n;
        }
        return !escapeLexer.hasMoreTokens() || !bl;
    }

    public synchronized String parse(String string, int n) throws SQLException {
        if (this.matchStringToTokens(string, userTokens, true)) {
            return "USER";
        }
        if (this.matchStringToTokens(string, nowTokens, true)) {
            return "'NOW'";
        }
        if (this.matchStringToTokens(string, curdateTokens, true)) {
            return "'TODAY'";
        }
        if (this.matchStringToTokens(string, lengthTokens, false)) {
            int n2 = string.indexOf("(");
            if (n2 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "STRLEN " + string.substring(n2);
        }
        if (this.matchStringToTokens(string, subStringTokens, false)) {
            int n3 = string.indexOf("(");
            if (n3 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "SUBSTR " + string.substring(n3);
        }
        if (this.matchStringToTokens(string, ucaseTokens, false)) {
            int n4 = string.indexOf("(");
            if (n4 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "UPPER " + string.substring(n4);
        }
        if (this.matchStringToTokens(string, ucaseTokens, false)) {
            int n5 = string.indexOf("(");
            if (n5 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "LOWER " + string.substring(n5);
        }
        if (this.matchStringToTokens(string, asciiValTokens, false)) {
            int n6 = string.indexOf("(");
            if (n6 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "CHAR " + string.substring(n6);
        }
        if (this.matchStringToTokens(string, asciiCharTokens, false)) {
            int n7 = string.indexOf("(");
            if (n7 == -1) {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 124);
            }
            return "ASCII " + string.substring(n7);
        }
        int n8 = string.toUpperCase().indexOf("FN");
        if (n8 == -1) {
            throw new EscapeSyntaxException(ErrorKey.escapeSyntax__fn_0__, string);
        }
        return string.substring(n8 + 2);
    }
}

