/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import java.util.NoSuchElementException;

final class EscapeLexer {
    private int currentPos_ = 0;
    private int maxPos_;
    private String lexStr_;
    private String delimiters_;
    private boolean inSingleQuotedString_;
    private boolean inDoubleQuotedString_;
    private int curlyNestingDepth_ = 0;
    private char currentChar_;
    private char prevChar_;

    EscapeLexer(String string) {
        this(string, " \n\t\r'\"{},()\\[]");
    }

    EscapeLexer(String string, String string2) {
        this.maxPos_ = string.length() - 1;
        this.lexStr_ = string;
        this.prevChar_ = '\u0000';
        this.currentChar_ = string.charAt(this.currentPos_);
        this.delimiters_ = string2;
        if (this.maxPos_ >= 0) {
            this.inSingleQuotedString_ = this.currentChar_ == '\'';
            boolean bl = this.inDoubleQuotedString_ = this.currentChar_ == '\"';
            this.curlyNestingDepth_ = this.currentChar_ == '{' ? 1 : 0;
        } else {
            this.inSingleQuotedString_ = false;
            this.inDoubleQuotedString_ = false;
            this.curlyNestingDepth_ = 0;
        }
    }

    private synchronized boolean advance() {
        ++this.currentPos_;
        if (this.currentPos_ > this.maxPos_) {
            return false;
        }
        this.prevChar_ = this.currentChar_;
        this.currentChar_ = this.lexStr_.charAt(this.currentPos_);
        if (this.currentChar_ == '\'' && (this.prevChar_ != '\\' || this.inSingleQuotedString_)) {
            boolean bl = this.inSingleQuotedString_ = !this.inSingleQuotedString_;
        }
        if (this.currentChar_ == '\"' && this.prevChar_ != '\\') {
            boolean bl = this.inDoubleQuotedString_ = !this.inDoubleQuotedString_;
        }
        if (!this.inSingleQuotedString_ && !this.inDoubleQuotedString_) {
            if (this.currentChar_ == '{' && this.prevChar_ != '\\') {
                ++this.curlyNestingDepth_;
            }
            if (this.currentChar_ == '}' && this.prevChar_ != '\\' && this.curlyNestingDepth_ > 0) {
                --this.curlyNestingDepth_;
            }
        }
        return true;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private synchronized boolean skipWhiteSpaces() {
        while (this.isWhiteSpace(this.currentChar_)) {
            if (this.advance()) continue;
            return false;
        }
        return true;
    }

    private boolean isDelimChar(char c) {
        int n = 0;
        while (n < this.delimiters_.length()) {
            if (this.delimiters_.charAt(n) == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private synchronized int findNext(char c) {
        do {
            if (this.currentChar_ != c) continue;
            int n = this.currentPos_;
            this.advance();
            return n;
        } while (this.advance());
        return -1;
    }

    synchronized int findNextNotInQuotedString(char c) {
        do {
            if (this.currentChar_ != c || this.inSingleQuotedString_ || this.inDoubleQuotedString_) continue;
            int n = this.currentPos_;
            this.advance();
            return n;
        } while (this.advance());
        return -1;
    }

    synchronized int findNextMatching(char c) {
        boolean bl = this.inSingleQuotedString_;
        boolean bl2 = this.inDoubleQuotedString_;
        int n = this.curlyNestingDepth_;
        do {
            if (this.currentChar_ == c && bl == this.inSingleQuotedString_ && bl2 == this.inDoubleQuotedString_ && n == this.curlyNestingDepth_ + 1 && c == '}') {
                int n2 = this.currentPos_;
                this.advance();
                return n2;
            }
            if (this.advance()) continue;
            return -1;
        } while (!(bl && !this.inSingleQuotedString_ || bl2 && !this.inDoubleQuotedString_) && (n != this.curlyNestingDepth_ + 1 || this.currentChar_ != '}' || c == '}'));
        return -1;
    }

    synchronized String nextToken() throws NoSuchElementException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.currentPos_ > this.maxPos_) {
            throw new NoSuchElementException();
        }
        if (!this.skipWhiteSpaces()) {
            throw new NoSuchElementException();
        }
        stringBuffer.append(this.currentChar_);
        if (this.isDelimChar(this.currentChar_)) {
            this.advance();
            return stringBuffer.toString();
        }
        while (true) {
            if (!this.advance()) {
                return stringBuffer.toString();
            }
            if (this.isDelimChar(this.currentChar_)) break;
            stringBuffer.append(this.currentChar_);
        }
        return stringBuffer.toString();
    }

    synchronized String subString(int n, int n2) throws StringIndexOutOfBoundsException {
        return this.lexStr_.substring(n, n2);
    }

    synchronized String subString(int n) throws StringIndexOutOfBoundsException {
        return this.lexStr_.substring(n);
    }

    synchronized boolean hasMoreTokens() {
        return this.currentPos_ <= this.maxPos_ && this.skipWhiteSpaces();
    }
}

