/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.CharacterEncodings;
import interbase.interclient.ErrorKey;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.XSQLVAR;
import java.sql.SQLException;

final class IBTypes {
    static final int NULL_TYPE__ = 0;
    static final int SMALLINT__ = 1;
    static final int INTEGER__ = 2;
    static final int FLOAT__ = 3;
    static final int DOUBLE__ = 4;
    static final int NUMERIC_DOUBLE__ = 5;
    static final int NUMERIC_INTEGER__ = 6;
    static final int NUMERIC_SMALLINT__ = 7;
    static final int CHAR__ = 8;
    static final int VARCHAR__ = 9;
    static final int CLOB__ = 10;
    static final int DATE__ = 11;
    static final int BLOB__ = 12;
    static final int ARRAY__ = 14;
    static final int SQLDATE__ = 15;
    static final int TIME__ = 16;
    static final int NUMERIC_INT64__ = 17;
    static final int DECIMAL_INT64__ = 18;
    static final int DECIMAL_INTEGER__ = 19;
    static final int VARCHAR_STRING__ = 20;
    static final int SQLBOOLEAN__ = 21;
    static final int SMALLINT_PRECISION__ = 5;
    static final int INTEGER_PRECISION__ = 10;
    static final int FLOAT_PRECISION__ = 7;
    static final int DOUBLE_PRECISION__ = 15;
    static final int NUMERIC_DOUBLE_PRECISION__ = 15;
    static final int NUMERIC_INTEGER_PRECISION__ = 10;
    static final int NUMERIC_SMALLINT_PRECISION__ = 5;
    static final int DATE_PRECISION__ = 19;
    static final int SQLDATE_PRECISION__ = 10;
    static final int TIME_PRECISION__ = 8;
    static final int NUMERIC_INT64_PRECISION__ = 19;
    static final int DECIMAL_SMALLINT_PRECISION__ = 5;
    static final int DECIMAL_INTEGER_PRECISION__ = 10;
    static final int DECIMAL_INT64_PRECISION__ = 19;
    static final int TYPE_NAME_PRECISION__ = 16;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;

    IBTypes() {
    }

    static boolean isNumeric(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    static int getSQLType(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: 
            case 6: 
            case 7: 
            case 17: {
                return 2;
            }
            case 18: 
            case 19: {
                return 3;
            }
            case 8: {
                return 1;
            }
            case 9: 
            case 20: {
                return 12;
            }
            case 11: {
                return 93;
            }
            case 10: {
                return -1;
            }
            case 12: {
                return -4;
            }
            case 14: {
                return 1111;
            }
            case 15: {
                return 91;
            }
            case 16: {
                return 92;
            }
            case 21: {
                return -7;
            }
        }
        return 0;
    }

    static String getIBTypeName(int n) {
        switch (n) {
            case 1: {
                return "SMALLINT";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "FLOAT";
            }
            case 4: {
                return "DOUBLE PRECISION";
            }
            case 5: 
            case 6: 
            case 7: 
            case 17: {
                return "NUMERIC";
            }
            case 18: 
            case 19: {
                return "DECIMAL";
            }
            case 8: {
                return "CHAR";
            }
            case 9: 
            case 20: {
                return "VARCHAR";
            }
            case 11: {
                return "TIMESTAMP";
            }
            case 10: 
            case 12: {
                return "BLOB";
            }
            case 14: {
                return "ARRAY";
            }
            case 0: {
                return "";
            }
            case 15: {
                return "DATE";
            }
            case 16: {
                return "TIME";
            }
            case 21: {
                return "BOOLEAN";
            }
        }
        return "";
    }

    static final int getResultTypes(int n, XSQLVAR xSQLVAR) throws SQLException {
        switch (n & 0xFFFFFFFE) {
            case 452: {
                return 8;
            }
            case 448: {
                return 9;
            }
            case 600: {
                return 20;
            }
            case 496: {
                if (xSQLVAR.sqlscale == 0) {
                    return 2;
                }
                if (xSQLVAR.sqlsubtype == 2) {
                    return 19;
                }
                return 6;
            }
            case 500: {
                if (xSQLVAR.sqlscale == 0) {
                    return 1;
                }
                return 7;
            }
            case 482: {
                return 3;
            }
            case 510: {
                return 11;
            }
            case 480: {
                if (xSQLVAR.sqlscale == 0) {
                    return 4;
                }
                return 5;
            }
            case 530: {
                return 4;
            }
            case 540: {
                return 14;
            }
            case 520: {
                if (xSQLVAR.sqlsubtype == 1) {
                    return 10;
                }
                return 12;
            }
            case 580: {
                if (xSQLVAR.sqlsubtype == 2) {
                    return 18;
                }
                return 17;
            }
            case 560: {
                return 16;
            }
            case 570: {
                return 15;
            }
            case 590: {
                return 21;
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 10017);
    }

    static final int getDataType(short s, short s2, short s3) {
        if (s3 < 0) {
            switch (s) {
                case 7: 
                case 8: 
                case 16: 
                case 27: {
                    if (s2 == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (s) {
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
            case 11: 
            case 27: {
                return 8;
            }
            case 10: {
                return 6;
            }
            case 14: {
                return 1;
            }
            case 37: {
                return 12;
            }
            case 35: {
                return 93;
            }
            case 13: {
                return 92;
            }
            case 12: {
                return 91;
            }
            case 16: {
                if (s2 == 2) {
                    return 3;
                }
                return 2;
            }
            case 261: {
                if (s2 < 0) {
                    return 2004;
                }
                if (s2 == 1) {
                    return 12;
                }
                return -4;
            }
            case 17: {
                return -7;
            }
            case 9: {
                return 1111;
            }
        }
        return 0;
    }

    static final int getIBType(short s, short s2, short s3) {
        if (s3 < 0) {
            switch (s) {
                case 7: {
                    return 7;
                }
                case 8: {
                    if (s2 == 2) {
                        return 19;
                    }
                    return 6;
                }
                case 16: {
                    if (s2 == 2) {
                        return 18;
                    }
                    return 17;
                }
                case 27: {
                    return 5;
                }
            }
        }
        switch (s) {
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 11: 
            case 27: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 14: {
                return 8;
            }
            case 37: {
                return 9;
            }
            case 35: {
                return 11;
            }
            case 13: {
                return 16;
            }
            case 12: {
                return 15;
            }
            case 16: {
                if (s2 == 2) {
                    return 18;
                }
                return 17;
            }
            case 261: {
                if (s2 == 1) {
                    return 10;
                }
                return 12;
            }
            case 9: {
                return 14;
            }
            case 17: {
                return 21;
            }
        }
        return 0;
    }

    static final short getRadix(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 12: 
            case 1111: {
                return 0;
            }
        }
        return 10;
    }

    static final int getPrecision(XSQLVAR xSQLVAR, int n) {
        if (xSQLVAR.sqlPrecision != 0) {
            return xSQLVAR.sqlPrecision;
        }
        switch (n) {
            case 2: 
            case 6: 
            case 19: {
                return 10;
            }
            case 1: 
            case 7: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: 
            case 5: {
                return 15;
            }
            case 17: 
            case 18: {
                return 19;
            }
        }
        return 0;
    }

    static final int getPrecision(int n, int n2) {
        switch (n) {
            case 8: 
            case 9: 
            case 20: {
                return n2;
            }
            case 11: {
                return 19;
            }
            case 2: 
            case 6: 
            case 19: {
                return 10;
            }
            case 1: 
            case 7: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: 
            case 5: {
                return 15;
            }
            case 17: 
            case 18: {
                return 19;
            }
            case 15: {
                return 10;
            }
            case 16: {
                return 8;
            }
            case 21: {
                return 1;
            }
        }
        return 0;
    }

    static final String getClassName(int n) throws SQLException {
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                return (class$java$lang$String == null ? (class$java$lang$String = IBTypes.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 12: {
                return (class$java$sql$Blob == null ? (class$java$sql$Blob = IBTypes.class$("java.sql.Blob")) : class$java$sql$Blob).getName();
            }
            case 14: {
                return (class$java$sql$Array == null ? (class$java$sql$Array = IBTypes.class$("java.sql.Array")) : class$java$sql$Array).getName();
            }
            case 11: {
                return (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = IBTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName();
            }
            case 21: {
                return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IBTypes.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName();
            }
            case 1: {
                return (class$java$lang$Short == null ? (class$java$lang$Short = IBTypes.class$("java.lang.Short")) : class$java$lang$Short).getName();
            }
            case 7: 
            case 17: {
                return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = IBTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName();
            }
            case 18: {
                return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = IBTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName();
            }
            case 15: {
                return (class$java$sql$Date == null ? (class$java$sql$Date = IBTypes.class$("java.sql.Date")) : class$java$sql$Date).getName();
            }
            case 16: {
                return (class$java$sql$Time == null ? (class$java$sql$Time = IBTypes.class$("java.sql.Time")) : class$java$sql$Time).getName();
            }
            case 4: 
            case 5: {
                return (class$java$lang$Double == null ? (class$java$lang$Double = IBTypes.class$("java.lang.Double")) : class$java$lang$Double).getName();
            }
            case 3: {
                return (class$java$lang$Float == null ? (class$java$lang$Float = IBTypes.class$("java.lang.Float")) : class$java$lang$Float).getName();
            }
            case 6: 
            case 19: {
                return (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = IBTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName();
            }
            case 2: {
                return (class$java$lang$Integer == null ? (class$java$lang$Integer = IBTypes.class$("java.lang.Integer")) : class$java$lang$Integer).getName();
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 115);
    }

    static final int getColumnSize(int n, int n2) {
        switch (n) {
            case 8: 
            case 9: 
            case 20: {
                return n2;
            }
            case 11: {
                return 24;
            }
            case 2: 
            case 6: 
            case 19: {
                return 10;
            }
            case 1: 
            case 7: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: 
            case 5: {
                return 15;
            }
            case 17: 
            case 18: {
                return 19;
            }
            case 15: {
                return 10;
            }
            case 16: {
                return 8;
            }
            case 21: {
                return 1;
            }
        }
        return 0;
    }

    static final int getIBArrayPrecision(int n, int n2) throws SQLException {
        switch (n) {
            case 14: 
            case 15: 
            case 37: 
            case 38: {
                return n2;
            }
            case 35: {
                return 19;
            }
            case 8: {
                return 10;
            }
            case 7: {
                return 5;
            }
            case 10: {
                return 7;
            }
            case 27: {
                return 15;
            }
            case 11: {
                return 15;
            }
            case 16: {
                return 19;
            }
            case 13: {
                return 8;
            }
            case 12: {
                return 10;
            }
            case 17: {
                return 1;
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 10026);
    }

    static final int getIBArrayType(int n, int n2, int n3) throws SQLException {
        if (n2 < 0) {
            switch (n) {
                case 7: {
                    return 7;
                }
                case 8: {
                    if (n3 == 2) {
                        return 19;
                    }
                    return 6;
                }
                case 16: {
                    if (n3 == 2) {
                        return 18;
                    }
                    return 17;
                }
                case 27: {
                    return 5;
                }
            }
        }
        switch (n) {
            case 14: 
            case 15: {
                return 8;
            }
            case 37: 
            case 38: {
                return 9;
            }
            case 8: {
                if (n2 == 0) {
                    return 2;
                }
                return 6;
            }
            case 7: {
                if (n2 == 0) {
                    return 1;
                }
                return 7;
            }
            case 10: {
                return 3;
            }
            case 35: {
                return 11;
            }
            case 27: {
                if (n2 == 0) {
                    return 4;
                }
                return 5;
            }
            case 11: {
                return 4;
            }
            case 17: {
                return 21;
            }
            case 16: {
                if (n3 == 1) {
                    return 17;
                }
                return 18;
            }
            case 13: {
                return 16;
            }
            case 12: {
                return 91;
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 10017);
    }

    public static int getCharacterLength(XSQLVAR xSQLVAR) throws SQLException {
        if ((xSQLVAR.sqltype & 0xFFFFFFFE) == 452 || (xSQLVAR.sqltype & 0xFFFFFFFE) == 448) {
            int n = xSQLVAR.sqlsubtype % 128;
            if (CharacterEncodings.isOneByteCharSet(n)) {
                return xSQLVAR.sqllen;
            }
            if (CharacterEncodings.isTwoByteCharSet(n)) {
                return xSQLVAR.sqllen / 2;
            }
            if (CharacterEncodings.isThreeByteCharSet(n)) {
                return xSQLVAR.sqllen / 3;
            }
            throw new UnsupportedCharacterSetException(128, n);
        }
        return xSQLVAR.sqllen;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

