/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.DataSourceProperties;
import interbase.interclient.SQLException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class PooledConnection
implements javax.sql.PooledConnection,
XAConnection {
    private transient ConnectionEventListener[] listeners;
    private transient PrintWriter logWriter;
    private transient boolean closing;
    private transient ConnectionEvent event;
    private transient java.sql.Connection physCon;
    private transient Connection bCon;
    private transient Connection delegateCon;
    private transient DataSourceProperties props;
    private transient int maxStatements;

    PooledConnection() {
    }

    PooledConnection(java.sql.Connection connection, DataSourceProperties dataSourceProperties) {
        this.props = dataSourceProperties;
        this.physCon = connection;
        if (connection instanceof Connection) {
            this.bCon = (Connection)connection;
        }
        this.event = new ConnectionEvent(this);
        this.logWriter = dataSourceProperties.logWriter_;
    }

    public synchronized java.sql.Connection getConnection() throws java.sql.SQLException {
        if (this.logWriter != null || DriverManager.getLogWriter() != null) {
            this.println("PooledConnection.getConnection()", this);
        }
        return this.physCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws java.sql.SQLException {
        if (!this.closing) {
            try {
                this.closing = true;
                if (this.physCon != null) {
                    this.physCon.close();
                }
                this.physCon = null;
                this.delegateCon = null;
                this.listeners = null;
                Object var2_1 = null;
                this.closing = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closing = false;
                throw throwable;
            }
        }
    }

    final synchronized void returnToPool() throws SQLException {
        ConnectionEventListener[] connectionEventListenerArray = this.listeners;
        int n = 0;
        while (n < connectionEventListenerArray.length) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[n];
            if (connectionEventListener != null) {
                connectionEventListener.connectionClosed(this.event);
            }
            ++n;
        }
        this.delegateCon = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.addListener(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners != null) {
            this.removeListener(connectionEventListener);
        }
    }

    public XAResource getXAResource() throws java.sql.SQLException {
        this.getConnection();
        if (this.logWriter != null || DriverManager.getLogWriter() != null) {
            this.println("PooledConnection.getXAResource()", this);
        }
        return null;
    }

    private final void addListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners == null) {
            this.listeners = new ConnectionEventListener[1];
            this.listeners[0] = connectionEventListener;
        } else {
            int n = 0;
            while (n < this.listeners.length) {
                if (this.listeners[n] == null) {
                    this.listeners[n] = connectionEventListener;
                    return;
                }
                ++n;
            }
            int n2 = this.listeners.length;
            ConnectionEventListener[] connectionEventListenerArray = new ConnectionEventListener[n2 + 1];
            System.arraycopy(this.listeners, 0, connectionEventListenerArray, 0, n2);
            connectionEventListenerArray[n2] = connectionEventListener;
            this.listeners = connectionEventListenerArray;
        }
    }

    private final void removeListener(ConnectionEventListener connectionEventListener) {
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] == connectionEventListener) {
                this.listeners[n] = null;
                return;
            }
            ++n;
        }
    }

    final void println(String string, Object object) {
        if (this.logWriter != null) {
            this.logWriter.println("  \"  :" + string + " [" + object + "]");
            this.logWriter.flush();
        }
        DriverManager.println(string);
    }
}

