/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.XdrEnabled;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

class XdrOutputStream
extends DataOutputStream {
    private static final String defaultEncoding = "8859_1";
    private final byte[] pad = new byte[]{0, 0, 0, 0};

    public XdrOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public final void writeOpaque(byte[] byArray, int n) throws IOException {
        if (byArray != null && n > 0) {
            this.write(byArray, 0, n);
            this.write(this.pad, 0, 4 - n & 3);
        }
    }

    public final void writeBuffer(byte[] byArray, int n) throws IOException {
        this.writeInt(n);
        if (byArray != null && n > 0) {
            this.write(byArray, 0, n);
            this.write(this.pad, 0, 4 - n & 3);
        }
    }

    public final void writeBlobBuffer(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > Short.MAX_VALUE) {
            throw new IOException("");
        }
        this.writeInt(n + 2);
        this.writeInt(n + 2);
        this.write(n >> 0 & 0xFF);
        this.write(n >> 8 & 0xFF);
        this.write(byArray, 0, n);
        this.write(this.pad, 0, 4 - n + 2 & 3);
    }

    public final void writeString(String string, String string2) throws IOException {
        if (string2 == null) {
            this.writeString(string, defaultEncoding);
        } else {
            byte[] byArray = string.getBytes(string2);
            int n = byArray.length;
            this.writeInt(n);
            if (n > 0) {
                this.write(byArray, 0, n);
                this.write(this.pad, 0, 4 - n & 3);
            }
        }
    }

    public final void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        this.writeInt(n);
        if (n > 0) {
            this.write(byArray, 0, n);
            this.write(this.pad, 0, 4 - n & 3);
        }
    }

    final void writeSet(int n, Set set) throws IOException {
        if (set == null) {
            this.writeInt(1);
            this.write(n);
        } else {
            this.writeInt(set.size() + 1);
            this.write(n);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                this.write(n2);
            }
            this.write(this.pad, 0, 4 - (set.size() + 1) & 3);
        }
    }

    final void writeTyped(int n, XdrEnabled xdrEnabled) throws IOException {
        int n2;
        if (xdrEnabled == null) {
            this.writeInt(1);
            this.write(n);
            n2 = 1;
        } else {
            n2 = xdrEnabled.getSize() + 1;
            this.writeInt(n2);
            this.write(n);
            xdrEnabled.write(this);
        }
        this.write(this.pad, 0, 4 - n2 & 3);
    }
}

