/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class MozillaDelegate {
    Browser browser;
    Listener listener;
    boolean hasFocus;
    static boolean GtkLoaded;
    static boolean IsLinux;

    static {
        String string = System.getProperty("os.name").toLowerCase();
        IsLinux = string.startsWith("linux");
    }

    MozillaDelegate(Browser browser) {
        if (!IsLinux) {
            browser.dispose();
            SWT.error(2, null, " [Unsupported platform]");
        }
        this.browser = browser;
        if (!GtkLoaded) {
            GtkLoaded = true;
            try {
                Library.loadLibrary("swt-gtk");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                browser.dispose();
                SWT.error(2, unsatisfiedLinkError);
            }
        }
    }

    static Browser findBrowser(int n) {
        Display display = Display.getCurrent();
        Shell[] shellArray = display.getShells();
        Browser browser = null;
        int n2 = 0;
        while (n2 < shellArray.length) {
            browser = MozillaDelegate.findBrowser(shellArray[n2], n);
            if (browser != null) break;
            ++n2;
        }
        return browser;
    }

    static Browser findBrowser(Control control, int n) {
        Control[] controlArray;
        Composite composite;
        if (control instanceof Browser) {
            composite = (Browser)control;
            controlArray = ((Browser)composite).webBrowser;
            if (controlArray instanceof Mozilla && ((Mozilla)controlArray).embedHandle == n) {
                return composite;
            }
        }
        if (control instanceof Composite) {
            composite = (Composite)control;
            controlArray = composite.getChildren();
            int n2 = 0;
            while (n2 < controlArray.length) {
                Browser browser = MozillaDelegate.findBrowser(controlArray[n2], n);
                if (browser != null) {
                    return browser;
                }
                ++n2;
            }
        }
        return null;
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return Converter.mbcsToWcs(string, byArray);
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        return Converter.wcsToMbcs(string, string2, bl);
    }

    int getHandle() {
        if (Mozilla.BrowserCount == 1) {
            GTK.gtk_init_check(new int[1], null);
            final Display display = this.browser.getDisplay();
            display.asyncExec(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                public void run() {
                    if (Mozilla.BrowserCount != 0) ** GOTO lbl5
                    return;
lbl-1000:
                    // 1 sources

                    {
                        GTK.gtk_main_iteration();
lbl5:
                        // 2 sources

                        ** while (GTK.gtk_events_pending() != 0)
                    }
lbl6:
                    // 1 sources

                    display.timerExec(25, this);
                }
            });
        }
        this.browser.getShell().setFocus();
        int n = GTK.gtk_plug_new(this.browser.embeddedHandle);
        GTK.gtk_widget_show(n);
        return n;
    }

    String getLibraryName() {
        return "libxpcom.so";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void init() {
    }

    void onDispose(int n) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        GTK.gtk_widget_destroy(n);
        while (GTK.gtk_events_pending() != 0) {
            GTK.gtk_main_iteration();
        }
        this.browser = null;
    }

    void setSize(int n, int n2, int n3) {
    }
}

