/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    int xClient;
    int yClient;
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color selectionFadeStart;
    Color selectionHighlightGradientBegin = null;
    Color[] selectionHighlightGradientColorsCache = null;
    Image bgImage;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    static Color borderColor;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    Rectangle chevronRect = new Rectangle(0, 0, 0, 0);
    int chevronImageState = 1;
    boolean showChevron = false;
    Menu showMenu;
    boolean showMin = false;
    Rectangle minRect = new Rectangle(0, 0, 0, 0);
    boolean minimized = false;
    int minImageState = 1;
    boolean showMax = false;
    Rectangle maxRect = new Rectangle(0, 0, 0, 0);
    boolean maximized = false;
    int maxImageState = 1;
    Control topRight;
    Rectangle topRightRect = new Rectangle(0, 0, 0, 0);
    int topRightAlignment = 131072;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    int borderBottom = 0;
    int highlight_margin = 0;
    int highlight_header = 0;
    int[] curve;
    int[] topCurveHighlightStart;
    int[] topCurveHighlightEnd;
    int curveWidth = 0;
    int curveIndent = 0;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_SIZE = 18;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_LEFT_CORNER_HILITE;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_UNSELECTED_INNER_CORNER;
    static final int[] TOP_LEFT_CORNER_BORDERLESS;
    static final int[] TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_TOP_RIGHT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int BORDER1_COLOR = 18;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int BUTTON_BORDER = 17;
    static final int BUTTON_FILL = 25;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int HOT = 2;
    static final int SELECTED = 3;
    static final RGB CLOSE_FILL;
    static final int CHEVRON_CHILD_ID = 0;
    static final int MINIMIZE_CHILD_ID = 1;
    static final int MAXIMIZE_CHILD_ID = 2;
    static final int EXTRA_CHILD_ID_COUNT = 3;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        TOP_LEFT_CORNER_HILITE = new int[]{5, 2, 4, 2, 3, 3, 2, 4, 2, 5, 1, 6};
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
        SIMPLE_UNSELECTED_INNER_CORNER = new int[2];
        int[] nArray9 = new int[12];
        nArray9[1] = 6;
        nArray9[2] = 1;
        nArray9[3] = 5;
        nArray9[4] = 1;
        nArray9[5] = 4;
        nArray9[6] = 4;
        nArray9[7] = 1;
        nArray9[8] = 5;
        nArray9[9] = 1;
        nArray9[10] = 6;
        TOP_LEFT_CORNER_BORDERLESS = nArray9;
        int[] nArray10 = new int[12];
        nArray10[0] = -7;
        nArray10[2] = -6;
        nArray10[3] = 1;
        nArray10[4] = -5;
        nArray10[5] = 1;
        nArray10[6] = -2;
        nArray10[7] = 4;
        nArray10[8] = -2;
        nArray10[9] = 5;
        nArray10[10] = -1;
        nArray10[11] = 6;
        TOP_RIGHT_CORNER_BORDERLESS = nArray10;
        int[] nArray11 = new int[16];
        nArray11[1] = -6;
        nArray11[2] = 1;
        nArray11[3] = -6;
        nArray11[4] = 1;
        nArray11[5] = -5;
        nArray11[6] = 2;
        nArray11[7] = -4;
        nArray11[8] = 4;
        nArray11[9] = -2;
        nArray11[10] = 5;
        nArray11[11] = -1;
        nArray11[12] = 6;
        nArray11[13] = -1;
        nArray11[14] = 6;
        BOTTOM_LEFT_CORNER_BORDERLESS = nArray11;
        int[] nArray12 = new int[16];
        nArray12[0] = -7;
        nArray12[2] = -7;
        nArray12[3] = -1;
        nArray12[4] = -6;
        nArray12[5] = -1;
        nArray12[6] = -5;
        nArray12[7] = -2;
        nArray12[8] = -3;
        nArray12[9] = -4;
        nArray12[10] = -2;
        nArray12[11] = -5;
        nArray12[12] = -2;
        nArray12[13] = -6;
        nArray12[14] = -1;
        nArray12[15] = -6;
        BOTTOM_RIGHT_CORNER_BORDERLESS = nArray12;
        int[] nArray13 = new int[6];
        nArray13[1] = 2;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = 2;
        SIMPLE_TOP_LEFT_CORNER_BORDERLESS = nArray13;
        int[] nArray14 = new int[6];
        nArray14[0] = -3;
        nArray14[2] = -2;
        nArray14[3] = 1;
        nArray14[4] = -1;
        nArray14[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER_BORDERLESS = nArray14;
        int[] nArray15 = new int[8];
        nArray15[1] = -3;
        nArray15[2] = 1;
        nArray15[3] = -2;
        nArray15[4] = 2;
        nArray15[5] = -1;
        nArray15[6] = 3;
        SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS = nArray15;
        int[] nArray16 = new int[8];
        nArray16[0] = -4;
        nArray16[2] = -3;
        nArray16[3] = -1;
        nArray16[4] = -2;
        nArray16[5] = -2;
        nArray16[6] = -1;
        nArray16[7] = -3;
        SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS = nArray16;
        CLOSE_FILL = new RGB(252, 160, 160);
    }

    public CTabFolder(Composite composite, int n) {
        super(composite, CTabFolder.checkStyle(composite, n));
        super.setLayout(new CTabFolderLayout());
        int n2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n2 & 0x400) != 0;
        this.showClose = (n2 & 0x40) != 0;
        this.single = (n2 & 4) != 0;
        this.borderRight = (n & 0x800) != 0 ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        this.highlight_header = (n & 0x800000) != 0 ? 1 : 3;
        this.highlight_margin = (n & 0x800000) != 0 ? 0 : 2;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        borderColor = display.getSystemColor(18);
        this.updateTabHeight(false);
        this.initAccessible();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize();
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 5, 4, 9, 11, 31};
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addListener(nArray[n3], this.listener);
            ++n3;
        }
    }

    static int checkStyle(Composite composite, int n) {
        int n2 = 109053126;
        if (((n &= n2) & 0x80) != 0) {
            n &= 0xFFFFFBFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        n |= 0x100000;
        String string = SWT.getPlatform();
        if ("carbon".equals(string) || "gtk".equals(string)) {
            return n;
        }
        if ((n & 0x4000000) != 0) {
            return n;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n & 0x2000000) == 0) {
            return n;
        }
        return n | 0x40000;
    }

    static void fillRegion(GC gC, Region region) {
        Region region2 = new Region();
        gC.getClipping(region2);
        region.intersect(region2);
        gC.setClipping(region);
        gC.fillRectangle(region.getBounds());
        gC.setClipping(region2);
        region2.dispose();
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void antialias(int[] nArray, RGB rGB, RGB rGB2, RGB rGB3, GC gC) {
        Color color;
        int n;
        int n2;
        int n3;
        RGB rGB4;
        int n4;
        int n5;
        if (this.simple || "carbon".equals(SWT.getPlatform()) || "wpf".equals(SWT.getPlatform())) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (rGB3 != null) {
            int n6 = 0;
            n5 = 1;
            n4 = this.onBottom ? 0 : this.getSize().y;
            int[] nArray2 = new int[nArray.length];
            int n7 = 0;
            while (n7 < nArray.length / 2) {
                if (n5 != 0 && n6 + 3 < nArray.length) {
                    n5 = this.onBottom ? (n4 <= nArray[n6 + 3] ? 1 : 0) : (n4 >= nArray[n6 + 3] ? 1 : 0);
                    n4 = nArray[n6 + 1];
                }
                nArray2[n6] = nArray[n6++] + (n5 != 0 ? -1 : 1);
                nArray2[n6] = nArray[n6++];
                ++n7;
            }
            RGB rGB5 = rGB;
            rGB4 = rGB3;
            n3 = rGB5.red + 2 * (rGB4.red - rGB5.red) / 3;
            n2 = rGB5.green + 2 * (rGB4.green - rGB5.green) / 3;
            n = rGB5.blue + 2 * (rGB4.blue - rGB5.blue) / 3;
            color = new Color(this.getDisplay(), n3, n2, n);
            gC.setForeground(color);
            gC.drawPolyline(nArray2);
            color.dispose();
        }
        if (rGB2 != null) {
            int[] nArray3 = new int[nArray.length];
            n5 = 0;
            n4 = 1;
            int n8 = this.onBottom ? 0 : this.getSize().y;
            int n9 = 0;
            while (n9 < nArray.length / 2) {
                if (n4 != 0 && n5 + 3 < nArray.length) {
                    n4 = this.onBottom ? (n8 <= nArray[n5 + 3] ? 1 : 0) : (n8 >= nArray[n5 + 3] ? 1 : 0);
                    n8 = nArray[n5 + 1];
                }
                nArray3[n5] = nArray[n5++] + (n4 != 0 ? 1 : -1);
                nArray3[n5] = nArray[n5++];
                ++n9;
            }
            RGB rGB6 = rGB;
            rGB4 = rGB2;
            n3 = rGB6.red + 2 * (rGB4.red - rGB6.red) / 3;
            n2 = rGB6.green + 2 * (rGB4.green - rGB6.green) / 3;
            n = rGB6.blue + 2 * (rGB4.blue - rGB6.blue) / 3;
            color = new Color(this.getDisplay(), n3, n2, n);
            gC.setForeground(color);
            gC.drawPolyline(nArray3);
            color.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = n - this.marginWidth - this.highlight_margin - this.borderLeft;
        int n6 = n3 + this.borderLeft + this.borderRight + 2 * this.marginWidth + 2 * this.highlight_margin;
        if (this.minimized) {
            int n7 = this.onBottom ? n2 - this.borderTop : n2 - this.highlight_header - this.tabHeight - this.borderTop;
            int n8 = this.borderTop + this.borderBottom + this.tabHeight + this.highlight_header;
            return new Rectangle(n5, n7, n6, n8);
        }
        int n9 = this.onBottom ? n2 - this.marginHeight - this.highlight_margin - this.borderTop : n2 - this.marginHeight - this.highlight_header - this.tabHeight - this.borderTop;
        int n10 = n4 + this.borderTop + this.borderBottom + 2 * this.marginHeight + this.tabHeight + this.highlight_header + this.highlight_margin;
        return new Rectangle(n5, n9, n6, n10);
    }

    void createItem(CTabItem cTabItem, int n) {
        if (n < 0 || n > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        cTabItemArray[n] = cTabItem;
        System.arraycopy(this.items, n, cTabItemArray, n + 1, this.items.length - n);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n2 = 0;
        int n3 = this.priority.length;
        int n4 = 0;
        while (n4 < this.priority.length) {
            if (!this.mru && this.priority[n4] == n) {
                n3 = n2++;
            }
            nArray[n2++] = this.priority[n4] >= n ? this.priority[n4] + 1 : this.priority[n4];
            ++n4;
        }
        nArray[n3] = n;
        this.priority = nArray;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n = this.indexOf(cTabItem);
        if (n == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            this.setButtonBounds();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        System.arraycopy(this.items, n + 1, cTabItemArray, n, this.items.length - n - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.priority.length) {
            if (this.priority[n3] != n) {
                nArray[n2++] = this.priority[n3] > n ? this.priority[n3] - 1 : this.priority[n3];
            }
            ++n3;
        }
        this.priority = nArray;
        if (this.selectedIndex == n) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n4 = this.mru ? this.priority[0] : Math.max(0, n - 1);
            this.setSelection(n4, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    void drawBackground(GC gC, int[] nArray, boolean bl) {
        Color color = bl ? this.selectionBackground : this.getBackground();
        Image image = bl ? this.selectionBgImage : this.bgImage;
        Color[] colorArray = bl ? this.selectionGradientColors : this.gradientColors;
        int[] nArray2 = bl ? this.selectionGradientPercents : this.gradientPercents;
        boolean bl2 = bl ? this.selectionGradientVertical : this.gradientVertical;
        Point point = this.getSize();
        int n = point.x;
        int n2 = this.tabHeight + this.highlight_header;
        int n3 = 0;
        if (this.borderLeft > 0) {
            ++n3;
            n -= 2;
        }
        int n4 = this.onBottom ? point.y - this.borderBottom - n2 : this.borderTop;
        this.drawBackground(gC, nArray, n3, n4, n, n2, color, image, colorArray, nArray2, bl2);
    }

    void drawBackground(GC gC, int[] nArray, int n, int n2, int n3, int n4, Color color, Image image, Color[] colorArray, int[] nArray2, boolean bl) {
        Region region = new Region();
        gC.getClipping(region);
        Region region2 = new Region();
        region2.add(nArray);
        region2.intersect(region);
        gC.setClipping(region2);
        if (image != null) {
            gC.setBackground(color);
            gC.fillRectangle(n, n2, n3, n4);
            Rectangle rectangle = image.getBounds();
            gC.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2, n3, n4);
        } else if (colorArray != null) {
            if (colorArray.length == 1) {
                Color color2 = colorArray[0] != null ? colorArray[0] : color;
                gC.setBackground(color2);
                gC.fillRectangle(n, n2, n3, n4);
            } else if (bl) {
                if (this.onBottom) {
                    Color color3;
                    int n5 = 0;
                    if (nArray2[nArray2.length - 1] < 100) {
                        n5 = nArray2[nArray2.length - 1] * n4 / 100;
                        gC.setBackground(color);
                        gC.fillRectangle(n, n2, n3, n5);
                    }
                    if ((color3 = colorArray[colorArray.length - 1]) == null) {
                        color3 = color;
                    }
                    int n6 = nArray2.length - 1;
                    while (n6 >= 0) {
                        gC.setForeground(color3);
                        color3 = colorArray[n6];
                        if (color3 == null) {
                            color3 = color;
                        }
                        gC.setBackground(color3);
                        int n7 = nArray2[n6] * n4 / 100;
                        gC.fillGradientRectangle(n, n2 + n5, n3, n7, true);
                        n5 += n7;
                        --n6;
                    }
                } else {
                    Color color4 = colorArray[0];
                    if (color4 == null) {
                        color4 = color;
                    }
                    int n8 = 0;
                    int n9 = 0;
                    while (n9 < nArray2.length) {
                        gC.setForeground(color4);
                        color4 = colorArray[n9 + 1];
                        if (color4 == null) {
                            color4 = color;
                        }
                        gC.setBackground(color4);
                        int n10 = nArray2[n9] * n4 / 100;
                        gC.fillGradientRectangle(n, n2 + n8, n3, n10, true);
                        n8 += n10;
                        ++n9;
                    }
                    if (n8 < n4) {
                        gC.setBackground(color);
                        gC.fillRectangle(n, n8, n3, n4 - n8 + 1);
                    }
                }
            } else {
                n2 = 0;
                n4 = this.getSize().y;
                Color color5 = colorArray[0];
                if (color5 == null) {
                    color5 = color;
                }
                int n11 = 0;
                int n12 = 0;
                while (n12 < nArray2.length) {
                    gC.setForeground(color5);
                    color5 = colorArray[n12 + 1];
                    if (color5 == null) {
                        color5 = color;
                    }
                    gC.setBackground(color5);
                    int n13 = nArray2[n12] * n3 / 100 - n11;
                    gC.fillGradientRectangle(n + n11, n2, n13, n4, false);
                    n11 += n13;
                    ++n12;
                }
                if (n11 < n3) {
                    gC.setBackground(color);
                    gC.fillRectangle(n + n11, n2, n3 - n11, n4);
                }
            }
        } else if ((this.getStyle() & 0x40000) != 0 || !color.equals(this.getBackground())) {
            gC.setBackground(color);
            gC.fillRectangle(n, n2, n3, n4);
        }
        gC.setClipping(region);
        region.dispose();
        region2.dispose();
    }

    void drawBody(Event event) {
        int n;
        int n2;
        int n3;
        GC gC = event.gc;
        Point point = this.getSize();
        if (!this.minimized) {
            n3 = point.x - this.borderLeft - this.borderRight - 2 * this.highlight_margin;
            n2 = point.y - this.borderTop - this.borderBottom - this.tabHeight - this.highlight_header - this.highlight_margin;
            if (this.highlight_margin > 0) {
                int[] nArray = null;
                if (this.onBottom) {
                    n = this.borderLeft;
                    int n4 = this.borderTop;
                    int n5 = point.x - this.borderRight;
                    int n6 = point.y - this.borderBottom - this.tabHeight - this.highlight_header;
                    nArray = new int[]{n, n4, n5, n4, n5, n6, n5 - this.highlight_margin, n6, n5 - this.highlight_margin, n4 + this.highlight_margin, n + this.highlight_margin, n4 + this.highlight_margin, n + this.highlight_margin, n6, n, n6};
                } else {
                    n = this.borderLeft;
                    int n7 = this.borderTop + this.tabHeight + this.highlight_header;
                    int n8 = point.x - this.borderRight;
                    int n9 = point.y - this.borderBottom;
                    nArray = new int[]{n, n7, n + this.highlight_margin, n7, n + this.highlight_margin, n9 - this.highlight_margin, n8 - this.highlight_margin, n9 - this.highlight_margin, n8 - this.highlight_margin, n7, n8, n7, n8, n9, n, n9};
                }
                if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                    this.drawBackground(gC, nArray, true);
                } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                    this.drawBackground(gC, nArray, false);
                } else {
                    gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                    gC.fillPolygon(nArray);
                }
            }
            if ((this.getStyle() & 0x40000) != 0) {
                gC.setBackground(this.getBackground());
                gC.fillRectangle(this.xClient - this.marginWidth, this.yClient - this.marginHeight, n3, n2);
            }
        } else if ((this.getStyle() & 0x40000) != 0 && point.y > (n3 = this.borderTop + this.tabHeight + this.highlight_header + this.borderBottom)) {
            gC.setBackground(this.getParent().getBackground());
            gC.fillRectangle(0, n3, point.x, point.y - n3);
        }
        if (this.borderLeft > 0) {
            gC.setForeground(borderColor);
            n3 = this.borderLeft - 1;
            n2 = point.x - this.borderRight;
            int n10 = this.onBottom ? this.borderTop - 1 : this.borderTop + this.tabHeight;
            n = this.onBottom ? point.y - this.tabHeight - this.borderBottom - 1 : point.y - this.borderBottom;
            gC.drawLine(n3, n10, n3, n);
            gC.drawLine(n2, n10, n2, n);
            if (this.onBottom) {
                gC.drawLine(n3, n10, n2, n10);
            } else {
                gC.drawLine(n3, n, n2, n);
            }
        }
    }

    void drawChevron(GC gC) {
        int n;
        if (this.chevronRect.width == 0 || this.chevronRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        Point point = display.getDPI();
        int n2 = 720 / point.y;
        FontData fontData = this.getFont().getFontData()[0];
        fontData.setHeight(n2);
        Font font = new Font((Device)display, fontData);
        int n3 = font.getFontData()[0].getHeight() * point.y / 72;
        int n4 = Math.max(2, (this.chevronRect.height - n3 - 4) / 2);
        int n5 = this.chevronRect.x + 2;
        int n6 = this.chevronRect.y + n4;
        if (this.single) {
            n = this.selectedIndex == -1 ? this.items.length : this.items.length - 1;
        } else {
            int n7 = 0;
            while (n7 < this.priority.length && this.items[this.priority[n7]].showing) {
                ++n7;
            }
            n = this.items.length - n7;
        }
        String string = n > 99 ? "99+" : String.valueOf(n);
        switch (this.chevronImageState) {
            case 1: {
                Color color = this.single ? this.getSelectionForeground() : this.getForeground();
                gC.setForeground(color);
                gC.setFont(font);
                gC.drawLine(n5, n6, n5 + 2, n6 + 2);
                gC.drawLine(n5 + 2, n6 + 2, n5, n6 + 4);
                gC.drawLine(n5 + 1, n6, n5 + 3, n6 + 2);
                gC.drawLine(n5 + 3, n6 + 2, n5 + 1, n6 + 4);
                gC.drawLine(n5 + 4, n6, n5 + 6, n6 + 2);
                gC.drawLine(n5 + 6, n6 + 2, n5 + 5, n6 + 4);
                gC.drawLine(n5 + 5, n6, n5 + 7, n6 + 2);
                gC.drawLine(n5 + 7, n6 + 2, n5 + 4, n6 + 4);
                gC.drawString(string, n5 + 7, n6 + 3, true);
                break;
            }
            case 2: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n5, n6, n5 + 2, n6 + 2);
                gC.drawLine(n5 + 2, n6 + 2, n5, n6 + 4);
                gC.drawLine(n5 + 1, n6, n5 + 3, n6 + 2);
                gC.drawLine(n5 + 3, n6 + 2, n5 + 1, n6 + 4);
                gC.drawLine(n5 + 4, n6, n5 + 6, n6 + 2);
                gC.drawLine(n5 + 6, n6 + 2, n5 + 5, n6 + 4);
                gC.drawLine(n5 + 5, n6, n5 + 7, n6 + 2);
                gC.drawLine(n5 + 7, n6 + 2, n5 + 4, n6 + 4);
                gC.drawString(string, n5 + 7, n6 + 3, true);
                break;
            }
            case 3: {
                gC.setForeground(display.getSystemColor(17));
                gC.setBackground(display.getSystemColor(25));
                gC.setFont(font);
                gC.fillRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, 6, 6);
                gC.drawRoundRectangle(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width - 1, this.chevronRect.height - 1, 6, 6);
                gC.drawLine(n5 + 1, n6 + 1, n5 + 3, n6 + 3);
                gC.drawLine(n5 + 3, n6 + 3, n5 + 1, n6 + 5);
                gC.drawLine(n5 + 2, n6 + 1, n5 + 4, n6 + 3);
                gC.drawLine(n5 + 4, n6 + 3, n5 + 2, n6 + 5);
                gC.drawLine(n5 + 5, n6 + 1, n5 + 7, n6 + 3);
                gC.drawLine(n5 + 7, n6 + 3, n5 + 6, n6 + 5);
                gC.drawLine(n5 + 6, n6 + 1, n5 + 8, n6 + 3);
                gC.drawLine(n5 + 8, n6 + 3, n5 + 5, n6 + 5);
                gC.drawString(string, n5 + 8, n6 + 4, true);
            }
        }
        font.dispose();
    }

    void drawMaximize(GC gC) {
        if (this.maxRect.width == 0 || this.maxRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n = this.maxRect.x + 4;
        int n2 = this.maxRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.maxImageState) {
            case 1: {
                if (!this.maximized) {
                    gC.fillRectangle(n, n2, 9, 9);
                    gC.drawRectangle(n, n2, 9, 9);
                    gC.drawLine(n + 1, n2 + 2, n + 8, n2 + 2);
                    break;
                }
                gC.fillRectangle(n, n2 + 3, 5, 4);
                gC.fillRectangle(n + 2, n2, 5, 4);
                gC.drawRectangle(n, n2 + 3, 5, 4);
                gC.drawRectangle(n + 2, n2, 5, 4);
                gC.drawLine(n + 3, n2 + 1, n + 6, n2 + 1);
                gC.drawLine(n + 1, n2 + 4, n + 4, n2 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n, n2, 9, 9);
                    gC.drawRectangle(n, n2, 9, 9);
                    gC.drawLine(n + 1, n2 + 2, n + 8, n2 + 2);
                    break;
                }
                gC.fillRectangle(n, n2 + 3, 5, 4);
                gC.fillRectangle(n + 2, n2, 5, 4);
                gC.drawRectangle(n, n2 + 3, 5, 4);
                gC.drawRectangle(n + 2, n2, 5, 4);
                gC.drawLine(n + 3, n2 + 1, n + 6, n2 + 1);
                gC.drawLine(n + 1, n2 + 4, n + 4, n2 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, 6, 6);
                gC.drawRoundRectangle(this.maxRect.x, this.maxRect.y, this.maxRect.width - 1, this.maxRect.height - 1, 6, 6);
                if (!this.maximized) {
                    gC.fillRectangle(n + 1, n2 + 1, 9, 9);
                    gC.drawRectangle(n + 1, n2 + 1, 9, 9);
                    gC.drawLine(n + 2, n2 + 3, n + 9, n2 + 3);
                    break;
                }
                gC.fillRectangle(n + 1, n2 + 4, 5, 4);
                gC.fillRectangle(n + 3, n2 + 1, 5, 4);
                gC.drawRectangle(n + 1, n2 + 4, 5, 4);
                gC.drawRectangle(n + 3, n2 + 1, 5, 4);
                gC.drawLine(n + 4, n2 + 2, n + 7, n2 + 2);
                gC.drawLine(n + 2, n2 + 5, n + 5, n2 + 5);
            }
        }
    }

    void drawMinimize(GC gC) {
        if (this.minRect.width == 0 || this.minRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n = this.minRect.x + 4;
        int n2 = this.minRect.y + 3;
        gC.setForeground(display.getSystemColor(17));
        gC.setBackground(display.getSystemColor(25));
        switch (this.minImageState) {
            case 1: {
                if (!this.minimized) {
                    gC.fillRectangle(n, n2, 9, 3);
                    gC.drawRectangle(n, n2, 9, 3);
                    break;
                }
                gC.fillRectangle(n, n2 + 3, 5, 4);
                gC.fillRectangle(n + 2, n2, 5, 4);
                gC.drawRectangle(n, n2 + 3, 5, 4);
                gC.drawRectangle(n + 2, n2, 5, 4);
                gC.drawLine(n + 3, n2 + 1, n + 6, n2 + 1);
                gC.drawLine(n + 1, n2 + 4, n + 4, n2 + 4);
                break;
            }
            case 2: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n, n2, 9, 3);
                    gC.drawRectangle(n, n2, 9, 3);
                    break;
                }
                gC.fillRectangle(n, n2 + 3, 5, 4);
                gC.fillRectangle(n + 2, n2, 5, 4);
                gC.drawRectangle(n, n2 + 3, 5, 4);
                gC.drawRectangle(n + 2, n2, 5, 4);
                gC.drawLine(n + 3, n2 + 1, n + 6, n2 + 1);
                gC.drawLine(n + 1, n2 + 4, n + 4, n2 + 4);
                break;
            }
            case 3: {
                gC.fillRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, 6, 6);
                gC.drawRoundRectangle(this.minRect.x, this.minRect.y, this.minRect.width - 1, this.minRect.height - 1, 6, 6);
                if (!this.minimized) {
                    gC.fillRectangle(n + 1, n2 + 1, 9, 3);
                    gC.drawRectangle(n + 1, n2 + 1, 9, 3);
                    break;
                }
                gC.fillRectangle(n + 1, n2 + 4, 5, 4);
                gC.fillRectangle(n + 3, n2 + 1, 5, 4);
                gC.drawRectangle(n + 1, n2 + 4, 5, 4);
                gC.drawRectangle(n + 3, n2 + 1, 5, 4);
                gC.drawLine(n + 4, n2 + 2, n + 7, n2 + 2);
                gC.drawLine(n + 2, n2 + 5, n + 5, n2 + 5);
            }
        }
    }

    void drawTabArea(Event event) {
        int n;
        int n2;
        Object object;
        int[] nArray;
        GC gC = event.gc;
        Point point = this.getSize();
        int[] nArray2 = null;
        if (this.tabHeight == 0) {
            int n3;
            int n4 = this.getStyle();
            if ((n4 & 0x800000) != 0 && (n4 & 0x800) == 0) {
                return;
            }
            int n5 = this.borderLeft - 1;
            int n6 = point.x - this.borderRight;
            int n7 = this.onBottom ? point.y - this.borderBottom - this.highlight_header - 1 : this.borderTop + this.highlight_header;
            int n8 = n3 = this.onBottom ? point.y - this.borderBottom : this.borderTop;
            if (this.borderLeft <= 0 || this.onBottom) {
                // empty if block
            }
            nArray2 = new int[]{n5, n7, n5, --n3, n6, n3, n6, n7};
            if (this.selectedIndex != -1 && this.selectionGradientColors != null && this.selectionGradientColors.length > 1 && !this.selectionGradientVertical) {
                this.drawBackground(gC, nArray2, true);
            } else if (this.selectedIndex == -1 && this.gradientColors != null && this.gradientColors.length > 1 && !this.gradientVertical) {
                this.drawBackground(gC, nArray2, false);
            } else {
                gC.setBackground(this.selectedIndex == -1 ? this.getBackground() : this.selectionBackground);
                gC.fillPolygon(nArray2);
            }
            if (this.borderLeft > 0) {
                gC.setForeground(borderColor);
                gC.drawPolyline(nArray2);
            }
            return;
        }
        int n9 = Math.max(0, this.borderLeft - 1);
        int n10 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop;
        int n11 = point.x - this.borderLeft - this.borderRight + 1;
        int n12 = this.tabHeight - 1;
        if (this.onBottom) {
            if ((this.getStyle() & 0x800) != 0) {
                nArray = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
                object = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
            } else {
                nArray = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER_BORDERLESS : BOTTOM_LEFT_CORNER_BORDERLESS;
                object = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER_BORDERLESS : BOTTOM_RIGHT_CORNER_BORDERLESS;
            }
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n2 = 0;
            nArray2[n2++] = n9;
            nArray2[n2++] = n10 - this.highlight_header;
            n = 0;
            while (n < nArray.length / 2) {
                nArray2[n2++] = n9 + nArray[2 * n];
                nArray2[n2++] = n10 + n12 + nArray[2 * n + 1];
                if (this.borderLeft == 0) {
                    int n13 = n2 - 1;
                    nArray2[n13] = nArray2[n13] + 1;
                }
                ++n;
            }
            n = 0;
            while (n < ((int[])object).length / 2) {
                nArray2[n2++] = n9 + n11 + object[2 * n];
                nArray2[n2++] = n10 + n12 + object[2 * n + 1];
                if (this.borderLeft == 0) {
                    int n14 = n2 - 1;
                    nArray2[n14] = nArray2[n14] + 1;
                }
                ++n;
            }
            nArray2[n2++] = n9 + n11;
            nArray2[n2++] = n10 - this.highlight_header;
        } else {
            if ((this.getStyle() & 0x800) != 0) {
                nArray = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
                object = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
            } else {
                nArray = this.simple ? SIMPLE_TOP_LEFT_CORNER_BORDERLESS : TOP_LEFT_CORNER_BORDERLESS;
                object = this.simple ? SIMPLE_TOP_RIGHT_CORNER_BORDERLESS : TOP_RIGHT_CORNER_BORDERLESS;
            }
            nArray2 = new int[nArray.length + ((int[])object).length + 4];
            n2 = 0;
            nArray2[n2++] = n9;
            nArray2[n2++] = n10 + n12 + this.highlight_header + 1;
            n = 0;
            while (n < nArray.length / 2) {
                nArray2[n2++] = n9 + nArray[2 * n];
                nArray2[n2++] = n10 + nArray[2 * n + 1];
                ++n;
            }
            n = 0;
            while (n < ((int[])object).length / 2) {
                nArray2[n2++] = n9 + n11 + object[2 * n];
                nArray2[n2++] = n10 + object[2 * n + 1];
                ++n;
            }
            nArray2[n2++] = n9 + n11;
            nArray2[n2++] = n10 + n12 + this.highlight_header + 1;
        }
        boolean bl = this.single && this.selectedIndex != -1;
        this.drawBackground(gC, nArray2, bl);
        object = new Region();
        ((Region)object).add(new Rectangle(n9, n10, n11 + 1, n12 + 1));
        ((Region)object).subtract(nArray2);
        gC.setBackground(this.getParent().getBackground());
        CTabFolder.fillRegion(gC, (Region)object);
        ((Region)object).dispose();
        if (!this.single) {
            n2 = 0;
            while (n2 < this.items.length) {
                if (n2 != this.selectedIndex && event.getBounds().intersects(this.items[n2].getBounds())) {
                    this.items[n2].onPaint(gC, false);
                }
                ++n2;
            }
        }
        if (this.selectedIndex != -1) {
            CTabItem cTabItem = this.items[this.selectedIndex];
            cTabItem.onPaint(gC, true);
        } else {
            n2 = this.borderLeft;
            n = this.onBottom ? point.y - this.borderBottom - this.tabHeight - 1 : this.borderTop + this.tabHeight;
            int n15 = point.x - this.borderRight;
            gC.setForeground(borderColor);
            gC.drawLine(n2, n, n15, n);
        }
        this.drawChevron(gC);
        this.drawMinimize(gC);
        this.drawMaximize(gC);
        if (this.borderLeft > 0) {
            RGB rGB = this.getParent().getBackground().getRGB();
            this.antialias(nArray2, borderColor.getRGB(), null, rGB, gC);
            gC.setForeground(borderColor);
            gC.drawPolyline(nArray2);
        }
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderLeft == 1;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.minimized) {
            return new Rectangle(this.xClient, this.yClient, 0, 0);
        }
        Point point = this.getSize();
        int n = point.x - this.borderLeft - this.borderRight - 2 * this.marginWidth - 2 * this.highlight_margin;
        int n2 = point.y - this.borderTop - this.borderBottom - 2 * this.marginHeight - this.highlight_margin - this.highlight_header;
        return new Rectangle(this.xClient, this.yClient, n, n2 -= this.tabHeight);
    }

    public CTabItem getItem(int n) {
        if (n < 0 || n >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        Point point2 = this.getSize();
        if (point2.x <= this.borderLeft + this.borderRight) {
            return null;
        }
        if (this.showChevron && this.chevronRect.contains(point)) {
            return null;
        }
        int n = 0;
        while (n < this.priority.length) {
            CTabItem cTabItem = this.items[this.priority[n]];
            Rectangle rectangle = cTabItem.getBounds();
            if (rectangle.contains(point)) {
                return cTabItem;
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return String.valueOf(string.substring(0, n - 1)) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    int getRightItemEdge() {
        int n = this.getSize().x - this.borderRight - 3;
        if (this.showMin) {
            n -= 18;
        }
        if (this.showMax) {
            n -= 18;
        }
        if (this.showChevron) {
            n -= 27;
        }
        if (this.topRight != null && this.topRightAlignment != 4) {
            Point point = this.topRight.computeSize(-1, -1);
            n -= point.x + 3;
        }
        return Math.max(0, n);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFB7F;
        n |= this.onBottom ? 1024 : 128;
        n &= 0xFFFFFFF9;
        n |= this.single ? 4 : 2;
        if (this.borderLeft != 0) {
            n |= 0x800;
        }
        return n;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] == cTabItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.stripMnemonic(CTabFolder.this.items[n].getText());
                } else if (n == CTabFolder.this.items.length + 0) {
                    string = SWT.getMessage("SWT_ShowList");
                } else if (n == CTabFolder.this.items.length + 1) {
                    string = CTabFolder.this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
                } else if (n == CTabFolder.this.items.length + 2) {
                    string = CTabFolder.this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n == -1) {
                    string = CTabFolder.this.getToolTipText();
                } else if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.items[n].getToolTipText();
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length && (string = CTabFolder.this.items[n].getText()) != null && (c = CTabFolder.this._findMnemonic(string)) != '\u0000') {
                    string2 = "Alt+" + c;
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = CTabFolder.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                int n = -2;
                int n2 = 0;
                while (n2 < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[n2].getBounds().contains(point)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n == -2) {
                    if (CTabFolder.this.showChevron && CTabFolder.this.chevronRect.contains(point)) {
                        n = CTabFolder.this.items.length + 0;
                    } else if (CTabFolder.this.showMin && CTabFolder.this.minRect.contains(point)) {
                        n = CTabFolder.this.items.length + 1;
                    } else if (CTabFolder.this.showMax && CTabFolder.this.maxRect.contains(point)) {
                        n = CTabFolder.this.items.length + 2;
                    } else {
                        Rectangle rectangle = CTabFolder.this.getBounds();
                        rectangle.height -= CTabFolder.this.getClientArea().height;
                        if (rectangle.contains(point)) {
                            n = -1;
                        }
                    }
                }
                accessibleControlEvent.childID = n;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = null;
                int n = accessibleControlEvent.childID;
                if (n == -1) {
                    rectangle = CTabFolder.this.getBounds();
                } else if (n >= 0 && n < CTabFolder.this.items.length) {
                    rectangle = CTabFolder.this.items[n].getBounds();
                } else if (CTabFolder.this.showChevron && n == CTabFolder.this.items.length + 0) {
                    rectangle = CTabFolder.this.chevronRect;
                } else if (CTabFolder.this.showMin && n == CTabFolder.this.items.length + 1) {
                    rectangle = CTabFolder.this.minRect;
                } else if (CTabFolder.this.showMax && n == CTabFolder.this.items.length + 2) {
                    rectangle = CTabFolder.this.maxRect;
                }
                if (rectangle != null) {
                    Point point = CTabFolder.this.toDisplay(rectangle.x, rectangle.y);
                    accessibleControlEvent.x = point.x;
                    accessibleControlEvent.y = point.y;
                    accessibleControlEvent.width = rectangle.width;
                    accessibleControlEvent.height = rectangle.height;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = CTabFolder.this.items.length + 3;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                String string = null;
                int n = accessibleControlEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = SWT.getMessage("SWT_Switch");
                }
                if (n >= CTabFolder.this.items.length && n < CTabFolder.this.items.length + 3) {
                    string = SWT.getMessage("SWT_Press");
                }
                accessibleControlEvent.result = string;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                int n = -2;
                if (CTabFolder.this.isFocusControl()) {
                    n = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                accessibleControlEvent.childID = n;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 60;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 37;
                } else if (n2 >= CTabFolder.this.items.length && n2 < CTabFolder.this.items.length + 3) {
                    n = 43;
                }
                accessibleControlEvent.detail = n;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 0;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        n |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == n2) {
                        n |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            n |= 4;
                        }
                    }
                } else if (n2 == CTabFolder.this.items.length + 0) {
                    n = CTabFolder.this.showChevron ? 0 : 32768;
                } else if (n2 == CTabFolder.this.items.length + 1) {
                    n = CTabFolder.this.showMin ? 0 : 32768;
                } else if (n2 == CTabFolder.this.items.length + 2) {
                    n = CTabFolder.this.showMax ? 0 : 32768;
                }
                accessibleControlEvent.detail = n;
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = CTabFolder.this.items.length + 3;
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = new Integer(n2);
                    ++n2;
                }
                accessibleControlEvent.children = objectArray;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n;
                int n2;
                int n3 = this.items.length;
                if (n3 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n4 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n5 = n2 = event.keyCode == n4 ? -1 : 1;
                if (!this.mru) {
                    n = this.selectedIndex + n2;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n6 = 0;
                    int n7 = -1;
                    int n8 = 0;
                    while (n8 < this.items.length) {
                        if (this.items[n8].showing) {
                            if (n8 == this.selectedIndex) {
                                n7 = n6;
                            }
                            nArray[n6++] = n8;
                        }
                        ++n8;
                    }
                    if (n7 + n2 >= 0 && n7 + n2 < n6) {
                        n = nArray[n7 + n2];
                    } else {
                        if (this.showChevron) {
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = this.chevronRect.x;
                            cTabFolderEvent.y = this.chevronRect.y;
                            cTabFolderEvent.width = this.chevronRect.width;
                            cTabFolderEvent.height = this.chevronRect.height;
                            cTabFolderEvent.doit = true;
                            int n9 = 0;
                            while (n9 < this.folderListeners.length) {
                                this.folderListeners[n9].showList(cTabFolderEvent);
                                ++n9;
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(this.chevronRect);
                            }
                        }
                        return;
                    }
                }
                if (n < 0 || n >= n3) {
                    return;
                }
                this.setSelection(n, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] != null) {
                this.items[n2].dispose();
            }
            ++n2;
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.disposeSelectionHighlightGradientColors();
    }

    void onDragDetect(Event event) {
        boolean bl = false;
        if (this.chevronRect.contains(event.x, event.y) || this.minRect.contains(event.x, event.y) || this.maxRect.contains(event.x, event.y)) {
            bl = true;
        } else {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n].closeRect.contains(event.x, event.y)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event) {
        char c = event.character;
        int n = 0;
        while (n < this.items.length) {
            char c2;
            if (this.items[n] != null && (c2 = this._findMnemonic(this.items[n].getText())) != '\u0000' && Character.toLowerCase(c) == c2) {
                this.setSelection(n, true);
                return true;
            }
            ++n;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        int n = event.x;
        int n2 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                if (this.minImageState != 1) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int n3 = 0;
                while (n3 < this.items.length) {
                    CTabItem cTabItem = this.items[n3];
                    if (n3 != this.selectedIndex && cTabItem.closeImageState != 0) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (n3 == this.selectedIndex && cTabItem.closeImageState != 1) {
                        cTabItem.closeImageState = 1;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                if (this.minRect.contains(n, n2)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.minImageState = 3;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    this.update();
                    return;
                }
                if (this.maxRect.contains(n, n2)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.maxImageState = 3;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    this.update();
                    return;
                }
                if (this.chevronRect.contains(n, n2)) {
                    if (event.button != 1) {
                        return;
                    }
                    this.chevronImageState = this.chevronImageState != 2 ? 2 : 3;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    this.update();
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n4 = 0;
                    while (n4 < this.items.length) {
                        Rectangle rectangle = this.items[n4].getBounds();
                        if (rectangle.contains(n, n2)) {
                            cTabItem = this.items[n4];
                        }
                        ++n4;
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n, n2)) {
                    if (event.button != 1) {
                        return;
                    }
                    cTabItem.closeImageState = 3;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n5 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    this.setSelection(n5, true);
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (this.minRect.contains(n, n2)) {
                    bl2 = true;
                    if (this.minImageState != 3 && this.minImageState != 2) {
                        this.minImageState = 2;
                        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    }
                }
                if (this.maxRect.contains(n, n2)) {
                    bl3 = true;
                    if (this.maxImageState != 3 && this.maxImageState != 2) {
                        this.maxImageState = 2;
                        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    }
                }
                if (this.chevronRect.contains(n, n2)) {
                    bl4 = true;
                    if (this.chevronImageState != 3 && this.chevronImageState != 2) {
                        this.chevronImageState = 2;
                        this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                    }
                }
                if (this.minImageState != 1 && !bl2) {
                    this.minImageState = 1;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                }
                if (this.maxImageState != 1 && !bl3) {
                    this.maxImageState = 1;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                }
                if (this.chevronImageState != 1 && !bl4) {
                    this.chevronImageState = 1;
                    this.redraw(this.chevronRect.x, this.chevronRect.y, this.chevronRect.width, this.chevronRect.height, false);
                }
                int n6 = 0;
                while (n6 < this.items.length) {
                    CTabItem cTabItem = this.items[n6];
                    bl = false;
                    if (cTabItem.getBounds().contains(n, n2)) {
                        bl = true;
                        if (cTabItem.closeRect.contains(n, n2)) {
                            if (cTabItem.closeImageState != 3 && cTabItem.closeImageState != 2) {
                                cTabItem.closeImageState = 2;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 1) {
                            cTabItem.closeImageState = 1;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                    }
                    if (n6 != this.selectedIndex && cTabItem.closeImageState != 0 && !bl) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if (n6 == this.selectedIndex && cTabItem.closeImageState != 1 && !bl) {
                        cTabItem.closeImageState = 1;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n6;
                }
                break;
            }
            case 4: {
                Object object;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                if (this.chevronRect.contains(n, n2)) {
                    boolean bl;
                    boolean bl5 = bl = this.chevronImageState == 3;
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = this.chevronRect.x;
                    cTabFolderEvent.y = this.chevronRect.y;
                    cTabFolderEvent.width = this.chevronRect.width;
                    cTabFolderEvent.height = this.chevronRect.height;
                    cTabFolderEvent.doit = true;
                    int n7 = 0;
                    while (n7 < this.folderListeners.length) {
                        this.folderListeners[n7].showList(cTabFolderEvent);
                        ++n7;
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(this.chevronRect);
                    }
                    return;
                }
                if (this.minRect.contains(n, n2)) {
                    boolean bl = this.minImageState == 3;
                    this.minImageState = 2;
                    this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    int n8 = 0;
                    while (n8 < this.folderListeners.length) {
                        if (this.minimized) {
                            this.folderListeners[n8].restore(cTabFolderEvent);
                        } else {
                            this.folderListeners[n8].minimize(cTabFolderEvent);
                        }
                        ++n8;
                    }
                    return;
                }
                if (this.maxRect.contains(n, n2)) {
                    boolean bl = this.maxImageState == 3;
                    this.maxImageState = 2;
                    this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
                    if (!bl) {
                        return;
                    }
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    int n9 = 0;
                    while (n9 < this.folderListeners.length) {
                        if (this.maximized) {
                            this.folderListeners[n9].restore(cTabFolderEvent);
                        } else {
                            this.folderListeners[n9].maximize(cTabFolderEvent);
                        }
                        ++n9;
                    }
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n10 = 0;
                    while (n10 < this.items.length) {
                        serializable = this.items[n10].getBounds();
                        if (serializable.contains(n, n2)) {
                            cTabItem = this.items[n10];
                        }
                        ++n10;
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n, n2)) break;
                boolean bl = cTabItem.closeImageState == 3;
                cTabItem.closeImageState = 2;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                int n11 = 0;
                while (n11 < this.folderListeners.length) {
                    object = this.folderListeners[n11];
                    object.close((CTabFolderEvent)serializable);
                    ++n11;
                }
                n11 = 0;
                while (n11 < this.tabListeners.length) {
                    object = this.tabListeners[n11];
                    object.itemClosed((CTabFolderEvent)serializable);
                    ++n11;
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 3 && cTabItem2.closeImageState != 2) {
                                cTabItem2.closeImageState = 2;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 1) {
                            cTabItem2.closeImageState = 1;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    boolean onPageTraversal(Event event) {
        int n = this.items.length;
        if (n == 0) {
            return false;
        }
        int n2 = this.selectedIndex;
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3;
            int n4 = n3 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n2 = (this.selectedIndex + n3 + n) % n;
            } else {
                int[] nArray = new int[this.items.length];
                int n5 = 0;
                int n6 = -1;
                int n7 = 0;
                while (n7 < this.items.length) {
                    if (this.items[n7].showing) {
                        if (n7 == this.selectedIndex) {
                            n6 = n5;
                        }
                        nArray[n5++] = n7;
                    }
                    ++n7;
                }
                if (n6 + n3 >= 0 && n6 + n3 < n5) {
                    n2 = nArray[n6 + n3];
                } else {
                    if (this.showChevron) {
                        CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                        cTabFolderEvent.widget = this;
                        cTabFolderEvent.time = event.time;
                        cTabFolderEvent.x = this.chevronRect.x;
                        cTabFolderEvent.y = this.chevronRect.y;
                        cTabFolderEvent.width = this.chevronRect.width;
                        cTabFolderEvent.height = this.chevronRect.height;
                        cTabFolderEvent.doit = true;
                        int n8 = 0;
                        while (n8 < this.folderListeners.length) {
                            this.folderListeners[n8].showList(cTabFolderEvent);
                            ++n8;
                        }
                        if (cTabFolderEvent.doit && !this.isDisposed()) {
                            this.showList(this.chevronRect);
                        }
                    }
                    return true;
                }
            }
        }
        this.setSelection(n2, true);
        return true;
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        this.drawBody(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.drawTabArea(event);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize() {
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n = Math.min(point.x, this.oldSize.x);
            if (point.x != this.oldSize.x) {
                n -= this.borderRight + this.highlight_margin + 2;
            }
            if (!this.simple) {
                n -= 5;
            }
            int n2 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n2 -= this.borderBottom + this.highlight_margin;
            }
            int n3 = Math.max(point.x, this.oldSize.x);
            int n4 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n2, n3, n4 - n2, false);
            this.redraw(n, 0, n3 - n, n4, false);
        }
        this.oldSize = point;
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event);
                if (!event.doit) break;
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        if (this.onBottom) {
            this.redraw(0, point.y - this.borderBottom - this.tabHeight - this.highlight_header - 1, point.x, this.borderBottom + this.tabHeight + this.highlight_header + 1, false);
        } else {
            this.redraw(0, 0, point.x, this.borderTop + this.tabHeight + this.highlight_header + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.folderListeners.length) {
            if (cTabFolder2Listener == this.folderListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n);
        System.arraycopy(this.folderListeners, n + 1, cTabFolder2ListenerArray, n, this.folderListeners.length - n - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.tabListeners.length) {
            if (cTabFolderListener == this.tabListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n);
        System.arraycopy(this.tabListeners, n + 1, cTabFolderListenerArray, n, this.tabListeners.length - n - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
    }

    void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            n = 0;
            while (n < nArray.length) {
                if (nArray[n] < 0 || nArray[n] > 100) {
                    SWT.error(5);
                }
                if (n > 0 && nArray[n] < nArray[n - 1]) {
                    SWT.error(5);
                }
                ++n;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.bgImage == null) {
            if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
                n = 0;
                int n2 = 0;
                while (n2 < this.gradientColors.length) {
                    n = this.gradientColors[n2] == null ? (colorArray[n2] == null ? 1 : 0) : (int)(this.gradientColors[n2].equals(colorArray[n2]) ? 1 : 0);
                    if (n == 0) break;
                    ++n2;
                }
                if (n != 0) {
                    n2 = 0;
                    while (n2 < this.gradientPercents.length) {
                        int n3 = n = this.gradientPercents[n2] == nArray[n2] ? 1 : 0;
                        if (n == 0) break;
                        ++n2;
                    }
                }
                if (n != 0 && this.gradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.bgImage = null;
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground((Color)null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            n = 0;
            while (n < colorArray.length) {
                this.gradientColors[n] = colorArray[n];
                ++n;
            }
            this.gradientPercents = new int[nArray.length];
            n = 0;
            while (n < nArray.length) {
                this.gradientPercents[n] = nArray[n];
                ++n;
            }
            this.gradientVertical = bl;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    void setBackground(Image image) {
        this.checkWidget();
        if (image == this.bgImage) {
            return;
        }
        if (image != null) {
            this.gradientColors = null;
            this.gradientPercents = null;
        }
        this.bgImage = image;
        this.redraw();
    }

    public void setBorderVisible(boolean bl) {
        this.checkWidget();
        if (this.borderLeft == 1 == bl) {
            return;
        }
        this.borderRight = bl ? 1 : 0;
        this.borderLeft = this.borderRight;
        this.borderTop = this.onBottom ? this.borderLeft : 0;
        this.borderBottom = this.onBottom ? 0 : this.borderLeft;
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds() {
        int n;
        int n2;
        int n3;
        Point point = this.getSize();
        int n4 = this.maxRect.x;
        int n5 = this.maxRect.y;
        int n6 = this.maxRect.width;
        int n7 = this.maxRect.height;
        this.maxRect.height = 0;
        this.maxRect.width = 0;
        this.maxRect.y = 0;
        this.maxRect.x = 0;
        if (this.showMax) {
            this.maxRect.x = point.x - this.borderRight - 18 - 3;
            if (this.borderRight > 0) {
                ++this.maxRect.x;
            }
            this.maxRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.maxRect.width = 18;
            this.maxRect.height = 18;
        }
        if (n4 != this.maxRect.x || n6 != this.maxRect.width || n5 != this.maxRect.y || n7 != this.maxRect.height) {
            n3 = Math.min(n4, this.maxRect.x);
            n2 = Math.max(n4 + n6, this.maxRect.x + this.maxRect.width);
            n = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n3, n, n2 - n3, this.tabHeight, false);
        }
        n4 = this.minRect.x;
        n5 = this.minRect.y;
        n6 = this.minRect.width;
        n7 = this.minRect.height;
        this.minRect.height = 0;
        this.minRect.width = 0;
        this.minRect.y = 0;
        this.minRect.x = 0;
        if (this.showMin) {
            this.minRect.x = point.x - this.borderRight - this.maxRect.width - 18 - 3;
            if (this.borderRight > 0) {
                ++this.minRect.x;
            }
            this.minRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
            this.minRect.width = 18;
            this.minRect.height = 18;
        }
        if (n4 != this.minRect.x || n6 != this.minRect.width || n5 != this.minRect.y || n7 != this.minRect.height) {
            n3 = Math.min(n4, this.minRect.x);
            n2 = Math.max(n4 + n6, this.minRect.x + this.minRect.width);
            n = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n3, n, n2 - n3, this.tabHeight, false);
        }
        n4 = this.topRightRect.x;
        n5 = this.topRightRect.y;
        n6 = this.topRightRect.width;
        n7 = this.topRightRect.height;
        this.topRightRect.height = 0;
        this.topRightRect.width = 0;
        this.topRightRect.y = 0;
        this.topRightRect.x = 0;
        if (this.topRight != null) {
            switch (this.topRightAlignment) {
                case 4: {
                    n3 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n3 -= 2;
                    }
                    if (this.single) {
                        if (this.items.length == 0 || this.selectedIndex == -1) {
                            this.topRightRect.x = this.borderLeft + 3;
                            this.topRightRect.width = n3 - this.topRightRect.x;
                        } else {
                            CTabItem cTabItem = this.items[this.selectedIndex];
                            if (cTabItem.x + cTabItem.width + 7 + 27 >= n3) break;
                            this.topRightRect.x = cTabItem.x + cTabItem.width + 7 + 27;
                            this.topRightRect.width = n3 - this.topRightRect.x;
                        }
                    } else {
                        if (this.showChevron) break;
                        if (this.items.length == 0) {
                            this.topRightRect.x = this.borderLeft + 3;
                        } else {
                            CTabItem cTabItem = this.items[this.items.length - 1];
                            this.topRightRect.x = cTabItem.x + cTabItem.width;
                            if (!this.simple && this.items.length - 1 == this.selectedIndex) {
                                this.topRightRect.x += this.curveWidth - this.curveIndent;
                            }
                        }
                        this.topRightRect.width = Math.max(0, n3 - this.topRightRect.x);
                    }
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                    break;
                }
                case 131072: {
                    Point point2 = this.topRight.computeSize(-1, this.tabHeight, false);
                    n2 = point.x - this.borderRight - 3 - this.maxRect.width - this.minRect.width;
                    if (!(this.simple || this.borderRight <= 0 || this.showMax || this.showMin)) {
                        n2 -= 2;
                    }
                    this.topRightRect.x = n2 - point2.x;
                    this.topRightRect.width = point2.x;
                    this.topRightRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
                    this.topRightRect.height = this.tabHeight - 1;
                }
            }
            this.topRight.setBounds(this.topRightRect);
        }
        if (n4 != this.topRightRect.x || n6 != this.topRightRect.width || n5 != this.topRightRect.y || n7 != this.topRightRect.height) {
            int n8 = Math.min(n4, this.topRightRect.x);
            int n9 = Math.max(n4 + n6, this.topRightRect.x + this.topRightRect.width);
            n = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n8, n, n9 - n8, this.tabHeight, false);
        }
        n4 = this.chevronRect.x;
        n5 = this.chevronRect.y;
        n6 = this.chevronRect.width;
        n7 = this.chevronRect.height;
        this.chevronRect.width = 0;
        this.chevronRect.height = 0;
        this.chevronRect.y = 0;
        this.chevronRect.x = 0;
        if (this.single) {
            if (this.selectedIndex == -1 || this.items.length > 1) {
                this.chevronRect.width = 27;
                this.chevronRect.height = 18;
                int n10 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
                if (this.selectedIndex == -1) {
                    this.chevronRect.x = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.topRightRect.width - this.chevronRect.width;
                } else {
                    CTabItem cTabItem = this.items[this.selectedIndex];
                    int n11 = point.x - this.borderRight - 3 - this.minRect.width - this.maxRect.width - this.chevronRect.width;
                    if (this.topRightRect.width > 0) {
                        n11 -= this.topRightRect.width + 3;
                    }
                    this.chevronRect.x = Math.min(cTabItem.x + cTabItem.width + 3, n11);
                }
                if (this.borderRight > 0) {
                    ++this.chevronRect.x;
                }
            }
        } else if (this.showChevron) {
            this.chevronRect.width = 27;
            this.chevronRect.height = 18;
            int n12 = 0;
            int n13 = -1;
            while (n12 < this.priority.length && this.items[this.priority[n12]].showing) {
                n13 = Math.max(n13, this.priority[n12++]);
            }
            if (n13 == -1) {
                n13 = this.firstIndex;
            }
            CTabItem cTabItem = this.items[n13];
            int n14 = cTabItem.x + cTabItem.width + 3;
            if (!this.simple && n13 == this.selectedIndex) {
                n14 += this.curveWidth - 2 * this.curveIndent;
            }
            this.chevronRect.x = Math.min(n14, this.getRightItemEdge());
            int n15 = this.chevronRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - this.chevronRect.height) / 2 : this.borderTop + (this.tabHeight - this.chevronRect.height) / 2;
        }
        if (n4 != this.chevronRect.x || n6 != this.chevronRect.width || n5 != this.chevronRect.y || n7 != this.chevronRect.height) {
            int n16 = Math.min(n4, this.chevronRect.x);
            int n17 = Math.max(n4 + n6, this.chevronRect.x + this.chevronRect.width);
            int n18 = this.onBottom ? point.y - this.borderBottom - this.tabHeight : this.borderTop + 1;
            this.redraw(n16, n18, n17 - n16, this.tabHeight, false);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl) {
        this.checkWidget();
    }

    public void setInsertMark(int n, boolean bl) {
        this.checkWidget();
        if (n < -1 || n >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation() {
        int n;
        boolean bl = false;
        if (this.items.length == 0) {
            return false;
        }
        Point point = this.getSize();
        int n2 = n = this.onBottom ? Math.max(this.borderBottom, point.y - this.borderBottom - this.tabHeight) : this.borderTop;
        if (this.single) {
            int n3 = this.getDisplay().getBounds().width + 10;
            int n4 = 0;
            while (n4 < this.items.length) {
                CTabItem cTabItem = this.items[n4];
                if (n4 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n5 = cTabItem.x;
                    int n6 = cTabItem.y;
                    cTabItem.x = this.borderLeft;
                    cTabItem.y = n;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = this.borderLeft + 4;
                        int n7 = cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    }
                    if (cTabItem.x != n5 || cTabItem.y != n6) {
                        bl = true;
                    }
                } else {
                    cTabItem.x = n3;
                    cTabItem.showing = false;
                }
                ++n4;
            }
        } else {
            int n8 = this.getRightItemEdge();
            int n9 = n8 - this.borderLeft;
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.priority.length) {
                CTabItem cTabItem = this.items[this.priority[n11]];
                boolean bl2 = n11 == 0 ? true : (cTabItem.showing = cTabItem.width > 0 && (n10 += cTabItem.width) <= n9);
                if (!this.simple && this.priority[n11] == this.selectedIndex) {
                    n10 += this.curveWidth - 2 * this.curveIndent;
                }
                ++n11;
            }
            n11 = 0;
            int n12 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            int n13 = 0;
            while (n13 < this.items.length) {
                CTabItem cTabItem = this.items[n13];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n12) {
                        bl = true;
                    }
                    cTabItem.x = n12;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, n13);
                    if (cTabItem.x != n11 || cTabItem.y != n) {
                        bl = true;
                    }
                    cTabItem.x = n11;
                    cTabItem.y = n;
                    if (n13 == this.selectedIndex) {
                        int n14 = Math.min(cTabItem.x + cTabItem.width, n8);
                        cTabItem.closeRect.x = n14 - 4 - 18;
                    } else {
                        cTabItem.closeRect.x = cTabItem.x + cTabItem.width - 4 - 18;
                    }
                    cTabItem.closeRect.y = this.onBottom ? point.y - this.borderBottom - this.tabHeight + (this.tabHeight - 18) / 2 : this.borderTop + (this.tabHeight - 18) / 2;
                    n11 += cTabItem.width;
                    if (!this.simple && n13 == this.selectedIndex) {
                        n11 += this.curveWidth - 2 * this.curveIndent;
                    }
                }
                ++n13;
            }
        }
        return bl;
    }

    boolean setItemSize() {
        int n;
        int[] nArray;
        boolean bl = false;
        if (this.isDisposed()) {
            return bl;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl;
        }
        this.xClient = this.borderLeft + this.marginWidth + this.highlight_margin;
        this.yClient = this.onBottom ? this.borderTop + this.highlight_margin + this.marginHeight : this.borderTop + this.tabHeight + this.highlight_header + this.marginHeight;
        this.showChevron = false;
        if (this.single) {
            this.showChevron = true;
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                GC gC = new GC(this);
                int n2 = cTabItem.preferredWidth(gC, true, false);
                gC.dispose();
                n2 = Math.min(n2, this.getRightItemEdge() - this.borderLeft);
                if (cTabItem.height != this.tabHeight || cTabItem.width != n2) {
                    bl = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n2;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.width = 18;
                        cTabItem.closeRect.height = 18;
                    }
                }
            }
            return bl;
        }
        if (this.items.length == 0) {
            return bl;
        }
        GC gC = new GC(this);
        int n3 = point.x - this.borderLeft - this.borderRight - 3;
        if (this.showMin) {
            n3 -= 18;
        }
        if (this.showMax) {
            n3 -= 18;
        }
        if (this.topRightAlignment == 131072 && this.topRight != null) {
            Point point2 = this.topRight.computeSize(-1, -1, false);
            n3 -= point2.x + 3;
        }
        if (!this.simple) {
            n3 -= this.curveWidth - 2 * this.curveIndent;
        }
        n3 = Math.max(0, n3);
        int n4 = 0;
        int[] nArray2 = new int[this.items.length];
        int n5 = 0;
        while (n5 < this.priority.length) {
            int n6 = this.priority[n5];
            nArray2[n6] = this.items[n6].preferredWidth(gC, n6 == this.selectedIndex, true);
            if ((n4 += nArray2[n6]) > n3) break;
            ++n5;
        }
        if (n4 > n3) {
            boolean bl2 = this.showChevron = this.items.length > 1;
            if (this.showChevron) {
                n3 -= 27;
            }
            nArray = nArray2;
            int n7 = n5 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n3 < nArray[n5]) {
                nArray[n5] = Math.max(0, n3);
            }
        } else {
            n5 = 0;
            int[] nArray3 = new int[this.items.length];
            n = 0;
            while (n < this.items.length) {
                nArray3[n] = this.items[n].preferredWidth(gC, n == this.selectedIndex, false);
                n5 += nArray3[n];
                ++n;
            }
            if (n5 <= n3) {
                nArray = nArray3;
            } else {
                int n8;
                n = (n3 - n4) / this.items.length;
                while (true) {
                    n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < this.items.length) {
                        if (nArray3[n10] > nArray2[n10] + n) {
                            n9 += nArray2[n10] + n;
                            ++n8;
                        } else {
                            n9 += nArray3[n10];
                        }
                        ++n10;
                    }
                    if (n9 >= n3) {
                        --n;
                        break;
                    }
                    if (n8 == 0 || n3 - n9 < n8) break;
                    ++n;
                }
                nArray = new int[this.items.length];
                n8 = 0;
                while (n8 < this.items.length) {
                    nArray[n8] = Math.min(nArray3[n8], nArray2[n8] + n);
                    ++n8;
                }
            }
        }
        gC.dispose();
        n5 = 0;
        while (n5 < this.items.length) {
            CTabItem cTabItem = this.items[n5];
            n = nArray[n5];
            if (cTabItem.height != this.tabHeight || cTabItem.width != n) {
                bl = true;
                cTabItem.shortenedText = null;
                cTabItem.shortenedTextWidth = 0;
                cTabItem.height = this.tabHeight;
                cTabItem.width = n;
                cTabItem.closeRect.height = 0;
                cTabItem.closeRect.width = 0;
                if ((this.showClose || cTabItem.showClose) && (n5 == this.selectedIndex || this.showUnselectedClose)) {
                    cTabItem.closeRect.width = 18;
                    cTabItem.closeRect.height = 18;
                }
            }
            ++n5;
        }
        return bl;
    }

    public void setMaximizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMax == bl) {
            return;
        }
        this.showMax = bl;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        if (this.maximized == bl) {
            return;
        }
        if (bl && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl;
        this.redraw(this.maxRect.x, this.maxRect.y, this.maxRect.width, this.maxRect.height, false);
    }

    public void setMinimizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMin == bl) {
            return;
        }
        this.showMin = bl;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        if (bl && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl;
        this.redraw(this.minRect.x, this.minRect.y, this.minRect.width, this.minRect.height, false);
    }

    public void setMinimumCharacters(int n) {
        this.checkWidget();
        if (n < 0) {
            SWT.error(6);
        }
        if (this.minChars == n) {
            return;
        }
        this.minChars = n;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean bl) {
        this.checkWidget();
        if (this.mru == bl) {
            return;
        }
        this.mru = bl;
        if (!this.mru) {
            int n = this.firstIndex;
            int n2 = 0;
            int n3 = this.firstIndex;
            while (n3 < this.items.length) {
                this.priority[n2++] = n3++;
            }
            n3 = 0;
            while (n3 < n) {
                this.priority[n2++] = n3++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n = this.indexOf(cTabItem);
        this.setSelection(n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n];
        if (this.selectedIndex == n) {
            this.showItem(cTabItem);
            return;
        }
        int n2 = this.selectedIndex;
        this.selectedIndex = n;
        if (n2 != -1) {
            this.items[n2].closeImageState = 0;
        }
        cTabItem.closeImageState = 1;
        cTabItem.showing = false;
        Control control = cTabItem.control;
        if (control != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        if (n2 != -1 && (control = this.items[n2].control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n, boolean bl) {
        int n2 = this.selectedIndex;
        this.setSelection(n);
        if (bl && this.selectedIndex != n2 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        int n2;
        this.checkWidget();
        Color color = null;
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1 && nArray.length != colorArray.length - 2) {
                SWT.error(5);
            }
            n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 > 0 && nArray[n2] < nArray[n2 - 1]) {
                    SWT.error(5);
                }
                ++n2;
            }
            if (nArray.length == colorArray.length - 2) {
                color = colorArray[colorArray.length - 1];
                n = colorArray.length - 1;
            } else {
                n = colorArray.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[n - 1]};
                n = colorArray.length;
                nArray = new int[]{};
            }
        } else {
            n = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == n) {
                n2 = 0;
                int n3 = 0;
                while (n3 < this.selectionGradientColors.length) {
                    n2 = this.selectionGradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.selectionGradientColors[n3].equals(colorArray[n3]) ? 1 : 0);
                    if (n2 == 0) break;
                    ++n3;
                }
                if (n2 != 0) {
                    n3 = 0;
                    while (n3 < this.selectionGradientPercents.length) {
                        int n4 = n2 = this.selectionGradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                        ++n3;
                    }
                }
                if (n2 != 0 && this.selectionGradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[n];
            n2 = 0;
            while (n2 < n) {
                this.selectionGradientColors[n2] = colorArray[n2];
                ++n2;
            }
            this.selectionGradientPercents = new int[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                this.selectionGradientPercents[n2] = nArray[n2];
                ++n2;
            }
            this.selectionGradientVertical = bl;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(color);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color color) {
        this.selectionHighlightGradientBegin = null;
        if (color == null) {
            return;
        }
        if (this.getDisplay().getDepth() < 15) {
            return;
        }
        if (this.selectionGradientColors.length < 2) {
            return;
        }
        this.selectionHighlightGradientBegin = color;
        if (!this.isSelectionHighlightColorsCacheHit(color)) {
            this.createSelectionHighlightGradientColors(color);
        }
    }

    boolean isSelectionHighlightColorsCacheHit(Color color) {
        if (this.selectionHighlightGradientColorsCache == null) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length < 2) {
            return false;
        }
        Color color2 = this.selectionHighlightGradientColorsCache[0];
        Color color3 = this.selectionHighlightGradientColorsCache[this.selectionHighlightGradientColorsCache.length - 1];
        if (!color2.equals(color)) {
            return false;
        }
        if (this.selectionHighlightGradientColorsCache.length != this.tabHeight) {
            return false;
        }
        return color3.equals(this.selectionBackground);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void createSelectionHighlightGradientColors(Color color) {
        this.disposeSelectionHighlightGradientColors();
        if (color == null) {
            return;
        }
        int n = this.tabHeight;
        RGB rGB = color.getRGB();
        RGB rGB2 = this.selectionBackground.getRGB();
        this.selectionHighlightGradientColorsCache = new Color[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 - n3;
            int n5 = n3;
            int n6 = (rGB2.red * n5 + rGB.red * n4) / n2;
            int n7 = (rGB2.green * n5 + rGB.green * n4) / n2;
            int n8 = (rGB2.blue * n5 + rGB.blue * n4) / n2;
            this.selectionHighlightGradientColorsCache[n3] = new Color(this.getDisplay(), n6, n7, n8);
            ++n3;
        }
    }

    void disposeSelectionHighlightGradientColors() {
        if (this.selectionHighlightGradientColorsCache == null) {
            return;
        }
        int n = 0;
        while (n < this.selectionHighlightGradientColorsCache.length) {
            this.selectionHighlightGradientColorsCache[n].dispose();
            ++n;
        }
        this.selectionHighlightGradientColorsCache = null;
    }

    Color getSelectionBackgroundGradientBegin() {
        if (this.selectionGradientColors == null) {
            return this.getSelectionBackground();
        }
        if (this.selectionGradientColors.length == 0) {
            return this.getSelectionBackground();
        }
        return this.selectionGradientColors[0];
    }

    public void setSimple(boolean bl) {
        this.checkWidget();
        if (this.simple != bl) {
            this.simple = bl;
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean bl) {
        this.checkWidget();
        if (this.single != bl) {
            this.single = bl;
            if (!bl) {
                int n = 0;
                while (n < this.items.length) {
                    if (n != this.selectedIndex && this.items[n].closeImageState == 1) {
                        this.items[n].closeImageState = 0;
                    }
                    ++n;
                }
            }
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTabHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n == 1024)) {
            this.onBottom = n == 1024;
            this.borderTop = this.onBottom ? this.borderLeft : 0;
            this.borderBottom = this.onBottom ? 0 : this.borderRight;
            this.updateTabHeight(true);
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n) {
        this.checkWidget();
        if (n != 131072 && n != 4) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        this.topRight = control;
        this.topRightAlignment = n;
        if (this.updateItems()) {
            this.redraw();
        }
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedClose == bl) {
            return;
        }
        this.showUnselectedClose = bl;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedImage == bl) {
            return;
        }
        this.showUnselectedImage = bl;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem cTabItem) {
        int n;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.priority.length) {
            if (this.priority[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n2);
            System.arraycopy(this.priority, n2 + 1, nArray, n2 + 1, this.priority.length - n2 - 1);
            nArray[0] = n;
            this.priority = nArray;
        }
        if (cTabItem.isShowing()) {
            return;
        }
        this.updateItems(n);
        this.redrawTabs();
    }

    void showList(Rectangle rectangle) {
        Object object;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            int n = 0;
            while (n < menuItemArray.length) {
                menuItemArray[n].dispose();
                ++n;
            }
        }
        int n = 0;
        while (n < this.items.length) {
            CTabItem cTabItem = this.items[n];
            if (!cTabItem.showing) {
                object = new MenuItem(this.showMenu, 0);
                ((MenuItem)object).setText(cTabItem.getText());
                ((Item)object).setImage(cTabItem.getImage());
                ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
                ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.widget;
                        int n = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(n, true);
                    }
                });
            }
            ++n;
        }
        n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n, n2);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n, int n2) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n, n2);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n) {
        int n3;
        if (!this.single && !this.mru && n != -1) {
            int n2;
            n3 = n;
            if (this.priority[0] < n) {
                int n4;
                int n22 = this.getRightItemEdge() - this.borderLeft;
                if (!this.simple) {
                    n4 = n22 - (this.curveWidth - 2 * this.curveIndent);
                }
                n2 = 0;
                int[] nArray = new int[this.items.length];
                GC gC = new GC(this);
                int n5 = this.priority[0];
                while (n5 <= n) {
                    nArray[n5] = this.items[n5].preferredWidth(gC, n5 == this.selectedIndex, true);
                    if ((n2 += nArray[n5]) > n4) break;
                    ++n5;
                }
                if (n2 > n4) {
                    n2 = 0;
                    n5 = n;
                    while (n5 >= 0) {
                        if (nArray[n5] == 0) {
                            nArray[n5] = this.items[n5].preferredWidth(gC, n5 == this.selectedIndex, true);
                        }
                        if ((n2 += nArray[n5]) <= n4) {
                            n3 = n5--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n3 = this.priority[0];
                    n5 = n + 1;
                    while (n5 < this.items.length) {
                        nArray[n5] = this.items[n5].preferredWidth(gC, n5 == this.selectedIndex, true);
                        if ((n2 += nArray[n5]) >= n4) break;
                        ++n5;
                    }
                    if (n2 < n4) {
                        n5 = this.priority[0] - 1;
                        while (n5 >= 0) {
                            if (nArray[n5] == 0) {
                                nArray[n5] = this.items[n5].preferredWidth(gC, n5 == this.selectedIndex, true);
                            }
                            if ((n2 += nArray[n5]) <= n4) {
                                n3 = n5--;
                                continue;
                            }
                            break;
                        }
                    }
                }
                gC.dispose();
            }
            if (n3 != this.priority[0]) {
                boolean bl = false;
                n2 = n3;
                while (n2 < this.items.length) {
                    this.priority[++var3_6] = n2++;
                }
                n2 = 0;
                while (n2 < n3) {
                    this.priority[++var3_7] = n2++;
                }
            }
        }
        n3 = this.showChevron;
        int n7 = this.setItemSize();
        n7 = n7 | this.setItemLocation();
        this.setButtonBounds();
        boolean bl = n7 | this.showChevron ^ n3;
        if (bl && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        return bl;
    }

    boolean updateTabHeight(boolean bl) {
        int n;
        int n2 = this.getStyle();
        if (this.fixedTabHeight == 0 && (n2 & 0x800000) != 0 && (n2 & 0x800) == 0) {
            this.highlight_header = 0;
        }
        int n3 = this.tabHeight;
        if (this.fixedTabHeight != -1) {
            this.tabHeight = this.fixedTabHeight == 0 ? 0 : this.fixedTabHeight + 1;
        } else {
            n = 0;
            GC gC = new GC(this);
            if (this.items.length == 0) {
                n = gC.textExtent((String)"Default", (int)9).y + 2 + 2;
            } else {
                int n4 = 0;
                while (n4 < this.items.length) {
                    n = Math.max(n, this.items[n4].preferredHeight(gC));
                    ++n4;
                }
            }
            gC.dispose();
            this.tabHeight = n;
        }
        if (!bl && this.tabHeight == n3) {
            return false;
        }
        this.oldSize = null;
        if (this.onBottom) {
            n = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[1] = 13 + n;
            nArray[3] = 12 + n;
            nArray[4] = 2;
            nArray[5] = 12 + n;
            nArray[6] = 3;
            nArray[7] = 11 + n;
            nArray[8] = 5;
            nArray[9] = 11 + n;
            nArray[10] = 6;
            nArray[11] = 10 + n;
            nArray[12] = 7;
            nArray[13] = 10 + n;
            nArray[14] = 9;
            nArray[15] = 8 + n;
            nArray[16] = 10;
            nArray[17] = 8 + n;
            nArray[18] = 11;
            nArray[19] = 7 + n;
            nArray[20] = 11 + n;
            nArray[21] = 7;
            nArray[22] = 12 + n;
            nArray[23] = 6;
            nArray[24] = 13 + n;
            nArray[25] = 6;
            nArray[26] = 15 + n;
            nArray[27] = 4;
            nArray[28] = 16 + n;
            nArray[29] = 4;
            nArray[30] = 17 + n;
            nArray[31] = 3;
            nArray[32] = 19 + n;
            nArray[33] = 3;
            nArray[34] = 20 + n;
            nArray[35] = 2;
            nArray[36] = 22 + n;
            nArray[37] = 2;
            nArray[38] = 23 + n;
            nArray[39] = 1;
            this.curve = nArray;
            this.curveWidth = 26 + n;
            this.curveIndent = this.curveWidth / 3;
        } else {
            n = this.tabHeight - 12;
            int[] nArray = new int[40];
            nArray[3] = 1;
            nArray[4] = 2;
            nArray[5] = 1;
            nArray[6] = 3;
            nArray[7] = 2;
            nArray[8] = 5;
            nArray[9] = 2;
            nArray[10] = 6;
            nArray[11] = 3;
            nArray[12] = 7;
            nArray[13] = 3;
            nArray[14] = 9;
            nArray[15] = 5;
            nArray[16] = 10;
            nArray[17] = 5;
            nArray[18] = 11;
            nArray[19] = 6;
            nArray[20] = 11 + n;
            nArray[21] = 6 + n;
            nArray[22] = 12 + n;
            nArray[23] = 7 + n;
            nArray[24] = 13 + n;
            nArray[25] = 7 + n;
            nArray[26] = 15 + n;
            nArray[27] = 9 + n;
            nArray[28] = 16 + n;
            nArray[29] = 9 + n;
            nArray[30] = 17 + n;
            nArray[31] = 10 + n;
            nArray[32] = 19 + n;
            nArray[33] = 10 + n;
            nArray[34] = 20 + n;
            nArray[35] = 11 + n;
            nArray[36] = 22 + n;
            nArray[37] = 11 + n;
            nArray[38] = 23 + n;
            nArray[39] = 12 + n;
            this.curve = nArray;
            this.curveWidth = 26 + n;
            this.curveIndent = this.curveWidth / 3;
            int[] nArray2 = new int[22];
            nArray2[1] = 2;
            nArray2[2] = 1;
            nArray2[3] = 2;
            nArray2[4] = 2;
            nArray2[5] = 2;
            nArray2[6] = 3;
            nArray2[7] = 3;
            nArray2[8] = 4;
            nArray2[9] = 3;
            nArray2[10] = 5;
            nArray2[11] = 3;
            nArray2[12] = 6;
            nArray2[13] = 4;
            nArray2[14] = 7;
            nArray2[15] = 4;
            nArray2[16] = 8;
            nArray2[17] = 5;
            nArray2[18] = 9;
            nArray2[19] = 6;
            nArray2[20] = 10;
            nArray2[21] = 6;
            this.topCurveHighlightStart = nArray2;
            this.topCurveHighlightEnd = new int[]{10 + n, 6 + n, 11 + n, 7 + n, 12 + n, 8 + n, 13 + n, 8 + n, 14 + n, 9 + n, 15 + n, 10 + n, 16 + n, 10 + n, 17 + n, 11 + n, 18 + n, 11 + n, 19 + n, 11 + n, 20 + n, 12 + n, 21 + n, 12 + n, 22 + n, 12 + n};
        }
        this.notifyListeners(11, new Event());
        return true;
    }

    String _getToolTip(int n, int n2) {
        if (this.showMin && this.minRect.contains(n, n2)) {
            return this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize");
        }
        if (this.showMax && this.maxRect.contains(n, n2)) {
            return this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize");
        }
        if (this.showChevron && this.chevronRect.contains(n, n2)) {
            return SWT.getMessage("SWT_ShowList");
        }
        CTabItem cTabItem = this.getItem(new Point(n, n2));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n, n2)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }
}

