/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public final class Cursor
extends Resource {
    public int handle;
    static final byte[] APPSTARTING_SRC;
    static final byte[] APPSTARTING_MASK;

    static {
        byte[] byArray = new byte[128];
        byArray[8] = 4;
        byArray[12] = 12;
        byArray[16] = 28;
        byArray[20] = 60;
        byArray[24] = 124;
        byArray[28] = -4;
        byArray[32] = -4;
        byArray[33] = 1;
        byArray[36] = -4;
        byArray[37] = 59;
        byArray[40] = 124;
        byArray[41] = 56;
        byArray[44] = 108;
        byArray[45] = 84;
        byArray[48] = -60;
        byArray[49] = -36;
        byArray[52] = -64;
        byArray[53] = 68;
        byArray[56] = -128;
        byArray[57] = 57;
        byArray[60] = -128;
        byArray[61] = 57;
        APPSTARTING_SRC = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[4] = 6;
        byArray2[8] = 14;
        byArray2[12] = 30;
        byArray2[16] = 62;
        byArray2[20] = 126;
        byArray2[24] = -2;
        byArray2[28] = -2;
        byArray2[29] = 1;
        byArray2[32] = -2;
        byArray2[33] = 59;
        byArray2[36] = -2;
        byArray2[37] = 127;
        byArray2[40] = -2;
        byArray2[41] = 127;
        byArray2[44] = -2;
        byArray2[45] = -2;
        byArray2[48] = -18;
        byArray2[49] = -1;
        byArray2[50] = 1;
        byArray2[52] = -28;
        byArray2[53] = -1;
        byArray2[56] = -64;
        byArray2[57] = 127;
        byArray2[60] = -64;
        byArray2[61] = 127;
        byArray2[64] = -128;
        byArray2[65] = 57;
        APPSTARTING_MASK = byArray2;
    }

    Cursor() {
    }

    public Cursor(Device device, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int n2 = 0;
        switch (n) {
            case 3: {
                break;
            }
            case 0: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 150;
                break;
            }
            case 21: {
                n2 = 60;
                break;
            }
            case 2: {
                n2 = 30;
                break;
            }
            case 4: {
                n2 = 92;
                break;
            }
            case 5: {
                n2 = 52;
                break;
            }
            case 6: {
                n2 = 120;
                break;
            }
            case 7: {
                n2 = 42;
                break;
            }
            case 8: {
                n2 = 120;
                break;
            }
            case 9: {
                n2 = 108;
                break;
            }
            case 10: {
                n2 = 138;
                break;
            }
            case 11: {
                n2 = 16;
                break;
            }
            case 12: {
                n2 = 96;
                break;
            }
            case 13: {
                n2 = 70;
                break;
            }
            case 14: {
                n2 = 136;
                break;
            }
            case 15: {
                n2 = 14;
                break;
            }
            case 16: {
                n2 = 12;
                break;
            }
            case 17: {
                n2 = 134;
                break;
            }
            case 18: {
                n2 = 114;
                break;
            }
            case 19: {
                n2 = 152;
                break;
            }
            case 20: {
                n2 = 0;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = n2 == 0 && n == 3 ? this.createCursor(APPSTARTING_SRC, APPSTARTING_MASK, 32, 32, 2, 2, true) : OS.XCreateFontCursor(device.xDisplay, n2);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        byte by;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(5);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        imageData = ImageData.convertMask(imageData);
        imageData2 = ImageData.convertMask(imageData2);
        byte[] byArray = new byte[imageData.data.length];
        byte[] byArray2 = new byte[imageData2.data.length];
        byte[] byArray3 = imageData.data;
        int n3 = 0;
        while (n3 < byArray3.length) {
            by = byArray3[n3];
            byArray[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray[n3] = ~byArray[n3];
            ++n3;
        }
        byArray = ImageData.convertPad(byArray, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
        byArray3 = imageData2.data;
        n3 = 0;
        while (n3 < byArray3.length) {
            by = byArray3[n3];
            byArray2[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray2[n3] = ~byArray2[n3];
            ++n3;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        this.handle = this.createCursor(byArray2, byArray, imageData.width, imageData.height, n, n2, true);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData object, int n, int n2) {
        byte[] byArray;
        byte[] byArray2;
        Object object2;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (object == null) {
            SWT.error(4);
        }
        if (n >= ((ImageData)object).width || n < 0 || n2 >= ((ImageData)object).height || n2 < 0) {
            SWT.error(5);
        }
        ImageData imageData = ((ImageData)object).getTransparencyMask();
        if (((ImageData)object).depth > 1) {
            object2 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, 0, 0, 0, 0, 0);
            byte[] byArray3 = new byte[2];
            byArray3[1] = -1;
            byArray2 = byArray3;
            byArray = byArray2;
            byte[] byArray4 = byArray2;
            PaletteData paletteData = ((ImageData)object).palette;
            if (paletteData.isDirect) {
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, ((ImageData)object2).getByteOrder(), 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, byArray2, byArray, byArray4, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                int n3 = rGBArray.length;
                byte[] byArray5 = new byte[n3];
                byte[] byArray6 = new byte[n3];
                byte[] byArray7 = new byte[n3];
                int n4 = 0;
                while (n4 < rGBArray.length) {
                    RGB rGB = rGBArray[n4];
                    if (rGB != null) {
                        byArray5[n4] = (byte)rGB.red;
                        byArray6[n4] = (byte)rGB.green;
                        byArray7[n4] = (byte)rGB.blue;
                    }
                    ++n4;
                }
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, byArray5, byArray6, byArray7, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, ((ImageData)object2).getByteOrder(), 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, byArray2, byArray, byArray4, false, false);
            }
            object = object2;
        }
        object2 = new byte[((ImageData)object).data.length];
        byArray2 = new byte[imageData.data.length];
        byArray = ((ImageData)object).data;
        int n5 = 0;
        while (n5 < byArray.length) {
            byte by = byArray[n5];
            object2[n5] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            ++n5;
        }
        object2 = ImageData.convertPad((byte[])object2, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 1);
        byArray = imageData.data;
        n5 = 0;
        while (n5 < byArray.length) {
            byte by = byArray[n5];
            byArray2[n5] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            ++n5;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
        this.handle = this.createCursor((byte[])object2, byArray2, ((ImageData)object).width, ((ImageData)object).height, n, n2, false);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int createCursor(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.device.xDisplay;
        int n6 = OS.XDefaultRootWindow(n5);
        int n7 = OS.XCreateBitmapFromData(n5, n6, byArray, n, n2);
        int n8 = OS.XCreateBitmapFromData(n5, n6, byArray2, n, n2);
        int n9 = 0;
        if (n7 != 0 && n8 != 0) {
            int n10 = OS.XDefaultScreen(n5);
            XColor xColor = new XColor();
            int n11 = xColor.pixel = !bl ? OS.XWhitePixel(n5, n10) : OS.XBlackPixel(n5, n10);
            if (!bl) {
                xColor.blue = (short)-1;
                xColor.green = (short)-1;
                xColor.red = (short)-1;
            }
            XColor xColor2 = new XColor();
            int n12 = xColor2.pixel = bl ? OS.XWhitePixel(n5, n10) : OS.XBlackPixel(n5, n10);
            if (bl) {
                xColor2.blue = (short)-1;
                xColor2.green = (short)-1;
                xColor2.red = (short)-1;
            }
            n9 = OS.XCreatePixmapCursor(n5, n7, n8, xColor, xColor2, n3, n4);
        }
        if (n7 != 0) {
            OS.XFreePixmap(n5, n7);
        }
        if (n8 != 0) {
            OS.XFreePixmap(n5, n8);
        }
        return n9;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.XFreeCursor(this.device.xDisplay, this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Cursor motif_new(Device device, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.device = device;
        cursor.handle = n;
        return cursor;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

