/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFontStruct;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int defaultAscent;
    int defaultDescent;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        XFontStruct xFontStruct = this.getFontHeigth(device.getSystemFont());
        this.defaultAscent = xFontStruct.ascent;
        this.defaultDescent = xFontStruct.descent;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    int stringWidth(StyleItem styleItem, char[] cArray) {
        if (cArray.length == 0) {
            return 0;
        }
        Font font = this.getItemFont(styleItem);
        int n = font.handle;
        byte[] byArray = Converter.wcsToMbcs(font.codePage, cArray, true);
        int n2 = OS.XmStringCreateLocalized(byArray);
        int n3 = OS.XmStringWidth(n, n2);
        OS.XmStringFree(n2);
        return n3;
    }

    void computeRuns() {
        int n;
        int n2;
        int n3;
        if (this.runs != null) {
            return;
        }
        StyleItem[] styleItemArray = this.itemize();
        int n4 = 0;
        while (n4 < styleItemArray.length - 1) {
            StyleItem styleItem = styleItemArray[n4];
            this.place(styleItem);
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        while (n7 < styleItemArray.length - 1) {
            int n8;
            int n9;
            StyleItem styleItem = styleItemArray[n7];
            if (styleItem.length == 1) {
                n3 = this.text.charAt(styleItem.start);
                switch (n3) {
                    case 9: {
                        styleItem.tab = true;
                        styleItem.baseline = 0;
                        if (this.tabs == null) break;
                        n2 = this.tabs.length;
                        n9 = 0;
                        while (n9 < n2) {
                            if (this.tabs[n9] > n4) {
                                styleItem.width = this.tabs[n9] - n4;
                                break;
                            }
                            ++n9;
                        }
                        if (n9 != n2) break;
                        n8 = this.tabs[n2 - 1];
                        int n10 = n = n2 > 1 ? this.tabs[n2 - 1] - this.tabs[n2 - 2] : this.tabs[0];
                        if (n <= 0) break;
                        while (n8 <= n4) {
                            n8 += n;
                        }
                        styleItem.width = n8 - n4;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        styleItem.width = 0;
                        styleItem.baseline = 0;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        styleItem.width = 0;
                        styleItem.baseline = 0;
                        StyleItem styleItem2 = styleItemArray[n7 + 1];
                        if (styleItem2.length == 0 || this.text.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        ++n7;
                    }
                }
            }
            if (this.wrapWidth != -1 && n4 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                n3 = 0;
                char[] cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                if (styleItem.style == null || styleItem.style.metrics == null) {
                    n9 = 0;
                    n8 = this.wrapWidth - n4;
                    char[] cArray2 = new char[]{cArray[n3]};
                    int n11 = this.stringWidth(styleItem, cArray2);
                    while (n9 + n11 < n8) {
                        n9 += n11;
                        cArray2[0] = cArray[++n3];
                        n11 = this.stringWidth(styleItem, cArray2);
                    }
                }
                n9 = n3;
                n8 = n7;
                while (n7 >= n5) {
                    cArray = new char[styleItem.length];
                    this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                    while (n3 >= 0) {
                        if (Compatibility.isSpaceChar(cArray[n3]) || Compatibility.isWhitespace(cArray[n3])) break;
                        --n3;
                    }
                    if (n3 >= 0 || n7 == n5) break;
                    styleItem = styleItemArray[--n7];
                    n3 = styleItem.length - 1;
                }
                if (n3 == 0 && n7 != n5) {
                    styleItem = styleItemArray[--n7];
                } else if (n3 <= 0 && n7 == n5) {
                    n7 = n8;
                    styleItem = styleItemArray[n7];
                    n3 = Math.max(1, n9);
                }
                cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                while (n3 < styleItem.length) {
                    if (!Compatibility.isWhitespace(cArray[n3])) break;
                    ++n3;
                }
                if (n3 > 0 && n3 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n3;
                    styleItem3.length = styleItem.length - n3;
                    styleItem3.style = styleItem.style;
                    styleItem.length = n3;
                    this.place(styleItem);
                    this.place(styleItem3);
                    StyleItem[] styleItemArray2 = new StyleItem[styleItemArray.length + 1];
                    System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n7 + 1);
                    System.arraycopy(styleItemArray, n7 + 1, styleItemArray2, n7 + 2, styleItemArray.length - n7 - 1);
                    styleItemArray = styleItemArray2;
                    styleItemArray[n7 + 1] = styleItem3;
                }
                if (n7 != styleItemArray.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n4 += styleItem.width;
            if (styleItem.lineBreak) {
                n5 = n7 + 1;
                n4 = 0;
                ++n6;
            }
            ++n7;
        }
        n4 = 0;
        this.runs = new StyleItem[n6][];
        this.lineOffset = new int[n6 + 1];
        this.lineY = new int[n6 + 1];
        this.lineWidth = new int[n6];
        n7 = 0;
        int n12 = 0;
        n3 = Math.max(this.defaultAscent, this.ascent);
        n2 = Math.max(this.defaultDescent, this.descent);
        StyleItem[] styleItemArray3 = new StyleItem[styleItemArray.length];
        n = 0;
        while (n < styleItemArray.length) {
            StyleItem styleItem = styleItemArray[n];
            styleItemArray3[n7++] = styleItem;
            n4 += styleItem.width;
            if (styleItem.style != null) {
                int n13 = this.defaultAscent;
                int n14 = this.defaultDescent;
                if (styleItem.style.metrics != null) {
                    GlyphMetrics glyphMetrics = styleItem.style.metrics;
                    n13 = glyphMetrics.ascent;
                    n14 = glyphMetrics.descent;
                } else if (styleItem.style.font != null) {
                    XFontStruct xFontStruct = this.getFontHeigth(styleItem.style.font);
                    n13 = xFontStruct.ascent;
                    n14 = xFontStruct.descent;
                }
                n3 = Math.max(n3, n13 + styleItem.style.rise);
                n2 = Math.max(n2, n14 - styleItem.style.rise);
                if (styleItem.style.rise != 0) {
                    styleItem.baseline += styleItem.style.rise;
                }
            }
            if (styleItem.lineBreak || n == styleItemArray.length - 1) {
                this.runs[n12] = new StyleItem[n7];
                System.arraycopy(styleItemArray3, 0, this.runs[n12], 0, n7);
                StyleItem styleItem4 = this.runs[n12][n7 - 1];
                this.lineWidth[n12] = n4;
                this.lineY[++n12] = this.lineY[n12 - 1] + n3 + n2 + this.lineSpacing;
                this.lineOffset[n12] = styleItem4.start + styleItem4.length;
                n4 = 0;
                n7 = 0;
                n3 = Math.max(this.defaultAscent, this.ascent);
                n2 = Math.max(this.defaultDescent, this.descent);
            }
            ++n;
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.tabs = null;
        this.styles = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        boolean bl;
        this.checkLayout();
        this.computeRuns();
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        gC.checkGC(1);
        int n6 = this.text.length();
        if (n6 == 0 && n5 == 0) {
            return;
        }
        boolean bl2 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
        if (bl || (n5 & 0x100000) != 0) {
            n3 = Math.min(Math.max(0, n3), n6 - 1);
            n4 = Math.min(Math.max(0, n4), n6 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
        }
        Color color3 = gC.getForeground();
        Color color4 = gC.getBackground();
        Font font = gC.getFont();
        Rectangle rectangle = gC.getClipping();
        int n7 = 0;
        while (n7 < this.runs.length) {
            int n8;
            int n9 = n + this.getLineIndent(n7);
            int n10 = n2 + this.lineY[n7];
            StyleItem[] styleItemArray = this.runs[n7];
            int n11 = this.lineY[n7 + 1] - this.lineY[n7];
            if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
                n8 = 0;
                if (n7 == this.runs.length - 1 && (n5 & 0x100000) != 0) {
                    n8 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n3 <= styleItem.start && styleItem.start <= n4) {
                            n8 = 1;
                        }
                    } else {
                        int n12 = styleItem.start + styleItem.length - 1;
                        if (n3 <= n12 && n12 < n4 && (n5 & 0x10000) != 0) {
                            n8 = 1;
                        }
                    }
                }
                if (n8 != 0) {
                    gC.setBackground(color2);
                    int n13 = (n5 & 0x10000) != 0 ? Integer.MAX_VALUE : n11 / 3;
                    gC.fillRectangle(n9 + this.lineWidth[n7], n10, n13, n11);
                }
            }
            if (n9 <= rectangle.x + rectangle.width && n9 + this.lineWidth[n7] >= rectangle.x) {
                n8 = Math.max(0, this.ascent);
                int n14 = 0;
                while (n14 < styleItemArray.length) {
                    n8 = Math.max(n8, styleItemArray[n14].baseline);
                    ++n14;
                }
                n14 = 0;
                while (n14 < styleItemArray.length) {
                    StyleItem styleItem = styleItemArray[n14];
                    if (styleItem.length != 0) {
                        if (n9 > rectangle.x + rectangle.width) break;
                        if (n9 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            boolean bl3;
                            String string = this.text.substring(styleItem.start, styleItem.start + styleItem.length);
                            int n15 = n10 + (n8 - styleItem.baseline);
                            int n16 = styleItem.start + styleItem.length - 1;
                            gC.setFont(this.getItemFont(styleItem));
                            boolean bl4 = bl3 = bl && n3 <= styleItem.start && n4 >= n16;
                            if (bl3) {
                                gC.setBackground(color2);
                                gC.fillRectangle(n9, n10, styleItem.width, n11);
                                if (!(styleItem.tab || styleItem.style != null && styleItem.style.metrics != null)) {
                                    int n17;
                                    gC.setForeground(color);
                                    gC.drawString(string, n9, n15, true);
                                    if (styleItem.style != null && styleItem.style.underline) {
                                        n17 = n15 + styleItem.baseline + 1 - styleItem.style.rise;
                                        gC.drawLine(n9, n17, n9 + styleItem.width, n17);
                                    }
                                    if (styleItem.style != null && styleItem.style.strikeout) {
                                        n17 = n15 + styleItem.height - styleItem.height / 2 - 1;
                                        gC.drawLine(n9, n17, n9 + styleItem.width, n17);
                                    }
                                }
                            } else {
                                if (styleItem.style != null && styleItem.style.background != null) {
                                    Color color5 = styleItem.style.background;
                                    gC.setBackground(color5);
                                    gC.fillRectangle(n9, n15, styleItem.width, styleItem.height);
                                }
                                if (!styleItem.tab) {
                                    int n18;
                                    Color color6 = color3;
                                    if (styleItem.style != null && styleItem.style.foreground != null) {
                                        color6 = styleItem.style.foreground;
                                    }
                                    gC.setForeground(color6);
                                    if (styleItem.style == null || styleItem.style.metrics == null) {
                                        gC.drawString(string, n9, n15, true);
                                        if (styleItem.style != null && styleItem.style.underline) {
                                            n18 = n15 + styleItem.baseline + 1 - styleItem.style.rise;
                                            gC.drawLine(n9, n18, n9 + styleItem.width, n18);
                                        }
                                        if (styleItem.style != null && styleItem.style.strikeout) {
                                            n18 = n15 + styleItem.height - styleItem.height / 2 - 1;
                                            gC.drawLine(n9, n18, n9 + styleItem.width, n18);
                                        }
                                    }
                                    int n19 = n18 = bl && n3 <= n16 && styleItem.start <= n4 ? 1 : 0;
                                    if (n18 != 0) {
                                        int n20 = Math.max(n3, styleItem.start);
                                        int n21 = Math.min(n4, n16);
                                        string = this.text.substring(styleItem.start, n20);
                                        int n22 = n9 + gC.stringExtent((String)string).x;
                                        string = this.text.substring(n20, n21 + 1);
                                        int n23 = gC.stringExtent((String)string).x;
                                        gC.setBackground(color2);
                                        gC.fillRectangle(n22, n10, n23, n11);
                                        if (color6 != color && (styleItem.style == null || styleItem.style.metrics == null)) {
                                            int n24;
                                            gC.setForeground(color);
                                            gC.drawString(string, n22, n15, true);
                                            if (styleItem.style != null && styleItem.style.underline) {
                                                n24 = n15 + styleItem.baseline + 1 - styleItem.style.rise;
                                                gC.drawLine(n22, n24, n22 + n23, n24);
                                            }
                                            if (styleItem.style != null && styleItem.style.strikeout) {
                                                n24 = n15 + styleItem.height - styleItem.height / 2 - 1;
                                                gC.drawLine(n22, n24, n22 + n23, n24);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        n9 += styleItem.width;
                    }
                    ++n14;
                }
            }
            ++n7;
        }
        gC.setForeground(color3);
        gC.setBackground(color4);
        gC.setFont(font);
    }

    void freeRuns() {
        this.runs = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            int n2 = 0;
            while (n2 < this.runs.length) {
                n = Math.max(n, this.lineWidth[n2] + this.getLineIndent(n2));
                ++n2;
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    /*
     * Unable to fully structure code
     */
    public Rectangle getBounds(int var1_1, int var2_2) {
        block3: {
            this.checkLayout();
            this.computeRuns();
            var3_3 = this.text.length();
            if (var3_3 == 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            if (var1_1 > var2_2) {
                return new Rectangle(0, 0, 0, 0);
            }
            var1_1 = Math.min(Math.max(0, var1_1), var3_3 - 1);
            var2_2 = Math.min(Math.max(0, var2_2), var3_3 - 1);
            var4_4 = this.getLineIndex(var1_1);
            var5_5 = this.getLineIndex(var2_2);
            var6_6 = new Rectangle(0, 0, 0, 0);
            var6_6.y = this.lineY[var4_4];
            var6_6.height = this.lineY[var5_5 + 1] - var6_6.y - this.lineSpacing;
            if (var4_4 != var5_5) ** GOTO lbl20
            var6_6.x = this.getLocation((int)var1_1, (boolean)false).x;
            var6_6.width = this.getLocation((int)var2_2, (boolean)true).x - var6_6.x;
            break block3;
lbl-1000:
            // 1 sources

            {
                var6_6.width = Math.max(var6_6.width, this.lineWidth[var4_4++]);
lbl20:
                // 2 sources

                ** while (var4_4 <= var5_5)
            }
        }
        return var6_6;
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    XFontStruct getFontHeigth(Font font) {
        int n;
        int[] nArray = new int[1];
        int n2 = font.handle;
        if (!OS.XmFontListInitFontContext(nArray, n2)) {
            SWT.error(2);
        }
        int n3 = nArray[0];
        int n4 = 0;
        int n5 = 0;
        XFontStruct xFontStruct = new XFontStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n = OS.XmFontListNextEntry(n3)) != 0) {
            int n6 = OS.XmFontListEntryGetFont(n, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n6, 80);
                n4 = Math.max(n4, xFontStruct.ascent);
                n5 = Math.max(n5, xFontStruct.descent);
                continue;
            }
            int n7 = OS.XFontsOfFontSet(n6, nArray2, nArray3);
            int[] nArray4 = new int[n7];
            OS.memmove(nArray4, nArray2[0], n7 * 4);
            int n8 = 0;
            while (n8 < n7) {
                OS.memmove(xFontStruct, nArray4[n8], 80);
                n4 = Math.max(n4, xFontStruct.ascent);
                n5 = Math.max(n5, xFontStruct.descent);
                ++n8;
            }
        }
        OS.XmFontListFreeFontContext(n3);
        xFontStruct.ascent = n4;
        xFontStruct.descent = n5;
        return xFontStruct;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        return 0;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] nArray = new int[this.lineOffset.length];
        System.arraycopy(this.lineOffset, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns();
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.getLineIndent(n);
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3 - this.lineSpacing;
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.runs.length;
    }

    int getLineIndent(int n) {
        boolean bl;
        int n2 = 0;
        if (n == 0) {
            n2 = this.indent;
        } else {
            StyleItem[] styleItemArray = this.runs[n - 1];
            StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                n2 = this.indent;
            }
        }
        if (this.wrapWidth != -1 && (bl = true)) {
            int n3 = this.lineWidth[n] + n2;
            switch (this.alignment) {
                case 0x1000000: {
                    n2 += (this.wrapWidth - n3) / 2;
                    break;
                }
                case 131072: {
                    n2 += this.wrapWidth - n3;
                }
            }
        }
        return n2;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) {
                return n3;
            }
            ++n3;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns();
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = Math.max(this.defaultAscent, this.ascent);
        int n3 = Math.max(this.defaultDescent, this.descent);
        if (this.text.length() != 0) {
            GC gC = new GC(this.device);
            StyleItem[] styleItemArray = this.runs[n];
            int n4 = 0;
            while (n4 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n4];
                if (styleItem.style != null) {
                    Object object;
                    int n5 = 0;
                    int n6 = 0;
                    if (styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n5 = ((GlyphMetrics)object).ascent;
                        n6 = ((GlyphMetrics)object).descent;
                    } else if (styleItem.style.font != null) {
                        gC.setFont(styleItem.style.font);
                        object = gC.getFontMetrics();
                        n5 = ((FontMetrics)object).getAscent();
                        n6 = ((FontMetrics)object).getDescent();
                    }
                    n2 = Math.max(n2, n5 + styleItem.style.rise);
                    n3 = Math.max(n3, n6 - styleItem.style.rise);
                }
                ++n4;
            }
            gC.dispose();
        }
        return FontMetrics.motif_new(n2, n3, 0, 0, n2 + n3);
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns();
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) break;
            ++n3;
        }
        n3 = Math.min(n3, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n3];
        Point point = null;
        if (n == n2) {
            point = new Point(this.lineWidth[n3], this.lineY[n3]);
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n5];
                int n6 = styleItem.start + styleItem.length;
                if (styleItem.start <= n && n < n6) {
                    if (styleItem.tab) {
                        if (bl || n == n2) {
                            n4 += styleItem.width;
                        }
                    } else {
                        if (bl) {
                            ++n;
                        }
                        if (styleItem.style != null && styleItem.style.metrics != null) {
                            GlyphMetrics glyphMetrics = styleItem.style.metrics;
                            n4 += glyphMetrics.width * (n - styleItem.start);
                        } else {
                            char[] cArray = new char[n - styleItem.start];
                            this.text.getChars(styleItem.start, n, cArray, 0);
                            n4 += this.stringWidth(styleItem, cArray);
                        }
                    }
                    point = new Point(n4, this.lineY[n3]);
                    break;
                }
                n4 += styleItem.width;
                ++n5;
            }
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        point.x += this.getLineIndent(n3);
        return point;
    }

    Font getItemFont(StyleItem styleItem) {
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font;
        }
        if (this.font != null) {
            return this.font;
        }
        return this.device.systemFont;
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        this.computeRuns();
        int n3 = this.text.length();
        if (n < 0 || n > n3) {
            SWT.error(6);
        }
        if (n == n3) {
            return n3;
        }
        if ((n2 & 3) != 0) {
            return n + 1;
        }
        int n4 = 0;
        int n5 = 1;
        while (n5 < this.lineOffset.length) {
            if (this.lineOffset[n5] > n) {
                n4 = Math.max(this.lineOffset[n5 - 1], this.lineOffset[n5] - 1);
                if (n5 != this.runs.length) break;
                ++n4;
                break;
            }
            ++n5;
        }
        n5 = Compatibility.isLetterOrDigit(this.text.charAt(n)) ? 0 : 1;
        ++n;
        while (n < n4) {
            int n6;
            int n7 = n6 = Compatibility.isLetterOrDigit(this.text.charAt(n)) ? 0 : 1;
            if ((n2 == 4 || n2 == 8) && n6 != 0 && n5 == 0 || n2 == 16 && n6 == 0 && n5 != 0) break;
            n5 = n6;
            ++n;
        }
        return n;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        this.computeRuns();
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n3 = this.runs.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.lineY[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        if ((n -= this.getLineIndent(n4)) >= this.lineWidth[n4]) {
            n = this.lineWidth[n4] - 1;
        }
        if (n < 0) {
            n = 0;
        }
        StyleItem[] styleItemArray = this.runs[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < styleItemArray.length) {
            StyleItem styleItem = styleItemArray[n6];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return styleItem.start;
            }
            if (n5 + styleItem.width > n) {
                Object object;
                int n7;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    n7 = n - n5;
                    object = styleItem.style.metrics;
                    if (object.width > 0) {
                        if (nArray != null) {
                            nArray[0] = n7 % object.width < object.width / 2 ? 0 : 1;
                        }
                        return styleItem.start + n7 / object.width;
                    }
                }
                if (styleItem.tab) {
                    if (nArray != null) {
                        nArray[0] = n < n5 + styleItem.width / 2 ? 0 : 1;
                    }
                    return styleItem.start;
                }
                n7 = 0;
                object = new char[1];
                char[] cArray = new char[styleItem.length];
                this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
                n7 = 0;
                while (n7 < cArray.length) {
                    object[0] = cArray[n7];
                    int n8 = this.stringWidth(styleItem, (char[])object);
                    if (n5 + n8 > n) {
                        if (nArray == null) break;
                        nArray[0] = n < n5 + n8 / 2 ? 0 : 1;
                        break;
                    }
                    n5 += n8;
                    ++n7;
                }
                return styleItem.start + n7;
            }
            n5 += styleItem.width;
            ++n6;
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.lineOffset[n4 + 1];
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        int n3;
        this.checkLayout();
        this.computeRuns();
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (n == 0) {
            return 0;
        }
        if ((n2 & 3) != 0) {
            return n - 1;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.lineOffset.length - 1) {
            n3 = this.lineOffset[n6 + 1];
            if (n6 == this.runs.length - 1) {
                ++n3;
            }
            if (n3 > n) {
                n5 = this.lineOffset[n6];
                break;
            }
            ++n6;
        }
        n6 = Compatibility.isLetterOrDigit(this.text.charAt(--n)) ? 0 : 1;
        while (n5 < n) {
            int n7 = n3 = Compatibility.isLetterOrDigit(this.text.charAt(n - 1)) ? 0 : 1;
            if (n2 == 8 && n3 == 0 && n6 != 0 || (n2 == 4 || n2 == 16) && n3 != 0 && n6 == 0) break;
            --n;
            n6 = n3;
        }
        return n;
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            StyleItem styleItem = this.styles[n3];
            if (styleItem.start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int n = this.text.length();
        if (n == 0) {
            return new StyleItem[]{new StyleItem(), new StyleItem()};
        }
        int n2 = 0;
        int n3 = 0;
        StyleItem[] styleItemArray = new StyleItem[n];
        char[] cArray = this.text.toCharArray();
        int n4 = 0;
        while (n4 < n) {
            char c = cArray[n4];
            if (c == '\t' || c == '\r' || c == '\n') {
                StyleItem styleItem;
                if (n4 != n3) {
                    styleItem = new StyleItem();
                    styleItem.start = n3;
                    styleItemArray[n2++] = styleItem;
                }
                styleItem = new StyleItem();
                styleItem.start = n4;
                styleItemArray[n2++] = styleItem;
                n3 = n4 + 1;
            }
            ++n4;
        }
        n4 = cArray[n - 1];
        if (n4 != 9 && n4 != 13 && n4 != 10) {
            StyleItem styleItem = new StyleItem();
            styleItem.start = n3;
            styleItemArray[n2++] = styleItem;
        }
        if (n2 != n) {
            StyleItem[] styleItemArray2 = new StyleItem[n2];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n2);
            styleItemArray = styleItemArray2;
        }
        styleItemArray = this.merge(styleItemArray, n2);
        return styleItemArray;
    }

    StyleItem[] merge(StyleItem[] styleItemArray, int n) {
        StyleItem styleItem;
        int n2 = this.text.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        StyleItem[] styleItemArray2 = new StyleItem[n + this.styles.length];
        while (n4 < n5) {
            int n8;
            styleItem = new StyleItem();
            styleItem.start = n4;
            styleItem.style = this.styles[n7].style;
            styleItemArray2[n3++] = styleItem;
            int n9 = n6 + 1 < styleItemArray.length ? styleItemArray[n6 + 1].start : n2;
            int n10 = n8 = n7 + 1 < this.styles.length ? this.styles[n7 + 1].start : n2;
            if (n8 <= n9) {
                ++n7;
                n4 = n8;
            }
            if (n9 <= n8) {
                ++n6;
                n4 = n9;
            }
            styleItem.length = n4 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n5;
        styleItemArray2[n3++] = styleItem;
        if (styleItemArray2.length != n3) {
            StyleItem[] styleItemArray3 = new StyleItem[n3];
            System.arraycopy(styleItemArray2, 0, styleItemArray3, 0, n3);
            return styleItemArray3;
        }
        return styleItemArray2;
    }

    void place(StyleItem styleItem) {
        if (styleItem.length == 0) {
            return;
        }
        if (styleItem.style != null && styleItem.style.metrics != null) {
            GlyphMetrics glyphMetrics = styleItem.style.metrics;
            styleItem.width = glyphMetrics.width * styleItem.length;
            styleItem.baseline = glyphMetrics.ascent;
            styleItem.height = glyphMetrics.ascent + glyphMetrics.descent;
        } else {
            char[] cArray = new char[styleItem.length];
            this.text.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
            Font font = this.getItemFont(styleItem);
            int n = font.handle;
            byte[] byArray = Converter.wcsToMbcs(font.codePage, cArray, true);
            short[] sArray = new short[1];
            short[] sArray2 = new short[1];
            int n2 = OS.XmStringCreateLocalized(byArray);
            OS.XmStringExtent(n, n2, sArray, sArray2);
            styleItem.width = sArray[0] & 0xFFFF;
            styleItem.height = sArray2[0] & 0xFFFF;
            styleItem.baseline = OS.XmStringBaseline(n, n2);
            OS.XmStringFree(n2);
        }
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        this.freeRuns();
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
        XFontStruct xFontStruct = this.getFontHeigth(font != null ? font : this.device.systemFont);
        this.defaultAscent = xFontStruct.ascent;
        this.defaultDescent = xFontStruct.descent;
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        this.orientation = n;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        this.checkLayout();
        int n5 = this.text.length();
        if (n5 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n5 - 1);
        n2 = Math.min(Math.max(0, n2), n5 - 1);
        int n6 = -1;
        int n7 = this.styles.length;
        while (n7 - n6 > 1) {
            n4 = (n7 + n6) / 2;
            if (this.styles[n4 + 1].start > n) {
                n7 = n4;
                continue;
            }
            n6 = n4;
        }
        if (n7 >= 0 && n7 < this.styles.length) {
            StyleItem styleItem = this.styles[n7];
            if (styleItem.start == n && this.styles[n7 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n8 = n4 = n7;
        while (n8 < this.styles.length) {
            if (this.styles[n8 + 1].start > n2) break;
            ++n8;
        }
        if (n4 == n8) {
            n3 = this.styles[n4].start;
            int n9 = this.styles[n8 + 1].start - 1;
            if (n3 == n && n9 == n2) {
                this.styles[n4].style = textStyle;
                return;
            }
            if (n3 != n && n9 != n2) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                styleItemArray[n4 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n4].style;
                styleItemArray[n4 + 2] = styleItem;
                System.arraycopy(this.styles, n8 + 1, styleItemArray, n8 + 3, this.styles.length - n8 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n == this.styles[n4].start) {
            --n4;
        }
        if (n2 == this.styles[n8 + 1].start - 1) {
            ++n8;
        }
        n3 = this.styles.length + 1 - (n8 - n4 - 1);
        StyleItem[] styleItemArray = new StyleItem[n3];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        styleItemArray[n4 + 1] = styleItem;
        this.styles[n8].start = n2 + 1;
        System.arraycopy(this.styles, n8, styleItemArray, n4 + 2, this.styles.length - n8);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        int width;
        int height;
        int baseline;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

