/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        super.drawBackground(gC, n, n2, n3, n4);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Caret getIMCaret() {
        return this.caret;
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        super.releaseChildren(bl);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        Control control;
        int n8;
        boolean bl2;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n9 = n - n3;
        int n10 = n2 - n4;
        if (n9 == 0 && n10 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        if ((n8 = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        int n11 = OS.XtWindow(this.handle);
        if (n11 == 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (Math.min(n3 + n5, nArray2[1]) >= Math.max(n3, 0) && Math.min(n4 + n6, 0 + nArray2[3]) >= Math.max(n4, 0)) {
            int n12 = OS.XtMalloc(96);
            OS.XSync(n8, false);
            OS.XSync(n8, false);
            while (OS.XCheckWindowEvent(n8, n11, 32768, n12)) {
                OS.XtDispatchEvent(n12);
            }
            OS.XtFree(n12);
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            int n13 = OS.XCreateGC(n8, n11, 0, null);
            OS.XCopyArea(n8, n11, n11, n13, n3, n4, n5, n6, n, n2);
            OS.XFreeGC(n8, n13);
            int n14 = n7 = n + n5 >= n3 && n3 + n5 >= n && n2 + n6 >= n4 && n4 + n6 >= n2 ? 0 : 1;
            if (n7 != 0) {
                OS.XClearArea(n8, n11, n3, n4, n5, n6, true);
            } else {
                int n15;
                if (n9 != 0) {
                    n15 = n - n9;
                    if (n9 < 0) {
                        n15 = n + n5;
                    }
                    OS.XClearArea(n8, n11, n15, n4, Math.abs(n9), n6, true);
                }
                if (n10 != 0) {
                    n15 = n2 - n10;
                    if (n10 < 0) {
                        n15 = n2 + n6;
                    }
                    OS.XClearArea(n8, n11, n3, n15, n5, Math.abs(n10), true);
                }
            }
        }
        if (bl) {
            Control[] controlArray = this._getChildren();
            n7 = 0;
            while (n7 < controlArray.length) {
                Control control2 = controlArray[n7];
                Rectangle rectangle = control2.getBounds();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) >= Math.max(n3, rectangle.x) && Math.min(n4 + n6, rectangle.y + rectangle.height) >= Math.max(n4, rectangle.y)) {
                    control2.setLocation(rectangle.x + n9, rectangle.y + n10);
                }
                ++n7;
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        boolean bl5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return bl5;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    int XExposure(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n5 = super.XExposure(n, n2, n3, n4);
        if (bl) {
            this.caret.setFocus();
        }
        return n5;
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        int n = super.xFocusIn(xFocusChangeEvent);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return n;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        int n = super.xFocusOut(xFocusChangeEvent);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return n;
    }
}

