/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int visibleCount = 5;
    public static final int LIMIT = Integer.MAX_VALUE;
    boolean ignoreSelect;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, n, -1, false);
        OS.XmStringFree(n);
    }

    public void add(String string, int n) {
        byte[] byArray;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n > nArray2[1]) {
            this.error(6);
        }
        if ((n2 = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, n2, n + 1, false);
        OS.XmStringFree(n2);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextClearSelection(nArray2[1], OS.XtLastTimestampProcessed(n));
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int[] nArray = new int[16];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        nArray[4] = OS.XmNitemCount;
        nArray[6] = OS.XmNmarginWidth;
        nArray[8] = OS.XmNshadowThickness;
        nArray[10] = OS.XmNhighlightThickness;
        nArray[12] = OS.XmNarrowSize;
        nArray[14] = OS.XmNarrowSpacing;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
        xtWidgetGeometry.request_mode = 4;
        OS.XtQueryGeometry(nArray2[1], null, xtWidgetGeometry);
        int n3 = xtWidgetGeometry.width;
        int n4 = this.getTextHeight();
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNmarginWidth;
        nArray3[2] = OS.XmNshadowThickness;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[3], nArray4, nArray4.length / 2);
        if ((this.style & 8) == 0) {
            n3 += 2 * nArray2[7];
        }
        if ((this.style & 4) != 0) {
            n3 += nArray2[13] + nArray2[15];
        } else {
            int n5 = nArray2[5] == 0 ? 5 : nArray2[5];
            n4 += this.getItemHeight() * n5;
        }
        n3 += 2 * nArray2[9] + 2 * nArray2[11] + 2 * nArray4[1] + 2 * nArray4[3];
        if (nArray2[5] == 0) {
            n3 = 64;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n != -1) {
            n3 = n;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextCopy(nArray2[1], OS.XtLastTimestampProcessed(n));
    }

    void createHandle(int n) {
        int n2 = this.parent.handle;
        int[] nArray = new int[]{OS.XmNancestorSensitive, 1};
        this.formHandle = OS.XmCreateForm(n2, null, nArray, nArray.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int n3 = 1;
        if ((this.style & 0x40) != 0) {
            n3 = 0;
        } else if ((this.style & 8) != 0) {
            n3 = 2;
        }
        int[] nArray2 = new int[12];
        nArray2[0] = OS.XmNcomboBoxType;
        nArray2[1] = n3;
        nArray2[2] = OS.XmNtopAttachment;
        nArray2[3] = 1;
        nArray2[4] = OS.XmNbottomAttachment;
        nArray2[5] = 1;
        nArray2[6] = OS.XmNleftAttachment;
        nArray2[7] = 1;
        nArray2[8] = OS.XmNrightAttachment;
        nArray2[9] = 1;
        nArray2[10] = OS.XmNresizable;
        int[] nArray3 = nArray2;
        this.handle = OS.XmCreateComboBox(this.formHandle, null, nArray3, nArray3.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] nArray4 = new int[2];
        nArray4[0] = OS.XmNtextField;
        int[] nArray5 = nArray4;
        OS.XtGetValues(this.handle, nArray5, nArray5.length / 2);
        int n4 = nArray5[1];
        int[] nArray6 = new int[2];
        nArray6[0] = OS.XmNverifyBell;
        int[] nArray7 = nArray6;
        OS.XtSetValues(n4, nArray7, nArray7.length / 2);
        OS.XmDropSiteUnregister(n4);
    }

    public void cut() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextCut(nArray2[1], OS.XtLastTimestampProcessed(n));
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (OS.XmListPosSelected(nArray2[3], n + 1)) {
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(nArray2[1], new byte[1]);
            this.display.setWarnings(bl);
            OS.XmListDeselectAllItems(nArray2[3]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(nArray2[1], new byte[1]);
        this.display.setWarnings(bl);
        OS.XmListDeselectAllItems(nArray2[3]);
    }

    public String getItem(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitemCount;
        nArray[2] = OS.XmNitems;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[1]) {
            this.error(6);
        }
        if (nArray2[3] == 0) {
            this.error(8);
        }
        int n2 = nArray2[3] + n * 4;
        int[] nArray3 = new int[1];
        OS.memmove(nArray3, n2, 4);
        n2 = nArray3[0];
        int[] nArray4 = new int[]{this.display.tabMapping, this.display.crMapping};
        int n3 = OS.XmStringUnparse(n2, null, 0, 0, nArray4, nArray4.length, 0);
        if (n3 == 0) {
            this.error(8);
        }
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        OS.XtFree(n3);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), byArray)));
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[6];
        nArray3[0] = OS.XmNlistSpacing;
        nArray3[2] = OS.XmNhighlightThickness;
        nArray3[4] = OS.XmNfontList;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
        int n = nArray4[1];
        int n2 = nArray4[3];
        int n3 = nArray4[5];
        return this.getFontHeight(n3) + n + 2 * n2;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        int[] nArray3 = new int[1];
        String[] stringArray = new String[n2];
        String string = this.getCodePage();
        int n3 = 0;
        while (n3 < n2) {
            OS.memmove(nArray3, n, 4);
            int n4 = nArray3[0];
            int[] nArray4 = new int[]{this.display.tabMapping, this.display.crMapping};
            int n5 = OS.XmStringUnparse(n4, null, 0, 0, nArray4, nArray4.length, 0);
            if (n5 == 0) {
                this.error(8);
            }
            int n6 = OS.strlen(n5);
            byte[] byArray = new byte[n6];
            OS.memmove(byArray, n5, n6);
            OS.XtFree(n5);
            stringArray[n3] = this.decodeString(new String(Converter.mbcsToWcs(string, byArray)));
            n += 4;
            ++n3;
        }
        return stringArray;
    }

    int getMinimumHeight() {
        return this.getTextHeight();
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNtextField;
        int[] nArray4 = nArray3;
        OS.XtGetValues(this.handle, nArray4, nArray4.length / 2);
        OS.XmTextGetSelectionPosition(nArray4[1], nArray, nArray2);
        if (nArray[0] == nArray2[0]) {
            nArray[0] = nArray2[0] = OS.XmTextGetInsertionPosition(nArray4[1]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = OS.XmListGetKbdItemPos(nArray2[1]);
        if (OS.XmListPosSelected(nArray2[1], n)) {
            return n - 1;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        if (!OS.XmListGetSelectedPos(nArray2[1], nArray3, nArray4)) {
            return -1;
        }
        if (nArray4[0] == 0) {
            return -1;
        }
        int n2 = nArray3[0];
        int[] nArray5 = new int[1];
        OS.memmove(nArray5, n2, 4);
        OS.XtFree(n2);
        return nArray5[0] - 1;
    }

    public String getText() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = OS.XmTextGetString(nArray2[1]);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        OS.XtFree(n);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), byArray)));
    }

    public int getTextHeight() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (!OS.XtIsRealized(this.handle)) {
                this.getShell().realizeWidget();
            }
            XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
            xtWidgetGeometry.request_mode = 8;
            OS.XtQueryGeometry(this.handle, null, xtWidgetGeometry);
            return xtWidgetGeometry.height;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNmarginHeight;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
        int n = this.getFontHeight(this.font.handle);
        XRectangle xRectangle = new XRectangle();
        OS.XmWidgetGetDisplayRect(nArray2[1], xRectangle);
        n += xRectangle.y * 2 + 2 * nArray4[1];
        int[] nArray5 = new int[6];
        nArray5[0] = OS.XmNmarginHeight;
        nArray5[2] = OS.XmNshadowThickness;
        nArray5[4] = OS.XmNhighlightThickness;
        int[] nArray6 = nArray5;
        OS.XtGetValues(this.handle, nArray6, nArray6.length / 2);
        return n += 2 * nArray6[1] + 2 * nArray6[3] + 2 * nArray6[5];
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return OS.XmTextGetMaxLength(nArray2[1]);
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 0x40) != 0) {
            return this.visibleCount;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvisibleItemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        OS.XtAddCallback(n2, OS.XmNbrowseSelectionCallback, n, 11);
        OS.XtAddEventHandler(n2, 1, false, n, 6);
        OS.XtAddEventHandler(n2, 2, false, n, 7);
        OS.XtAddCallback(n3, OS.XmNactivateCallback, n, 9);
        OS.XtAddCallback(n3, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(n3, OS.XmNmodifyVerifyCallback, n, 19);
        OS.XtAddEventHandler(n3, 4, false, n, 1);
        OS.XtAddEventHandler(n3, 8, false, n, 2);
        OS.XtAddEventHandler(n3, 16, false, n, 4);
        OS.XtAddEventHandler(n3, 32, false, n, 8);
        OS.XtAddEventHandler(n3, 1, false, n, 6);
        OS.XtAddEventHandler(n3, 2, false, n, 7);
        OS.XtInsertEventHandler(n3, 0x200000, false, n, 5, 1);
    }

    public int indexOf(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            return -1;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = OS.XmListItemPos(nArray2[1], n);
        OS.XmStringFree(n);
        return n2 - 1;
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        if (n < 0 || n >= n3) {
            return -1;
        }
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true);
        int n4 = OS.XmStringCreateLocalized(byArray);
        if (n4 == 0) {
            return -1;
        }
        int n5 = n;
        n2 += n * 4;
        int[] nArray3 = new int[1];
        while (n5 < n3) {
            OS.memmove(nArray3, n2, 4);
            if (OS.XmStringCompare(nArray3[0], n4)) break;
            n2 += 4;
            ++n5;
        }
        OS.XmStringFree(n4);
        if (n5 == n3) {
            return -1;
        }
        return n5;
    }

    public void paste() {
        this.checkWidget();
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextFieldPaste(nArray2[1]);
        this.display.setWarnings(bl);
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[1]) {
            this.error(6);
        }
        if (nArray2[1] == 1) {
            this.removeAll();
        } else {
            OS.XmComboBoxDeletePos(this.handle, n + 1);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n > n2 || n2 >= nArray2[1]) {
            this.error(6);
        }
        if (nArray2[1] == n2 - n + 1) {
            this.removeAll();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                OS.XmComboBoxDeletePos(this.handle, n + 1);
                ++n3;
            }
        }
    }

    void register() {
        super.register();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.addWidget(nArray2[1], this);
        this.display.addWidget(nArray2[3], this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.focusedCombo == this) {
            this.display.focusedCombo = null;
        }
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNlist;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n = OS.XtParent(nArray2[1]);
            while (n != 0 && !OS.XtIsSubclass(n, OS.shellWidgetClass())) {
                n = OS.XtParent(n);
            }
            if (n != 0) {
                OS.XtPopdown(n);
            }
        }
    }

    public void remove(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(15);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = OS.XmListItemPos(nArray2[1], n);
        OS.XmStringFree(n);
        if (n2 == 0) {
            this.error(5);
        }
        if (nArray2[3] == 1) {
            this.removeAll();
        } else {
            OS.XmComboBoxDeletePos(this.handle, n2);
        }
    }

    public void removeAll() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        nArray[4] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(nArray2[1], new byte[1]);
        this.display.setWarnings(bl);
        OS.XmListDeselectAllItems(nArray2[3]);
        int n = 0;
        while (n < nArray2[5]) {
            OS.XmComboBoxDeletePos(this.handle, 1);
            ++n;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n == -1) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNlist;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(nArray2[1], new byte[1]);
            this.display.setWarnings(bl);
            OS.XmListDeselectAllItems(nArray2[3]);
        } else {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNitemCount;
            int[] nArray3 = nArray;
            OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
            if (n < 0 || n >= nArray3[1]) {
                return;
            }
            int[] nArray4 = new int[]{OS.XmNselectedPosition, n};
            this.ignoreSelect = true;
            OS.XtSetValues(this.handle, nArray4, nArray4.length / 2);
            this.ignoreSelect = false;
        }
    }

    void sendFocusEvent(int n) {
        Display display = this.display;
        Combo combo = display.focusedCombo;
        if (n == 15 && combo != this) {
            super.sendFocusEvent(n);
            if (!this.isDisposed()) {
                display.focusedCombo = this;
            }
        }
    }

    boolean sendIMKeyEvent(int n, XKeyEvent xKeyEvent) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return super.sendIMKeyEvent(n, xKeyEvent, nArray2[1]);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNforeground;
        nArray3[2] = OS.XmNhighlightColor;
        int[] nArray4 = nArray3;
        OS.XtGetValues(n2, nArray4, nArray4.length / 2);
        OS.XmChangeColor(n2, n);
        OS.XtSetValues(n2, nArray4, nArray4.length / 2);
        int[] nArray5 = new int[4];
        nArray5[0] = OS.XmNforeground;
        nArray5[2] = OS.XmNhighlightColor;
        int[] nArray6 = nArray5;
        OS.XtGetValues(n3, nArray6, nArray6.length / 2);
        OS.XmChangeColor(n3, n);
        OS.XtSetValues(n3, nArray6, nArray6.length / 2);
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.checkWidget();
        int n5 = bl2 && (this.style & 4) != 0 ? this.getTextHeight() : n4;
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    public void setFont(Font font) {
        Object[] objectArray;
        boolean bl;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl2 = bl = OS.IsDBLocale && nArray2[3] == 0;
        if (bl) {
            objectArray = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int n = OS.XmStringCreateLocalized(objectArray);
            OS.XmComboBoxAddItem(this.handle, n, -1, false);
            OS.XmStringFree(n);
        }
        super.setFont(font);
        if (bl) {
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        if (OS.XtIsRealized(this.handle)) {
            int[] nArray3 = new int[6];
            nArray3[0] = OS.XmNwidth;
            nArray3[2] = OS.XmNheight;
            nArray3[4] = OS.XmNborderWidth;
            objectArray = nArray3;
            OS.XtGetValues(this.handle, objectArray, objectArray.length / 2);
            OS.XtResizeWidget(this.handle, objectArray[1], objectArray[3] + 1, objectArray[5]);
            OS.XtResizeWidget(this.handle, objectArray[1], objectArray[3], objectArray[5]);
        }
    }

    void setForegroundPixel(int n) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[]{OS.XmNforeground, n};
        OS.XtSetValues(nArray2[1], nArray3, nArray3.length / 2);
        OS.XtSetValues(nArray2[3], nArray3, nArray3.length / 2);
        super.setForegroundPixel(n);
    }

    public void setItem(int n, String string) {
        byte[] byArray;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[3]) {
            this.error(6);
        }
        if ((n2 = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        boolean bl = OS.XmListPosSelected(nArray2[1], n + 1);
        OS.XmListReplaceItemsPosUnselected(nArray2[1], new int[]{n2}, 1, n + 1);
        if (bl) {
            OS.XmListSelectPos(nArray2[1], n + 1, false);
        }
        OS.XmStringFree(n2);
    }

    public void setItems(String[] stringArray) {
        int n;
        Object[] objectArray;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                this.error(5);
            }
            ++n2;
        }
        if (stringArray.length == 0) {
            this.removeAll();
            return;
        }
        n2 = 0;
        int[] nArray = new int[stringArray.length];
        String string = this.getCodePage();
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            objectArray = Converter.wcsToMbcs(string, this.encodeString(string2), true);
            n = OS.XmStringCreateLocalized(objectArray);
            if (n == 0) break;
            nArray[n2++] = n;
        }
        int n3 = OS.XtMalloc(n2 * 4);
        OS.memmove(n3, nArray, n2 * 4);
        objectArray = new int[]{OS.XmNitems, n3, OS.XmNitemCount, n2};
        OS.XtSetValues(this.handle, objectArray, objectArray.length / 2);
        n = 0;
        while (n < n2) {
            OS.XmStringFree(nArray[n]);
            ++n;
        }
        OS.XtFree(n3);
        if (n2 < stringArray.length) {
            this.error(14);
        }
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNtextField;
        int[] nArray3 = nArray2;
        OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(nArray3[1], new byte[1]);
        this.display.setWarnings(bl);
        int[] nArray4 = new int[2];
        nArray4[0] = OS.XmNlist;
        int[] nArray5 = nArray4;
        OS.XtGetValues(this.handle, nArray5, nArray5.length / 2);
        int[] nArray6 = new int[4];
        nArray6[0] = OS.XmNselectedItemCount;
        nArray6[2] = OS.XmNselectedItems;
        int[] nArray7 = nArray6;
        OS.XtSetValues(nArray5[1], nArray7, nArray7.length / 2);
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = OS.XmTextGetLastPosition(nArray2[1]);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((n = OS.XtDisplay(nArray2[1])) == 0) {
            return;
        }
        int n3 = Math.min(Math.max(Math.min(point.x, point.y), 0), n2);
        int n4 = Math.min(Math.max(Math.max(point.x, point.y), 0), n2);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(nArray2[1], n3, n4, OS.XtLastTimestampProcessed(n));
        OS.XmTextSetInsertionPosition(nArray2[1], n4);
        this.display.setWarnings(bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1) {
                this.select(n);
            }
        } else {
            byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
            int n = OS.XmStringCreateLocalized(byArray);
            if (n == 0) {
                return;
            }
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNlist;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n2 = OS.XmListItemPos(nArray2[3], n);
            if (n2 > 0) {
                OS.XmComboBoxSelectItem(this.handle, n);
            } else {
                boolean bl = this.display.getWarnings();
                this.display.setWarnings(false);
                OS.XmTextSetString(nArray2[1], byArray);
                OS.XmTextSetInsertionPosition(nArray2[1], 0);
                this.display.setWarnings(bl);
            }
            OS.XmStringFree(n);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmTextSetMaxLength(nArray2[1], n);
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[]{OS.XmNvisibleItemCount, n};
        OS.XtSetValues(nArray2[1], nArray3, nArray3.length / 2);
    }

    void deregister() {
        super.deregister();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.removeWidget(nArray2[1]);
        this.display.removeWidget(nArray2[3]);
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.enableHandle(bl, nArray2[1]);
        this.enableHandle(bl, nArray2[3]);
    }

    String encodeString(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ') {
                return string;
            }
            ++n;
        }
        return String.valueOf(string) + ' ';
    }

    String decodeString(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ') {
                return string;
            }
            ++n;
        }
        return string.substring(0, string.length() - 1);
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        this.postEvent(14);
        return 0;
    }

    int XmNbrowseSelectionCallback(int n, int n2, int n3) {
        if (this.ignoreSelect || this.getSelectionIndex() == -1) {
            return 0;
        }
        this.postEvent(13);
        return 0;
    }

    int XmNmodifyVerifyCallback(int n, int n2, int n3) {
        Object object;
        int n4 = super.XmNmodifyVerifyCallback(n, n2, n3);
        if (n4 != 0) {
            return n4;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return n4;
        }
        XmTextVerifyCallbackStruct xmTextVerifyCallbackStruct = new XmTextVerifyCallbackStruct();
        OS.memmove(xmTextVerifyCallbackStruct, n3, 32);
        XmTextBlockRec xmTextBlockRec = new XmTextBlockRec();
        OS.memmove(xmTextBlockRec, xmTextVerifyCallbackStruct.text, 12);
        byte[] byArray = new byte[xmTextBlockRec.length];
        OS.memmove(byArray, xmTextBlockRec.ptr, xmTextBlockRec.length);
        String string = this.getCodePage();
        String string2 = new String(Converter.mbcsToWcs(string, byArray));
        Event event = new Event();
        if (xmTextVerifyCallbackStruct.event != 0) {
            object = new XKeyEvent();
            OS.memmove((XKeyEvent)object, xmTextVerifyCallbackStruct.event, 60);
            event.time = ((XKeyEvent)object).time;
            this.setKeyState(event, (XKeyEvent)object);
        }
        event.start = xmTextVerifyCallbackStruct.startPos;
        event.end = xmTextVerifyCallbackStruct.endPos;
        event.doit = xmTextVerifyCallbackStruct.doit == 1;
        event.text = string2;
        this.sendEvent(25, event);
        object = event.text;
        xmTextVerifyCallbackStruct.doit = (byte)(event.doit && object != null ? 1 : 0);
        if (object != null && object != string2) {
            OS.XtFree(xmTextBlockRec.ptr);
            byte[] byArray2 = Converter.wcsToMbcs(string, (String)object, true);
            int n5 = byArray2.length;
            int n6 = OS.XtMalloc(n5);
            OS.memmove(n6, byArray2, n5);
            xmTextBlockRec.ptr = n6;
            xmTextBlockRec.length = byArray2.length - 1;
            OS.memmove(xmTextVerifyCallbackStruct.text, xmTextBlockRec, 12);
        }
        OS.memmove(n3, xmTextVerifyCallbackStruct, 32);
        return n4;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        this.sendEvent(24);
        return 0;
    }
}

