/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    Color fg;
    Color bg;
    Calendar calendar = Calendar.getInstance();
    DateFormatSymbols formatSymbols = new DateFormatSymbols();
    Button down;
    Button up;
    Button monthDown;
    Button monthUp;
    Button yearDown;
    Button yearUp;
    Text text;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MARGIN_WIDTH = 2;
    static final int MARGIN_HEIGHT = 1;
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n) | 0x100000);
        if ((this.style & 0x400) != 0) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 9: {
                            DateTime.this.handlePaint(event);
                            break;
                        }
                        case 11: {
                            DateTime.this.handleResize(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.handleMouseDown(event);
                            break;
                        }
                        case 1: {
                            DateTime.this.handleKeyDown(event);
                            break;
                        }
                        case 31: {
                            DateTime.this.handleTraverse(event);
                        }
                    }
                }
            };
            this.addListener(9, listener);
            this.addListener(11, listener);
            this.addListener(3, listener);
            this.addListener(1, listener);
            this.addListener(31, listener);
            this.yearDown = new Button(this, 16388);
            this.monthDown = new Button(this, 16388);
            this.monthUp = new Button(this, 131076);
            this.yearUp = new Button(this, 131076);
            listener = new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.handleSelection(event);
                }
            };
            this.yearDown.addListener(13, listener);
            this.monthDown.addListener(13, listener);
            this.monthUp.addListener(13, listener);
            this.yearUp.addListener(13, listener);
        } else {
            this.text = new Text(this, 4);
            if ((this.style & 0x20) != 0) {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
            } else {
                this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
            }
            this.text.setText(this.getFormattedString(this.style));
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            DateTime.this.onKeyDown(event);
                            break;
                        }
                        case 15: {
                            DateTime.this.onFocusIn(event);
                            break;
                        }
                        case 16: {
                            DateTime.this.onFocusOut(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 4: {
                            DateTime.this.onMouseClick(event);
                            break;
                        }
                        case 25: {
                            DateTime.this.onVerify(event);
                        }
                    }
                }
            };
            this.text.addListener(1, listener);
            this.text.addListener(15, listener);
            this.text.addListener(16, listener);
            this.text.addListener(3, listener);
            this.text.addListener(4, listener);
            this.text.addListener(25, listener);
            this.up = new Button(this, 132);
            this.down = new Button(this, 1028);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.onResize(event);
                }
            });
        }
    }

    static int checkStyle(int n) {
        n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    String formattedStringValue(int n, int n2, boolean bl) {
        if (n == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            return stringArray[n2];
        }
        if (bl) {
            if (n == 10 && n2 == 0) {
                return String.valueOf(12);
            }
            if (n == 2) {
                return String.valueOf(n2 + 1);
            }
        }
        return String.valueOf(n2);
    }

    String getFormattedString(int n) {
        if ((n & 0x80) != 0) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            int n2 = this.calendar.get(10);
            if (n2 == 0) {
                n2 = 12;
            }
            int n3 = this.calendar.get(12);
            int n4 = this.calendar.get(13);
            int n5 = this.calendar.get(9);
            if ((n & 0x8000) != 0) {
                return (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? " " : "") + n3 + " " + stringArray[n5];
            }
            return (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? " " : "") + n3 + ":" + (n4 < 10 ? " " : "") + n4 + " " + stringArray[n5];
        }
        int n6 = this.calendar.get(1);
        int n7 = this.calendar.get(2) + 1;
        int n8 = this.calendar.get(5);
        if ((n & 0x8000) != 0) {
            return (n7 < 10 ? " " : "") + n7 + "/" + n6;
        }
        return (n7 < 10 ? " " : "") + n7 + "/" + (n8 < 10 ? " " : "") + n8 + "/" + n6;
    }

    String getComputeSizeString(int n) {
        if ((n & 0x20) != 0) {
            return (n & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((n & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (n & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((n & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int n) {
        int n2 = 0;
        while (n2 < this.fieldCount) {
            if (this.fieldNames[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int n;
            this.characterCount = 0;
            int n2 = this.fieldNames[this.currentField];
            int n3 = this.fieldIndices[this.currentField].x;
            int n4 = this.fieldIndices[this.currentField].y;
            String string = this.text.getText(n3, n4 - 1);
            int n5 = string.lastIndexOf(32);
            if (n5 != -1) {
                string = string.substring(n5 + 1);
            }
            if ((n = this.unformattedIntValue(n2, string, this.characterCount == 0, this.calendar.getActualMaximum(n2))) != -1) {
                this.setTextField(n2, n, true, true);
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x400) != 0) {
            object = this.getCellSize(null);
            Point point = this.monthDown.computeSize(-1, -1, bl);
            n3 = ((Point)object).x * 7;
            n4 = ((Point)object).y * 7 + Math.max(((Point)object).y, point.y);
        } else {
            object = new GC(this.text);
            Point point = ((GC)object).stringExtent(this.getComputeSizeString(this.style));
            ((GC)object).dispose();
            Rectangle rectangle = this.text.computeTrim(0, 0, point.x, point.y);
            Point point2 = this.up.computeSize(-1, -1, bl);
            n3 = rectangle.width + point2.x;
            n4 = Math.max(rectangle.height, point2.y);
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 + 2 * n5, n4 + 2 * n5);
    }

    void drawDay(GC gC, Point point, int n) {
        int n2 = this.getCell(n);
        Point point2 = this.getCellLocation(n2, point);
        String string = String.valueOf(n);
        Point point3 = gC.stringExtent(string);
        int n3 = this.calendar.get(5);
        if (n == n3) {
            Display display = this.getDisplay();
            gC.setBackground(display.getSystemColor(26));
            gC.setForeground(display.getSystemColor(27));
            gC.fillRectangle(point2.x, point2.y, point.x, point.y);
        }
        gC.drawString(string, point2.x + (point.x - point3.x) / 2, point2.y + (point.y - point3.y) / 2, true);
        if (n == n3) {
            gC.setBackground(this.getBackground());
            gC.setForeground(this.getForeground());
        }
    }

    void drawDays(GC gC, Point point, Rectangle rectangle) {
        gC.setBackground(this.getBackground());
        gC.setForeground(this.getForeground());
        gC.fillRectangle(0, point.y, rectangle.width, point.y * 7);
        int n = this.calendar.getActualMinimum(5);
        int n2 = this.calendar.getActualMaximum(5);
        int n3 = n;
        while (n3 <= n2) {
            this.drawDay(gC, point, n3);
            ++n3;
        }
    }

    void drawDaysOfWeek(GC gC, Point point, Rectangle rectangle) {
        Display display = this.getDisplay();
        gC.setBackground(display.getSystemColor(22));
        gC.setForeground(display.getSystemColor(21));
        gC.fillRectangle(0, 0, rectangle.width, point.y);
        String[] stringArray = this.formatSymbols.getShortWeekdays();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < stringArray.length) {
            String string = stringArray[n3];
            Point point2 = gC.stringExtent(string);
            gC.drawString(string, n + (point.x - point2.x) / 2, n2 + (point.y - point2.y) / 2, true);
            n += point.x;
            ++n3;
        }
        gC.drawLine(0, point.y - 1, rectangle.width, point.y - 1);
    }

    void drawMonth(GC gC, Point point, Rectangle rectangle) {
        Display display = this.getDisplay();
        gC.setBackground(display.getSystemColor(22));
        gC.setForeground(display.getSystemColor(21));
        int n = point.y * 7;
        gC.fillRectangle(0, n, rectangle.width, point.y);
        gC.drawLine(0, n - 1, rectangle.width, n - 1);
        String string = String.valueOf(this.formatSymbols.getShortMonths()[this.calendar.get(2)]) + ", " + this.calendar.get(1);
        Point point2 = gC.stringExtent(string);
        gC.drawString(string, (point.x * 7 - point2.x) / 2, n + (point.y - point2.y) / 2, true);
    }

    Point getCellSize(GC gC) {
        boolean bl;
        boolean bl2 = bl = gC == null;
        if (gC == null) {
            gC = new GC(this);
        }
        int n = 0;
        int n2 = 0;
        String[] stringArray = this.formatSymbols.getShortWeekdays();
        int n3 = 0;
        while (n3 < stringArray.length) {
            Point point = gC.stringExtent(stringArray[n3]);
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
            ++n3;
        }
        n3 = this.calendar.getMinimum(5);
        int n4 = this.calendar.getMaximum(5);
        int n5 = n3;
        while (n5 <= n4) {
            Point point = gC.stringExtent(String.valueOf(n5));
            n = Math.max(n, point.x);
            n2 = Math.max(n2, point.y);
            ++n5;
        }
        if (bl) {
            gC.dispose();
        }
        return new Point(n + 4, n2 + 2);
    }

    Point getCellLocation(int n, Point point) {
        return new Point(n % 7 * point.x, n / 7 * point.y);
    }

    int getCell(int n) {
        int n2 = this.calendar.get(5);
        this.calendar.set(5, 1);
        int n3 = n + this.calendar.get(7) + 5;
        this.calendar.set(5, n2);
        return n3;
    }

    int getDate(int n) {
        int n2 = this.calendar.get(5);
        this.calendar.set(5, 1);
        int n3 = n - this.calendar.get(7) - 5;
        this.calendar.set(5, n2);
        return n3;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bg == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.bg;
    }

    public int getDay() {
        this.checkWidget();
        return this.calendar.get(5);
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fg == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.fg;
    }

    public int getHours() {
        this.checkWidget();
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        return this.calendar.get(2);
    }

    public int getSeconds() {
        this.checkWidget();
        return this.calendar.get(13);
    }

    public int getYear() {
        this.checkWidget();
        return this.calendar.get(1);
    }

    void handleKeyDown(Event event) {
        int n = this.calendar.get(5);
        switch (event.keyCode) {
            case 0x1000002: {
                n += 7;
                break;
            }
            case 0x1000001: {
                n -= 7;
                break;
            }
            case 0x1000004: {
                ++n;
                break;
            }
            case 0x1000003: {
                --n;
            }
        }
        this.setDay(n, true);
    }

    void handleMouseDown(Event event) {
        this.setFocus();
        Point point = this.getCellSize(null);
        int n = event.x / point.x;
        int n2 = event.y / point.y;
        int n3 = n2 * 7 + n;
        int n4 = this.getDate(n3);
        this.setDay(n4, true);
    }

    void handlePaint(Event event) {
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        Point point = this.getCellSize(gC);
        this.drawDaysOfWeek(gC, point, rectangle);
        this.drawDays(gC, point, rectangle);
        this.drawMonth(gC, point, rectangle);
    }

    void handleResize(Event event) {
        this.yearDown.pack();
        this.monthDown.pack();
        this.monthUp.pack();
        this.yearUp.pack();
        Point point = this.getCellSize(null);
        Point point2 = this.monthDown.getSize();
        int n = Math.max(point.y, point2.y);
        int n2 = point.y * 7 + (n - point2.y) / 2;
        this.yearDown.setLocation(0, n2);
        this.monthDown.setLocation(point2.x, n2);
        int n3 = point.x * 7 - point2.x;
        this.monthUp.setLocation(n3 - point2.x, n2);
        this.yearUp.setLocation(n3, n2);
    }

    void handleSelection(Event event) {
        if (event.widget == this.monthDown) {
            this.calendar.add(2, -1);
        } else if (event.widget == this.monthUp) {
            this.calendar.add(2, 1);
        } else if (event.widget == this.yearDown) {
            this.calendar.add(1, -1);
        } else if (event.widget == this.yearUp) {
            this.calendar.add(1, 1);
        } else {
            return;
        }
        this.redraw();
        this.notifyListeners(13, new Event());
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    boolean isValid(int n, int n2) {
        int n3 = this.calendar.getActualMinimum(n);
        int n4 = this.calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                break;
            }
            case 0x1000003: {
                int n = this.currentField - 1;
                this.selectField(n < 0 ? this.fieldCount - 1 : n);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMinimum(n), true, true);
                break;
            }
            case 0x1000008: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMaximum(n), true, true);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                    }
                }
            }
        }
    }

    void onFocusIn(Event event) {
        this.selectField(this.currentField);
    }

    void onFocusOut(Event event) {
        this.commitCurrentField();
    }

    void onMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point point = this.text.getSelection();
        int n = 0;
        while (n < this.fieldCount) {
            if (point.x >= this.fieldIndices[n].x && point.x <= this.fieldIndices[n].y) {
                this.currentField = n;
                break;
            }
            ++n;
        }
        this.selectField(this.currentField);
    }

    void onResize(Event event) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.up.computeSize(-1, n2);
        int n3 = point.y / 2;
        this.text.setBounds(0, 0, n - point.x, n2);
        this.up.setBounds(n - point.x, 0, point.x, n3);
        this.down.setBounds(n - point.x, n3, point.x, n3);
    }

    void onVerify(Event event) {
        int n;
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.fieldIndices[this.currentField].x;
        int n4 = this.fieldIndices[this.currentField].y;
        int n5 = n4 - n3;
        String string = event.text;
        if (n2 == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            if (string.equalsIgnoreCase(stringArray[0].substring(0, 1)) || string.equalsIgnoreCase(stringArray[0])) {
                this.setTextField(n2, 0, true, false);
            } else if (string.equalsIgnoreCase(stringArray[1].substring(0, 1)) || string.equalsIgnoreCase(stringArray[1])) {
                this.setTextField(n2, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String string2 = this.text.getText(n3, n4 - 1);
            n = string2.lastIndexOf(32);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            string = string2 + string;
        }
        int n6 = string.length();
        n = this.characterCount == 0 ? 1 : 0;
        this.characterCount = n6 < n5 ? n6 : 0;
        int n7 = this.calendar.getActualMaximum(n2);
        int n8 = this.calendar.getActualMinimum(n2);
        int n9 = this.unformattedIntValue(n2, string, this.characterCount == 0, n7);
        if (n9 == -1) {
            this.characterCount = 0;
            return;
        }
        if (n != 0 && n9 == 0 && n5 > 1) {
            this.setTextField(n2, n9, false, false);
        } else if (n8 <= n9 && n9 <= n7) {
            this.setTextField(n2, n9, this.characterCount == 0, this.characterCount == 0);
        } else if (n6 >= n5 && (n9 = this.unformattedIntValue(n2, string = string.substring(n6 - n5 + 1), this.characterCount == 0, n7)) != -1) {
            this.characterCount = n5 - 1;
            if (n8 <= n9 && n9 <= n7) {
                this.setTextField(n2, n9, this.characterCount == 0, true);
            }
        }
    }

    void incrementField(int n) {
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.calendar.get(n2);
        if (n2 == 10) {
            int n4 = this.calendar.getMaximum(10);
            int n5 = this.calendar.getMinimum(10);
            if (n3 == n4 && n == 1 || n3 == n5 && n == -1) {
                int n6 = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = n6;
            }
        }
        this.setTextField(n2, n3 + n, true, true);
    }

    void selectField(int n) {
        if (n != this.currentField) {
            this.commitCurrentField();
        }
        final int n2 = this.fieldIndices[n].x;
        final int n3 = this.fieldIndices[n].y;
        Point point = this.text.getSelection();
        if (n == this.currentField && n2 == point.x && n3 == point.y) {
            return;
        }
        this.currentField = n;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String string = DateTime.this.text.getText(n2, n3 - 1);
                    int n = string.lastIndexOf(32);
                    n = n == -1 ? n2 : n2 + n + 1;
                    DateTime.this.text.setSelection(n, n3);
                }
            }
        });
    }

    void setTextField(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        if (bl) {
            n4 = this.calendar.getActualMaximum(n);
            n3 = this.calendar.getActualMinimum(n);
            if (n == 1) {
                n4 = 9999;
                n3 = 1752;
                int n5 = Calendar.getInstance().get(1);
                int n6 = n5 / 100 * 100;
                if (n2 < (n5 + 30) % 100) {
                    n2 += n6;
                } else if (n2 < 100) {
                    n2 += n6 - 100;
                }
            }
            if (n2 > n4) {
                n2 = n3;
            }
            if (n2 < n3) {
                n2 = n4;
            }
        }
        n4 = this.fieldIndices[this.currentField].x;
        n3 = this.fieldIndices[this.currentField].y;
        this.text.setSelection(n4, n3);
        String string = this.formattedStringValue(n, n2, bl2);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n7 = n3 - n4 - stringBuffer.length();
        int n8 = 0;
        while (n8 < n7) {
            stringBuffer.insert(0, ' ');
            ++n8;
        }
        string = stringBuffer.toString();
        this.ignoreVerify = true;
        this.text.insert(string);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (bl) {
            this.setField(n, n2);
        }
    }

    void setField(int n, int n2) {
        if (this.calendar.get(n) == n2) {
            return;
        }
        if (n == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(n, n2);
        this.notifyListeners(13, new Event());
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    void redraw(int n, Point point) {
        Point point2 = this.getCellLocation(n, point);
        this.redraw(point2.x, point2.y, point.x, point.y, false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.bg = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValid(5, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.setDay(n, false);
        } else {
            this.calendar.set(5, n);
            this.updateControl();
        }
    }

    void setDay(int n, boolean bl) {
        int n2 = this.calendar.getActualMinimum(5);
        int n3 = this.calendar.getActualMaximum(5);
        if (n2 > n || n > n3) {
            return;
        }
        Point point = this.getCellSize(null);
        this.redraw(this.getCell(this.calendar.get(5)), point);
        this.calendar.set(5, n);
        this.redraw(this.getCell(this.calendar.get(5)), point);
        if (bl) {
            this.notifyListeners(13, new Event());
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        this.fg = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.checkWidget();
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValid(11, n)) {
            return;
        }
        this.calendar.set(11, n);
        this.updateControl();
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValid(12, n)) {
            return;
        }
        this.calendar.set(12, n);
        this.updateControl();
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValid(2, n)) {
            return;
        }
        this.calendar.set(2, n);
        this.updateControl();
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValid(13, n)) {
            return;
        }
        this.calendar.set(13, n);
        this.updateControl();
    }

    public void setYear(int n) {
        this.checkWidget();
        if (n < 1752 || n > 9999) {
            return;
        }
        this.calendar.set(1, n);
        this.updateControl();
    }

    int unformattedIntValue(int n, String string, boolean bl, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n == 2 && bl && --n3 == -1) {
            n3 = n2;
        }
        if (n == 10 && bl && n3 == 12) {
            n3 = 0;
        }
        return n3;
    }

    public void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

