/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        Rectangle rectangle;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n5 = this.layout.getWidth();
        if (n == 0) {
            this.layout.setWidth(1);
            rectangle = this.layout.getBounds();
            n4 = 0;
            n3 = rectangle.height;
        } else {
            this.layout.setWidth(n);
            rectangle = this.layout.getBounds();
            n4 = rectangle.width;
            n3 = rectangle.height;
        }
        this.layout.setWidth(n5);
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n6 = this.getBorderWidth();
        return new Point(n4 += n6 * 2, n3 += n6 * 2);
    }

    void createHandle(int n) {
        this.state |= 0x80;
        int[] nArray = new int[12];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNborderWidth;
        nArray[3] = (this.style & 0x800) != 0 ? 1 : 0;
        nArray[4] = OS.XmNmarginWidth;
        nArray[6] = OS.XmNmarginHeight;
        nArray[8] = OS.XmNresizePolicy;
        nArray[10] = OS.XmNtraversalOn;
        int[] nArray2 = nArray;
        this.handle = OS.XmCreateDrawingArea(this.parent.handle, null, nArray2, nArray2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        this.layout = new TextLayout(this.display);
        this.linkColor = new Color(this.display, LINK_FOREGROUND);
        this.disabledColor = new Color(this.display, LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            ++n;
        }
        this.redraw();
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n5++] = this.layout.getBounds(point.x, nArray[n3] - 1);
            rectangleArray[n5++] = this.layout.getBounds(nArray[n4 - 1], point.y);
            if (n4 - n3 > 1) {
                int n6 = n3;
                while (n6 < n4 - 1) {
                    rectangleArray[n5++] = this.layout.getLineBounds(n6);
                    ++n6;
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, n9, n4, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && bl2) {
            this.layout.setWidth(n3 > 0 ? n3 : -1);
            this.redraw();
        }
        return bl3;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.layout.setFont(this.font);
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = OS.XtWindow(this.handle);
        if (n2 == 0) {
            return;
        }
        OS.XClearArea(n, n2, 0, 0, 0, 0, true);
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        int n2 = OS.XtDisplay(this.handle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XtWindow(this.handle);
        if (n3 == 0) {
            return;
        }
        OS.XClearArea(n2, n3, 0, 0, 0, 0, true);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        int[] nArray = new int[]{OS.XmNtraversalOn, this.offsets.length > 0 ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNsensitive;
        int[] nArray3 = nArray2;
        OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
        boolean bl = nArray3[1] != 0;
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            ++n;
        }
        TextStyle textStyle2 = new TextStyle(null, null, null);
        textStyle2.underline = true;
        int n2 = 0;
        while (n2 < this.mnemonics.length) {
            int n3 = this.mnemonics[n2];
            if (n3 != -1) {
                this.layout.setStyle(textStyle2, n3, n3);
            }
            ++n2;
        }
        this.redraw();
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int n2 = super.traversalCode(n, xKeyEvent);
        if (xKeyEvent != null && n == 65289) {
            boolean bl;
            boolean bl2 = bl = (xKeyEvent.state & 1) == 0;
            if (bl && this.focusIndex < this.offsets.length - 1) {
                return n2 & 0xFFFFFFEF;
            }
            if (!bl && this.focusIndex > 0) {
                return n2 & 0xFFFFFFF7;
            }
        }
        return n2;
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        if (xButtonEvent.button == 1) {
            int n6 = this.layout.getOffset(xButtonEvent.x, xButtonEvent.y, null);
            int n7 = this.selection.x;
            int n8 = this.selection.y;
            this.selection.x = n6;
            this.selection.y = -1;
            if (n7 != -1 && n8 != -1) {
                if (n7 > n8) {
                    int n9 = n7;
                    n7 = n8;
                    n8 = n9;
                }
                Rectangle rectangle = this.layout.getBounds(n7, n8);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int n10 = 0;
            while (n10 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n10);
                int n11 = 0;
                while (n11 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n11];
                    if (rectangle.contains(xButtonEvent.x, xButtonEvent.y)) {
                        this.focusIndex = n10;
                        this.redraw();
                        return n5;
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        return n5;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonRelease(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        if (this.focusIndex == -1) {
            return n5;
        }
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        if (xButtonEvent.button == 1) {
            Rectangle[] rectangleArray = this.getRectangles(this.focusIndex);
            int n6 = 0;
            while (n6 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n6];
                if (rectangle.contains(xButtonEvent.x, xButtonEvent.y)) {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.notifyListeners(13, event);
                    return n5;
                }
                ++n6;
            }
        }
        return n5;
    }

    int XExposure(int n, int n2, int n3, int n4) {
        Rectangle[] rectangleArray;
        XExposeEvent xExposeEvent = new XExposeEvent();
        OS.memmove(xExposeEvent, n3, 40);
        int n5 = OS.XtDisplay(this.handle);
        if (n5 == 0) {
            return 0;
        }
        XRectangle xRectangle = new XRectangle();
        xRectangle.x = (short)xExposeEvent.x;
        xRectangle.y = (short)xExposeEvent.y;
        xRectangle.width = (short)xExposeEvent.width;
        xRectangle.height = (short)xExposeEvent.height;
        int n6 = OS.XCreateRegion();
        OS.XUnionRectWithRegion(xRectangle, n6, n6);
        GCData gCData = new GCData();
        gCData.damageRgn = n6;
        GC gC = GC.motif_new(this, gCData);
        OS.XSetRegion(n5, gC.handle, n6);
        int n7 = this.selection.x;
        int n8 = this.selection.y;
        if (n7 > n8) {
            n7 = this.selection.y;
            n8 = this.selection.x;
        }
        n8 = -1;
        n7 = -1;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n7, n8, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectangles(this.focusIndex);
            int n9 = 0;
            while (n9 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n9];
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n9;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.count = xExposeEvent.count;
            rectangleArray.x = xExposeEvent.x;
            rectangleArray.y = xExposeEvent.y;
            rectangleArray.width = xExposeEvent.width;
            rectangleArray.height = xExposeEvent.height;
            rectangleArray.gc = GC.motif_new(this, gCData);
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
        gC.dispose();
        OS.XDestroyRegion(n6);
        return 0;
    }

    int XFocusChange(int n, int n2, int n3, int n4) {
        int n5 = super.XFocusChange(n, n2, n3, n4);
        this.redraw();
        return n5;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        if (this.focusIndex == -1) {
            return n5;
        }
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        int[] nArray = new int[1];
        OS.XLookupString(xKeyEvent, null, 0, nArray, null);
        nArray[0] = nArray[0] & 0xFFFF;
        switch (nArray[0]) {
            case 32: 
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendEvent(13, event);
                break;
            }
            case 65289: {
                if (this.focusIndex >= this.offsets.length - 1) break;
                ++this.focusIndex;
                this.redraw();
                OS.memmove(n4, new int[1], 4);
                return 1;
            }
            case 65056: {
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
                OS.memmove(n4, new int[1], 4);
                return 1;
            }
        }
        return n5;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        int n5 = super.XPointerMotion(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XMotionEvent xMotionEvent = new XMotionEvent();
        OS.memmove(xMotionEvent, n3, 60);
        if ((xMotionEvent.state & 0x100) != 0) {
            int n6 = this.selection.y;
            this.selection.y = this.layout.getOffset(xMotionEvent.x, xMotionEvent.y, null);
            if (this.selection.y != n6) {
                int n7 = this.selection.y;
                if (n6 > n7) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                }
                Rectangle rectangle = this.layout.getBounds(n6, n7);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            return n5;
        }
        int n9 = 0;
        while (n9 < this.offsets.length) {
            Rectangle[] rectangleArray = this.getRectangles(n9);
            int n10 = 0;
            while (n10 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n10];
                if (rectangle.contains(xMotionEvent.x, xMotionEvent.y)) {
                    this.setCursor(this.display.getSystemCursor(21));
                    return n5;
                }
                ++n10;
            }
            ++n9;
        }
        this.setCursor(null);
        return n5;
    }
}

