/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    boolean hasLocation;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    void _setVisible(boolean bl) {
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                int n = OS.XtDisplay(this.handle);
                if (n == 0) {
                    return;
                }
                int n2 = OS.XDefaultRootWindow(n);
                if (n2 == 0) {
                    return;
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                if (OS.XQueryPointer(n, n2, nArray, nArray, nArray2, nArray3, nArray, nArray, nArray4) == 0) {
                    return;
                }
                if (!this.hasLocation) {
                    nArray2[0] = nArray2[0] + 1;
                    nArray3[0] = nArray3[0] + 1;
                    int[] nArray5 = new int[]{OS.XmNx, nArray2[0], OS.XmNy, nArray3[0]};
                    OS.XtSetValues(this.handle, nArray5, nArray5.length / 2);
                }
                OS.XUngrabPointer(n, 0);
                OS.XtManageChild(this.handle);
                int n3 = 1792;
                if ((nArray4[0] & n3) == 0) {
                    OS._XmSetMenuTraversal(this.handle, true);
                }
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.XtUnmanageChild(this.handle);
        }
    }

    void addAccelerators() {
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            menuItem.addAccelerators();
            ++n;
        }
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    void createHandle(int n) {
        int n2;
        Object[] objectArray;
        int n3 = 0;
        int n4 = 0;
        if (Display.DisplayDisposed) {
            objectArray = new int[1];
            int n5 = OS.XtCreateApplicationContext();
            n3 = OS.XtOpenDisplay(n5, null, null, null, 0, 0, objectArray, 0);
            n4 = OS.XtAppCreateShell(null, null, OS.topLevelShellWidgetClass(), n3, null, 0);
        }
        if ((this.style & 2) != 0) {
            int n6 = this.parent.scrolledHandle;
            int[] nArray = new int[]{OS.XmNancestorSensitive, 1};
            this.handle = OS.XmCreateMenuBar(n6, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        objectArray = new byte[1];
        int[] nArray = new int[]{OS.XmNancestorSensitive, 1};
        if ((this.style & 8) != 0) {
            n2 = this.parent.dialogHandle();
            this.handle = OS.XmCreatePopupMenu(n2, (byte[])objectArray, nArray, nArray.length / 2);
        } else {
            n2 = this.parent.scrolledHandle;
            this.handle = OS.XmCreatePulldownMenu(n2, (byte[])objectArray, nArray, nArray.length / 2);
        }
        if (this.handle == 0) {
            this.error(2);
        }
        if (Display.DisplayDisposed) {
            if (n4 != 0) {
                OS.XtDestroyWidget(n4);
            }
            if (n3 != 0) {
                n2 = OS.XtDisplayToApplicationContext(n3);
                OS.XtDestroyApplicationContext(n2);
            }
        }
    }

    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.XtIsManaged(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        if ((this.style & 2) != 0) {
            short[] sArray = new short[1];
            short[] sArray2 = new short[1];
            OS.XtTranslateCoords(this.handle, (short)n, (short)n, sArray, sArray2);
            n = sArray[0];
            n2 = sArray2[0];
        }
        return new Rectangle(n, n2, nArray2[5], nArray2[7]);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public MenuItem getItem(int n) {
        Widget widget;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0) {
            this.error(8);
        }
        int[] nArray3 = new int[nArray2[3]];
        OS.memmove(nArray3, nArray2[1], nArray2[3] * 4);
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray2[3]) {
            if (OS.XtIsManaged(nArray3[n2])) {
                if (n == n3) break;
                ++n3;
            }
            ++n2;
        }
        if (n != n3) {
            this.error(6);
        }
        if (!((widget = this.display.getWidget(nArray3[n2])) instanceof MenuItem)) {
            this.error(8);
        }
        return (MenuItem)widget;
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0 || nArray2[3] == 0) {
            return 0;
        }
        int[] nArray3 = new int[nArray2[3]];
        OS.memmove(nArray3, nArray2[1], nArray2[3] * 4);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray2[3]) {
            if (OS.XtIsManaged(nArray3[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public MenuItem[] getItems() {
        Object object;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        if (n2 == 0 || n == 0) {
            return new MenuItem[0];
        }
        int[] nArray3 = new int[n2];
        OS.memmove(nArray3, n, n2 * 4);
        MenuItem[] menuItemArray = new MenuItem[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            object = this.display.getWidget(nArray3[n3]);
            if (object != null) {
                menuItemArray[n4++] = (MenuItem)object;
            }
            ++n3;
        }
        if (n3 == n4) {
            return menuItemArray;
        }
        object = new MenuItem[n4];
        System.arraycopy(menuItemArray, 0, object, 0, n4);
        return object;
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n - 1) {
                string = String.valueOf(string) + menuItemArray[n2].getNameText() + ", ";
                ++n2;
            }
            string = String.valueOf(string) + menuItemArray[n - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 8) != 0 && (menuArray = this.display.popups) != null) {
            int n = 0;
            while (n < menuArray.length) {
                if (menuArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        return OS.XtIsManaged(this.handle);
    }

    void hookEvents() {
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, n, 17);
        OS.XtAddCallback(this.handle, OS.XmNmapCallback, n, 28);
        OS.XtAddCallback(this.handle, OS.XmNunmapCallback, n, 29);
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[nArray2[3]];
        OS.memmove(nArray3, nArray2[1], nArray3.length * 4);
        int n = 0;
        int n2 = 0;
        while (n2 < nArray3.length) {
            if (OS.XtIsManaged(nArray3[n2])) {
                if (nArray3[n2] == menuItem.handle) {
                    return n;
                }
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            if (menuItem != null && !menuItem.isDisposed()) {
                menuItem.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    void removeAccelerators() {
        MenuItem[] menuItemArray = this.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n];
            menuItem.removeAccelerators();
            ++n;
        }
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void sendHelpEvent(int n) {
        if (this.hooks(28)) {
            this.postEvent(28);
            return;
        }
        this.parent.sendHelpEvent(n);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem != null && menuItem.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = menuItem;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNsensitive, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNx, n, OS.XmNy, n2};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    boolean translateAccelerator(int n, boolean bl) {
        if (!this.getEnabled()) {
            return false;
        }
        MenuItem[] menuItemArray = this.getItems();
        int n2 = 0;
        while (n2 < menuItemArray.length) {
            MenuItem menuItem = menuItemArray[n2];
            if (menuItem.translateAccelerator(n, bl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int XmNhelpCallback(int n, int n2, int n3) {
        this.sendHelpEvent(n3);
        return 0;
    }

    int XmNmapCallback(int n, int n2, int n3) {
        if ((this.style & 8) != 0) {
            return 0;
        }
        this.sendEvent(22);
        return 0;
    }

    int XmNunmapCallback(int n, int n2, int n3) {
        this.sendEvent(23);
        return 0;
    }
}

