/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    int button;
    String message = "";

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, MessageBox.checkStyle(n));
        this.checkSubclass();
    }

    int activate(int n, int n2, int n3) {
        OS.XtUnmanageChild(n);
        this.button = n2;
        return 0;
    }

    static int checkStyle(int n) {
        int n2;
        int n3;
        if ((n & 0x38000) == 0) {
            n |= 0x10000;
        }
        if ((n3 = n & (n2 = 4064)) == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }

    int createHandle(int n, int[] nArray) {
        if ((this.style & 1) != 0) {
            return OS.XmCreateErrorDialog(n, null, nArray, nArray.length / 2);
        }
        if ((this.style & 2) != 0) {
            return OS.XmCreateInformationDialog(n, null, nArray, nArray.length / 2);
        }
        if ((this.style & 4) != 0) {
            return OS.XmCreateQuestionDialog(n, null, nArray, nArray.length / 2);
        }
        if ((this.style & 8) != 0) {
            return OS.XmCreateWarningDialog(n, null, nArray, nArray.length / 2);
        }
        if ((this.style & 0x10) != 0) {
            return OS.XmCreateWorkingDialog(n, null, nArray, nArray.length / 2);
        }
        return OS.XmCreateMessageDialog(n, null, nArray, nArray.length / 2);
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        Object object;
        String string = this.title;
        if (string.length() == 0) {
            string = " ";
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        int n2 = 0;
        if ((this.style & 0x8000) != 0) {
            n2 = 1;
        }
        if ((this.style & 0x10000) != 0) {
            n2 = 2;
        }
        if ((this.style & 0x20000) != 0) {
            n2 = 3;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        boolean bl = this.parent.isVisible();
        int[] nArray = new int[10];
        nArray[0] = OS.XmNnoResize;
        nArray[1] = 1;
        nArray[2] = OS.XmNresizePolicy;
        nArray[4] = OS.XmNdialogStyle;
        nArray[5] = n2;
        nArray[6] = OS.XmNdialogTitle;
        nArray[7] = n;
        nArray[8] = OS.XmNdefaultPosition;
        nArray[9] = bl ? 1 : 0;
        int n3 = this.parent.shellHandle;
        int[] nArray2 = nArray;
        int n4 = this.createHandle(n3, nArray2);
        if (n4 == 0) {
            this.error(2);
        }
        OS.XmStringFree(n);
        this.setMessage(n4);
        this.setButtons(n4);
        Callback callback = new Callback(this, "activate", 3);
        int n5 = callback.getAddress();
        if (n5 == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(n4, OS.XmNokCallback, n5, 4);
        OS.XtAddCallback(n4, OS.XmNcancelCallback, n5, 2);
        OS.XtAddCallback(n4, OS.XmNhelpCallback, n5, 7);
        if (!bl) {
            OS.XtRealizeWidget(n4);
            int[] nArray3 = new int[4];
            nArray3[0] = OS.XmNwidth;
            nArray3[2] = OS.XmNheight;
            object = nArray3;
            OS.XtGetValues(n4, (int[])object, ((Object)object).length / 2);
            Monitor monitor = this.parent.getMonitor();
            Rectangle rectangle = monitor.getBounds();
            int n6 = rectangle.x + (rectangle.width - object[1]) / 2;
            int n7 = rectangle.y + (rectangle.height - object[3]) / 2;
            int[] nArray4 = new int[]{OS.XmNx, n6, OS.XmNy, n7};
            OS.XtSetValues(n4, nArray4, nArray4.length / 2);
        }
        OS.XtManageChild(n4);
        object = this.parent.display;
        while (OS.XtIsRealized(n4) && OS.XtIsManaged(n4)) {
            if (((Display)object).readAndDispatch()) continue;
            ((Display)object).sleep();
        }
        if (OS.XtIsRealized(n4)) {
            OS.XtDestroyWidget(n4);
        }
        callback.dispose();
        if ((this.style & 0x1C0) == 448) {
            if (this.button == 4) {
                return 64;
            }
            if (this.button == 2) {
                return 128;
            }
            return 256;
        }
        if ((this.style & 0xC0) == 192) {
            return this.button == 4 ? 64 : 128;
        }
        if ((this.style & 0x120) == 288) {
            return this.button == 4 ? 32 : 256;
        }
        if ((this.style & 0x20) == 32) {
            return 32;
        }
        if ((this.style & 0x500) == 1280) {
            return this.button == 4 ? 1024 : 256;
        }
        if ((this.style & 0xE00) == 3584) {
            if (this.button == 4) {
                return 512;
            }
            if (this.button == 2) {
                return 1024;
            }
            return 2048;
        }
        return 256;
    }

    void setButtons(int n) {
        OS.XmMessageBoxGetChild(n, 4);
        int n2 = OS.XmMessageBoxGetChild(n, 2);
        int n3 = OS.XmMessageBoxGetChild(n, 7);
        OS.XtUnmanageChild(n3);
        if ((this.style & 0x120) == 288) {
            return;
        }
        if ((this.style & 0x20) == 32) {
            OS.XtUnmanageChild(n2);
            return;
        }
        if ((this.style & 0x1C0) == 448) {
            OS.XtManageChild(n3);
            byte[] byArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Yes"), true);
            int n4 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray2 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_No"), true);
            int n5 = OS.XmStringParseText(byArray2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray3 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Cancel"), true);
            int n6 = OS.XmStringParseText(byArray3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray = new int[]{OS.XmNokLabelString, n4, OS.XmNcancelLabelString, n5, OS.XmNhelpLabelString, n6};
            OS.XtSetValues(n, nArray, nArray.length / 2);
            OS.XmStringFree(n4);
            OS.XmStringFree(n5);
            OS.XmStringFree(n6);
            return;
        }
        if ((this.style & 0xC0) == 192) {
            byte[] byArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Yes"), true);
            int n7 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray4 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_No"), true);
            int n8 = OS.XmStringParseText(byArray4, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray = new int[]{OS.XmNokLabelString, n7, OS.XmNcancelLabelString, n8};
            OS.XtSetValues(n, nArray, nArray.length / 2);
            OS.XmStringFree(n7);
            OS.XmStringFree(n8);
            return;
        }
        if ((this.style & 0x500) == 1280) {
            byte[] byArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true);
            int n9 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray5 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Cancel"), true);
            int n10 = OS.XmStringParseText(byArray5, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray = new int[]{OS.XmNokLabelString, n9, OS.XmNcancelLabelString, n10};
            OS.XtSetValues(n, nArray, nArray.length / 2);
            OS.XmStringFree(n9);
            OS.XmStringFree(n10);
            return;
        }
        if ((this.style & 0xE00) == 3584) {
            OS.XtManageChild(n3);
            byte[] byArray = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Abort"), true);
            int n11 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray6 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Retry"), true);
            int n12 = OS.XmStringParseText(byArray6, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            byte[] byArray7 = Converter.wcsToMbcs(null, SWT.getMessage("SWT_Ignore"), true);
            int n13 = OS.XmStringParseText(byArray7, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray = new int[]{OS.XmNokLabelString, n11, OS.XmNcancelLabelString, n12, OS.XmNhelpLabelString, n13};
            OS.XtSetValues(n, nArray, nArray.length / 2);
            OS.XmStringFree(n11);
            OS.XmStringFree(n12);
            OS.XmStringFree(n13);
            return;
        }
    }

    void setMessage(int n) {
        Object object;
        int n2;
        Object[] objectArray;
        String string = this.message;
        int n3 = OS.XmMessageBoxGetChild(n, 10);
        if (n3 != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNfontList;
            objectArray = nArray;
            OS.XtGetValues(n3, objectArray, objectArray.length / 2);
            n2 = objectArray[1];
            if (n2 != 0) {
                object = this.parent.display;
                int n4 = ((Display)object).xDisplay;
                int n5 = OS.XDefaultScreen(n4);
                int n6 = OS.XDisplayWidth(n4, n5);
                Font font = Font.motif_new((Device)object, n2);
                string = ((Display)object).wrapText(this.message, font, n6 * 3 / 5);
            }
        }
        objectArray = Converter.wcsToMbcs(null, string, true);
        n2 = OS.XmStringGenerate(objectArray, null, 0, null);
        object = new int[]{OS.XmNmessageString, n2};
        OS.XtSetValues(n, (int[])object, ((int[])object).length / 2);
        OS.XmStringFree(n2);
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

