/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    int x;
    int y;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    Listener listener;
    TextLayout layoutText;
    TextLayout layoutMessage;
    Region region;
    Font boldFont;
    Runnable runnable;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        Display display = this.getDisplay();
        this.tip = new Shell(shell, 16392);
        Color color = display.getSystemColor(29);
        this.tip.setBackground(color);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        ToolTip.this.onDispose(event);
                        break;
                    }
                    case 9: {
                        ToolTip.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        ToolTip.this.onMouseDown(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.tip.addListener(9, this.listener);
        this.tip.addListener(3, this.listener);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        Object object;
        Display display = this.parent.getDisplay();
        if (this.x == -1 || this.y == -1) {
            object = display.getCursorLocation();
            this.x = ((Point)object).x;
            this.y = ((Point)object).y;
        }
        object = this.parent.getMonitor();
        Rectangle rectangle = ((Monitor)object).getBounds();
        Point point = this.getSize(rectangle.width / 4);
        int n = point.x;
        int n2 = point.y;
        int n3 = (this.style & 0x1000) != 0 ? 20 : 0;
        int n4 = (this.style & 0x1000) != 0 ? 16 : 0;
        this.tip.setSize(n, n2 + n3);
        boolean bl = this.spikeAbove = rectangle.height >= this.y + point.y + n3;
        if (rectangle.width >= this.x + point.x) {
            if (rectangle.height >= this.y + point.y + n3) {
                int[] nArray2 = new int[68];
                nArray2[1] = 5 + n3;
                nArray2[2] = 1;
                nArray2[3] = 5 + n3;
                nArray2[4] = 1;
                nArray2[5] = 3 + n3;
                nArray2[6] = 3;
                nArray2[7] = 1 + n3;
                nArray2[8] = 5;
                nArray2[9] = 1 + n3;
                nArray2[10] = 5;
                nArray2[11] = n3;
                nArray2[12] = 16;
                nArray2[13] = n3;
                nArray2[14] = 16;
                nArray2[16] = 35;
                nArray2[17] = n3;
                nArray2[18] = n - 5;
                nArray2[19] = n3;
                nArray2[20] = n - 5;
                nArray2[21] = 1 + n3;
                nArray2[22] = n - 3;
                nArray2[23] = 1 + n3;
                nArray2[24] = n - 1;
                nArray2[25] = 3 + n3;
                nArray2[26] = n - 1;
                nArray2[27] = 5 + n3;
                nArray2[28] = n;
                nArray2[29] = 5 + n3;
                nArray2[30] = n;
                nArray2[31] = n2 - 5 + n3;
                nArray2[32] = n - 1;
                nArray2[33] = n2 - 5 + n3;
                nArray2[34] = n - 1;
                nArray2[35] = n2 - 3 + n3;
                nArray2[36] = n - 2;
                nArray2[37] = n2 - 3 + n3;
                nArray2[38] = n - 2;
                nArray2[39] = n2 - 2 + n3;
                nArray2[40] = n - 3;
                nArray2[41] = n2 - 2 + n3;
                nArray2[42] = n - 3;
                nArray2[43] = n2 - 1 + n3;
                nArray2[44] = n - 5;
                nArray2[45] = n2 - 1 + n3;
                nArray2[46] = n - 5;
                nArray2[47] = n2 + n3;
                nArray2[48] = 5;
                nArray2[49] = n2 + n3;
                nArray2[50] = 5;
                nArray2[51] = n2 - 1 + n3;
                nArray2[52] = 3;
                nArray2[53] = n2 - 1 + n3;
                nArray2[54] = 3;
                nArray2[55] = n2 - 2 + n3;
                nArray2[56] = 2;
                nArray2[57] = n2 - 2 + n3;
                nArray2[58] = 2;
                nArray2[59] = n2 - 3 + n3;
                nArray2[60] = 1;
                nArray2[61] = n2 - 3 + n3;
                nArray2[62] = 1;
                nArray2[63] = n2 - 5 + n3;
                nArray2[65] = n2 - 5 + n3;
                nArray2[67] = 5 + n3;
                nArray = nArray2;
                int[] nArray3 = new int[56];
                nArray3[1] = 5 + n3;
                nArray3[2] = 1;
                nArray3[3] = 4 + n3;
                nArray3[4] = 1;
                nArray3[5] = 3 + n3;
                nArray3[6] = 3;
                nArray3[7] = 1 + n3;
                nArray3[8] = 4;
                nArray3[9] = 1 + n3;
                nArray3[10] = 5;
                nArray3[11] = n3;
                nArray3[12] = 16;
                nArray3[13] = n3;
                nArray3[14] = 16;
                nArray3[15] = 1;
                nArray3[16] = 35;
                nArray3[17] = n3;
                nArray3[18] = n - 6;
                nArray3[19] = 0 + n3;
                nArray3[20] = n - 5;
                nArray3[21] = 1 + n3;
                nArray3[22] = n - 4;
                nArray3[23] = 1 + n3;
                nArray3[24] = n - 2;
                nArray3[25] = 3 + n3;
                nArray3[26] = n - 2;
                nArray3[27] = 4 + n3;
                nArray3[28] = n - 1;
                nArray3[29] = 5 + n3;
                nArray3[30] = n - 1;
                nArray3[31] = n2 - 6 + n3;
                nArray3[32] = n - 2;
                nArray3[33] = n2 - 5 + n3;
                nArray3[34] = n - 2;
                nArray3[35] = n2 - 4 + n3;
                nArray3[36] = n - 4;
                nArray3[37] = n2 - 2 + n3;
                nArray3[38] = n - 5;
                nArray3[39] = n2 - 2 + n3;
                nArray3[40] = n - 6;
                nArray3[41] = n2 - 1 + n3;
                nArray3[42] = 5;
                nArray3[43] = n2 - 1 + n3;
                nArray3[44] = 4;
                nArray3[45] = n2 - 2 + n3;
                nArray3[46] = 3;
                nArray3[47] = n2 - 2 + n3;
                nArray3[48] = 1;
                nArray3[49] = n2 - 4 + n3;
                nArray3[50] = 1;
                nArray3[51] = n2 - 5 + n3;
                nArray3[53] = n2 - 6 + n3;
                nArray3[55] = 5 + n3;
                this.borderPolygon = nArray3;
                this.tip.setLocation(Math.max(0, this.x - n4), this.y);
            } else {
                int[] nArray4 = new int[68];
                nArray4[1] = 5;
                nArray4[2] = 1;
                nArray4[3] = 5;
                nArray4[4] = 1;
                nArray4[5] = 3;
                nArray4[6] = 3;
                nArray4[7] = 1;
                nArray4[8] = 5;
                nArray4[9] = 1;
                nArray4[10] = 5;
                nArray4[12] = n - 5;
                nArray4[14] = n - 5;
                nArray4[15] = 1;
                nArray4[16] = n - 3;
                nArray4[17] = 1;
                nArray4[18] = n - 1;
                nArray4[19] = 3;
                nArray4[20] = n - 1;
                nArray4[21] = 5;
                nArray4[22] = n;
                nArray4[23] = 5;
                nArray4[24] = n;
                nArray4[25] = n2 - 5;
                nArray4[26] = n - 1;
                nArray4[27] = n2 - 5;
                nArray4[28] = n - 1;
                nArray4[29] = n2 - 3;
                nArray4[30] = n - 2;
                nArray4[31] = n2 - 3;
                nArray4[32] = n - 2;
                nArray4[33] = n2 - 2;
                nArray4[34] = n - 3;
                nArray4[35] = n2 - 2;
                nArray4[36] = n - 3;
                nArray4[37] = n2 - 1;
                nArray4[38] = n - 5;
                nArray4[39] = n2 - 1;
                nArray4[40] = n - 5;
                nArray4[41] = n2;
                nArray4[42] = 35;
                nArray4[43] = n2;
                nArray4[44] = 16;
                nArray4[45] = n2 + n3;
                nArray4[46] = 16;
                nArray4[47] = n2;
                nArray4[48] = 5;
                nArray4[49] = n2;
                nArray4[50] = 5;
                nArray4[51] = n2 - 1;
                nArray4[52] = 3;
                nArray4[53] = n2 - 1;
                nArray4[54] = 3;
                nArray4[55] = n2 - 2;
                nArray4[56] = 2;
                nArray4[57] = n2 - 2;
                nArray4[58] = 2;
                nArray4[59] = n2 - 3;
                nArray4[60] = 1;
                nArray4[61] = n2 - 3;
                nArray4[62] = 1;
                nArray4[63] = n2 - 5;
                nArray4[65] = n2 - 5;
                nArray4[67] = 5;
                nArray = nArray4;
                int[] nArray5 = new int[56];
                nArray5[1] = 5;
                nArray5[2] = 1;
                nArray5[3] = 4;
                nArray5[4] = 1;
                nArray5[5] = 3;
                nArray5[6] = 3;
                nArray5[7] = 1;
                nArray5[8] = 4;
                nArray5[9] = 1;
                nArray5[10] = 5;
                nArray5[12] = n - 6;
                nArray5[14] = n - 5;
                nArray5[15] = 1;
                nArray5[16] = n - 4;
                nArray5[17] = 1;
                nArray5[18] = n - 2;
                nArray5[19] = 3;
                nArray5[20] = n - 2;
                nArray5[21] = 4;
                nArray5[22] = n - 1;
                nArray5[23] = 5;
                nArray5[24] = n - 1;
                nArray5[25] = n2 - 6;
                nArray5[26] = n - 2;
                nArray5[27] = n2 - 5;
                nArray5[28] = n - 2;
                nArray5[29] = n2 - 4;
                nArray5[30] = n - 4;
                nArray5[31] = n2 - 2;
                nArray5[32] = n - 5;
                nArray5[33] = n2 - 2;
                nArray5[34] = n - 6;
                nArray5[35] = n2 - 1;
                nArray5[36] = 36;
                nArray5[37] = n2 - 1;
                nArray5[38] = 16;
                nArray5[39] = n2 + n3 - 1;
                nArray5[40] = 16;
                nArray5[41] = n2 - 1;
                nArray5[42] = 5;
                nArray5[43] = n2 - 1;
                nArray5[44] = 4;
                nArray5[45] = n2 - 2;
                nArray5[46] = 3;
                nArray5[47] = n2 - 2;
                nArray5[48] = 1;
                nArray5[49] = n2 - 4;
                nArray5[50] = 1;
                nArray5[51] = n2 - 5;
                nArray5[53] = n2 - 6;
                nArray5[55] = 5;
                this.borderPolygon = nArray5;
                this.tip.setLocation(Math.max(0, this.x - n4), this.y - point.y - n3);
            }
        } else if (rectangle.height >= this.y + point.y + n3) {
            int[] nArray6 = new int[68];
            nArray6[1] = 5 + n3;
            nArray6[2] = 1;
            nArray6[3] = 5 + n3;
            nArray6[4] = 1;
            nArray6[5] = 3 + n3;
            nArray6[6] = 3;
            nArray6[7] = 1 + n3;
            nArray6[8] = 5;
            nArray6[9] = 1 + n3;
            nArray6[10] = 5;
            nArray6[11] = n3;
            nArray6[12] = n - 35;
            nArray6[13] = n3;
            nArray6[14] = n - 16;
            nArray6[16] = n - 16;
            nArray6[17] = n3;
            nArray6[18] = n - 5;
            nArray6[19] = n3;
            nArray6[20] = n - 5;
            nArray6[21] = 1 + n3;
            nArray6[22] = n - 3;
            nArray6[23] = 1 + n3;
            nArray6[24] = n - 1;
            nArray6[25] = 3 + n3;
            nArray6[26] = n - 1;
            nArray6[27] = 5 + n3;
            nArray6[28] = n;
            nArray6[29] = 5 + n3;
            nArray6[30] = n;
            nArray6[31] = n2 - 5 + n3;
            nArray6[32] = n - 1;
            nArray6[33] = n2 - 5 + n3;
            nArray6[34] = n - 1;
            nArray6[35] = n2 - 3 + n3;
            nArray6[36] = n - 2;
            nArray6[37] = n2 - 3 + n3;
            nArray6[38] = n - 2;
            nArray6[39] = n2 - 2 + n3;
            nArray6[40] = n - 3;
            nArray6[41] = n2 - 2 + n3;
            nArray6[42] = n - 3;
            nArray6[43] = n2 - 1 + n3;
            nArray6[44] = n - 5;
            nArray6[45] = n2 - 1 + n3;
            nArray6[46] = n - 5;
            nArray6[47] = n2 + n3;
            nArray6[48] = 5;
            nArray6[49] = n2 + n3;
            nArray6[50] = 5;
            nArray6[51] = n2 - 1 + n3;
            nArray6[52] = 3;
            nArray6[53] = n2 - 1 + n3;
            nArray6[54] = 3;
            nArray6[55] = n2 - 2 + n3;
            nArray6[56] = 2;
            nArray6[57] = n2 - 2 + n3;
            nArray6[58] = 2;
            nArray6[59] = n2 - 3 + n3;
            nArray6[60] = 1;
            nArray6[61] = n2 - 3 + n3;
            nArray6[62] = 1;
            nArray6[63] = n2 - 5 + n3;
            nArray6[65] = n2 - 5 + n3;
            nArray6[67] = 5 + n3;
            nArray = nArray6;
            int[] nArray7 = new int[56];
            nArray7[1] = 5 + n3;
            nArray7[2] = 1;
            nArray7[3] = 4 + n3;
            nArray7[4] = 1;
            nArray7[5] = 3 + n3;
            nArray7[6] = 3;
            nArray7[7] = 1 + n3;
            nArray7[8] = 4;
            nArray7[9] = 1 + n3;
            nArray7[10] = 5;
            nArray7[11] = n3;
            nArray7[12] = n - 35;
            nArray7[13] = n3;
            nArray7[14] = n - 17;
            nArray7[15] = 2;
            nArray7[16] = n - 17;
            nArray7[17] = n3;
            nArray7[18] = n - 6;
            nArray7[19] = n3;
            nArray7[20] = n - 5;
            nArray7[21] = 1 + n3;
            nArray7[22] = n - 4;
            nArray7[23] = 1 + n3;
            nArray7[24] = n - 2;
            nArray7[25] = 3 + n3;
            nArray7[26] = n - 2;
            nArray7[27] = 4 + n3;
            nArray7[28] = n - 1;
            nArray7[29] = 5 + n3;
            nArray7[30] = n - 1;
            nArray7[31] = n2 - 6 + n3;
            nArray7[32] = n - 2;
            nArray7[33] = n2 - 5 + n3;
            nArray7[34] = n - 2;
            nArray7[35] = n2 - 4 + n3;
            nArray7[36] = n - 4;
            nArray7[37] = n2 - 2 + n3;
            nArray7[38] = n - 5;
            nArray7[39] = n2 - 2 + n3;
            nArray7[40] = n - 6;
            nArray7[41] = n2 - 1 + n3;
            nArray7[42] = 5;
            nArray7[43] = n2 - 1 + n3;
            nArray7[44] = 4;
            nArray7[45] = n2 - 2 + n3;
            nArray7[46] = 3;
            nArray7[47] = n2 - 2 + n3;
            nArray7[48] = 1;
            nArray7[49] = n2 - 4 + n3;
            nArray7[50] = 1;
            nArray7[51] = n2 - 5 + n3;
            nArray7[53] = n2 - 6 + n3;
            nArray7[55] = 5 + n3;
            this.borderPolygon = nArray7;
            this.tip.setLocation(Math.min(rectangle.width - point.x, this.x - point.x + n4), this.y);
        } else {
            int[] nArray8 = new int[68];
            nArray8[1] = 5;
            nArray8[2] = 1;
            nArray8[3] = 5;
            nArray8[4] = 1;
            nArray8[5] = 3;
            nArray8[6] = 3;
            nArray8[7] = 1;
            nArray8[8] = 5;
            nArray8[9] = 1;
            nArray8[10] = 5;
            nArray8[12] = n - 5;
            nArray8[14] = n - 5;
            nArray8[15] = 1;
            nArray8[16] = n - 3;
            nArray8[17] = 1;
            nArray8[18] = n - 1;
            nArray8[19] = 3;
            nArray8[20] = n - 1;
            nArray8[21] = 5;
            nArray8[22] = n;
            nArray8[23] = 5;
            nArray8[24] = n;
            nArray8[25] = n2 - 5;
            nArray8[26] = n - 1;
            nArray8[27] = n2 - 5;
            nArray8[28] = n - 1;
            nArray8[29] = n2 - 3;
            nArray8[30] = n - 2;
            nArray8[31] = n2 - 3;
            nArray8[32] = n - 2;
            nArray8[33] = n2 - 2;
            nArray8[34] = n - 3;
            nArray8[35] = n2 - 2;
            nArray8[36] = n - 3;
            nArray8[37] = n2 - 1;
            nArray8[38] = n - 5;
            nArray8[39] = n2 - 1;
            nArray8[40] = n - 5;
            nArray8[41] = n2;
            nArray8[42] = n - 16;
            nArray8[43] = n2;
            nArray8[44] = n - 16;
            nArray8[45] = n2 + n3;
            nArray8[46] = n - 35;
            nArray8[47] = n2;
            nArray8[48] = 5;
            nArray8[49] = n2;
            nArray8[50] = 5;
            nArray8[51] = n2 - 1;
            nArray8[52] = 3;
            nArray8[53] = n2 - 1;
            nArray8[54] = 3;
            nArray8[55] = n2 - 2;
            nArray8[56] = 2;
            nArray8[57] = n2 - 2;
            nArray8[58] = 2;
            nArray8[59] = n2 - 3;
            nArray8[60] = 1;
            nArray8[61] = n2 - 3;
            nArray8[62] = 1;
            nArray8[63] = n2 - 5;
            nArray8[65] = n2 - 5;
            nArray8[67] = 5;
            nArray = nArray8;
            int[] nArray9 = new int[56];
            nArray9[1] = 5;
            nArray9[2] = 1;
            nArray9[3] = 4;
            nArray9[4] = 1;
            nArray9[5] = 3;
            nArray9[6] = 3;
            nArray9[7] = 1;
            nArray9[8] = 4;
            nArray9[9] = 1;
            nArray9[10] = 5;
            nArray9[12] = n - 6;
            nArray9[14] = n - 5;
            nArray9[15] = 1;
            nArray9[16] = n - 4;
            nArray9[17] = 1;
            nArray9[18] = n - 2;
            nArray9[19] = 3;
            nArray9[20] = n - 2;
            nArray9[21] = 4;
            nArray9[22] = n - 1;
            nArray9[23] = 5;
            nArray9[24] = n - 1;
            nArray9[25] = n2 - 6;
            nArray9[26] = n - 2;
            nArray9[27] = n2 - 5;
            nArray9[28] = n - 2;
            nArray9[29] = n2 - 4;
            nArray9[30] = n - 4;
            nArray9[31] = n2 - 2;
            nArray9[32] = n - 5;
            nArray9[33] = n2 - 2;
            nArray9[34] = n - 6;
            nArray9[35] = n2 - 1;
            nArray9[36] = n - 17;
            nArray9[37] = n2 - 1;
            nArray9[38] = n - 17;
            nArray9[39] = n2 + n3 - 2;
            nArray9[40] = n - 36;
            nArray9[41] = n2 - 1;
            nArray9[42] = 5;
            nArray9[43] = n2 - 1;
            nArray9[44] = 4;
            nArray9[45] = n2 - 2;
            nArray9[46] = 3;
            nArray9[47] = n2 - 2;
            nArray9[48] = 1;
            nArray9[49] = n2 - 4;
            nArray9[50] = 1;
            nArray9[51] = n2 - 5;
            nArray9[53] = n2 - 6;
            nArray9[55] = 5;
            this.borderPolygon = nArray9;
            this.tip.setLocation(Math.min(rectangle.width - point.x, this.x - point.x + n4), this.y - point.y - n3);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(nArray);
            this.tip.setRegion(this.region);
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            n2 = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            n3 = this.layoutMessage.getBounds().width;
        }
        int n4 = 28;
        boolean bl = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(n - n5);
            n7 = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(n - n4);
            n8 = this.layoutMessage.getBounds().height;
        }
        int n9 = 20 + n8;
        if (this.layoutText != null) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getMessage() {
        this.checkWidget();
        return this.layoutMessage != null ? this.layoutMessage.getText() : "";
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.layoutText != null ? this.layoutText.getText() : "";
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.tip.getVisible();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.tip.dispose();
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        this.borderPolygon = null;
    }

    void onMouseDown(Event event) {
        this.notifyListeners(13, new Event());
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gC = event.gc;
        int n = 10;
        int n2 = 10;
        if ((this.style & 0x1000) != 0) {
            if (this.spikeAbove) {
                n2 += 20;
            }
            gC.drawPolygon(this.borderPolygon);
        } else {
            Rectangle rectangle = this.tip.getClientArea();
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
        if (this.layoutText != null) {
            int n3 = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && n3 != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(n3);
                Rectangle rectangle = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n, n2, 16, 16);
                n += 16;
            }
            this.layoutText.draw(gC, n += 4, n2);
            n2 += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            n = 14;
            this.layoutMessage.draw(gC, n, n2);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if (this.x == n && this.y == n2) {
            return;
        }
        this.x = n;
        this.y = n2;
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutMessage = new TextLayout(display);
            this.layoutMessage.setText(string);
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutText = new TextLayout(display);
            this.layoutText.setText(string);
            Font font = display.getSystemFont();
            FontData fontData = font.getFontData()[0];
            this.boldFont = new Font((Device)display, fontData.getName(), fontData.getHeight(), 1);
            TextStyle textStyle = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(textStyle, 0, string.length());
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.configure();
        }
        this.tip.setVisible(bl);
        Display display = this.getDisplay();
        if (this.runnable != null) {
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (this.autohide && bl) {
            this.runnable = new Runnable(){

                public void run() {
                    if (!ToolTip.this.isDisposed()) {
                        ToolTip.this.setVisible(false);
                    }
                }
            };
            display.timerExec(10000, this.runnable);
        }
    }
}

