/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int FOCUS_FORCED = 8;
    static final int BACKGROUND = 16;
    static final int FOREGROUND = 32;
    static final int PARENT_BACKGROUND = 64;
    static final int THEME_BACKGROUND = 128;
    static final int LAYOUT_NEEDED = 256;
    static final int LAYOUT_CHANGED = 512;
    static final int LAYOUT_CHILD = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int FOREIGN_HANDLE = 8192;
    static final int DRAG_DETECT = 16384;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int BUTTON_PRESS = 1;
    static final int BUTTON_RELEASE = 2;
    static final int EXPOSURE = 3;
    static final int ENTER_WINDOW = 4;
    static final int FOCUS_CHANGE = 5;
    static final int KEY_PRESS = 6;
    static final int KEY_RELEASE = 7;
    static final int LEAVE_WINDOW = 8;
    static final int ACTIVATE_CALLBACK = 9;
    static final int ARM_CALLBACK = 10;
    static final int BROWSE_SELECTION_CALLBACK = 11;
    static final int CASCADING_CALLBACK = 12;
    static final int DECREMENT_CALLBACK = 13;
    static final int DEFAULT_ACTION_CALLBACK = 14;
    static final int DRAG_CALLBACK = 15;
    static final int EXTENDED_SELECTION_CALLBACK = 16;
    static final int HELP_CALLBACK = 17;
    static final int INCREMENT_CALLBACK = 18;
    static final int MODIFY_VERIFY_CALLBACK = 19;
    static final int PAGE_DECREMENT_CALLBACK = 20;
    static final int PAGE_INCREMENT_CALLBACK = 21;
    static final int TO_BOTTOM_CALLBACK = 22;
    static final int TO_TOP_CALLBACK = 23;
    static final int VALUE_CHANGED_CALLBACK = 24;
    static final int NON_MASKABLE = 25;
    static final int POINTER_MOTION = 26;
    static final int STRUCTURE_NOTIFY = 27;
    static final int MAP_CALLBACK = 28;
    static final int UNMAP_CALLBACK = 29;
    static final int DELETE_WINDOW = 30;
    static final int EXPOSURE_CALLBACK = 31;
    static final int MULTIPLE_SELECTION_CALLBACK = 32;
    static final int PROPERTY_CHANGE = 33;

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int n) {
    }

    void createWidget(int n) {
        this.createHandle(n);
        this.hookEvents();
        this.register();
        this.manageChildren();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        int n = this.topHandle();
        this.releaseHandle();
        if (n != 0) {
            OS.XtDestroyWidget(n);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void enableHandle(boolean bl, int n) {
        int[] nArray = new int[]{OS.XmNsensitive, bl ? 1 : 0};
        OS.XtSetValues(n, nArray, nArray.length / 2);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    char fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        char c = '\u0000';
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (c == '\u0000') {
                c = cArray[n];
            }
            --n2;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return c;
    }

    int focusProc(int n, int n2, int n3, int n4) {
        return 0;
    }

    String getCodePage() {
        return null;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n = 1;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    void hookEvents() {
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void manageChildren() {
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void propagateHandle(boolean bl, int n, int n2) {
        int n3 = OS.XtDisplay(n);
        if (n3 == 0) {
            return;
        }
        int n4 = OS.XtWindow(n);
        if (n4 == 0) {
            return;
        }
        int n5 = OS.XtBuildEventMask(n);
        int n6 = 79;
        if (!bl) {
            n5 &= ~(n6 | 0x10 | 0x20);
            n6 = 0;
        }
        int n7 = 22528;
        XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
        xSetWindowAttributes.event_mask = n5;
        xSetWindowAttributes.do_not_propagate_mask = n6;
        xSetWindowAttributes.cursor = n2;
        OS.XChangeWindowAttributes(n3, n4, n7, xSetWindowAttributes);
    }

    void redrawHandle(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = OS.XtDisplay(n5);
        if (n6 == 0) {
            return;
        }
        int n7 = OS.XtWindow(n5);
        if (n7 == 0) {
            return;
        }
        if (bl) {
            OS.XClearArea(n6, n7, 0, 0, 0, 0, true);
        } else if (n3 > 0 && n4 > 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            int[] nArray2 = nArray;
            OS.XtGetValues(n5, nArray2, nArray2.length / 2);
            if (n < nArray2[1] && n2 < nArray2[3] && n + n3 > 0 && n2 + n4 > 0) {
                OS.XClearArea(n6, n7, n, n2, n3, n4, true);
            }
        }
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        this.display.addWidget(this.handle, this);
    }

    void release(boolean bl) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    boolean setInputState(Event event, int n) {
        if ((n & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((n & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((n & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((n & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((n & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, XKeyEvent xKeyEvent) {
        Object[] objectArray;
        if (xKeyEvent.keycode == 0) {
            return false;
        }
        byte[] byArray = new byte[5];
        int[] nArray = new int[1];
        OS.XLookupString(xKeyEvent, byArray, byArray.length, nArray, null);
        boolean bl = this.display.fixKey(nArray, byArray, xKeyEvent.state);
        if (nArray[0] != 0) {
            event.keyCode = Display.translateKey(nArray[0]);
        }
        if (event.keyCode == 0) {
            char[] cArray;
            objectArray = new byte[5];
            int[] nArray2 = new int[1];
            int n = xKeyEvent.state;
            xKeyEvent.state = 0;
            OS.XLookupString(xKeyEvent, objectArray, objectArray.length, nArray2, null);
            xKeyEvent.state = n;
            if (objectArray[0] != 0 && (cArray = Converter.mbcsToWcs(null, objectArray)).length != 0) {
                event.keyCode = cArray[0];
            }
        }
        if (byArray[0] != 0 && (objectArray = (Object[])Converter.mbcsToWcs(null, byArray)).length != 0) {
            event.character = objectArray[0];
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !bl) {
            return false;
        }
        return this.setInputState(event, xKeyEvent.state);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendIMKeyEvent(int n, XKeyEvent xKeyEvent) {
        return this.sendIMKeyEvent(n, xKeyEvent, 0);
    }

    boolean sendIMKeyEvent(int n, XKeyEvent xKeyEvent, int n2) {
        int n3;
        Object object;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n4 = OS.XtWindowToWidget(xKeyEvent.display, xKeyEvent.window);
        int n5 = OS.XmImMbLookupString(n4, xKeyEvent, byArray, byArray.length, nArray2, nArray);
        if (nArray[0] == -1) {
            byArray = new byte[n5];
            n5 = OS.XmImMbLookupString(n4, xKeyEvent, byArray, n5, nArray2, nArray);
        }
        if (n5 == 0) {
            return true;
        }
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        int n6 = 0;
        int n7 = 0;
        while (n6 < cArray.length) {
            if (cArray[n6] == '\u0000') {
                cArray[n7] = '\u0000';
                break;
            }
            object = new Event();
            object.time = xKeyEvent.time;
            object.character = cArray[n6];
            this.setInputState((Event)object, xKeyEvent.state);
            this.sendEvent(n, (Event)object);
            if (this.isDisposed()) {
                return false;
            }
            if (object.doit) {
                cArray[n7++] = cArray[n6];
            }
            ++n6;
        }
        if (n7 == 0) {
            return false;
        }
        if (n2 != 0 && ((n3 = OS.XmImMbLookupString(n2, xKeyEvent, object = new byte[5], ((byte[])object).length, nArray2, nArray2)) == 0 || n6 != n7)) {
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.XmTextGetSelectionPosition(n2, nArray3, nArray4);
            if (nArray3[0] == nArray4[0]) {
                nArray3[0] = nArray4[0] = OS.XmTextGetInsertionPosition(n2);
            }
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            if (n6 != n7) {
                byArray = Converter.wcsToMbcs(this.getCodePage(), cArray, true);
            }
            OS.XmTextReplace(n2, nArray3[0], nArray4[0], byArray);
            int n8 = nArray3[0] + n7;
            OS.XmTextSetInsertionPosition(n2, n8);
            this.display.setWarnings(bl);
            return false;
        }
        return true;
    }

    boolean sendKeyEvent(int n, XKeyEvent xKeyEvent) {
        Event event = new Event();
        event.time = xKeyEvent.time;
        if (!this.setKeyState(event, xKeyEvent)) {
            return true;
        }
        Widget widget = this;
        if ((this.state & 2) != 0 && (this.style & 0x80000) != 0) {
            widget = this.display.getFocusControl();
        }
        if (widget != null) {
            widget.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        }
        return event.doit;
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) break;
                n += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateAccelerator(char c, int n, XKeyEvent xKeyEvent, boolean bl) {
        return false;
    }

    boolean translateMnemonic(char c, int n, XKeyEvent xKeyEvent) {
        return false;
    }

    boolean translateTraversal(int n, XKeyEvent xKeyEvent) {
        return false;
    }

    boolean XmProcessTraversal(int n, int n2) {
        Display display = this.display;
        boolean bl = display.postFocusOut;
        display.postFocusOut = true;
        boolean bl2 = OS.XmProcessTraversal(n, n2);
        display.postFocusOut = bl;
        if (!display.postFocusOut) {
            display.focusEvent = 16;
            display.runFocusOutEvents();
            display.focusEvent = 0;
        }
        return bl2;
    }

    int hoverProc(int n) {
        return 0;
    }

    int timerProc(int n) {
        return 0;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 1: {
                return this.XButtonPress(n, n2, n3, n4);
            }
            case 2: {
                return this.XButtonRelease(n, n2, n3, n4);
            }
            case 4: {
                return this.XEnterWindow(n, n2, n3, n4);
            }
            case 3: {
                return this.XExposure(n, n2, n3, n4);
            }
            case 5: {
                return this.XFocusChange(n, n2, n3, n4);
            }
            case 6: {
                return this.XKeyPress(n, n2, n3, n4);
            }
            case 7: {
                return this.XKeyRelease(n, n2, n3, n4);
            }
            case 8: {
                return this.XLeaveWindow(n, n2, n3, n4);
            }
            case 33: {
                return this.XPropertyChange(n, n2, n3, n4);
            }
            case 9: {
                return this.XmNactivateCallback(n, n2, n3);
            }
            case 10: {
                return this.XmNarmCallback(n, n2, n3);
            }
            case 11: {
                return this.XmNbrowseSelectionCallback(n, n2, n3);
            }
            case 12: {
                return this.XmNcascadingCallback(n, n2, n3);
            }
            case 13: {
                return this.XmNdecrementCallback(n, n2, n3);
            }
            case 14: {
                return this.XmNdefaultActionCallback(n, n2, n3);
            }
            case 15: {
                return this.XmNdragCallback(n, n2, n3);
            }
            case 16: {
                return this.XmNextendedSelectionCallback(n, n2, n3);
            }
            case 17: {
                return this.XmNhelpCallback(n, n2, n3);
            }
            case 18: {
                return this.XmNincrementCallback(n, n2, n3);
            }
            case 19: {
                return this.XmNmodifyVerifyCallback(n, n2, n3);
            }
            case 32: {
                return this.XmNmultipleSelectionCallback(n, n2, n3);
            }
            case 20: {
                return this.XmNpageDecrementCallback(n, n2, n3);
            }
            case 21: {
                return this.XmNpageIncrementCallback(n, n2, n3);
            }
            case 22: {
                return this.XmNtoBottomCallback(n, n2, n3);
            }
            case 23: {
                return this.XmNtoTopCallback(n, n2, n3);
            }
            case 24: {
                return this.XmNvalueChangedCallback(n, n2, n3);
            }
            case 25: {
                return this.XNonMaskable(n, n2, n3, n4);
            }
            case 26: {
                return this.XPointerMotion(n, n2, n3, n4);
            }
            case 27: {
                return this.XStructureNotify(n, n2, n3, n4);
            }
            case 28: {
                return this.XmNmapCallback(n, n2, n3);
            }
            case 29: {
                return this.XmNunmapCallback(n, n2, n3);
            }
            case 30: {
                return this.WM_DELETE_WINDOW(n, n2, n3);
            }
            case 31: {
                return this.XmNexposureCallback(n, n2, n3);
            }
        }
        return 0;
    }

    int WM_DELETE_WINDOW(int n, int n2, int n3) {
        return 0;
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XEnterWindow(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XExposure(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XFocusChange(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        boolean bl = true;
        bl = xKeyEvent.keycode != 0 ? this.sendKeyEvent(1, xKeyEvent) : this.sendIMKeyEvent(1, xKeyEvent);
        if (!bl) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XKeyRelease(int n, int n2, int n3, int n4) {
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        if (!this.sendKeyEvent(2, xKeyEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XLeaveWindow(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XPropertyChange(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNarmCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNbrowseSelectionCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNcascadingCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNdecrementCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNdefaultActionCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNdragCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNexposureCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNextendedSelectionCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNhelpCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNincrementCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNmapCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNmodifyVerifyCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNmultipleSelectionCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNpageDecrementCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNpageIncrementCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNtoBottomCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNtoTopCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNunmapCallback(int n, int n2, int n3) {
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        return 0;
    }

    int XNonMaskable(int n, int n2, int n3, int n4) {
        return 0;
    }

    int XStructureNotify(int n, int n2, int n3, int n4) {
        return 0;
    }
}

