/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import org.pentaho.reporting.libraries.xmlns.parser.XmlDocumentInfo;
import org.pentaho.reporting.libraries.xmlns.parser.XmlFactoryModule;

public abstract class AbstractXmlFactoryModule
implements XmlFactoryModule {
    private String namespace;
    private String rootElementName;

    protected AbstractXmlFactoryModule(String namespace, String rootElementName) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (rootElementName == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.rootElementName = rootElementName;
    }

    public int getDocumentSupport(XmlDocumentInfo documentInfo) {
        String rootNamespace = documentInfo.getRootElementNameSpace();
        if (rootNamespace != null && rootNamespace.length() > 0) {
            if (!this.namespace.equals(rootNamespace)) {
                return -1;
            }
            if (this.rootElementName.equals(documentInfo.getRootElement())) {
                return 4000;
            }
        } else if (this.rootElementName.equals(documentInfo.getRootElement())) {
            return 1000;
        }
        return -1;
    }

    public String getDefaultNamespace(XmlDocumentInfo documentInfo) {
        return this.namespace;
    }
}

