/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.raw.RawResourceData;
import org.pentaho.reporting.libraries.xmlns.parser.LoggingErrorHandler;
import org.pentaho.reporting.libraries.xmlns.parser.MultiplexRootElementHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ResourceDataInputSource;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlFactoryModule;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractXmlResourceFactory
implements ResourceFactory {
    private static final Log logger = LogFactory.getLog(AbstractXmlResourceFactory.class);
    public static final String CONTENTBASE_KEY = "content-base";
    private static final byte[] EMPTY_DATA = new byte[0];
    private ArrayList modules = new ArrayList();
    private SAXParserFactory factory;

    protected AbstractXmlResourceFactory() {
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
        }
        return this.factory.newSAXParser();
    }

    protected void configureReader(XMLReader reader, RootXmlReadHandler handler) {
        block10: {
            block9: {
                try {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler.getCommentHandler());
                }
                catch (SAXException se) {
                    logger.debug((Object)"Comments are not supported by this SAX implementation.");
                }
                try {
                    reader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
                }
                catch (SAXException e) {
                    handler.setXmlnsUrisNotAvailable(true);
                }
                try {
                    reader.setFeature("http://xml.org/sax/features/validation", false);
                    reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                }
                catch (SAXException e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug((Object)"Disabling external validation failed. Parsing may or may not fail with a parse error later.");
                }
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)"No Namespace features will be available. (Yes, this is serious)", (Throwable)e);
                }
                if (!logger.isWarnEnabled()) break block10;
                logger.warn((Object)"No Namespace features will be available. (Yes, this is serious)");
            }
        }
    }

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            long version;
            ResourceKey contextKey;
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            XmlFactoryModule[] rootHandlers = this.getModules();
            if (rootHandlers.length == 0) {
                throw new ResourceCreationException("There are no root-handlers registered for the factory for type " + this.getFactoryType());
            }
            ResourceDataInputSource input = new ResourceDataInputSource(data, manager);
            ResourceKey targetKey = data.getKey();
            if (context == null) {
                contextKey = targetKey;
                version = data.getVersion(manager);
            } else {
                contextKey = context;
                version = -1L;
            }
            RootXmlReadHandler handler = this.createRootHandler(manager, targetKey, rootHandlers, contextKey, version);
            DefaultConfiguration parserConfiguration = handler.getParserConfiguration();
            URL value = manager.toURL(contextKey);
            if (value != null) {
                parserConfiguration.setConfigProperty(CONTENTBASE_KEY, value.toExternalForm());
            }
            this.configureReader(reader, handler);
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setEntityResolver(handler.getEntityResolver());
            reader.setErrorHandler(this.getErrorHandler());
            Map parameters = targetKey.getFactoryParameters();
            for (Object o : parameters.keySet()) {
                if (!(o instanceof FactoryParameterKey)) continue;
                FactoryParameterKey fpk = (FactoryParameterKey)o;
                handler.setHelperObject(fpk.getName(), parameters.get(fpk));
            }
            reader.parse(input);
            Object createdProduct = this.finishResult(handler.getResult(), manager, data, contextKey);
            handler.getDependencyCollector().add(targetKey, data.getVersion(manager));
            return this.createResource(targetKey, handler, createdProduct, this.getFactoryType());
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document: " + data.getKey(), (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read the stream from document: " + data.getKey(), (Exception)e);
        }
    }

    protected RootXmlReadHandler createRootHandler(ResourceManager manager, ResourceKey targetKey, XmlFactoryModule[] rootHandlers, ResourceKey contextKey, long version) {
        return new MultiplexRootElementHandler(manager, targetKey, contextKey, version, rootHandlers);
    }

    public Object parseDirectly(ResourceManager manager, InputSource input, ResourceKey context, Map parameters) throws ResourceKeyCreationException, ResourceCreationException, ResourceLoadingException {
        try {
            SAXParser parser = this.getParser();
            XMLReader reader = parser.getXMLReader();
            ResourceKey targetKey = manager.createKey((Object)EMPTY_DATA);
            ResourceKey contextKey = context == null ? targetKey : context;
            XmlFactoryModule[] rootHandlers = this.getModules();
            RootXmlReadHandler handler = this.createRootHandler(manager, targetKey, rootHandlers, contextKey, -1L);
            DefaultConfiguration parserConfiguration = handler.getParserConfiguration();
            URL value = manager.toURL(contextKey);
            if (value != null) {
                parserConfiguration.setConfigProperty(CONTENTBASE_KEY, value.toExternalForm());
            }
            this.configureReader(reader, handler);
            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            reader.setEntityResolver(handler.getEntityResolver());
            reader.setErrorHandler(this.getErrorHandler());
            for (Object o : parameters.keySet()) {
                if (!(o instanceof FactoryParameterKey)) continue;
                FactoryParameterKey fpk = (FactoryParameterKey)o;
                handler.setHelperObject(fpk.getName(), parameters.get(fpk));
            }
            reader.parse(input);
            return this.finishResult(handler.getResult(), manager, (ResourceData)new RawResourceData(targetKey), contextKey);
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document", (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read the stream", (Exception)e);
        }
    }

    private XmlFactoryModule[] getModules() {
        return this.modules.toArray(new XmlFactoryModule[this.modules.size()]);
    }

    protected Resource createResource(ResourceKey targetKey, MultiplexRootElementHandler handler, Object createdProduct, Class createdType) {
        return new CompoundResource(targetKey, handler.getDependencyCollector(), createdProduct, createdType);
    }

    protected Resource createResource(ResourceKey targetKey, RootXmlReadHandler handler, Object createdProduct, Class createdType) {
        if (handler instanceof MultiplexRootElementHandler) {
            return this.createResource(targetKey, (MultiplexRootElementHandler)handler, createdProduct, createdType);
        }
        return new CompoundResource(targetKey, handler.getDependencyCollector(), createdProduct, createdType);
    }

    protected Object finishResult(Object res, ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        return res;
    }

    protected abstract Configuration getConfiguration();

    public void initializeDefaults() {
        String type = this.getFactoryType().getName();
        String prefix = "org.pentaho.reporting.libraries.resourceloader.factory.modules." + type;
        Configuration config = this.getConfiguration();
        Iterator itType = config.findPropertyKeys(prefix);
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String modClass = config.getConfigProperty(key);
            Object maybeFactory = ObjectUtilities.loadAndInstantiate((String)modClass, AbstractXmlResourceFactory.class, XmlFactoryModule.class);
            if (!(maybeFactory instanceof XmlFactoryModule)) continue;
            this.registerModule((XmlFactoryModule)maybeFactory);
        }
    }

    public void registerModule(XmlFactoryModule factoryModule) {
        if (factoryModule == null) {
            throw new NullPointerException();
        }
        this.modules.add(factoryModule);
    }

    protected ErrorHandler getErrorHandler() {
        return new LoggingErrorHandler();
    }
}

