/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CharacterEntityParser {
    private String[] charMap;
    private final HashMap entities;

    public CharacterEntityParser(Properties characterEntities) {
        if (characterEntities == null) {
            throw new NullPointerException("CharacterEntities must not be null");
        }
        this.entities = new HashMap<Object, Object>(characterEntities);
        this.charMap = new String[65536];
        for (Map.Entry entry : this.entities.entrySet()) {
            String value = (String)entry.getValue();
            String entityName = (String)entry.getKey();
            if (value.length() != 1) {
                throw new IllegalStateException();
            }
            this.charMap[value.charAt((int)0)] = entityName;
        }
    }

    public CharacterEntityParser(HashMap characterEntities) {
        if (characterEntities == null) {
            throw new NullPointerException("CharacterEntities must not be null");
        }
        this.entities = (HashMap)characterEntities.clone();
        this.charMap = new String[65536];
        for (Map.Entry entry : this.entities.entrySet()) {
            String value = (String)entry.getValue();
            String entityName = (String)entry.getKey();
            if (value.length() != 1) {
                throw new IllegalStateException();
            }
            this.charMap[value.charAt((int)0)] = entityName;
        }
    }

    public static CharacterEntityParser createXMLEntityParser() {
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("amp", "&");
        entities.put("quot", "\"");
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("apos", "'");
        return new CharacterEntityParser(entities);
    }

    private HashMap getEntities() {
        return this.entities;
    }

    private String lookupCharacter(String key) {
        return (String)this.getEntities().get(key);
    }

    public String encodeEntities(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int length = value.length();
        StringBuilder writer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char character = value.charAt(i);
            String lookup = this.charMap[character];
            if (lookup == null) {
                writer.append(character);
                continue;
            }
            writer.append('&');
            writer.append(lookup);
            writer.append(';');
        }
        return writer.toString();
    }

    public String decodeEntities(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int parserIndex = 0;
        int subStart = value.indexOf(38, parserIndex);
        if (subStart == -1) {
            return value;
        }
        int subEnd = value.indexOf(59, subStart);
        if (subEnd == -1) {
            return value;
        }
        StringBuilder bufValue = new StringBuilder(value.substring(0, subStart));
        do {
            if (value.charAt(subStart + 1) == '#') {
                int subValue = this.parseInt(value.substring(subStart + 2, subEnd), 0);
                if (subValue >= 1 && subValue <= 65536) {
                    char[] chr = new char[]{(char)subValue};
                    bufValue.append(chr);
                } else {
                    bufValue.append(value.substring(subStart, subEnd));
                }
            } else {
                String entity = value.substring(subStart + 1, subEnd);
                String replaceString = this.lookupCharacter(entity);
                if (replaceString != null) {
                    bufValue.append(this.decodeEntities(replaceString));
                } else {
                    bufValue.append('&');
                    bufValue.append(entity);
                    bufValue.append(';');
                }
            }
            parserIndex = subEnd + 1;
            subStart = value.indexOf(38, parserIndex);
            if (subStart == -1) {
                bufValue.append(value.substring(parserIndex));
                subEnd = -1;
                continue;
            }
            subEnd = value.indexOf(59, subStart);
            if (subEnd == -1) {
                bufValue.append(value.substring(parserIndex));
                continue;
            }
            bufValue.append(value.substring(parserIndex, subStart));
        } while (subStart != -1 && subEnd != -1);
        return bufValue.toString();
    }

    private int parseInt(String s, int defaultVal) {
        if (s == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return defaultVal;
        }
    }
}

