/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiResolver
extends FunUtil
implements Resolver {
    private final String name;
    private final String signature;
    private final String description;
    private final String[] signatures;
    private final Syntax syntax;

    protected MultiResolver(String name, String signature, String description, String[] signatures) {
        this.name = name;
        this.signature = signature;
        this.description = description;
        this.signatures = signatures;
        Util.assertTrue(signatures.length > 0);
        this.syntax = MultiResolver.decodeSyntacticType(signatures[0]);
        for (int i = 1; i < signatures.length; ++i) {
            Util.assertTrue(MultiResolver.decodeSyntacticType(signatures[i]) == this.syntax);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public String[] getReservedWords() {
        return emptyStringArray;
    }

    public String[] getSignatures() {
        return this.signatures;
    }

    @Override
    public FunDef getFunDef() {
        return null;
    }

    @Override
    public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
        block0: for (String signature : this.signatures) {
            int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
            if (parameterTypes.length != args.length) continue;
            conversions.clear();
            for (int i = 0; i < args.length; ++i) {
                if (!validator.canConvert(i, args[i], parameterTypes[i], conversions)) continue block0;
            }
            int returnType = MultiResolver.decodeReturnCategory(signature);
            FunDef dummy = MultiResolver.createDummyFunDef(this, returnType, args);
            return this.createFunDef(args, dummy);
        }
        return null;
    }

    @Override
    public boolean requiresExpression(int k) {
        for (String signature : this.signatures) {
            int[] parameterTypes = MultiResolver.decodeParameterCategories(signature);
            if (k >= parameterTypes.length || parameterTypes[k] != 8) continue;
            return false;
        }
        return true;
    }

    protected abstract FunDef createFunDef(Exp[] var1, FunDef var2);
}

