/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.SetFunDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.RolapVirtualCubeMeasure;
import mondrian.rolap.ScenarioImpl;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.spi.Dialect;
import org.apache.log4j.Logger;
import org.olap4j.AllocationPolicy;
import org.olap4j.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCell
implements Cell {
    private static final int MDACTION_TYPE_DRILLTHROUGH = 256;
    private final RolapResult result;
    protected final int[] pos;
    protected RolapResult.CellInfo ci;

    RolapCell(RolapResult result, int[] pos, RolapResult.CellInfo ci) {
        this.result = result;
        this.pos = pos;
        this.ci = ci;
    }

    @Override
    public List<Integer> getCoordinateList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return RolapCell.this.pos[index];
            }

            @Override
            public int size() {
                return RolapCell.this.pos.length;
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.ci.value == Util.nullValue) {
            return null;
        }
        return this.ci.value;
    }

    @Override
    public String getCachedFormatString() {
        return this.ci.formatString;
    }

    @Override
    public String getFormattedValue() {
        return this.ci.getFormatValue();
    }

    @Override
    public boolean isNull() {
        return this.ci.value == Util.nullValue;
    }

    @Override
    public boolean isError() {
        return this.ci.value instanceof Throwable;
    }

    @Override
    public String getDrillThroughSQL(boolean extendedContext) {
        return this.getDrillThroughSQL(new ArrayList<Exp>(), extendedContext);
    }

    public String getDrillThroughSQL(List<Exp> fields, boolean extendedContext) {
        if (!MondrianProperties.instance().EnableDrillThrough.get()) {
            throw MondrianResource.instance().DrillthroughDisabled.ex(MondrianProperties.instance().EnableDrillThrough.getPath());
        }
        Member[] currentMembers = this.getMembersForDrillThrough();
        StarPredicate starPredicateSlicer = this.buildDrillthroughSlicerPredicate(currentMembers, this.result.getSlicerAxis());
        DrillThroughCellRequest cellRequest = RolapAggregationManager.makeDrillThroughRequest(currentMembers, extendedContext, this.result.getCube(), fields);
        if (cellRequest == null) {
            return null;
        }
        RolapConnection connection = this.result.getExecution().getMondrianStatement().getMondrianConnection();
        AggregationManager aggMgr = connection.getServer().getAggregationManager();
        return ((RolapAggregationManager)aggMgr).getDrillThroughSql(cellRequest, starPredicateSlicer, fields, false);
    }

    @Override
    public int getDrillThroughCount() {
        Member[] currentMembers = this.getMembersForDrillThrough();
        StarPredicate starPredicateSlicer = this.buildDrillthroughSlicerPredicate(currentMembers, this.result.getSlicerAxis());
        DrillThroughCellRequest cellRequest = RolapAggregationManager.makeDrillThroughRequest(currentMembers, false, this.result.getCube(), null);
        if (cellRequest == null) {
            return -1;
        }
        RolapConnection connection = this.result.getExecution().getMondrianStatement().getMondrianConnection();
        AggregationManager aggMgr = connection.getServer().getAggregationManager();
        String sql = ((RolapAggregationManager)aggMgr).getDrillThroughSql(cellRequest, starPredicateSlicer, new ArrayList<Exp>(), true);
        SqlStatement stmt = RolapUtil.executeQuery(connection.getDataSource(), sql, new Locus(new Execution(connection.getInternalStatement(), 0L), "RolapCell.getDrillThroughCount", "Error while counting drill-through"));
        try {
            ResultSet rs = stmt.getResultSet();
            rs.next();
            ++stmt.rowCount;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    private StarPredicate buildDrillthroughSlicerPredicate(Member[] membersForDrillthrough, Axis slicerAxis) {
        List<Position> listOfPositions = slicerAxis.getPositions();
        if (listOfPositions.size() <= 1) {
            return null;
        }
        for (Position position : listOfPositions) {
            for (Member member : position) {
                RolapHierarchy rolapHierarchy = (RolapHierarchy)member.getHierarchy();
                if (membersForDrillthrough[rolapHierarchy.getOrdinalInCube()].equals(member)) continue;
                membersForDrillthrough[rolapHierarchy.getOrdinalInCube()] = rolapHierarchy.getAllMember();
            }
        }
        ArrayList<StarPredicate> listOfStarPredicatesForSlicerPositions = new ArrayList<StarPredicate>();
        for (Position position : listOfPositions) {
            ArrayList<StarPredicate> listOfStarPredicatesForCurrentPosition = new ArrayList<StarPredicate>();
            for (Member member : position) {
                RolapHierarchy rolapHierarchy = (RolapHierarchy)member.getHierarchy();
                if (membersForDrillthrough[rolapHierarchy.getOrdinalInCube()].equals(member)) continue;
                Level levelLast = null;
                for (Member memberWalk = member; memberWalk != null && !memberWalk.isAll(); memberWalk = memberWalk.getParentMember()) {
                    if (memberWalk.getLevel() != levelLast) {
                        RolapCubeMember rolapCubeMember = (RolapCubeMember)memberWalk;
                        RolapStar.Column column = rolapCubeMember.getLevel().getBaseStarKeyColumn(this.result.getCube());
                        listOfStarPredicatesForCurrentPosition.add(new MemberColumnPredicate(column, rolapCubeMember));
                    }
                    levelLast = memberWalk.getLevel();
                }
            }
            AndPredicate starPredicateForCurrentSlicerPosition = new AndPredicate(listOfStarPredicatesForCurrentPosition);
            listOfStarPredicatesForSlicerPositions.add(starPredicateForCurrentSlicerPosition);
        }
        return new OrPredicate(listOfStarPredicatesForSlicerPositions);
    }

    @Override
    public boolean canDrillThrough() {
        if (!MondrianProperties.instance().EnableDrillThrough.get()) {
            return false;
        }
        Member[] currentMembers = this.getMembersForDrillThrough();
        if (this.containsCalcMembers(currentMembers)) {
            return false;
        }
        RolapCube x = RolapCell.chooseDrillThroughCube(currentMembers, this.result.getCube());
        return x != null;
    }

    private boolean containsCalcMembers(Member[] currentMembers) {
        for (int i = 1; i < currentMembers.length; ++i) {
            Member currentMember = currentMembers[i];
            if (!currentMember.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static RolapCube chooseDrillThroughCube(Member[] currentMembers, RolapCube defaultCube) {
        if (defaultCube != null && defaultCube.isVirtual()) {
            ArrayList<RolapCube> cubes = new ArrayList<RolapCube>();
            for (RolapMember member : defaultCube.getMeasuresMembers()) {
                if (!(member instanceof RolapVirtualCubeMeasure)) continue;
                RolapVirtualCubeMeasure measure = (RolapVirtualCubeMeasure)member;
                cubes.add(measure.getCube());
            }
            defaultCube = (RolapCube)cubes.get(0);
            assert (!defaultCube.isVirtual());
        }
        DrillThroughVisitor visitor = new DrillThroughVisitor();
        try {
            for (Member member : currentMembers) {
                visitor.handleMember(member);
            }
        }
        catch (RuntimeException e) {
            if (e == DrillThroughVisitor.bomb) {
                return null;
            }
            throw e;
        }
        return visitor.cube == null ? defaultCube : visitor.cube;
    }

    private Member[] getMembersForDrillThrough() {
        Member[] currentMembers = this.result.getCellMembers(this.pos);
        List<Member> memberList = Arrays.asList(currentMembers);
        for (int i = 0; i < currentMembers.length; ++i) {
            this.replaceTrivialCalcMember(i, memberList);
        }
        return currentMembers;
    }

    private void replaceTrivialCalcMember(int i, List<Member> members) {
        ResolvedFunCall arg0;
        Exp[] args;
        ResolvedFunCall call;
        Member member = members.get(i);
        if (!member.isCalculated()) {
            return;
        }
        Exp expr = (member = RolapUtil.strip((RolapMember)member)).getExpression();
        if (expr instanceof MemberExpr) {
            members.set(i, ((MemberExpr)expr).getMember());
            return;
        }
        if (expr instanceof ResolvedFunCall && (call = (ResolvedFunCall)expr).getFunDef() instanceof AggregateFunDef && (args = call.getArgs())[0] instanceof ResolvedFunCall && (arg0 = (ResolvedFunCall)args[0]).getFunDef() instanceof SetFunDef && arg0.getArgCount() == 1 && arg0.getArg(0) instanceof MemberExpr) {
            MemberExpr memberExpr = (MemberExpr)arg0.getArg(0);
            members.set(i, memberExpr.getMember());
        }
    }

    public SqlStatement drillThroughInternal(int maxRowCount, int firstRowOrdinal, List<Exp> fields, boolean extendedContext, Logger logger) {
        if (!this.canDrillThrough()) {
            throw Util.newError("Cannot do DrillThrough operation on the cell");
        }
        String sql = this.getDrillThroughSQL(fields, extendedContext);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((Object)("drill through sql: " + sql));
        }
        Statement statement = this.result.getExecution().getMondrianStatement();
        Execution execution = new Execution(statement, 0L);
        RolapConnection connection = statement.getMondrianConnection();
        int resultSetType = 1004;
        int resultSetConcurrency = 1007;
        RolapSchema schema = statement.getSchema();
        Dialect dialect = schema.getDialect();
        if (!dialect.supportsResultSetConcurrency(resultSetType, resultSetConcurrency) || firstRowOrdinal <= 1) {
            resultSetType = 1003;
        }
        return RolapUtil.executeQuery(connection.getDataSource(), sql, null, maxRowCount, firstRowOrdinal, new SqlStatement.StatementLocus(execution, "RolapCell.drillThrough", "Error in drill through", SqlStatementEvent.Purpose.DRILL_THROUGH, 0), resultSetType, resultSetConcurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPropertyValue(String propertyName) {
        Integer defaultValue;
        block17: {
            boolean matchCase = MondrianProperties.instance().CaseSensitive.get();
            Property property = Property.lookup(propertyName, matchCase);
            defaultValue = null;
            if (property == null) break block17;
            switch (property.ordinal) {
                case 32: {
                    return this.result.getCellOrdinal(this.pos);
                }
                case 41: {
                    return this.getValue();
                }
                case 38: {
                    if (this.ci.formatString == null) {
                        Evaluator evaluator = this.result.getRootEvaluator();
                        int savepoint = evaluator.savepoint();
                        try {
                            this.result.populateEvaluator(evaluator, this.pos);
                            this.ci.formatString = evaluator.getFormatString();
                        }
                        finally {
                            evaluator.restore(savepoint);
                        }
                    }
                    return this.ci.formatString;
                }
                case 37: {
                    return this.getFormattedValue();
                }
                case 36: {
                    defaultValue = 0;
                    break;
                }
                case 40: {
                    defaultValue = 0;
                    break;
                }
                case 54: {
                    return this.canDrillThrough() ? 256 : 0;
                }
                case 55: {
                    return this.canDrillThrough() ? this.getDrillThroughCount() : -1;
                }
            }
        }
        Evaluator evaluator = this.result.getRootEvaluator();
        int savepoint = evaluator.savepoint();
        try {
            this.result.populateEvaluator(evaluator, this.pos);
            Object object = evaluator.getProperty(propertyName, defaultValue);
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    @Override
    public Member getContextMember(Hierarchy hierarchy) {
        return this.result.getMember(this.pos, hierarchy);
    }

    @Override
    public void setValue(Scenario scenario, Object newValue, AllocationPolicy allocationPolicy, Object ... allocationArgs) {
        double doubleCurrentValue;
        Object currentValue;
        if (allocationPolicy == null) {
            throw Util.newError("Allocation policy must not be null");
        }
        RolapMember[] members = this.result.getCellMembers(this.pos);
        for (int i = 0; i < members.length; ++i) {
            RolapMember member = members[i];
            if (ScenarioImpl.isScenario(member.getHierarchy())) {
                scenario = (Scenario)member.getPropertyValue(Property.SCENARIO.name);
                members[i] = (RolapMember)member.getHierarchy().getAllMember();
                continue;
            }
            if (!member.isCalculated()) continue;
            throw Util.newError("Cannot write to cell: one of the coordinates (" + member.getUniqueName() + ") is a calculated member");
        }
        if (scenario == null) {
            throw Util.newError("No active scenario");
        }
        if (allocationArgs == null) {
            allocationArgs = new Object[]{};
        }
        if ((currentValue = this.getValue()) == null) {
            doubleCurrentValue = 0.0;
        } else if (currentValue instanceof Number) {
            doubleCurrentValue = ((Number)currentValue).doubleValue();
        } else {
            return;
        }
        double doubleNewValue = ((Number)newValue).doubleValue();
        ((ScenarioImpl)scenario).setCellValue(this.result.getExecution().getMondrianStatement().getMondrianConnection(), Arrays.asList(members), doubleNewValue, doubleCurrentValue, allocationPolicy, allocationArgs);
    }

    private static class DrillThroughVisitor
    extends MdxVisitorImpl {
        static final RuntimeException bomb = new RuntimeException();
        RolapCube cube = null;

        DrillThroughVisitor() {
        }

        public Object visit(MemberExpr memberExpr) {
            this.handleMember(memberExpr.getMember());
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            FunDef def = call.getFunDef();
            Exp[] args = call.getArgs();
            String name = def.getName();
            if (name.equals("+") || name.equals("-") || name.equals("/") || name.equals("*") || name.equals("CoalesceEmpty") || name.equals("()") && args.length == 1) {
                return null;
            }
            throw bomb;
        }

        public void handleMember(Member member) {
            if (member instanceof RolapStoredMeasure) {
                RolapCube cube = ((RolapStoredMeasure)member).getCube();
                if (this.cube == null) {
                    this.cube = cube;
                } else if (this.cube != cube) {
                    throw bomb;
                }
            } else if (member instanceof RolapCubeMember) {
                this.handleMember(((RolapCubeMember)member).member);
            } else if (member instanceof RolapHierarchy.RolapCalculatedMeasure) {
                RolapHierarchy.RolapCalculatedMeasure measure = (RolapHierarchy.RolapCalculatedMeasure)member;
                measure.getFormula().getExpression().accept(this);
            } else if (!(member instanceof RolapMember)) {
                throw bomb;
            }
        }

        public Object visit(NamedSetExpr namedSetExpr) {
            throw Util.newInternal("not valid here: " + namedSetExpr);
        }

        public Object visit(Literal literal) {
            return null;
        }

        public Object visit(Query query) {
            throw Util.newInternal("not valid here: " + query);
        }

        public Object visit(QueryAxis queryAxis) {
            throw Util.newInternal("not valid here: " + queryAxis);
        }

        public Object visit(Formula formula) {
            throw Util.newInternal("not valid here: " + formula);
        }

        public Object visit(UnresolvedFunCall call) {
            throw Util.newInternal("expected resolved expression");
        }

        public Object visit(Id id) {
            throw Util.newInternal("expected resolved expression");
        }

        public Object visit(ParameterExpr parameterExpr) {
            throw bomb;
        }

        public Object visit(DimensionExpr dimensionExpr) {
            throw bomb;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            throw bomb;
        }

        public Object visit(LevelExpr levelExpr) {
            throw bomb;
        }
    }
}

