/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.util.ArraySortedSet;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentAxis {
    final StarColumnPredicate predicate;
    private final boolean predicateAlwaysTrue;
    private final Set<Object> predicateValues;
    private final Map<Comparable, Integer> mapKeyToOffset;
    private final Comparable[] keys;
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final Comparable[] NO_COMPARABLES = new Comparable[0];

    private SegmentAxis(StarColumnPredicate predicate, Comparable[] keys, boolean safe) {
        this.predicate = predicate;
        this.predicateAlwaysTrue = predicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)predicate).getValue();
        this.predicateValues = SegmentAxis.predicateValueSet(predicate);
        if (keys.length == 0) {
            this.keys = NO_COMPARABLES;
            this.mapKeyToOffset = Collections.emptyMap();
        } else {
            this.keys = keys;
            this.mapKeyToOffset = new HashMap<Comparable, Integer>(keys.length * 3 / 2);
            for (int i = 0; i < keys.length; ++i) {
                this.mapKeyToOffset.put(keys[i], i);
            }
        }
        assert (predicate != null);
        assert (safe || Util.isSorted(Arrays.asList(keys)));
    }

    private static Set<Object> predicateValueSet(StarColumnPredicate predicate) {
        if (!(predicate instanceof ListColumnPredicate)) {
            return null;
        }
        ListColumnPredicate listColumnPredicate = (ListColumnPredicate)predicate;
        List<StarColumnPredicate> predicates = listColumnPredicate.getPredicates();
        if (predicates.size() < 10) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (StarColumnPredicate subPredicate : predicates) {
            if (subPredicate instanceof ValueColumnPredicate) {
                ValueColumnPredicate valueColumnPredicate = (ValueColumnPredicate)subPredicate;
                valueColumnPredicate.values(set);
                continue;
            }
            return null;
        }
        return set;
    }

    SegmentAxis(StarColumnPredicate predicate, Comparable[] keys) {
        this(predicate, keys, false);
    }

    public SegmentAxis(StarColumnPredicate predicate, SortedSet<Comparable> keySet, boolean hasNull) {
        this(predicate, SegmentAxis.toArray(keySet, hasNull), true);
    }

    private static Comparable[] toArray(SortedSet<Comparable> keySet, boolean hasNull) {
        int size = keySet.size();
        if (hasNull) {
            ++size;
        }
        Comparable[] keys = keySet.toArray(new Comparable[size]);
        if (hasNull) {
            keys[size - 1] = RolapUtil.sqlNullValue;
        }
        return keys;
    }

    final StarColumnPredicate getPredicate() {
        return this.predicate;
    }

    final Comparable[] getKeys() {
        return this.keys;
    }

    final int getOffset(Comparable key) {
        if (this.keys.length == 1) {
            return this.keys[0].equals(key) ? 0 : -1;
        }
        Integer ordinal = this.mapKeyToOffset.get(key);
        if (ordinal == null) {
            return -1;
        }
        return ordinal;
    }

    public final boolean wouldContain(Object key) {
        return this.predicateAlwaysTrue || (this.predicateValues != null ? this.predicateValues.contains(key) : this.predicate.evaluate(key));
    }

    public int getMatchCount(StarColumnPredicate predicate) {
        int matchCount = 0;
        for (Comparable key : this.keys) {
            if (!predicate.evaluate(key)) continue;
            ++matchCount;
        }
        return matchCount;
    }

    public Pair<SortedSet<Comparable>, Boolean> getValuesAndIndicator() {
        if (this.keys.length > 0 && this.keys[this.keys.length - 1] == RolapUtil.sqlNullValue) {
            return Pair.of(new ArraySortedSet(this.keys, 0, this.keys.length - 1), Boolean.TRUE);
        }
        return Pair.of(new ArraySortedSet(this.keys), Boolean.FALSE);
    }
}

