/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mondrian.rolap.cache.SmartCacheImpl;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftSmartCache<K, V>
extends SmartCacheImpl<K, V> {
    private final Map<K, CacheReference> cache = new HashMap<K, CacheReference>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    @Override
    public V putImpl(K key, V value) {
        CacheReference ref;
        while ((ref = (CacheReference)this.queue.poll()) != null) {
            this.cache.remove(ref.key);
        }
        ref = new CacheReference(key, value);
        if ((ref = this.cache.put(key, ref)) != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public V getImpl(K key) {
        CacheReference ref = this.cache.get(key);
        if (ref == null) {
            return null;
        }
        Object value = ref.get();
        if (value == null) {
            this.cache.remove(key);
        }
        return (V)value;
    }

    @Override
    public V removeImpl(K key) {
        CacheReference ref = this.cache.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void clearImpl() {
        this.cache.clear();
    }

    @Override
    public int sizeImpl() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iteratorImpl() {
        final Iterator<Map.Entry<K, CacheReference>> cacheIterator = this.cache.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){
            private Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                if (this.entry != null) {
                    return true;
                }
                while (cacheIterator.hasNext()) {
                    Map.Entry cacheEntry = (Map.Entry)cacheIterator.next();
                    Object value = ((CacheReference)cacheEntry.getValue()).get();
                    if (value == null) continue;
                    this.entry = new Pair(cacheEntry.getKey(), value);
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = this.entry;
                this.entry = null;
                return entry;
            }

            @Override
            public void remove() {
                cacheIterator.remove();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheReference
    extends SoftReference<V> {
        K key;

        public CacheReference(K key, V value) {
            super(value, SoftSmartCache.this.queue);
            this.key = key;
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

