/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.PostgreSqlDialect;

public class GreenplumDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(GreenplumDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && PostgreSqlDialect.isGreenplum(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public GreenplumDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public boolean supportsGroupingSets() {
        return true;
    }

    public boolean requiresGroupByAlias() {
        return true;
    }

    public boolean requiresAliasForFromQuery() {
        return false;
    }

    public boolean allowsCountDistinct() {
        return true;
    }

    public boolean allowsFromQuery() {
        return false;
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.GREENPLUM;
    }

    public String generateCountExpression(String exp) {
        return this.caseWhenElse(exp + " ISNULL", "'0'", "TEXT(" + exp + ")");
    }

    public boolean allowsRegularExpressionInWhereClause() {
        return this.productVersion.compareTo("3.2") >= 0;
    }
}

