/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.audit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.core.audit.AuditEntry;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class AuditHelper {
    private static final Log log = LogFactory.getLog(AuditHelper.class);

    public static void audit(IRuntimeContext runtimeContext, IPentahoSession session, String messageType, String message, String value, float duration, ILogger logger) {
        String instanceId = runtimeContext == null ? "" : runtimeContext.getInstanceId();
        String userId = session.getName();
        String actionName = runtimeContext == null ? null : runtimeContext.getActionName();
        String objectType = runtimeContext == null ? "" : runtimeContext.getCurrentComponentName();
        String processId = runtimeContext == null ? null : runtimeContext.getProcessId();
        AuditHelper.audit(instanceId, userId, actionName, objectType, processId, messageType, message, value, duration, logger);
    }

    private static void logTheAuditError(ILogger logger, Exception e) {
        String msg = null;
        try {
            msg = e.getMessage() != null ? e.getMessage() : Messages.getErrorString("AUDITHELPER.ERROR_0001_AUDIT_ENTRY_ERROR");
        }
        catch (Throwable ignored) {
            msg = Messages.getErrorString("AUDITHELPER.ERROR_0001_AUDIT_ENTRY_ERROR");
        }
        if (msg.toLowerCase().indexOf("not found") >= 0) {
            e = null;
        }
        if (logger != null) {
            logger.error(msg, (Throwable)e);
        } else {
            Logger.error((String)AuditHelper.class.getName(), (String)msg, (Throwable)e);
        }
    }

    public static void audit(String instanceId, String userId, String actionName, String objectType, String processId, String messageType, String message, String value, float duration, ILogger logger) {
        try {
            if (processId == null || instanceId == null || actionName == null || actionName.equals("")) {
                if (processId == null) {
                    processId = "";
                    log.error((Object)Messages.getString("AUDITHELPER.ERROR_0002_PROCESS_ID_IS_NULL"));
                }
                if (instanceId == null) {
                    instanceId = "";
                    log.error((Object)Messages.getString("AUDITHELPER.ERROR_0003_INSTANCE_ID_IS_NULL"));
                }
                if (actionName == null) {
                    actionName = "";
                    log.error((Object)Messages.getString("AUDITHELPER.ERROR_0004_ACTION_NAME_IS_NULL"));
                }
            }
            AuditEntry.auditJobDuration(processId, instanceId, actionName, objectType, userId, messageType, message, value, duration);
        }
        catch (Exception e) {
            AuditHelper.logTheAuditError(logger, e);
        }
    }
}

