/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.output;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.pentaho.platform.api.engine.IContentListener;
import org.pentaho.platform.engine.core.output.SimpleContentItem;

public class BufferedContentItem
extends SimpleContentItem {
    private ByteArrayOutputStream outputStream;
    private InputStream inputStream;
    private IContentListener listener;

    public BufferedContentItem(IContentListener listener) {
        this.listener = listener;
        this.outputStream = new ByteArrayOutputStream();
        this.inputStream = null;
        this.setOutputStream(this.outputStream);
    }

    public void closeOutputStream() {
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        if (this.listener != null) {
            this.listener.close();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setMimeType(String mimeType) {
        super.setMimeType(mimeType);
        this.listener.setMimeType(mimeType);
    }
}

