/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.solution;

import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.util.ParameterHelper;

public abstract class BaseParameterProvider
implements IParameterProvider {
    protected abstract String getValue(String var1);

    public abstract Object getParameter(String var1);

    public String getStringParameter(String name, String defaultValue) {
        return ParameterHelper.parameterToString((String)this.getValue(name), (String)defaultValue);
    }

    public IPentahoResultSet getListParameter(String name) {
        return (IPentahoResultSet)this.getParameter(name);
    }

    public long getLongParameter(String name, long defaultValue) {
        return ParameterHelper.parameterToLong((String)this.getValue(name), (long)defaultValue);
    }

    public Date getDateParameter(String name, Date defaultValue) {
        Object value = this.getParameter(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return ParameterHelper.parameterToDate((String)this.getValue(name), (Date)defaultValue);
    }

    public BigDecimal getDecimalParameter(String name, BigDecimal defaultValue) {
        return ParameterHelper.parameterToDecimal((String)this.getStringParameter(name, ""), (BigDecimal)defaultValue);
    }

    public Object[] getArrayParameter(String name, Object[] defaultValue) {
        return ParameterHelper.parameterToObjectArray((Object)this.getParameter(name), (Object[])defaultValue);
    }

    public String[] getStringArrayParameter(String name, String[] defaultValue) {
        return ParameterHelper.parameterToStringArray((Object)this.getParameter(name), (String[])defaultValue);
    }

    public boolean hasParameter(String name) {
        return this.getParameter(name) != null;
    }
}

