/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.util.Locale;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoBase;

public abstract class BaseSession
extends PentahoBase
implements IPentahoSession {
    private static final long serialVersionUID = -8559249546126139228L;
    private String name;
    private String id;
    private String processId;
    private String actionName;
    private Locale locale;
    private boolean authenticated;
    private volatile boolean backgroundExecutionAlert;

    public BaseSession(String name, String id, Locale locale) {
        this.name = name;
        this.id = id;
        this.locale = locale;
        this.actionName = "";
        this.setLogId(Messages.getString("BaseSession.CODE_LOG_ID", id, "session", name));
        this.authenticated = false;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(String name) {
        if (name != null) {
            this.authenticated = true;
            this.name = name;
        }
    }

    public void setNotAuthenticated() {
        this.name = null;
        this.authenticated = false;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void destroy() {
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getObjectName() {
        return this.getClass().getName();
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getActionName() {
        return this.actionName;
    }

    public synchronized void setBackgroundExecutionAlert() {
        this.backgroundExecutionAlert = true;
    }

    public synchronized boolean getBackgroundExecutionAlert() {
        return this.backgroundExecutionAlert;
    }

    public synchronized void resetBackgroundExecutionAlert() {
        this.backgroundExecutionAlert = false;
    }
}

