/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.StandaloneSession;

public class PentahoSessionHolder {
    private static final ThreadLocal<IPentahoSession> perThreadSession = new InheritableThreadLocal<IPentahoSession>();
    private static Log logger = LogFactory.getLog(PentahoSessionHolder.class);

    public static void setSession(IPentahoSession session) {
        perThreadSession.set(session);
    }

    public static IPentahoSession getSession() {
        IPentahoSession sess = perThreadSession.get();
        if (sess == null) {
            logger.debug((Object)Messages.getString("PentahoSessionHolder.WARN_THREAD_SESSION_NULL", Thread.currentThread().getName()));
        }
        return sess;
    }

    public static void removeSession() {
        IPentahoSession sess = perThreadSession.get();
        if (sess != null) {
            if (sess instanceof StandaloneSession) {
                ((StandaloneSession)sess).destroy();
            }
            perThreadSession.remove();
        }
    }
}

